/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui.credential_manipulation;

import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.io.File;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import javafx.fxml.FXML;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SavePemPanelController {
    private static final Logger LOG = LoggerFactory.getLogger(SavePemPanelController.class);
    private final GeniUserProvider geniUserProvider;
    @FXML
    private BorderPane root;

    @Inject
    public SavePemPanelController(GeniUserProvider geniUserProvider) {
        this.geniUserProvider = geniUserProvider;
    }

    private Window getWindow() {
        return this.root.getScene().getWindow();
    }

    public File saveToFile(String defaultFileName) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialFileName(defaultFileName);
        File file = fileChooser.showSaveDialog(this.getWindow());
        return file;
    }

    public String getUsername() {
        if (!this.geniUserProvider.isUserLoggedIn()) {
            return null;
        }
        return this.geniUserProvider.getLoggedInGeniUser().getUserUrn().getEncodedResourceName();
    }

    public String getNiceName() {
        if (!this.geniUserProvider.isUserLoggedIn()) {
            return null;
        }
        GeniUrn userUrn = this.geniUserProvider.getLoggedInGeniUser().getUserUrn();
        return userUrn.getEncodedTopLevelAuthority() + "_" + userUrn.getEncodedResourceName();
    }

    public void saveWithPass() {
        JFDialogs.create().owner(this.getWindow()).message("This is not yet implemented").title("Unsupported operation").showWarning();
    }

    public void saveWithoutPass() {
        File file = this.saveToFile(this.getNiceName() + ".pem");
        if (!this.geniUserProvider.isUserLoggedIn()) {
            return;
        }
        GeniUser user = this.geniUserProvider.getLoggedInGeniUser();
        PrivateKey pk = user.getPrivateKey();
        String pkPem = new String(KeyUtil.privateKeyToAnyPem((PrivateKey)pk));
        String certPem = KeyUtil.x509certificateChainToPem(user.getClientCertificateChain());
        String pem = pkPem + "\n" + certPem;
        IOUtils.stringToFile((File)file, (String)pem);
    }

    public void savePKCS12() {
        File pkcs12File = this.saveToFile(this.getNiceName() + ".p12");
        if (!this.geniUserProvider.isUserLoggedIn()) {
            return;
        }
        GeniUser user = this.geniUserProvider.getLoggedInGeniUser();
        PrivateKey pk = user.getPrivateKey();
        List<X509Certificate> certs = user.getClientCertificateChain();
        Certificate[] chain = new Certificate[certs.size()];
        for (int i = 0; i < certs.size(); ++i) {
            chain[i] = certs.get(i);
        }
        TextInputDialog textInputDialog = new TextInputDialog();
        textInputDialog.setContentText("New password for PKCS12 file");
        textInputDialog.showAndWait().ifPresent(pass -> {
            char[] keyStorePass = pass.toCharArray();
            KeyStore keyStore = null;
            try {
                keyStore = KeyStore.getInstance("jks");
                keyStore.load(null, null);
                keyStore.setKeyEntry(this.getNiceName(), pk, keyStorePass, chain);
                byte[] pkcs12 = KeyUtil.keyStoreToPKCS12Bytes((KeyStore)keyStore, (String)pass, (String)pass);
                IOUtils.byteArrayToFile((File)pkcs12File, (byte[])pkcs12);
                LOG.info("Saved user login as PKCS12 to " + String.valueOf(pkcs12File) + "  (" + pkcs12.length + " bytes)");
            }
            catch (Exception e) {
                LOG.error("Failed to convert and save PK12: " + e.getMessage(), (Throwable)e);
            }
        });
    }
}

