/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui.credential_manipulation;

import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.model.ParameterHistoryModel;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.CredentialException;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.credential_manipulation.CredentialCreatorPanel;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.io.File;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.util.Pair;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeaksForSfaCredentialCreatorPanelController
extends CredentialCreatorPanel {
    private static final Logger LOG = LoggerFactory.getLogger(SpeaksForSfaCredentialCreatorPanelController.class);
    @FXML
    private BorderPane root;
    @FXML
    private Label spokenForUrnLabel;
    @FXML
    private TextField spokenForUrnText;
    @FXML
    private Label spokenForUrnNoteLabel;
    @FXML
    private Label targetLabel;
    @FXML
    private TextField targetText;
    @FXML
    private RadioButton targetViaUrn;
    @FXML
    private RadioButton targetViaCert;
    @FXML
    private VBox targetUrnBox;
    @FXML
    private VBox targetCertfileBox;
    @FXML
    private TextField targetCertFilename;
    @FXML
    private Button loadCertButton;
    @FXML
    private Button generateButton;
    @FXML
    private Label generateNoteLabel;
    @FXML
    private Label resultLabel;
    @FXML
    private TextArea resultText;
    @FXML
    private Button saveResultButton;
    @FXML
    private Label privNameLabel;
    @FXML
    private TextField privNameText;
    @FXML
    private CheckBox canDelegateCheckBox;
    @FXML
    private Label expireLabel;
    @FXML
    private TextField expireText;
    private final ParameterHistoryModel parameterHistoryModel;
    private X509Certificate userCert;
    Thread generateSpeaksForThread = null;

    @Inject
    public SpeaksForSfaCredentialCreatorPanelController(JavaFXLogger logger, AuthorityFinder authorityFinder, GeniUserProvider geniUserProvider, JFedConnectionProvider connectionProvider, SfaModel sfaModel, HighLevelTaskFactory hltf, TaskThread tt, JFedPreferences jFedPreferences, ParameterHistoryModel parameterHistoryModel) {
        super(logger, authorityFinder, geniUserProvider, connectionProvider, sfaModel, hltf, tt, jFedPreferences);
        this.parameterHistoryModel = parameterHistoryModel;
    }

    @FXML
    private void initialize() {
        this.spokenForUrnLabel.managedProperty().bind((ObservableValue)this.spokenForUrnLabel.visibleProperty());
        this.spokenForUrnText.managedProperty().bind((ObservableValue)this.spokenForUrnText.visibleProperty());
        this.spokenForUrnNoteLabel.managedProperty().bind((ObservableValue)this.spokenForUrnNoteLabel.visibleProperty());
        this.generateButton.managedProperty().bind((ObservableValue)this.generateButton.visibleProperty());
        this.generateNoteLabel.managedProperty().bind((ObservableValue)this.generateNoteLabel.visibleProperty());
        this.resultLabel.managedProperty().bind((ObservableValue)this.resultLabel.visibleProperty());
        this.resultText.managedProperty().bind((ObservableValue)this.resultText.visibleProperty());
        this.targetUrnBox.managedProperty().bind((ObservableValue)this.targetUrnBox.visibleProperty());
        this.targetCertfileBox.managedProperty().bind((ObservableValue)this.targetCertfileBox.visibleProperty());
        this.privNameLabel.managedProperty().bind((ObservableValue)this.privNameLabel.visibleProperty());
        this.privNameText.managedProperty().bind((ObservableValue)this.privNameText.visibleProperty());
        this.canDelegateCheckBox.managedProperty().bind((ObservableValue)this.canDelegateCheckBox.visibleProperty());
        this.expireLabel.managedProperty().bind((ObservableValue)this.expireLabel.visibleProperty());
        this.expireText.managedProperty().bind((ObservableValue)this.expireText.visibleProperty());
        this.spokenForUrnLabel.visibleProperty().bind((ObservableValue)this.spokenForUrnText.visibleProperty());
        this.spokenForUrnNoteLabel.visibleProperty().bind((ObservableValue)this.spokenForUrnText.visibleProperty());
        this.generateNoteLabel.visibleProperty().bind((ObservableValue)this.generateButton.visibleProperty());
        this.resultLabel.visibleProperty().bind((ObservableValue)this.resultText.visibleProperty());
        this.saveResultButton.visibleProperty().bind((ObservableValue)this.resultText.visibleProperty());
        this.privNameLabel.visibleProperty().bind((ObservableValue)this.privNameText.visibleProperty());
        this.expireLabel.visibleProperty().bind((ObservableValue)this.expireText.visibleProperty());
        this.targetUrnBox.visibleProperty().bind((ObservableValue)this.targetViaUrn.selectedProperty());
        this.targetCertfileBox.visibleProperty().bind((ObservableValue)this.targetViaCert.selectedProperty());
        this.updateUser();
    }

    @FXML
    private void loadCertFile() {
        FileChooser fileChooser = new FileChooser();
        File file = fileChooser.showOpenDialog(null);
        if (file != null) {
            String filename = file.getPath();
            this.targetCertFilename.setText(filename);
            String fileContent = null;
            try {
                fileContent = IOUtils.fileToString((File)file);
                this.userCert = KeyUtil.pemToX509Certificate((String)fileContent);
            }
            catch (Exception e) {
                LOG.error("Error reading user certificate file \"" + filename + "\": " + e.getMessage(), (Throwable)e);
                this.targetCertFilename.setText("ERROR: " + e.getMessage());
                this.userCert = null;
            }
        }
    }

    private void updateUser() {
        if (this.geniUserProvider.isUserLoggedIn()) {
            this.spokenForUrnText.setText(this.geniUserProvider.getLoggedInGeniUser().getUserUrnString());
            this.generateButton.setDisable(false);
        } else {
            this.spokenForUrnText.setText("no user logged in");
            this.generateButton.setDisable(true);
        }
    }

    @Override
    protected void setResult(String text) {
        Platform.runLater(() -> this.resultText.setText(text));
    }

    public void generate() {
        int expireInDaysHelper;
        if (this.targetViaCert.isSelected() && this.userCert == null) {
            LOG.info("button clicked: generateDelegate not called since no certificate loaded yet");
            return;
        }
        if (this.generateSpeaksForThread != null) {
            LOG.debug("button clicked: generateSpeaksFor still running, so not called");
            return;
        }
        LOG.debug("button clicked: generateSpeaksFor called");
        this.generateButton.setDisable(true);
        try {
            expireInDaysHelper = Integer.parseInt(this.expireText.getText());
        }
        catch (NumberFormatException e) {
            LOG.debug("Error processing \"expire\": \"" + this.expireText.getText() + "\" is not a valid integer", (Throwable)e);
            this.setResult("Error processing \"expire\": \"" + this.expireText.getText() + "\" is not a valid integer");
            return;
        }
        int expireInDays = expireInDaysHelper;
        String privilegeName = this.privNameText.getText();
        boolean canDelegate = this.canDelegateCheckBox.isSelected();
        this.generateSpeaksForThread = new Thread(() -> {
            String targetUrn;
            if (this.targetViaUrn.isSelected()) {
                targetUrn = this.targetText.getText();
                this.userCert = this.certificateRetriever(targetUrn);
            } else {
                assert (this.userCert != null);
                targetUrn = this.findUrnInCertificate(this.userCert);
                assert (targetUrn != null);
            }
            this.generate_Helper(targetUrn, this.userCert, expireInDays, privilegeName, canDelegate);
            LOG.trace("generateSpeaksFor_Helper() returned");
            this.generateSpeaksForThread = null;
            Platform.runLater(() -> this.generateButton.setDisable(false));
        });
        this.generateSpeaksForThread.start();
    }

    public void generate_Helper(String speakerUrn, X509Certificate speakerCert, int expireInDays, String privilegeName, boolean canDelegate) {
        assert (!Platform.isFxApplicationThread());
        assert (this.geniUserProvider.isUserLoggedIn());
        LOG.trace("generateSpeaksFor_Helper() getting user info");
        Pair<GeniUrn, X509Certificate> userInfo = null;
        try {
            userInfo = this.getUserInfo(this.geniUserProvider.getLoggedInGeniUser().getUserUrnString());
        }
        catch (GeniUrn.GeniUrnParseException e) {
            LOG.error("User urn is invallid (should not occur!)", (Throwable)e);
            this.setResult("ERROR user urn is invalid: " + this.geniUserProvider.getLoggedInGeniUser().getUserUrnString());
            return;
        }
        catch (JFedException e) {
            LOG.error("Error in call for user urn info retrieval (should not occur!)", (Throwable)e);
            this.setResult("ERROR user urn is invalid: " + this.geniUserProvider.getLoggedInGeniUser().getUserUrnString());
            return;
        }
        PrivateKey userPrivateKey = this.geniUserProvider.getLoggedInGeniUser().getPrivateKey();
        Date expireDate = new Date(System.currentTimeMillis() + (long)(expireInDays * 24 * 60 * 60) * 1000L);
        try {
            LOG.trace("generateSpeaksFor_Helper() creating credential");
            SfaCredential speakForCredential = SfaCredential.createSpeaksFor(((GeniUrn)userInfo.getKey()).getValue(), speakerUrn, (X509Certificate)userInfo.getValue(), speakerCert, userPrivateKey, expireDate, privilegeName, canDelegate);
            LOG.trace("generateSpeaksFor_Helper() showing result");
            this.setResult(speakForCredential.getCredentialXml());
            this.parameterHistoryModel.addUserCredential((AnyCredential)speakForCredential);
        }
        catch (CredentialException e) {
            LOG.error("Exception creating speaks for credential", (Throwable)e);
            this.setResult("ERROR creating speaks for credential: " + e.getMessage());
        }
    }

    public void save() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Credential File");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Credential XML Files", new String[]{"*.xml"}));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"}));
        File file = fileChooser.showSaveDialog(this.root.getScene().getWindow());
        if (file != null) {
            try {
                IOUtils.stringToFile((File)file, (String)this.resultText.getText());
            }
            catch (Exception e) {
                LOG.error("Failed to save to file: " + file.getPath(), (Throwable)e);
            }
        }
    }
}

