/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.scanner;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetailsFactory;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.highlevel.history.ApiCallHistory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.scanner.AuthorityScannerInput;
import be.iminds.ilabt.jfed.scanner.AuthorityType;
import be.iminds.ilabt.jfed.scanner.ScanFeedback;
import be.iminds.ilabt.jfed.scanner.ServerScanner;
import be.iminds.ilabt.jfed.ui.javafx.log_gui.LogHistoryPanel;
import be.iminds.ilabt.jfed.ui.javafx.scanner.ScanFactPane;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.util.Pair;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanAuthorityDialogController {
    private static final Logger LOG = LoggerFactory.getLogger(ScanAuthorityDialogController.class);
    private final JavaFXLogger logger;
    private final GeniUserProvider geniUserProvider;
    private final JFedPreferences jFedPreferences;
    private final JFedConnectionProvider jFedConnectionProvider;
    private final SerializableApiCallDetailsFactory serializableApiCallDetailsFactory;
    @FXML
    private BorderPane pane;
    @FXML
    private LogHistoryPanel logHistoryPanel;
    @FXML
    private RadioButton basicRadioButton;
    @FXML
    private Label overviewLabelCon;
    @FXML
    private Label overviewLabelGV;
    @FXML
    private Label overviewLabelUrn;
    @FXML
    private Label overviewLabelType;
    @FXML
    private Pane inputPane;
    @FXML
    private TabPane tabs;
    @FXML
    private Tab securityTab;
    @FXML
    private Tab outputTab;
    @FXML
    private Tab overviewTab;
    @FXML
    private Tab debugTab;
    @FXML
    private TextField amUrlField;
    @FXML
    private TextField urnField;
    @FXML
    private ComboBox<AuthorityType> typeComboBox;
    @FXML
    private CheckBox proxyCheckBox;
    @FXML
    private HBox postScanButtons;
    @FXML
    private Button postScan1ShowButton;
    @FXML
    private HBox scanLogBox;
    @FXML
    private TextArea certTextArea;
    @FXML
    private TextArea scanLogTextArea;
    @FXML
    private ProgressIndicator progress1;
    @FXML
    private ProgressIndicator progress2;
    @FXML
    private Button scanButton;
    @FXML
    private Button cancelButton;
    @FXML
    private CheckBox trustCertsCheckbox;
    @FXML
    private Pane scannedFacts;
    private Stage stage;
    private ServerScanner scanner;
    private Map<ServerScanner.ScannedSingleFact, ScanFactPane> scanFactPaneByType;
    private Map<ServerScanner.ScannedSingleFact, ScanFactPane> scanFactPaneByHrn;
    private Map<ServerScanner.ScannedSingleFact, ScanFactPane> scanFactPaneByUrn;
    private Map<Pair<ApiInfo.Api, ServerScanner.ScannedSingleFact>, ScanFactPane> scanFactPaneByServertypeAndUrl;
    Thread scanThread = null;
    Testbed createTestbed = null;
    boolean cancelled = false;

    @Inject
    public ScanAuthorityDialogController(JavaFXLogger logger, GeniUserProvider geniUserProvider, JFedPreferences jFedPreferences, JFedConnectionProvider jFedConnectionProvider, SerializableApiCallDetailsFactory serializableApiCallDetailsFactory) {
        this.logger = logger;
        this.geniUserProvider = geniUserProvider;
        this.jFedPreferences = jFedPreferences;
        this.jFedConnectionProvider = jFedConnectionProvider;
        this.serializableApiCallDetailsFactory = serializableApiCallDetailsFactory;
    }

    @FXML
    private void initialize() {
        ApiCallHistory apiCallHistory = new ApiCallHistory((be.iminds.ilabt.jfed.log.Logger)this.logger, this.serializableApiCallDetailsFactory);
        this.logHistoryPanel.setApiCallHistory(apiCallHistory);
        this.inputPane.managedProperty().bind((ObservableValue)this.inputPane.visibleProperty());
        this.tabs.managedProperty().bind((ObservableValue)this.tabs.visibleProperty());
        this.postScanButtons.managedProperty().bind((ObservableValue)this.postScanButtons.visibleProperty());
        this.tabs.visibleProperty().setValue(Boolean.valueOf(false));
        String validatorCss = this.getClass().getResource("validation.css").toExternalForm();
        String scannerCss = this.getClass().getResource("scanner.css").toExternalForm();
        this.pane.getStylesheets().add((Object)validatorCss);
        this.pane.getStylesheets().add((Object)scannerCss);
        this.trustCertsCheckbox.getStylesheets().add((Object)validatorCss);
        this.amUrlField.textProperty().addListener((observableValue, s, s1) -> this.validate());
        ObservableList typeItems = FXCollections.observableArrayList();
        typeItems.addAll((Object[])AuthorityType.values());
        this.typeComboBox.setItems(typeItems);
        this.trustCertsCheckbox.setSelected(false);
    }

    private void setScanDebugLogText(String text) {
        this.scanLogTextArea.setText(text);
        this.scanLogTextArea.setScrollTop(Double.MAX_VALUE);
    }

    private void addScanDebugLogText(String text) {
        this.scanLogTextArea.appendText(text);
        this.scanLogTextArea.setScrollTop(Double.MAX_VALUE);
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public void cancel() {
        this.typeComboBox.getSelectionModel().clearSelection();
        this.amUrlField.setText("");
        this.urnField.setText("");
        this.cancelled = true;
        if (this.stage != null) {
            this.stage.close();
        }
    }

    public void restart() {
        this.cancelled = false;
        if (this.stage != null) {
            this.stage.close();
        }
    }

    public void scan() {
        this.setScanDebugLogText("");
        this.trustCertsCheckbox.setSelected(false);
        this.trustCertsCheckbox.getStyleClass().removeAll((Object[])new String[]{"validation-error", "validation-warning"});
        if (this.scanThread != null) {
            return;
        }
        this.inputPane.visibleProperty().setValue(Boolean.valueOf(false));
        this.tabs.visibleProperty().setValue(Boolean.valueOf(true));
        this.tabs.getSelectionModel().select((Object)this.debugTab);
        this.pane.getScene().getWindow().sizeToScene();
        this.amUrlField.setDisable(true);
        this.proxyCheckBox.setDisable(true);
        this.urnField.setDisable(true);
        this.typeComboBox.setDisable(true);
        this.scanButton.setDisable(true);
        this.cancelButton.setDisable(true);
        this.scanLogBox.setVisible(true);
        this.progress1.setVisible(true);
        this.progress2.setVisible(true);
        this.postScanButtons.setVisible(false);
        Runnable scanner = () -> {
            try {
                this.performScan();
            }
            catch (Throwable e) {
                Platform.runLater(() -> {
                    this.addScanDebugLogText("\nScanning encountered an error: " + e.getMessage() + "\n" + IOUtils.exceptionToStacktraceString((Throwable)e) + "\n");
                    this.amUrlField.setDisable(false);
                    this.proxyCheckBox.setDisable(false);
                    this.urnField.setDisable(false);
                    this.typeComboBox.setDisable(false);
                    this.scanButton.setDisable(false);
                    this.cancelButton.setDisable(false);
                    this.scanLogBox.setVisible(true);
                    this.progress1.setVisible(false);
                    this.progress2.setVisible(false);
                    this.postScanButtons.setVisible(false);
                });
            }
        };
        Thread scanThread = new Thread(scanner);
        scanThread.start();
    }

    private void performScan() {
        ScanFactPane pane;
        boolean useProxy = this.proxyCheckBox.isSelected();
        this.scanner = null;
        ArrayList<String> inputUrns = new ArrayList<String>();
        ArrayList<String> inputUrls = new ArrayList<String>();
        if (!this.amUrlField.getText().trim().isEmpty()) {
            inputUrls.add(this.amUrlField.getText());
        }
        if (!this.urnField.getText().trim().isEmpty()) {
            inputUrns.add(this.urnField.getText());
        }
        AuthorityType authorityType = null;
        if (!this.typeComboBox.getSelectionModel().isEmpty()) {
            authorityType = (AuthorityType)((Object)this.typeComboBox.getSelectionModel().getSelectedItem());
        }
        ArrayList<X509Certificate> trustedCerts = new ArrayList<X509Certificate>();
        ArrayList<X509Certificate> userCerts = new ArrayList<X509Certificate>();
        PrivateKey userPrivateKey = null;
        if (this.geniUserProvider.isUserLoggedIn()) {
            userCerts.addAll(this.geniUserProvider.getLoggedInGeniUser().getClientCertificateChain());
            userPrivateKey = this.geniUserProvider.getLoggedInGeniUser().getPrivateKey();
            Platform.runLater(() -> this.addScanDebugLogText("User " + this.geniUserProvider.getLoggedInGeniUser().getUserUrnString() + " is logged in: will use SSL with user authentication.\n"));
        } else {
            Platform.runLater(() -> this.addScanDebugLogText("No user logged in: will use SSL without user authentication.\n"));
        }
        AuthorityScannerInput input = new AuthorityScannerInput(inputUrns, inputUrls, trustedCerts, userCerts, userPrivateKey, authorityType, false);
        ScanFeedback feedback = new ScanFeedback(){

            @Override
            public boolean trustNonSelfSignedCert(List<X509Certificate> certificateList) {
                return true;
            }

            @Override
            public boolean trustSelfSignedCert(List<X509Certificate> certificateList) {
                return true;
            }

            @Override
            public boolean trustAlias(String urlHost, String certSubject) {
                return true;
            }
        };
        this.scanner = new ServerScanner((be.iminds.ilabt.jfed.log.Logger)this.logger, input, feedback, this.jFedPreferences, useProxy, this.geniUserProvider, this.jFedConnectionProvider);
        this.scanner.addResultListener(line -> Platform.runLater(() -> this.addScanDebugLogText(line + "\n")));
        this.scanner.setMode(this.basicRadioButton.isSelected() ? ServerScanner.Mode.BASIC : ServerScanner.Mode.EXPERIMENTAL);
        this.scanner.scan();
        StringBuilder certs = new StringBuilder();
        for (X509Certificate cert : this.scanner.getTrustedAuthCerts()) {
            certs.append(KeyUtil.x509certificateToPem((X509Certificate)cert)).append('\n');
        }
        boolean foundUrn = this.scanner.getUrns().isEmpty() ? false : this.scanner.getUrns().getMostTrustedScannedSingleFact().getCertainty().isMoreCertainThan(ServerScanner.ScanCertainty.USER_INPUT);
        boolean foundType = this.scanner.getTypes().isEmpty() ? false : this.scanner.getTypes().getMostTrustedScannedSingleFact().getCertainty().isMoreCertainThan(ServerScanner.ScanCertainty.USER_INPUT);
        Platform.runLater(() -> {
            this.certTextArea.setText(certs.toString());
            this.scannedFacts.getChildren().clear();
            this.overviewLabelCon.setText(this.scanner.isConnectionSuccess() ? "OK" : "FAIL");
            this.overviewLabelGV.setText(this.scanner.isGetVersionSuccess() ? "OK" : "FAIL");
            this.overviewLabelUrn.setText(foundUrn ? "OK" : "FAIL");
            this.overviewLabelType.setText(foundType ? "OK" : "FAIL");
            for (Label l : Arrays.asList(this.overviewLabelCon, this.overviewLabelGV, this.overviewLabelUrn, this.overviewLabelType)) {
                if (l.getText().startsWith("OK")) {
                    l.getStyleClass().add((Object)"overview-ok");
                    continue;
                }
                l.getStyleClass().add((Object)"overview-fail");
            }
        });
        this.scanFactPaneByType = new HashMap<ServerScanner.ScannedSingleFact, ScanFactPane>();
        this.scanFactPaneByUrn = new HashMap<ServerScanner.ScannedSingleFact, ScanFactPane>();
        this.scanFactPaneByHrn = new HashMap<ServerScanner.ScannedSingleFact, ScanFactPane>();
        this.scanFactPaneByServertypeAndUrl = new HashMap<Pair<ApiInfo.Api, ServerScanner.ScannedSingleFact>, ScanFactPane>();
        ArrayList<ScanFactPane> panes = new ArrayList<ScanFactPane>();
        for (ServerScanner.ScannedSingleFact<AuthorityType> scannedSingleFact : this.scanner.getTypes().getFacts()) {
            pane = new ScanFactPane("type", scannedSingleFact);
            if (scannedSingleFact == this.scanner.getTypes().getMostTrustedScannedSingleFact()) {
                pane.setSelected(true);
            } else {
                pane.setSelected(false);
            }
            panes.add(pane);
            this.scanFactPaneByType.put(scannedSingleFact, pane);
        }
        for (ServerScanner.ScannedSingleFact<Object> scannedSingleFact : this.scanner.getUrns().getFacts()) {
            pane = new ScanFactPane("urn", scannedSingleFact);
            if (scannedSingleFact == this.scanner.getUrns().getMostTrustedScannedSingleFact()) {
                pane.setSelected(true);
            } else {
                pane.setSelected(false);
            }
            panes.add(pane);
            this.scanFactPaneByUrn.put(scannedSingleFact, pane);
        }
        for (ServerScanner.ScannedSingleFact<Object> scannedSingleFact : this.scanner.getHrns().getFacts()) {
            pane = new ScanFactPane("hrn", scannedSingleFact);
            if (scannedSingleFact == this.scanner.getHrns().getMostTrustedScannedSingleFact()) {
                pane.setSelected(true);
            } else {
                pane.setSelected(false);
            }
            panes.add(pane);
            this.scanFactPaneByHrn.put(scannedSingleFact, pane);
        }
        LOG.debug("scanner.getUrlsByApi().size()=" + this.scanner.getUrlsByApi().size());
        for (Map.Entry entry : this.scanner.getUrlsByApi().entrySet()) {
            ApiInfo.Api st = (ApiInfo.Api)entry.getKey();
            ServerScanner.ScannedInformation urls = (ServerScanner.ScannedInformation)entry.getValue();
            for (ServerScanner.ScannedSingleFact fact : urls.getFacts()) {
                LOG.debug("scanner.getUrlsByApi() api=" + String.valueOf(st) + " fact=" + String.valueOf(fact) + (fact == urls.getMostTrustedScannedSingleFact() ? " (MOST TRUSTED)" : ""));
                ScanFactPane pane2 = new ScanFactPane(String.valueOf((Object)st.getName()) + " v" + st.getVersion() + " URL", fact);
                if (fact == urls.getMostTrustedScannedSingleFact() && fact != null && fact.getCertainty().value > ServerScanner.ScanCertainty.GOOD_GUESS.value && fact.getCertainty() != ServerScanner.ScanCertainty.USER_INPUT) {
                    pane2.setSelected(true);
                } else {
                    pane2.setSelected(false);
                }
                panes.add(pane2);
                this.scanFactPaneByServertypeAndUrl.put((Pair<ApiInfo.Api, ServerScanner.ScannedSingleFact>)new Pair((Object)st, fact), pane2);
            }
        }
        Platform.runLater(() -> this.scannedFacts.getChildren().setAll((Collection)panes));
        boolean atLeastUserProvidedUrn = this.scanner.getUrns().isEmpty() ? false : this.scanner.getUrns().getMostTrustedScannedSingleFact().getCertainty().isMoreOrEqualCertainThan(ServerScanner.ScanCertainty.USER_INPUT);
        Platform.runLater(() -> {
            this.addScanDebugLogText("\nScanning finished successfully. You can now review the scan results.\n");
            this.amUrlField.setDisable(false);
            this.urnField.setDisable(false);
            this.typeComboBox.setDisable(false);
            this.scanButton.setDisable(false);
            this.cancelButton.setDisable(false);
            this.scanLogBox.setVisible(true);
            this.progress1.setVisible(false);
            this.progress2.setVisible(false);
            this.postScanButtons.setVisible(true);
            this.postScan1ShowButton.setDisable(false);
            if (!foundUrn && !atLeastUserProvidedUrn) {
                this.postScan1ShowButton.setText("Show (Incomplete) Results");
            } else {
                this.postScan1ShowButton.setText("Show Results");
            }
            if (this.basicRadioButton.isSelected()) {
                this.tabs.getSelectionModel().select((Object)this.overviewTab);
            } else {
                this.tabs.getSelectionModel().select((Object)this.outputTab);
            }
        });
        this.scanThread = null;
    }

    public void showScanResults() {
        ScanFactPane pane;
        if (this.scanner == null) {
            return;
        }
        if (this.scanner != null && !this.scanner.getTrustedAuthCerts().isEmpty() && !this.trustCertsCheckbox.isSelected()) {
            this.trustCertsCheckbox.getStyleClass().add((Object)"validation-error");
            this.tabs.getSelectionModel().select((Object)this.securityTab);
            this.trustCertsCheckbox.requestFocus();
            return;
        }
        this.trustCertsCheckbox.getStyleClass().removeAll((Object[])new String[]{"validation-warning", "validation-error"});
        ServerScanner.ScannedInformation<AuthorityType> types = new ServerScanner.ScannedInformation<AuthorityType>();
        HashMap<ApiInfo.Api, ServerScanner.ScannedInformation<String>> urlsByServerType = new HashMap<ApiInfo.Api, ServerScanner.ScannedInformation<String>>();
        ServerScanner.ScannedInformation<String> hrns = new ServerScanner.ScannedInformation<String>();
        ServerScanner.ScannedInformation<String> urns = new ServerScanner.ScannedInformation<String>();
        Set<X509Certificate> trustedAuthCerts = this.scanner.getTrustedAuthCerts();
        String trustedAlias = this.scanner.getTrustedAlias();
        for (ServerScanner.ScannedSingleFact<AuthorityType> scannedSingleFact : this.scanner.getTypes().getFacts()) {
            pane = this.scanFactPaneByType.get(scannedSingleFact);
            if (!pane.isSelected()) continue;
            types.add(scannedSingleFact);
        }
        for (ServerScanner.ScannedSingleFact<Object> scannedSingleFact : this.scanner.getUrns().getFacts()) {
            pane = this.scanFactPaneByUrn.get(scannedSingleFact);
            if (!pane.isSelected()) continue;
            urns.add(scannedSingleFact);
        }
        for (ServerScanner.ScannedSingleFact<Object> scannedSingleFact : this.scanner.getHrns().getFacts()) {
            pane = this.scanFactPaneByHrn.get(scannedSingleFact);
            if (!pane.isSelected()) continue;
            hrns.add(scannedSingleFact);
        }
        for (Map.Entry entry : this.scanner.getUrlsByApi().entrySet()) {
            ApiInfo.Api st = (ApiInfo.Api)entry.getKey();
            ServerScanner.ScannedInformation urls = (ServerScanner.ScannedInformation)entry.getValue();
            for (ServerScanner.ScannedSingleFact fact : urls.getFacts()) {
                ScanFactPane pane2 = this.scanFactPaneByServertypeAndUrl.get(new Pair((Object)st, fact));
                if (!pane2.isSelected()) continue;
                if (!urlsByServerType.containsKey(st)) {
                    urlsByServerType.put(st, new ServerScanner.ScannedInformation());
                }
                ((ServerScanner.ScannedInformation)urlsByServerType.get(st)).add(fact);
            }
        }
        this.createTestbed = ServerScanner.createResult(types, urlsByServerType, hrns, urns, trustedAuthCerts, trustedAlias);
        this.createTestbed = new TestbedBuilder(this.createTestbed).createMinimized(JsonLdObjectsMetaData.Minimization.FULL_EMBED_ONLY_CHILDREN);
        if (this.stage != null) {
            this.stage.close();
        }
    }

    public void validate() {
        this.amUrlField.getStyleClass().removeAll((Object[])new String[]{"validation-error", "validation-warning"});
        try {
            URL uRL = new URL(this.amUrlField.getText());
        }
        catch (MalformedURLException e) {
            this.amUrlField.getStyleClass().add((Object)"validation-error");
        }
    }

    public String getAMUrl() {
        if (Objects.equals(this.amUrlField.getText(), "")) {
            return null;
        }
        return this.amUrlField.getText();
    }

    public Testbed getCreatedTestbed() {
        return this.createTestbed;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

