/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.scanner;

import be.iminds.ilabt.jfed.scanner.ServerScanner;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;

public class ScanFactPane
extends HBox {
    private final CheckBox select;
    private final Label type;
    private final Label certainityLab;
    private final Label certainityVal;
    private final Label valueLab;
    private final Label valueVal;
    private final String singleFactName;
    private final ServerScanner.ScannedSingleFact singleFact;
    private static final String scannerCss = ScanFactPane.class.getResource("scanner.css").toExternalForm();

    public ScanFactPane(String singleFactName, ServerScanner.ScannedSingleFact singleFact) {
        this.getStylesheets().add((Object)scannerCss);
        this.singleFact = singleFact;
        this.singleFactName = singleFactName;
        this.select = new CheckBox();
        this.type = new Label(singleFactName);
        this.certainityLab = new Label("Certainity:");
        this.certainityVal = new Label(singleFact.getCertainty().toString());
        this.valueLab = new Label("Value:");
        this.valueVal = new Label(String.valueOf(singleFact.getFact()));
        this.select.setSelected(true);
        this.getStyleClass().add((Object)"scan-box");
        this.type.getStyleClass().add((Object)"scan-typename");
        this.certainityLab.getStyleClass().add((Object)"scan-label");
        this.certainityVal.getStyleClass().add((Object)"scan-value");
        this.valueLab.getStyleClass().add((Object)"scan-label");
        this.valueVal.getStyleClass().add((Object)"scan-value");
        String certHelper = singleFact.getCertainty().toString().toLowerCase().replaceAll("_", "-");
        this.certainityVal.getStyleClass().add((Object)("certainty-" + certHelper));
        this.getChildren().addAll((Object[])new Node[]{this.select, this.type, this.certainityLab, this.certainityVal, this.valueLab, this.valueVal});
    }

    public ServerScanner.ScannedSingleFact getSingleFact() {
        return this.singleFact;
    }

    public boolean isSelected() {
        return this.select.isSelected();
    }

    public void setSelected(boolean newSelected) {
        this.select.setSelected(newSelected);
    }
}

