/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.scanner;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.ui.javafx.scanner.ScanResultPanelController;
import java.io.IOException;
import java.net.URL;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ScanResultPanelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ScanResultPanelFactory.class);
    private static final String SCAN_RESULT_PANEL_FXML = "ScanResultPanel.fxml";
    private final FXMLLoader loader;

    @Inject
    ScanResultPanelFactory(FXMLLoader loader) {
        this.loader = loader;
    }

    public boolean showScanResultPanel(Testbed testbed, boolean dialog) {
        Stage stage = new Stage();
        stage.setTitle("Server Scan Result");
        if (dialog) {
            stage.initStyle(StageStyle.UTILITY);
            stage.initModality(Modality.APPLICATION_MODAL);
        }
        try {
            URL location = this.getClass().getResource(SCAN_RESULT_PANEL_FXML);
            this.loader.setLocation(location);
            stage.setScene(new Scene((Parent)this.loader.load()));
            ScanResultPanelController controller = (ScanResultPanelController)this.loader.getController();
            controller.setTestbed(testbed);
            controller.setStage(stage);
            stage.sizeToScene();
            LOG.debug("Showing scanner panel");
            controller.showJsonSnippet();
            stage.showAndWait();
            return controller.isScanAgain();
        }
        catch (IOException ex) {
            LOG.error("Error while loading ScanResultPanel", (Throwable)ex);
            return false;
        }
    }
}

