/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.scanner;

import be.iminds.ilabt.jfed.base_gui.BaseGuiModule;
import be.iminds.ilabt.jfed.base_gui.UncaughtGuiExceptionLogger;
import be.iminds.ilabt.jfed.base_gui.util.GuiceContext;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.highlevel.LowLevelModule;
import be.iminds.ilabt.jfed.highlevel.UserLoginModelModule;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.ui.javafx.scanner.ScanResultPanelFactory;
import be.iminds.ilabt.jfed.ui.javafx.scanner.ScanServerDialogFactory;
import be.iminds.ilabt.jfed.ui.javafx.userlogin.AdvancedUserLoginDialog;
import be.iminds.ilabt.jfed.ui.javafx.util.ExtraInfoCallBackGUIs;
import java.util.ArrayList;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScannerStandalone
extends Application
implements GeniUserProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ScannerStandalone.class);
    public static boolean debugEnabled = false;
    private final GuiceContext context = new GuiceContext((Object)this, () -> {
        ArrayList<Object> modules = new ArrayList<Object>();
        modules.add(new LowLevelModule());
        modules.add(new UserLoginModelModule(false));
        modules.add(new BaseGuiModule());
        modules.add(binder -> binder.bind(GeniUserProvider.class).toInstance((Object)this));
        return modules;
    });
    @Inject
    private Provider<AdvancedUserLoginDialog> advancedUserLoginDialogProvider;
    @Inject
    private ScanServerDialogFactory scanServerDialogFactory;
    @Inject
    private ScanResultPanelFactory scanResultPanelFactory;
    @Inject
    private TestbedInfoSource testbedInfoSource;
    private GeniUser loggedInGeniUser = null;

    public static void main(String[] args) {
        for (String arg : args) {
            if (!arg.equalsIgnoreCase("debug") && !arg.equalsIgnoreCase("--debug") && !arg.equalsIgnoreCase("-debug")) continue;
            debugEnabled = true;
        }
        ScannerStandalone.launch((String[])args);
    }

    public void start(Stage stage) throws Exception {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)UncaughtGuiExceptionLogger.getInstance((Stage)stage));
        this.context.init();
        ExtraInfoCallBackGUIs.prepareExtraInfoCallback((Window)stage);
        stage.setOnCloseRequest(event -> this.exit());
        this.loggedInGeniUser = ((AdvancedUserLoginDialog)this.advancedUserLoginDialogProvider.get()).showUserLogin((Window)stage);
        if (!this.isUserLoggedIn()) {
            this.exit();
        }
        while (this.showScanner()) {
        }
        this.exit();
    }

    public boolean showScanner() {
        ScanServerDialogFactory.ScanServerDialogResult scanServerDialogResult = this.scanServerDialogFactory.showScanAuthorityDialog(false);
        if (scanServerDialogResult == null) {
            return false;
        }
        if (scanServerDialogResult.getResult() == null) {
            return scanServerDialogResult.isScanAgain();
        }
        Testbed testbed = scanServerDialogResult.getResult();
        LOG.debug("Showing scanner for auth " + String.valueOf(testbed == null ? null : testbed.getDefaultComponentManagerAsGeniUrn()));
        boolean scanAgain = this.scanResultPanelFactory.showScanResultPanel(testbed, false);
        return scanAgain;
    }

    public void exit() {
        LOG.info("Close was requested. Trying to terminate");
        Platform.exit();
        System.exit(0);
    }

    @Override
    @Nonnull
    public GeniUser getLoggedInGeniUser() {
        return this.loggedInGeniUser;
    }

    @Override
    public boolean isUserLoggedIn() {
        return this.loggedInGeniUser != null;
    }

    static {
        System.setProperty("java.awt.headless", "false");
    }
}

