/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model;

import be.iminds.ilabt.jfed.rspec.model.AddressPool;
import be.iminds.ilabt.jfed.rspec.model.IPv4;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.OpenflowDataPath;
import be.iminds.ilabt.jfed.rspec.model.OpenflowSliver;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.io.ByteArrayOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestSliverFinder {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestSliverFinder.class);
    private static final int MAX_IP_IN_SLIVERNAME = 3;
    public static final String IP_POOL_PREFIX = "ip-pool-";
    public static final String OPENFLOW_SLIVER_PREFIX = "oflow-sliver-";

    /*
     * WARNING - void declaration
     */
    @Nonnull
    private static String ipsToSliverName(List<? extends IPv4> ip4s) {
        void var4_6;
        int count = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (IPv4 iPv4 : ip4s) {
            try {
                byte[] bytes = InetAddress.getByName(iPv4.getAddress()).getAddress();
                baos.write(bytes, 0, bytes.length);
            }
            catch (UnknownHostException e) {
                LOG.warn("Invalid IP in manifest Rspec AddressPool: " + iPv4.getAddress(), (Throwable)e);
                byte[] bytes = new byte[]{-1, -1, -1, -1};
                baos.write(bytes, 0, bytes.length);
            }
            if (++count < 3) continue;
            break;
        }
        byte[] bytes = baos.toByteArray();
        String string = "";
        for (byte b : bytes) {
            String string2 = (String)var4_6 + String.format("%02X", b);
        }
        return var4_6;
    }

    public static Collection<GeniUrn> findSliversInManifest(String manifestRspecString) {
        ManifestRspecSource manifestRspecSource = new ManifestRspecSource(manifestRspecString, ModelRspecType.BASIC);
        return ManifestSliverFinder.findSliversInManifest(manifestRspecSource);
    }

    public static Collection<GeniUrn> findSliversInManifest(ManifestRspecSource manifestRspecSource) {
        ArrayList<GeniUrn> res = new ArrayList<GeniUrn>();
        ImmutableModelRspec rspec = manifestRspecSource.getImmutableModelRspec();
        if (rspec == null) {
            return res;
        }
        for (RspecNode rspecNode : rspec.getNodes()) {
            if (rspecNode.getSliverId() == null) continue;
            res.add(rspecNode.getSliverId());
        }
        for (RspecLink rspecLink : rspec.getLinks()) {
            if (rspecLink.getSliverId() == null) continue;
            res.add(rspecLink.getSliverId());
        }
        for (AddressPool addressPool : rspec.getAddressPools()) {
            GeniUrn geniUrn = addressPool.getComponentManagerId();
            String ipName = ManifestSliverFinder.ipsToSliverName(addressPool.getIPv4s());
            if (ipName.isEmpty() || addressPool.getCount() == null || addressPool.getCount() <= 0) continue;
            String uniqueName = IP_POOL_PREFIX + addressPool.getClientId() + "-" + ipName;
            GeniUrn poolUrn = GeniUrn.createGeniUrnFromEncodedParts((String)geniUrn.getEncodedTopLevelAuthority(), (String)"sliver", (String)uniqueName);
            res.add(poolUrn);
        }
        int indexForFakeSlivers = 0;
        for (OpenflowSliver openflowSliver : rspec.getOpenflowSlivers()) {
            Set cms = openflowSliver.getGroups().stream().flatMap(g -> g.getDataPaths().stream()).map(OpenflowDataPath::getComponentManagerId).map(cm -> GeniUrn.parse((String)cm)).filter(Objects::nonNull).collect(Collectors.toSet());
            if (cms.isEmpty()) continue;
            GeniUrn cmUrn = (GeniUrn)cms.iterator().next();
            String uniqueName = OPENFLOW_SLIVER_PREFIX + indexForFakeSlivers;
            ++indexForFakeSlivers;
            GeniUrn fakeSliverUrn = GeniUrn.createGeniUrnFromDecodedParts((String)cmUrn.getTopLevelAuthority(), (String)"sliver", (String)uniqueName);
            res.add(fakeSliverUrn);
        }
        return res;
    }
}

