/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model;

import be.iminds.ilabt.jfed.rspec.model.DiskImage;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SliverType {
    private final String name;
    private final List<DiskImage> diskImages;
    private final Integer xenCores;
    private final Integer xenRam;
    private final Integer xenDisk;
    private final List<ExtraXml> other;
    private final List<String> diskImageListRefs;
    private final List<String> flavors;
    private final List<String> flavorListRefs;

    protected SliverType(String name, Collection<DiskImage> diskImages, Integer xenCores, Integer xenRam, Integer xenDisk, List<String> diskImageListRefs, List<String> flavorListRefs, List<String> flavors, Collection<ExtraXml> other) {
        this.name = name;
        this.diskImages = diskImages == null ? new ArrayList<DiskImage>() : new ArrayList<DiskImage>(diskImages);
        this.diskImageListRefs = diskImageListRefs == null ? new ArrayList<String>() : new ArrayList<String>(diskImageListRefs);
        this.flavorListRefs = flavorListRefs == null ? new ArrayList<String>() : new ArrayList<String>(flavorListRefs);
        this.flavors = flavors == null ? new ArrayList<String>() : new ArrayList<String>(flavors);
        this.other = other == null ? new ArrayList<ExtraXml>() : new ArrayList<ExtraXml>(other);
        this.xenCores = xenCores;
        this.xenRam = xenRam;
        this.xenDisk = xenDisk;
    }

    public String getName() {
        return this.name;
    }

    public List<ExtraXml> getExtraXml() {
        return Collections.unmodifiableList(this.other);
    }

    public List<DiskImage> getDiskImages() {
        return Collections.unmodifiableList(this.diskImages);
    }

    public Integer getXenCores() {
        return this.xenCores;
    }

    public Integer getXenRam() {
        return this.xenRam;
    }

    public Integer getXenDisk() {
        return this.xenDisk;
    }

    @Nonnull
    public List<String> getFlavorListRefs() {
        return Collections.unmodifiableList(this.flavorListRefs);
    }

    @Nonnull
    public List<String> getFlavors() {
        return Collections.unmodifiableList(this.flavors);
    }

    @Nonnull
    public List<String> getDiskImageListRefs() {
        return Collections.unmodifiableList(this.diskImageListRefs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SliverType that = (SliverType)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.diskImages, that.diskImages) && Objects.equals(this.xenCores, that.xenCores) && Objects.equals(this.xenRam, that.xenRam) && Objects.equals(this.xenDisk, that.xenDisk) && Objects.equals(this.other, that.other) && Objects.equals(this.diskImageListRefs, that.diskImageListRefs) && Objects.equals(this.flavorListRefs, that.flavorListRefs) && Objects.equals(this.flavors, that.flavors);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.diskImages, this.xenCores, this.xenRam, this.xenDisk, this.other, this.diskImageListRefs, this.flavorListRefs, this.flavors);
    }

    public String toString() {
        return "SliverType{name='" + this.name + "', diskImages=" + String.valueOf(this.diskImages) + ", xenCores=" + this.xenCores + ", xenRam=" + this.xenRam + ", xenDisk=" + this.xenDisk + ", other=" + String.valueOf(this.other) + ", diskImageListRefs=" + String.valueOf(this.diskImageListRefs) + ", flavorListRefs=" + String.valueOf(this.flavorListRefs) + ", flavors=" + String.valueOf(this.flavors) + "}";
    }

    public boolean hasXen() {
        return this.xenCores != null || this.xenDisk != null || this.xenRam != null;
    }
}

