/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model;

import be.iminds.ilabt.jfed.rspec.model.DiskImage;
import be.iminds.ilabt.jfed.rspec.model.SliverType;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SliverTypeBuilder {
    private String name;
    private List<DiskImage> diskImages;
    private List<String> diskImageListRefs;
    private List<String> flavorListRefs;
    private List<String> flavors;
    private Integer xenCores;
    private Integer xenRam;
    private Integer xenDisk;
    private List<ExtraXml> other;

    public SliverTypeBuilder() {
        this.name = null;
        this.diskImages = new ArrayList<DiskImage>();
        this.diskImageListRefs = new ArrayList<String>();
        this.flavorListRefs = new ArrayList<String>();
        this.flavors = new ArrayList<String>();
        this.other = new ArrayList<ExtraXml>();
    }

    public SliverTypeBuilder(String name) {
        this.name = name;
        this.diskImages = new ArrayList<DiskImage>();
        this.diskImageListRefs = new ArrayList<String>();
        this.flavorListRefs = new ArrayList<String>();
        this.flavors = new ArrayList<String>();
        this.other = new ArrayList<ExtraXml>();
    }

    public SliverTypeBuilder(SliverType base) {
        this.name = base.getName();
        this.diskImages = new ArrayList<DiskImage>(base.getDiskImages());
        this.diskImageListRefs = new ArrayList<String>(base.getDiskImageListRefs());
        this.flavorListRefs = new ArrayList<String>(base.getFlavorListRefs());
        this.flavors = new ArrayList<String>(base.getFlavors());
        this.other = new ArrayList<ExtraXml>(base.getExtraXml());
        this.xenCores = base.getXenCores();
        this.xenRam = base.getXenRam();
        this.xenDisk = base.getXenDisk();
    }

    public SliverType build() {
        if (this.name == null) {
            throw new RuntimeException("should not make sliver_type without name");
        }
        return new SliverType(this.name, this.diskImages, this.xenCores, this.xenRam, this.xenDisk, this.diskImageListRefs, this.flavorListRefs, this.flavors, this.other);
    }

    public boolean isValid() {
        return this.name != null;
    }

    public SliverTypeBuilder xenCores(Integer i) {
        this.xenCores = i;
        return this;
    }

    public SliverTypeBuilder xenRam(Integer i) {
        this.xenRam = i;
        return this;
    }

    public SliverTypeBuilder xenDisk(Integer i) {
        this.xenDisk = i;
        return this;
    }

    public SliverTypeBuilder name(String name) {
        this.name = name;
        return this;
    }

    public SliverTypeBuilder setExtraXml(List<ExtraXml> extraXmlList) {
        this.other = new ArrayList<ExtraXml>(extraXmlList);
        return this;
    }

    public SliverTypeBuilder addExtraXml(ExtraXml extraXml) {
        this.other.add(extraXml);
        return this;
    }

    public SliverTypeBuilder setDiskImage(DiskImage di) {
        this.diskImages.clear();
        if (di != null) {
            this.diskImages.add(di);
        }
        return this;
    }

    public SliverTypeBuilder addDiskImage(DiskImage diskImage) {
        if (diskImage == null) {
            throw new IllegalArgumentException("diskImage argument may not be null");
        }
        this.diskImages.add(diskImage);
        return this;
    }

    public SliverTypeBuilder addDiskImage(String diskImageName) {
        if (diskImageName == null) {
            throw new IllegalArgumentException("diskImageName argument may not be null");
        }
        this.diskImages.add(new DiskImage(diskImageName));
        return this;
    }

    public SliverTypeBuilder setDiskImages(Collection<DiskImage> diList) {
        assert (diList != null);
        this.diskImages = new ArrayList<DiskImage>(diList);
        return this;
    }

    public SliverTypeBuilder addDiskImageListRef(String diskImageListRef) {
        this.diskImageListRefs.add(diskImageListRef);
        return this;
    }

    public SliverTypeBuilder addFlavorListRef(String flavorListRef) {
        this.flavorListRefs.add(flavorListRef);
        return this;
    }

    public SliverTypeBuilder setDiskImageListRefs(List<String> diskImageListRefs) {
        assert (diskImageListRefs != null);
        this.diskImageListRefs = new ArrayList<String>(diskImageListRefs);
        return this;
    }

    public SliverTypeBuilder setFlavorListRefs(List<String> flavorListRefs) {
        assert (flavorListRefs != null);
        this.flavorListRefs = new ArrayList<String>(flavorListRefs);
        return this;
    }

    public SliverTypeBuilder addFlavor(String flavor) {
        this.flavors.add(flavor);
        return this;
    }

    public SliverTypeBuilder setFlavors(List<String> flavors) {
        assert (flavors != null);
        this.flavors = new ArrayList<String>(flavors);
        return this;
    }
}

