/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model;

import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import java.io.StringReader;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.ElementNameAndAttributeQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class StringRspec
extends BasicStringRspec {
    private static final Logger LOG = LoggerFactory.getLogger(StringRspec.class);

    public StringRspec(@Nonnull String xmlString) {
        super(xmlString);
    }

    private static Document isSimilarXmlHelper_StringToDocument(@Nonnull String rspec) throws TransformerException, ParserConfigurationException {
        String xslt = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- Remove unwanted attributes or/and nodes -->\n<xsl:stylesheet version=\"1.0\"      xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"      xmlns:fo=\"http://www.w3.org/1999/XSL/Format\"     xmlns:jFed=\"http://jfed.iminds.be/rspec/ext/jfed/1\" >\n    <xsl:output method=\"xml\" encoding=\"UTF-8\" indent=\"yes\"/>\n \n    <!-- Copy everything -->\n    <xsl:template match=\"@*|node()|text()|comment()|processing-instruction()\">\n        <xsl:copy>\n            <xsl:apply-templates select=\"@*|node()|text()|comment()|processing-instruction()\"/>\n        </xsl:copy>\n    </xsl:template>\n \n    <!-- To remove attributes or nodes, simply write a matching template that doesn't do anything. Therefore, it is removed -->\n    <xsl:template match=\"/*[local-name()='rspec']/@generated\"/>\n    <xsl:template match=\"/*[local-name()='rspec']/@generated_by\"/>\n    <xsl:template match=\"/*[local-name()='rspec']/@xmlns:jFed\"/>\n    <xsl:template match=\"jFed:*\"/>\n \n</xsl:stylesheet>";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        TransformerFactory factory = TransformerFactory.newInstance();
        Templates template = factory.newTemplates(new StreamSource(new StringReader(xslt)));
        Transformer xformer = template.newTransformer();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        assert (builder.isNamespaceAware());
        Document doc = builder.newDocument();
        DOMResult result = new DOMResult(doc);
        StreamSource source = new StreamSource(new StringReader(rspec));
        xformer.transform(source, result);
        assert (result.getNode().getNodeType() == 9);
        return (Document)result.getNode();
    }

    public static boolean isSimilarXml(@Nonnull String a, @Nonnull String b) {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLUnit.setIgnoreComments((boolean)true);
        try {
            Document origRspecDoc = StringRspec.isSimilarXmlHelper_StringToDocument(a);
            Document reconstructedRspecDoc = StringRspec.isSimilarXmlHelper_StringToDocument(b);
            DetailedDiff diff = new DetailedDiff(XMLUnit.compareXML((Document)origRspecDoc, (Document)reconstructedRspecDoc));
            diff.overrideElementQualifier((ElementQualifier)new ElementNameAndAttributeQualifier());
            boolean similar = diff.similar();
            List allDifferences = diff.getAllDifferences();
            if (!similar) {
                Object diffString = "";
                for (Object o : allDifferences) {
                    diffString = (String)diffString + String.valueOf(o) + "\n";
                }
                LOG.debug("Differences found: " + (String)diffString + "\n\nA XML:\n" + a + "\n\nB XML\n" + b);
            }
            return similar;
        }
        catch (ParserConfigurationException e) {
            LOG.warn("StringRspec.isSimilarXml ParserConfigurationException. Will treat XML as different. " + e.getMessage() + "\n\nA XML:\n" + a + "\n\nB XML\n" + b + "\n---", (Throwable)e);
            return false;
        }
        catch (TransformerException e) {
            LOG.warn("StringRspec.isSimilarXml TransformerException. Will treat XML as different. " + e.getMessage() + "\n\nA XML:\n" + a + "\n\nB XML\n" + b + "\n---", (Throwable)e);
            return false;
        }
    }

    public boolean isSimilarXml(@Nonnull StringRspec other) {
        return StringRspec.isSimilarXml(this.xmlString, other.xmlString);
    }
}

