/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model.impl;

import be.iminds.ilabt.jfed.rspec.model.Channel;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicChannel
implements Channel {
    private static final Logger LOG = LoggerFactory.getLogger(BasicChannel.class);
    private GeniUrn componentManagerId;
    private GeniUrn componentId;
    private String componentName;
    private String frequency;
    private double editorX = -1.0;
    private double editorY = -1.0;
    private final List<String> leaseIdRefs = new ArrayList<String>();
    private final List<ExtraXml> extraXml = new ArrayList<ExtraXml>();

    public BasicChannel(Channel channel) {
        this.componentId = channel.getComponentId();
        this.componentManagerId = channel.getComponentManagerId();
        this.componentName = channel.getComponentName();
        this.frequency = channel.getFrequency();
        this.editorX = channel.getEditorX();
        this.editorY = channel.getEditorY();
        this.leaseIdRefs.addAll(channel.getLeaseIdRefs());
    }

    public BasicChannel() {
    }

    @Override
    public GeniUrn getComponentId() {
        return this.componentId;
    }

    @Override
    public void setComponentId(GeniUrn componentId) {
        this.componentId = componentId;
    }

    @Override
    public void setComponentId(String value) {
        if (value == null) {
            this.componentId = null;
            return;
        }
        GeniUrn geniUrn = GeniUrn.parse((String)value);
        if (geniUrn != null) {
            this.componentId = geniUrn;
        } else {
            LOG.warn("Could not set componentId to {} as it is not a valid URN!", (Object)value);
            this.componentId = null;
        }
    }

    @Override
    public GeniUrn getComponentManagerId() {
        return this.componentManagerId;
    }

    @Override
    public void setComponentManagerId(GeniUrn componentManagerId) {
        this.componentManagerId = componentManagerId;
    }

    @Override
    public void setComponentManagerId(String value) {
        if (value == null) {
            this.componentManagerId = null;
            return;
        }
        GeniUrn geniUrn = GeniUrn.parse((String)value);
        if (geniUrn != null) {
            this.componentManagerId = geniUrn;
        } else {
            LOG.warn("Could not set componentManagerId to {} as it is not a valid URN!", (Object)value);
            this.componentManagerId = null;
        }
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    @Override
    public String getFrequency() {
        return this.frequency;
    }

    @Override
    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    @Override
    public double getEditorX() {
        return this.editorX;
    }

    @Override
    public void setEditorX(double value) {
        this.editorX = value;
    }

    @Override
    public double getEditorY() {
        return this.editorY;
    }

    @Override
    public void setEditorY(double value) {
        this.editorY = value;
    }

    @Override
    public void addLeaseIdRef(String leaseIdRef) {
        this.leaseIdRefs.add(leaseIdRef);
    }

    @Override
    public List<String> getLeaseIdRefs() {
        return this.leaseIdRefs;
    }

    @Override
    public List<ExtraXml> getExtraXml() {
        return this.extraXml;
    }
}

