/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model.impl;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.rspec.model.AddressPool;
import be.iminds.ilabt.jfed.rspec.model.Channel;
import be.iminds.ilabt.jfed.rspec.model.DiskImageList;
import be.iminds.ilabt.jfed.rspec.model.DistributeSshKeypair;
import be.iminds.ilabt.jfed.rspec.model.ExecuteAnsiblePlaybook;
import be.iminds.ilabt.jfed.rspec.model.FlavorList;
import be.iminds.ilabt.jfed.rspec.model.HardwareTypeInfo;
import be.iminds.ilabt.jfed.rspec.model.Lease;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.OpenflowDataPath;
import be.iminds.ilabt.jfed.rspec.model.OpenflowSliver;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecFactoryFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicAddressPool;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicChannel;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicDistributeSshKeypair;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicExecuteAnsiblePlaybook;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicLease;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicOpenflowDataPath;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicRspecInterface;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicRspecLink;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicRspecNode;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.rspec.parser.RspecParseException;
import be.iminds.ilabt.jfed.rspec.parser.StaxRspecWriter;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicModelRspec
implements ModelRspec {
    private static final Logger LOG = LoggerFactory.getLogger(BasicModelRspec.class);
    private final List<ExtraXml> extraXml = new ArrayList<ExtraXml>();
    private final Map<String, String> origNameSpaceInfo = new HashMap<String, String>();
    private final List<BasicRspecNode> nodes = new ArrayList<BasicRspecNode>();
    private final List<BasicRspecLink> links = new ArrayList<BasicRspecLink>();
    private final List<BasicLease> leases = new ArrayList<BasicLease>();
    private final List<BasicChannel> channels = new ArrayList<BasicChannel>();
    private final List<BasicOpenflowDataPath> openflowDataPaths = new ArrayList<BasicOpenflowDataPath>();
    private final List<OpenflowSliver> openflowSlivers = new ArrayList<OpenflowSliver>();
    private final List<BasicAddressPool> addressPools = new ArrayList<BasicAddressPool>();
    private final List<BasicExecuteAnsiblePlaybook> ansibleCookbooks = new ArrayList<BasicExecuteAnsiblePlaybook>();
    private final List<BasicDistributeSshKeypair> distributeSshKeypairs = new ArrayList<BasicDistributeSshKeypair>();
    private final List<DiskImageList> diskImageLists = new ArrayList<DiskImageList>();
    private final List<FlavorList> flavorLists = new ArrayList<FlavorList>();
    private String origDefaultNamespace = null;
    private String origSchemaLocation = null;
    private final String rspecType;
    private final List<UserSpec> sshKeys = new ArrayList<UserSpec>();
    private String expiresString;
    private HardwareTypeInfo hardwareTypeInfo;
    private Integer routableAddressesAvailable;
    private Integer routableAddressesConfigured;
    private Integer multiplexFactor;
    private final RspecFactory factory;

    public BasicModelRspec(String rspecType) {
        this.rspecType = rspecType;
        this.factory = RspecFactoryFactory.getRspecFactoryInstance(this.getModelRspecType());
    }

    @Override
    @Nonnull
    public ModelRspecType getModelRspecType() {
        return ModelRspecType.BASIC;
    }

    @Override
    public void setParseData(@Nullable String schemaLocation, @Nullable String defaultNamespace, @Nonnull Map<String, String> namespaces) {
        this.origSchemaLocation = schemaLocation;
        this.origDefaultNamespace = defaultNamespace;
        this.origNameSpaceInfo.putAll(namespaces);
    }

    @Override
    @Nullable
    public String getSchemaLocation() {
        return this.origSchemaLocation;
    }

    @Override
    @Nullable
    public String getOrigDefaultNamespace() {
        return this.origDefaultNamespace;
    }

    @Override
    @Nonnull
    public Map<String, String> getNameSpaceInfo() {
        return this.origNameSpaceInfo;
    }

    @Override
    public void addNode(@Nonnull RspecNode node) {
        assert (node instanceof BasicRspecNode);
        this.nodes.add((BasicRspecNode)node);
    }

    @Override
    public void addLink(@Nonnull RspecLink link) {
        assert (link instanceof BasicRspecLink);
        this.links.add((BasicRspecLink)link);
    }

    @Nonnull
    public List<BasicRspecNode> getNodes() {
        return this.nodes;
    }

    @Nonnull
    public List<BasicRspecLink> getLinks() {
        return this.links;
    }

    @Override
    public void addOpenflowDataPath(@Nonnull OpenflowDataPath dp) {
        assert (dp instanceof BasicOpenflowDataPath);
        this.openflowDataPaths.add((BasicOpenflowDataPath)dp);
    }

    @Nonnull
    public List<BasicOpenflowDataPath> getOpenflowDataPaths() {
        return this.openflowDataPaths;
    }

    @Override
    public void addOpenflowSliver(@Nonnull OpenflowSliver sliver) {
        this.openflowSlivers.add(sliver);
    }

    @Override
    @Nonnull
    public List<? extends OpenflowSliver> getOpenflowSlivers() {
        return this.openflowSlivers;
    }

    @Override
    public void addLease(@Nonnull Lease lease) {
        assert (lease instanceof BasicLease);
        this.leases.add((BasicLease)lease);
    }

    @Override
    @Nonnull
    public List<? extends Lease> getLeases() {
        return this.leases;
    }

    @Override
    public void addChannel(@Nonnull Channel channel) {
        assert (channel instanceof BasicChannel);
        this.channels.add((BasicChannel)channel);
    }

    @Nonnull
    public List<BasicChannel> getChannels() {
        return this.channels;
    }

    @Override
    public void addAddressPool(@Nonnull AddressPool addressPool) {
        if (addressPool instanceof BasicAddressPool) {
            this.addressPools.add((BasicAddressPool)addressPool);
        } else {
            this.addressPools.add(new BasicAddressPool(addressPool));
        }
    }

    @Override
    public boolean deleteAddressPool(@Nonnull AddressPool addressPool) {
        return this.addressPools.remove(addressPool);
    }

    @Nonnull
    public List<BasicAddressPool> getAddressPools() {
        return this.addressPools;
    }

    @Override
    @Nullable
    public AddressPool getAddressPoolByClientId(@Nonnull String clientId) {
        for (BasicAddressPool addressPool : this.addressPools) {
            if (!Objects.equals(clientId, addressPool.getClientId())) continue;
            return addressPool;
        }
        return null;
    }

    @Override
    public void addExecuteAnsiblePlaybook(@Nonnull ExecuteAnsiblePlaybook executeAnsiblePlaybook) {
        if (executeAnsiblePlaybook instanceof BasicExecuteAnsiblePlaybook) {
            this.ansibleCookbooks.add((BasicExecuteAnsiblePlaybook)executeAnsiblePlaybook);
        } else {
            this.ansibleCookbooks.add(new BasicExecuteAnsiblePlaybook(executeAnsiblePlaybook));
        }
    }

    @Override
    public boolean deleteExecuteAnsiblePlaybook(@Nonnull ExecuteAnsiblePlaybook executeAnsiblePlaybook) {
        return this.ansibleCookbooks.remove(executeAnsiblePlaybook);
    }

    @Nonnull
    public List<? extends BasicExecuteAnsiblePlaybook> getExecuteAnsiblePlaybooks() {
        return this.ansibleCookbooks;
    }

    @Override
    public void addDistributeSshKeypair(@Nonnull DistributeSshKeypair distributeSshKeypair) {
        if (distributeSshKeypair instanceof BasicDistributeSshKeypair) {
            this.distributeSshKeypairs.add((BasicDistributeSshKeypair)distributeSshKeypair);
        } else {
            this.distributeSshKeypairs.add(new BasicDistributeSshKeypair(distributeSshKeypair));
        }
    }

    @Override
    public boolean deleteDistributeSshKeypair(@Nonnull DistributeSshKeypair distributeSshKeypair) {
        return this.distributeSshKeypairs.remove(distributeSshKeypair);
    }

    @Override
    @Nonnull
    public List<? extends DistributeSshKeypair> getDistributeSshKeypairs() {
        return this.distributeSshKeypairs;
    }

    @Override
    @Nullable
    public HardwareTypeInfo getHardwareTypeInfo() {
        return this.hardwareTypeInfo;
    }

    @Override
    public void setHardwareTypeInfo(@Nullable HardwareTypeInfo hardwareTypeInfo) {
        this.hardwareTypeInfo = hardwareTypeInfo;
    }

    @Override
    @Nullable
    public BasicRspecNode getNodeByUniqueId(@Nonnull String id) {
        for (BasicRspecNode node : this.nodes) {
            if (!Objects.equals(node.getUniqueId(), id)) continue;
            return node;
        }
        return null;
    }

    @Override
    @Nullable
    public BasicRspecNode getNodeByClientId(@Nonnull String id) {
        for (BasicRspecNode node : this.nodes) {
            if (!Objects.equals(node.getClientId(), id)) continue;
            return node;
        }
        return null;
    }

    @Override
    @Nullable
    public BasicRspecNode getNodeByComponentId(@Nonnull String id) {
        for (BasicRspecNode node : this.nodes) {
            if (!Objects.equals(node.getComponentId().toString(), id)) continue;
            return node;
        }
        return null;
    }

    @Override
    @Nullable
    public BasicChannel getChannelByComponentId(@Nonnull GeniUrn urn) {
        for (BasicChannel channel : this.channels) {
            if (!Objects.equals(channel.getComponentId(), urn)) continue;
            return channel;
        }
        return null;
    }

    @Nonnull
    public List<BasicRspecNode> getNodesByAuthority(@Nonnull Server server) {
        return this.nodes.stream().filter(node -> node.getComponentManagerId().equalsIgnoringSubAuth((Object)server.getDefaultComponentManagerUrn())).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public BasicRspecLink getLinkByClientId(@Nonnull String id) {
        for (BasicRspecLink link : this.links) {
            if (!Objects.equals(link.getClientId(), id)) continue;
            return link;
        }
        return null;
    }

    @Override
    @Nullable
    public BasicRspecLink getLinkByUniqueId(@Nonnull String id) {
        for (BasicRspecLink link : this.links) {
            if (!Objects.equals(link.getUniqueId(), id)) continue;
            return link;
        }
        return null;
    }

    @Override
    public void deleteNode(@Nonnull RspecNode node) {
        assert (node instanceof BasicRspecNode);
        ArrayList<RspecLink> linksToDelete = new ArrayList<RspecLink>();
        ArrayList<RspecInterface> ifacesToDelete = new ArrayList<RspecInterface>();
        for (RspecInterface rspecInterface : node.getInterfaces()) {
            RspecLink link;
            if (rspecInterface.isLinkBound() && (link = rspecInterface.getLink()) != null && link.getInterfaces().size() <= 2) {
                linksToDelete.add(link);
            }
            ifacesToDelete.add(rspecInterface);
        }
        ifacesToDelete.forEach(RspecInterface::delete);
        this.nodes.remove(node);
        linksToDelete.forEach(this::deleteLink);
    }

    @Override
    public void deleteLink(@Nonnull RspecLink link) {
        assert (link instanceof BasicRspecLink);
        ArrayList<? extends RspecInterface> ifacesToDelete = new ArrayList<RspecInterface>(link.getInterfaces());
        ifacesToDelete.forEach(RspecInterface::delete);
        this.links.remove(link);
    }

    @Override
    public boolean deleteChannel(@Nonnull Channel channel) {
        assert (channel instanceof BasicChannel);
        return this.channels.remove(channel);
    }

    @Override
    @Nonnull
    public String toGeni3Rspec(@Nonnull ModelRspec.RequestRspecSpecialCases specialCase) {
        StaxRspecWriter staxRspecWriter = new StaxRspecWriter(this);
        switch (specialCase) {
            case NONE: {
                break;
            }
            case PLE: {
                ArrayList<String> allowedComponentManagers = new ArrayList<String>();
                allowedComponentManagers.add("urn:publicid:IDN+ple:ibbtple+authority+cm");
                staxRspecWriter.setComponentManagerFilter(allowedComponentManagers);
                staxRspecWriter.setAddSchemaLocation(false);
                staxRspecWriter.setAddEmptySliverToNodeHack(true);
                break;
            }
            case NITOS_NO_E_NODE_B_HACK: {
                staxRspecWriter.setUseNitosENodeBHack(false);
                break;
            }
            default: {
                throw new RuntimeException("Special case " + String.valueOf((Object)specialCase) + " not supported");
            }
        }
        try {
            return staxRspecWriter.call();
        }
        catch (RspecParseException e) {
            LOG.error("Error converting to Rspec: ", (Throwable)e);
            throw new RuntimeException("Error converting to Rspec: " + String.valueOf(e), e);
        }
    }

    @Override
    @Nonnull
    public String toGeni3Rspec() {
        return this.toGeni3Rspec(ModelRspec.RequestRspecSpecialCases.NONE);
    }

    @Override
    @Nullable
    public Date getExpires() throws ParseException {
        if (this.expiresString == null) {
            return null;
        }
        return RFC3339Util.rfc3339StringToDate((String)this.expiresString);
    }

    @Override
    public void setExpires(@Nullable Date expires) {
        this.expiresString = expires == null ? null : RFC3339Util.dateToRFC3339String((Date)expires, (boolean)true);
    }

    @Override
    @Nullable
    public String getExpiresString() {
        return this.expiresString;
    }

    @Override
    public void setExpires(@Nullable String expires) {
        this.expiresString = expires;
    }

    @Override
    @Nullable
    public Integer getRoutableAddressesAvailable() {
        return this.routableAddressesAvailable;
    }

    @Override
    @Nullable
    public Integer getRoutableAddressesConfigured() {
        return this.routableAddressesConfigured;
    }

    @Override
    public void setRoutableAddressesAvailable(@Nullable Integer routableAddressesAvailable) {
        this.routableAddressesAvailable = routableAddressesAvailable;
    }

    @Override
    public void setRoutableAddressesConfigured(@Nullable Integer routableAddressesConfigured) {
        this.routableAddressesConfigured = routableAddressesConfigured;
    }

    @Override
    @Nonnull
    public List<GeniUrn> getAllComponentManagerUrns() {
        HashSet urns = new HashSet();
        this.nodes.stream().map(RspecNode::getComponentManagerId).filter(Objects::nonNull).forEach(urns::add);
        this.links.stream().flatMap(link -> link.getComponentManagerUrns().stream()).forEach(urns::add);
        this.channels.stream().map(Channel::getComponentManagerId).forEach(urns::add);
        this.addressPools.stream().map(AddressPool::getComponentManagerId).forEach(urns::add);
        return new ArrayList<GeniUrn>(urns);
    }

    @Override
    @Nonnull
    public List<UserSpec> getSshKeys() {
        return this.sshKeys;
    }

    @Override
    public void setSshKeys(@Nonnull List<UserSpec> newKeys) {
        this.sshKeys.clear();
        this.sshKeys.addAll(newKeys);
    }

    @Override
    @Nonnull
    public String nextLinkName() {
        int c = this.links.size();
        String res = "link" + c;
        while (this.getLinkByClientId(res) != null) {
            res = "link" + ++c;
        }
        return res;
    }

    @Override
    @Nonnull
    public String nextNodeName() {
        int c = this.nodes.size();
        String res = "node" + c;
        while (this.getNodeByClientId(res) != null) {
            res = "node" + ++c;
        }
        return res;
    }

    @Override
    @Nullable
    public String getType() {
        return this.rspecType;
    }

    @Override
    @Nonnull
    public String nextIfaceName(@Nonnull RspecNode node) {
        int c = node.getInterfaces().size();
        String res = node.getClientId() + ":if" + c;
        while (this.getInterfaceByClientId(res) != null) {
            res = node.getClientId() + ":if" + ++c;
        }
        return res;
    }

    @Override
    @Nullable
    public BasicRspecInterface getInterfaceByClientId(@Nonnull String clientId) {
        BasicRspecInterface iface;
        for (BasicRspecNode node : this.nodes) {
            iface = node.getInterfaceByClientId(clientId);
            if (iface == null) continue;
            return iface;
        }
        for (BasicRspecLink link : this.links) {
            iface = link.getInterfaceByClientId(clientId);
            if (iface == null) continue;
            return iface;
        }
        return null;
    }

    @Override
    @Nullable
    public BasicRspecInterface getInterfaceByUniqueId(@Nonnull String uniqueId) {
        BasicRspecInterface iface;
        for (BasicRspecNode node : this.nodes) {
            iface = node.getInterfaceByUniqueId(uniqueId);
            if (iface == null) continue;
            return iface;
        }
        for (BasicRspecLink link : this.links) {
            iface = link.getInterfaceByUniqueId(uniqueId);
            if (iface == null) continue;
            return iface;
        }
        return null;
    }

    @Override
    @Nullable
    public Integer getMultiplexFactor() {
        return this.multiplexFactor;
    }

    @Override
    public void setMultiplexFactor(@Nullable Integer multiplexFactor) {
        this.multiplexFactor = multiplexFactor;
    }

    @Override
    @Nonnull
    public List<DiskImageList> getDiskImageLists() {
        return this.diskImageLists;
    }

    @Override
    @Nonnull
    public List<FlavorList> getFlavorLists() {
        return this.flavorLists;
    }

    @Override
    public void addDiskImageList(@Nonnull DiskImageList list) {
        this.diskImageLists.add(list);
    }

    @Override
    public void addFlavorList(@Nonnull FlavorList list) {
        this.flavorLists.add(list);
    }

    @Override
    @Nonnull
    public List<ExtraXml> getExtraXml() {
        return this.extraXml;
    }

    @Override
    public void setExtraXml(@Nonnull List<ExtraXml> extraXml) {
        this.extraXml.clear();
        this.extraXml.addAll(extraXml);
    }

    @Override
    @Nonnull
    public ModelRspec copy() {
        return this.factory.copyModelRspec(this, null);
    }
}

