/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model.impl;

import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicModelRspec;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicRspecLink;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicRspecNode;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicRspecInterface
implements RspecInterface {
    private static final Logger LOG = LoggerFactory.getLogger(BasicRspecInterface.class);
    protected final BasicModelRspec modelRspec;
    protected String clientId;
    protected GeniUrn sliverId;
    protected String componentId;
    protected String macAddress;
    protected Integer felixVlan;
    protected String componentName;
    protected String role;
    protected String publicIpv4;
    protected final List<ExtraXml> extraXml = new ArrayList<ExtraXml>();
    protected final List<ExtraXml> extraXmlForRef = new ArrayList<ExtraXml>();
    protected final List<RspecInterface.IpAddress> ipAddresses = new ArrayList<RspecInterface.IpAddress>();
    protected BasicRspecNode node;
    protected BasicRspecLink link;

    BasicRspecInterface(BasicRspecNode node, String anyId) {
        assert (node != null);
        this.modelRspec = node.getRspec();
        this.node = node;
        for (RspecInterface rspecInterface : node.getInterfaces()) {
            if (rspecInterface != this && !this.getUniqueId().equals(rspecInterface.getUniqueId())) continue;
            throw new RuntimeException("Duplicate interfaces in XML Rspec: id=\"" + rspecInterface.getUniqueId() + "\"");
        }
        node.addInterface(this);
    }

    BasicRspecInterface(BasicRspecLink link, String clientId) {
        assert (link != null);
        this.modelRspec = link.getRspec();
        this.node = null;
        this.link = link;
        this.clientId = clientId;
        for (RspecInterface rspecInterface : link.getInterfaces()) {
            if (rspecInterface != this && !this.getUniqueId().equals(rspecInterface.getUniqueId())) continue;
            throw new RuntimeException("Duplicate interfaces in XML Rspec: id=\"" + rspecInterface.getUniqueId() + "\"");
        }
        link.addInterface(this);
    }

    BasicRspecInterface(BasicRspecNode node, BasicRspecLink link, String clientId) {
        assert (link != null);
        assert (node != null);
        assert (node.getRspec() == link.getRspec());
        this.modelRspec = node.getRspec();
        this.node = node;
        this.link = link;
        this.clientId = clientId;
        for (RspecInterface rspecInterface : node.getInterfaces()) {
            if (rspecInterface != this && !this.getUniqueId().equals(rspecInterface.getUniqueId())) continue;
            throw new RuntimeException("Duplicate interfaces in XML Rspec: id=\"" + rspecInterface.getUniqueId() + "\"");
        }
        for (RspecInterface rspecInterface : link.getInterfaces()) {
            if (rspecInterface != this && !this.getUniqueId().equals(rspecInterface.getUniqueId())) continue;
            throw new RuntimeException("Duplicate interfaces in XML Rspec: id=\"" + rspecInterface.getUniqueId() + "\"");
        }
        node.addInterface(this);
        link.addInterface(this);
        if (node.getComponentManagerId() != null && !link.getComponentManagerUrns().contains(node.getComponentManagerId())) {
            link.getComponentManagerUrns().add(node.getComponentManagerId());
        }
    }

    @Override
    public void overwritePropertiesWith(RspecInterface other, boolean overwriteWithNull) {
        if (overwriteWithNull || other.getSliverId() != null) {
            this.sliverId = other.getSliverId();
        }
        if (overwriteWithNull || other.getClientId() != null) {
            this.clientId = other.getClientId();
        }
        if (overwriteWithNull || other.getComponentId() != null) {
            this.componentId = other.getComponentId();
        }
        if (overwriteWithNull || other.getComponentName() != null) {
            this.componentName = other.getComponentName();
        }
        if (overwriteWithNull || other.getRole() != null) {
            this.role = other.getRole();
        }
        if (overwriteWithNull || other.getPublicIpv4() != null) {
            this.publicIpv4 = other.getPublicIpv4();
        }
        if (overwriteWithNull || other.getMacAddress() != null) {
            this.macAddress = other.getMacAddress();
        }
        if (overwriteWithNull || other.getFelixVlan() != null) {
            this.felixVlan = other.getFelixVlan();
        }
        if (overwriteWithNull || other.getIpAddresses() != null && !other.getIpAddresses().isEmpty()) {
            this.ipAddresses.clear();
            this.ipAddresses.addAll(other.getIpAddresses());
        }
        if (overwriteWithNull || other.getExtraXml() != null && !other.getExtraXml().isEmpty()) {
            this.extraXml.clear();
            this.extraXml.addAll(other.getExtraXml());
        }
        if (overwriteWithNull || other.getRefExtraXml() != null && !other.getRefExtraXml().isEmpty()) {
            this.extraXmlForRef.clear();
            this.extraXmlForRef.addAll(other.getRefExtraXml());
        }
    }

    @Override
    public void bindLink(RspecLink rspecLink) {
        assert (rspecLink instanceof BasicRspecLink);
        if (this.node == null || this.link != null) {
            throw new IllegalStateException("bindLink can only be called once, and after the matching constructor");
        }
        this.link = (BasicRspecLink)rspecLink;
        for (RspecInterface rspecInterface : this.link.getInterfaces()) {
            if (rspecInterface != this && !this.getClientId().equals(rspecInterface.getClientId())) continue;
            throw new RuntimeException("Duplicate interfaces in XML Rspec: id=\"" + rspecInterface.getClientId() + "\"");
        }
        this.link.addInterface(this);
    }

    @Override
    public void bindNode(RspecNode rspecNode) {
        assert (rspecNode instanceof BasicRspecNode);
        if (this.node != null || this.link == null) {
            throw new IllegalStateException("bindNode can only be called once, and after the matching constructor");
        }
        this.node = (BasicRspecNode)rspecNode;
        for (RspecInterface rspecInterface : this.node.getInterfaces()) {
            if (rspecInterface != this && !this.getClientId().equals(rspecInterface.getClientId())) continue;
            throw new RuntimeException("Duplicate interfaces in XML Rspec: id=\"" + rspecInterface.getClientId() + "\"");
        }
        this.node.addInterface(this);
    }

    @Override
    public void moveToNode(RspecNode newRspecNode) {
        BasicRspecNode oldRspecNode = this.node;
        assert (this.node != null);
        assert (oldRspecNode instanceof BasicRspecNode);
        assert (newRspecNode instanceof BasicRspecNode);
        if (this.node == null) {
            throw new IllegalStateException("moveToNode can only be called an interface that is bound to a node");
        }
        this.node = (BasicRspecNode)newRspecNode;
        for (RspecInterface rspecInterface : newRspecNode.getInterfaces()) {
            if (rspecInterface != this && !this.getClientId().equals(rspecInterface.getClientId())) continue;
            throw new RuntimeException("Duplicate interfaces in XML Rspec: id=\"" + rspecInterface.getClientId() + "\"");
        }
        oldRspecNode.removeInterface(this);
        ((BasicRspecNode)newRspecNode).addInterface(this);
    }

    @Override
    public void moveToLink(RspecLink newRspecLink) {
        BasicRspecLink oldRspecLink = this.link;
        assert (this.link != null);
        assert (oldRspecLink instanceof BasicRspecLink);
        assert (newRspecLink instanceof BasicRspecLink);
        if (this.link == null) {
            throw new IllegalStateException("moveToLink can only be called an interface that is bound to a link");
        }
        this.link = (BasicRspecLink)newRspecLink;
        for (RspecInterface rspecInterface : newRspecLink.getInterfaces()) {
            if (rspecInterface != this && !this.getClientId().equals(rspecInterface.getClientId())) continue;
            throw new RuntimeException("Duplicate interfaces in XML Rspec: id=\"" + rspecInterface.getClientId() + "\"");
        }
        oldRspecLink.removeInterface(this);
        ((BasicRspecLink)newRspecLink).addInterface(this);
    }

    @Override
    public boolean isBound() {
        return this.node != null && this.link != null;
    }

    @Override
    public boolean isUnbound() {
        return this.node == null || this.link == null;
    }

    @Override
    public boolean isLinkUnbound() {
        return this.link == null;
    }

    @Override
    public boolean isNodeUnbound() {
        return this.node == null;
    }

    @Override
    public boolean isLinkBound() {
        return this.link != null;
    }

    @Override
    public boolean isNodeBound() {
        return this.node != null;
    }

    @Override
    public String getUniqueId() {
        return BasicStringRspec.makeUniqueInterfaceId((String)this.clientId, (String)this.componentId, this.node == null ? null : this.node.getUniqueId());
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public String getComponentId() {
        return this.componentId;
    }

    @Override
    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    @Override
    public String getPublicIpv4() {
        return this.publicIpv4;
    }

    @Override
    public void setPublicIpv4(String publicIpv4) {
        this.publicIpv4 = publicIpv4;
    }

    @Override
    public String getRole() {
        return this.role;
    }

    @Override
    public void setRole(String role) {
        this.role = role;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    @Override
    public GeniUrn getSliverId() {
        return this.sliverId;
    }

    @Override
    public void setSliverId(String sliverId) {
        if (sliverId == null) {
            this.sliverId = null;
            return;
        }
        GeniUrn geniUrn = GeniUrn.parse((String)sliverId);
        if (geniUrn != null) {
            this.sliverId = geniUrn;
        } else {
            LOG.warn("Could not set sliverId to {} as it is not a valid URN!", (Object)sliverId);
            this.sliverId = null;
        }
    }

    @Override
    public void setSliverId(GeniUrn sliverId) {
        this.sliverId = sliverId;
    }

    @Override
    public String getMacAddress() {
        return this.macAddress;
    }

    @Override
    public void setMacAddress(String value) {
        this.macAddress = value;
    }

    @Override
    public Integer getFelixVlan() {
        return this.felixVlan;
    }

    @Override
    public void setFelixVlan(Integer felixVlan) {
        this.felixVlan = felixVlan;
    }

    @Override
    public List<RspecInterface.IpAddress> getIpAddresses() {
        return this.ipAddresses;
    }

    @Override
    public List<ExtraXml> getExtraXml() {
        return this.extraXml;
    }

    @Override
    public List<ExtraXml> getRefExtraXml() {
        return this.extraXmlForRef;
    }

    @Override
    public BasicRspecNode getNode() {
        if (this.node == null) {
            throw new IllegalStateException("bindNode was not yet called");
        }
        return this.node;
    }

    @Override
    public BasicRspecLink getLink() {
        if (this.link == null) {
            throw new IllegalStateException("bindLink was not yet called");
        }
        return this.link;
    }

    @Override
    public boolean delete() {
        boolean removed;
        if (this.link == null && this.node == null) {
            return false;
        }
        if (this.node != null) {
            removed = this.node.removeInterface(this);
            assert (removed);
        }
        if (this.link != null) {
            removed = this.link.removeInterface(this);
            assert (removed);
        }
        this.node = null;
        this.link = null;
        return true;
    }

    @Override
    public BasicModelRspec getRspec() {
        return this.modelRspec;
    }

    public String toString() {
        return "RspecInterface{id=" + this.clientId + "}";
    }
}

