/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.parser;

import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.rspec.model.AddressPool;
import be.iminds.ilabt.jfed.rspec.model.AnsibleService;
import be.iminds.ilabt.jfed.rspec.model.Channel;
import be.iminds.ilabt.jfed.rspec.model.DiskImage;
import be.iminds.ilabt.jfed.rspec.model.DiskImageList;
import be.iminds.ilabt.jfed.rspec.model.DistributeSshKeypair;
import be.iminds.ilabt.jfed.rspec.model.ExecuteAnsiblePlaybook;
import be.iminds.ilabt.jfed.rspec.model.ExecuteService;
import be.iminds.ilabt.jfed.rspec.model.FlavorList;
import be.iminds.ilabt.jfed.rspec.model.HardwareType;
import be.iminds.ilabt.jfed.rspec.model.HardwareTypeInfo;
import be.iminds.ilabt.jfed.rspec.model.Lease;
import be.iminds.ilabt.jfed.rspec.model.LinkSetting;
import be.iminds.ilabt.jfed.rspec.model.LoginService;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.NodeLocation;
import be.iminds.ilabt.jfed.rspec.model.OpenflowDataPath;
import be.iminds.ilabt.jfed.rspec.model.OpenflowSliver;
import be.iminds.ilabt.jfed.rspec.model.ProxyService;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecFactoryFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.SliverType;
import be.iminds.ilabt.jfed.rspec.model.SliverTypeBuilder;
import be.iminds.ilabt.jfed.rspec.parser.EventListExtraXml;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.rspec.parser.RspecParseException;
import be.iminds.ilabt.jfed.rspec.parser.RspecXmlConstants;
import be.iminds.ilabt.jfed.rspec.parser.SingleElementExtraXml;
import be.iminds.ilabt.jfed.rspec.parser.StaxHelper;
import be.iminds.ilabt.jfed.rspec.parser.extensions.UserSpecParser;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec.util.ProgressProvider;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaxRspecParser
implements Callable<ModelRspec>,
ProgressProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StaxRspecParser.class);
    private final List<ProgressHandler> progressHandlers = Collections.synchronizedList(new ArrayList());
    private final RspecFactory rspecFactory;
    private static final long PROGRESS_LOSING_DATA = 20L;
    private final String inputRspec;
    private boolean useNitosENodeBHack;
    private final Map<LinkId, RspecInterface> interfacesByLinkId = new HashMap<LinkId, RspecInterface>();
    private static final String E_NODE_B_URN_REGEX = "urn:publicid:IDN\\+([0-9a-zA-Z._:-]*)\\+(e_node_b)\\+([+;%/0-9a-zA-Z._:-]*)";
    private static final Pattern E_NODE_B_URN_PATTERN = Pattern.compile("urn:publicid:IDN\\+([0-9a-zA-Z._:-]*)\\+(e_node_b)\\+([+;%/0-9a-zA-Z._:-]*)");
    private volatile double totalWork;
    private volatile double progress;

    public StaxRspecParser(@Nonnull String inputRspec, @Nonnull RspecFactory rspecFactory) {
        assert (rspecFactory.getModelRspecType() != ModelRspecType.IMMUTABLE);
        this.inputRspec = inputRspec;
        this.rspecFactory = rspecFactory;
        this.useNitosENodeBHack = true;
    }

    public StaxRspecParser setUseNitosENodeBHack(boolean useNitosENodeBHack) {
        this.useNitosENodeBHack = useNitosENodeBHack;
        return this;
    }

    private static boolean isType(ModelRspec modelRspec, String ... type) {
        if (modelRspec == null) {
            return false;
        }
        if (modelRspec.getType() == null) {
            return false;
        }
        for (String t : type) {
            if (!modelRspec.getType().equalsIgnoreCase(t)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    @Contract(value="null,_ -> null")
    public static ModelRspec parseOrNullNoError(@Nullable String inputRspec, @Nonnull ModelRspecType modelRspecType) {
        assert (modelRspecType != ModelRspecType.IMMUTABLE);
        if (inputRspec == null) {
            return null;
        }
        RspecFactory factory = RspecFactoryFactory.getRspecFactoryInstance(modelRspecType);
        try {
            return new StaxRspecParser(inputRspec, factory).call();
        }
        catch (RspecParseException e) {
            LOG.info("Failed to parse RSpec. Returning null.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    @Contract(value="null,_ -> null")
    public static ModelRspec parseOrNullOrThrow(@Nullable String inputRspec, @Nonnull ModelRspecType modelRspecType) throws RspecParseException {
        assert (modelRspecType != ModelRspecType.IMMUTABLE);
        if (inputRspec == null) {
            return null;
        }
        RspecFactory factory = RspecFactoryFactory.getRspecFactoryInstance(modelRspecType);
        return new StaxRspecParser(inputRspec, factory).call();
    }

    @Override
    @Nullable
    public ModelRspec call() throws RspecParseException {
        long startTime = System.currentTimeMillis();
        if (this.inputRspec.equals("")) {
            throw new RspecParseException(null, "Received an empty inputRspec");
        }
        String inputRspec = this.inputRspec.replace("http://www.protogeni.net/resources/rspec/2", "http://www.protogeni.net/resources/rspec/3");
        inputRspec = inputRspec.replaceFirst("<\\?xml .*\\?>", "<?xml version=\"1.0\" ?>");
        try {
            XMLInputFactory xif = XMLInputFactory.newFactory();
            StreamSource xml = new StreamSource(new StringReader(inputRspec));
            XMLEventReader eventReader = xif.createXMLEventReader(xml);
            XMLEvent e = eventReader.nextEvent();
            assert (e.isStartDocument());
            ArrayList<ExtraXml> topLevelExtraXml = new ArrayList<ExtraXml>();
            ModelRspec res = null;
            String rspecType = null;
            while (eventReader.hasNext()) {
                e = eventReader.nextEvent();
                this.updateProgress(Math.min(e.getLocation().getCharacterOffset(), inputRspec.length()), inputRspec.length());
                if (e.isStartElement()) {
                    RspecNode n;
                    boolean handled = false;
                    if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_RSPEC)) {
                        assert (res == null);
                        Attribute typeAtt = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_RSPEC_TYPE);
                        if (typeAtt != null) {
                            rspecType = typeAtt.getValue();
                            res = this.rspecFactory.createModelRspec(rspecType);
                        } else {
                            LOG.error("No type set in RSpec.");
                            rspecType = null;
                            res = this.rspecFactory.createModelRspec(null);
                        }
                        Attribute expiresAtt = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_RSPEC_EXPIRES);
                        if (expiresAtt != null) {
                            res.setExpires(expiresAtt.getValue());
                        }
                        String schemaLocation = null;
                        String defaultNamespace = null;
                        HashMap<String, String> namespaces = new HashMap<String, String>();
                        Attribute schemaLocationAtt = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_XSI_SCHEMALOCATION);
                        if (schemaLocationAtt != null) {
                            schemaLocation = schemaLocationAtt.getValue();
                        }
                        Iterator<Namespace> nsIt = e.asStartElement().getNamespaces();
                        while (nsIt.hasNext()) {
                            Namespace ns = nsIt.next();
                            if (ns.isDefaultNamespaceDeclaration()) {
                                defaultNamespace = ns.getNamespaceURI();
                                continue;
                            }
                            namespaces.put(ns.getPrefix(), ns.getNamespaceURI());
                        }
                        res.setParseData(schemaLocation, defaultNamespace, namespaces);
                        handled = true;
                    }
                    assert (res != null) : "ModelRspec-object should have been created by now! Wanted to process event " + String.valueOf(e);
                    if (res == null) {
                        throw new RuntimeException("Internal error in StaxRspecParser: res == null");
                    }
                    if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_NODE)) {
                        n = this.readNode(res, e, eventReader);
                        res.addNode(n);
                        handled = true;
                    }
                    if (this.useNitosENodeBHack && Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_NITOS_E_NODE_B)) {
                        n = this.readFlexENodeB(res, e, eventReader);
                        LOG.debug("Read flex:e_node_b as normal node");
                        LOG.debug("                   name=" + n.getComponentName() + " avail" + n.getAvailable());
                        res.addNode(n);
                        handled = true;
                    }
                    if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_LINK)) {
                        RspecLink l = this.readLink(res, e, eventReader, rspecType);
                        if (l != null) {
                            res.addLink(l);
                        }
                        handled = true;
                    }
                    if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_OPENFLOW_DATAPATH)) {
                        OpenflowDataPath dp = this.readOpenflowDataPath(res, e, eventReader);
                        res.addOpenflowDataPath(dp);
                        handled = true;
                        topLevelExtraXml.add(dp.getAsExtraXml());
                    }
                    if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_OPENFLOW_SLIVER)) {
                        OpenflowSliver sliver = this.readOpenflowSliver(res, e, eventReader);
                        res.addOpenflowSliver(sliver);
                        handled = true;
                        topLevelExtraXml.add(sliver.getAsExtraXml());
                    }
                    if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_LEASE)) {
                        Lease lease = this.readLease(res, e, eventReader);
                        res.addLease(lease);
                        handled = true;
                    }
                    if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_CHANNEL)) {
                        Channel channel = this.readChannel(res, e, eventReader);
                        res.addChannel(channel);
                        handled = true;
                    }
                    if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_NODE_ROUTABLEADRESSES)) {
                        Attribute availableAtt = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_ROUTABLEADRESSES_AVAILABLE);
                        if (availableAtt != null) {
                            res.setRoutableAddressesAvailable(Integer.parseInt(availableAtt.getValue()));
                        } else {
                            res.setRoutableAddressesAvailable(null);
                        }
                        Attribute configuredAtt = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_ROUTABLEADRESSES_CONFIGURED);
                        if (configuredAtt != null) {
                            res.setRoutableAddressesConfigured(Integer.parseInt(configuredAtt.getValue()));
                        } else {
                            res.setRoutableAddressesConfigured(null);
                        }
                        handled = true;
                    }
                    if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_COLLOCATE_FACTOR)) {
                        Attribute countAtt;
                        if (res.getMultiplexFactor() != null) {
                            LOG.warn("Detected duplicate <emulab:collocate_factor> @ {}", (Object)e.getLocation());
                        }
                        if ((countAtt = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_COLLOCATE_FACTOR_COUNT)) != null) {
                            try {
                                res.setMultiplexFactor(Integer.parseInt(countAtt.getValue()));
                            }
                            catch (NumberFormatException ex) {
                                LOG.error("Could not parse collocate factor count '{}' @ location {}", (Object)countAtt.getValue(), (Object)e.getLocation());
                            }
                        } else {
                            LOG.warn("No attribute 'count' could be found for <emulab:collocate_factor> @ {}", (Object)e.getLocation());
                        }
                        handled = true;
                    }
                    if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_ROUTABLE_POOL)) {
                        AddressPool addressPool = this.readAddressPool(res, e, eventReader);
                        res.addAddressPool(addressPool);
                        handled = true;
                    }
                    if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_JFED_EXECUTE_ANSIBLE_PLAYBOOK)) {
                        ExecuteAnsiblePlaybook executeAnsiblePlaybook = this.readExecuteAnsibleCookbook(res, e, eventReader);
                        if (executeAnsiblePlaybook != null) {
                            res.addExecuteAnsiblePlaybook(executeAnsiblePlaybook);
                        }
                        handled = true;
                    }
                    if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_JFED_DISTRIBUTE_SSH_KEYPAIR)) {
                        DistributeSshKeypair distributeSshKeypair = this.readDistributeSshKeypair(res, e, eventReader);
                        res.addDistributeSshKeypair(distributeSshKeypair);
                        handled = true;
                    }
                    if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_HWINFO_HARDWARE_TYPE_INFO)) {
                        HardwareTypeInfo hardwareTypeInfo = this.readHardwareTypeInfo(res, e, eventReader);
                        res.setHardwareTypeInfo(hardwareTypeInfo);
                        handled = true;
                    }
                    if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_DISK_IMAGE_LIST)) {
                        DiskImageList diskImageList = this.readDiskImageList(res, e, eventReader);
                        res.addDiskImageList(diskImageList);
                        handled = true;
                    }
                    if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_FLAVOR_LIST)) {
                        FlavorList flavorList = this.readFlavorList(res, e, eventReader);
                        res.addFlavorList(flavorList);
                        handled = true;
                    }
                    if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_JFEDSSH_USER_SSH_KEYS)) {
                        UserSpec userSpec = UserSpecParser.parseJfedSshUserSshKeys(e.asStartElement(), eventReader);
                        res.getSshKeys().add(userSpec);
                        handled = true;
                    }
                    if (!handled) {
                        EventListExtraXml extraXml = new EventListExtraXml(e.asStartElement(), eventReader);
                        topLevelExtraXml.add(extraXml);
                    }
                }
                if (e.getEventType() != 5) continue;
                topLevelExtraXml.add(new SingleElementExtraXml(e));
            }
            if (res == null) {
                throw new RspecParseException(null, "Received an invalid Rspec-input. Did not create an ModelRspec-object!");
            }
            res.getExtraXml().addAll(topLevelExtraXml);
            for (RspecInterface rspecInterface : this.interfacesByLinkId.values()) {
                if (rspecInterface.isLinkUnbound()) {
                    if (StaxRspecParser.isType(res, "advertisement")) continue;
                    this.ignorableParseError(null, "interface \"" + rspecInterface.getClientId() + "\" is not bound to any link");
                    continue;
                }
                if (!rspecInterface.isNodeUnbound() || StaxRspecParser.isType(res, "advertisement")) continue;
                this.ignorableParseError(null, "interface_ref \"" + rspecInterface.getClientId() + "\" is not bound to any node");
            }
            long stopTime = System.currentTimeMillis();
            LOG.info("Performance monitoring: PARSED RSPEC in " + (stopTime - startTime) + " ms");
            return res;
        }
        catch (XMLStreamException e) {
            throw new RspecParseException(e.getLocation(), "Problem parsing RSpec: " + e.getMessage(), e);
        }
        catch (AssertionError | Exception e) {
            throw new RspecParseException(null, "Problem parsing RSpec", (Throwable)e);
        }
    }

    @Nullable
    private RspecLink readLink(@Nonnull ModelRspec rspec, @Nonnull XMLEvent startNodeEvent, @Nonnull XMLEventReader eventReader, @Nullable String rspecType) throws XMLStreamException, RspecParseException {
        Attribute vlantagAtt;
        assert (startNodeEvent.isStartElement());
        assert (Objects.equals(startNodeEvent.asStartElement().getName(), RspecXmlConstants.Q_LINK));
        Attribute idAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_CLIENT_ID);
        if (idAtt == null) {
            if (rspecType == null || !rspecType.trim().equalsIgnoreCase("advertisement")) {
                LOG.warn("link@{} has no client_id. ignoring.", (Object)startNodeEvent.getLocation());
            }
            return null;
        }
        RspecLink res = this.rspecFactory.createLinkWithClientId(rspec, idAtt.getValue(), null);
        Attribute sliverIdAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_SLIVER_ID);
        if (sliverIdAtt != null) {
            res.setSliverId(sliverIdAtt.getValue());
        }
        if ((vlantagAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_LINK_VLANTAG)) != null && !vlantagAtt.getValue().equalsIgnoreCase("unknown")) {
            try {
                res.setVlanTag(Integer.parseInt(vlantagAtt.getValue()));
            }
            catch (NumberFormatException e) {
                LOG.error("Error while parsing vlantag '{}': {}", new Object[]{vlantagAtt.getValue(), e.getMessage(), e});
            }
        }
        ArrayList<XMLEventReader> linkPropertyEventsList = new ArrayList<XMLEventReader>();
        while (eventReader.hasNext()) {
            XMLEvent e = eventReader.nextEvent();
            if (e.isStartElement()) {
                Attribute att;
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_LINK_TYPE)) {
                    att = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_LINK_TYPE_NAME);
                    if (att.getValue() != null) {
                        res.getLinkTypes().add(att.getValue());
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_LINK_SHAREDLAN_LINKSHAREDVLAN)) {
                    att = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_LINK_SHAREDLAN_ATT_NAME);
                    if (att.getValue() != null) {
                        res.setSharedLan(att.getValue());
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_LINK_VLAN_TAGGING)) {
                    att = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_LINK_VLAN_TAGGING_ENABLED_ATT_NAME);
                    if (att.getValue() != null) {
                        res.setVlanTagging(TextUtil.objectToBoolean((Object)att.getValue()));
                    } else {
                        res.setVlanTagging(null);
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_LINK_BEST_EFFORT)) {
                    att = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_LINK_BEST_EFFORT_ENABLED_ATT_NAME);
                    if (att.getValue() != null) {
                        res.setBestEffort(TextUtil.objectToBoolean((Object)att.getValue()));
                    } else {
                        res.setBestEffort(null);
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_JFED_LINK_AUTOSHARELAN)) {
                    att = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_JFED_LINK_AUTOSHARELAN_NAME);
                    if (att.getValue() != null) {
                        res.getAutoShareLanNames().add(att.getValue());
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_LINK_LINK_MULTIPLEXING)) {
                    att = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_LINK_LINK_MULTIPLEXING_ENABLED_ATT_NAME);
                    if (att.getValue() != null) {
                        res.setLinkMultiplexing(TextUtil.objectToBoolean((Object)att.getValue()));
                    } else {
                        res.setLinkMultiplexing(null);
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_LINK_INTERSWITCH)) {
                    att = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_LINK_INTERSWITCH_ALLOW);
                    Boolean allow = TextUtil.objectToBoolean((Object)att.getValue());
                    if (allow != null) {
                        res.setInterswitchDisallow(!Objects.equals(allow, Boolean.TRUE));
                    } else {
                        res.setInterswitchDisallow(null);
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_LINK_LINKATTRIBUTE)) {
                    Attribute attKey = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_LINK_LINKATTRIBUTE_KEY);
                    Attribute attVal = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_LINK_LINKATTRIBUTE_VALUE);
                    if (attKey.getValue() != null && attVal.getValue() != null && Objects.equals(attKey.getValue(), "nomac_learning")) {
                        res.setNoMacLearning(attVal.getValue());
                    } else {
                        res.setNoMacLearning((Boolean)null);
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_LINK_COM_MAN) || Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_LINK_COM_MAN2)) {
                    att = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_LINK_COM_MAN_NAME);
                    if (att.getValue() != null && GeniUrn.parse((String)att.getValue()) != null) {
                        res.getComponentManagerUrns().add(GeniUrn.parse((String)att.getValue()));
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_LINK_PROPERTY)) {
                    linkPropertyEventsList.add(StaxHelper.getEventsUntilEndTag(e, eventReader));
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_INTERFACE_REF)) {
                    this.readInterfaceRef(res, e, eventReader);
                    continue;
                }
                EventListExtraXml extraXml = new EventListExtraXml(e.asStartElement(), eventReader);
                if (this.rspecFactory.processExtraLinkXml(res, extraXml)) continue;
                res.getExtraXml().add(extraXml);
                continue;
            }
            if (e.isEndElement() && Objects.equals(e.asEndElement().getName(), RspecXmlConstants.Q_LINK)) {
                for (XMLEventReader linkPropertyEvents : linkPropertyEventsList) {
                    assert (linkPropertyEvents.hasNext());
                    XMLEvent startEvent = linkPropertyEvents.nextEvent();
                    this.readLinkProperty(res, startEvent, linkPropertyEvents);
                }
                return res;
            }
            if (e.isAttribute() || e.isNamespace()) continue;
            if (e.isProcessingInstruction()) {
                // empty if block
            }
            if (e.isCharacters() && e.asCharacters().isWhiteSpace()) continue;
            if (e.isEntityReference()) {
                // empty if block
            }
            if (e.getEventType() != 5) continue;
            res.getExtraXml().add(new SingleElementExtraXml(e));
        }
        throw new RspecParseException(startNodeEvent.getLocation(), "<link> tag was never closed");
    }

    @Nonnull
    private Lease readLease(ModelRspec rspec, XMLEvent startNodeEvent, XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        assert (startNodeEvent.isStartElement());
        assert (Objects.equals(startNodeEvent.asStartElement().getName(), RspecXmlConstants.Q_LEASE));
        String leaseId = null;
        Attribute leaseIdAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_ID);
        if (leaseIdAtt != null) {
            leaseId = leaseIdAtt.getValue();
        }
        String clientId = null;
        Attribute cliendIdAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_CLIENT_ID);
        if (cliendIdAtt != null) {
            clientId = cliendIdAtt.getValue();
        }
        Date validFrom = null;
        Attribute validFromAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_VALID_FROM);
        if (validFromAtt != null) {
            try {
                validFrom = RFC3339Util.rfc3339StringToDate((String)validFromAtt.getValue());
            }
            catch (ParseException ex) {
                throw new RspecParseException(validFromAtt.getLocation(), "Could not properly parse validFrom attribute '" + validFromAtt.getValue() + "'. Is it a valid date?");
            }
        }
        Date validUntil = null;
        Attribute validUntilAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_VALID_UNTIL);
        if (validUntilAtt != null) {
            try {
                validUntil = RFC3339Util.rfc3339StringToDate((String)validUntilAtt.getValue());
            }
            catch (ParseException ex) {
                throw new RspecParseException(validUntilAtt.getLocation(), "Could not properly parse validUntil attribute '" + validUntilAtt.getValue() + "'. Is it a valid date?");
            }
        }
        StaxRspecParser.discardRestOfTag(startNodeEvent, eventReader);
        return this.rspecFactory.createLease(rspec, leaseId, clientId, validFrom, validUntil, validFromAtt != null ? validFromAtt.getValue() : null, validUntilAtt != null ? validUntilAtt.getValue() : null);
    }

    @Nonnull
    private Channel readChannel(ModelRspec rspec, XMLEvent startNodeEvent, XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        Attribute editorYAtt;
        Attribute editorXAtt;
        Attribute freqAtt;
        Attribute conNameAtt;
        Attribute comManIdAtt;
        assert (startNodeEvent.isStartElement());
        assert (Objects.equals(startNodeEvent.asStartElement().getName(), RspecXmlConstants.Q_CHANNEL));
        Channel channel = this.rspecFactory.createChannel(rspec);
        Attribute comIdAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_COM_ID);
        if (comIdAtt != null) {
            channel.setComponentId(comIdAtt.getValue());
        }
        if ((comManIdAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_COM_MAN_ID)) != null) {
            channel.setComponentManagerId(comManIdAtt.getValue());
        }
        if ((conNameAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_COM_NAME)) != null) {
            channel.setComponentName(conNameAtt.getValue());
        }
        if ((freqAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_FREQUENCY)) != null) {
            channel.setFrequency(freqAtt.getValue());
        }
        if ((editorXAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_JFED_LOCATION_X)) != null) {
            try {
                channel.setEditorX(Double.parseDouble(editorXAtt.getValue()));
            }
            catch (NumberFormatException ex) {
                LOG.warn("Could not parse {} into a valid double as editorX-location", (Object)editorXAtt.getValue());
            }
        }
        if ((editorYAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_JFED_LOCATION_Y)) != null) {
            try {
                channel.setEditorY(Double.parseDouble(editorYAtt.getValue()));
            }
            catch (NumberFormatException ex) {
                LOG.warn("Could not parse {} into a valid double as editorY-location", (Object)editorYAtt.getValue());
            }
        }
        while (eventReader.hasNext()) {
            XMLEvent e = eventReader.nextEvent();
            if (e.isStartElement()) {
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_LEASE_REF)) {
                    Attribute leaseRefId = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_ID_REF);
                    if (leaseRefId != null) {
                        channel.addLeaseIdRef(leaseRefId.getValue());
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                EventListExtraXml extraXml = new EventListExtraXml(e.asStartElement(), eventReader);
                channel.getExtraXml().add(extraXml);
                continue;
            }
            if (e.isEndElement() && Objects.equals(e.asEndElement().getName(), RspecXmlConstants.Q_CHANNEL)) {
                return channel;
            }
            if (e.isAttribute() || e.isNamespace()) continue;
            if (e.isProcessingInstruction()) {
                // empty if block
            }
            if (e.isCharacters() && e.asCharacters().isWhiteSpace()) continue;
            if (e.isEntityReference()) {
                // empty if block
            }
            if (e.getEventType() != 5) continue;
            channel.getExtraXml().add(new SingleElementExtraXml(e));
        }
        throw new RspecParseException(startNodeEvent.getLocation(), "<channel> tag was never closed");
    }

    @Nonnull
    private AddressPool readAddressPool(ModelRspec rspec, XMLEvent startNodeEvent, XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        Attribute editorYAtt;
        Attribute editorXAtt;
        Attribute countAtt;
        Attribute typeAtt;
        Attribute comManIdAtt;
        assert (startNodeEvent.isStartElement());
        assert (Objects.equals(startNodeEvent.asStartElement().getName(), RspecXmlConstants.Q_ROUTABLE_POOL));
        AddressPool addressPool = this.rspecFactory.createAddressPool(rspec);
        Attribute clientIdAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_CLIENT_ID);
        if (clientIdAtt != null) {
            addressPool.setClientId(clientIdAtt.getValue());
        }
        if ((comManIdAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_COM_MAN_ID)) != null) {
            try {
                addressPool.setComponentManagerId(new GeniUrn(comManIdAtt.getValue()));
            }
            catch (GeniUrn.GeniUrnParseException e) {
                LOG.warn("Could not parse component_manager_id from address_pool {}", (Object)(clientIdAtt != null ? clientIdAtt.getValue() : "<NO_CLIENT_ID>"), (Object)e);
            }
        }
        if ((typeAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_ROUTABLE_POOL_TYPE)) != null) {
            addressPool.setType(typeAtt.getValue());
        }
        if ((countAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_COUNT)) != null) {
            try {
                addressPool.setCount(Integer.parseInt(countAtt.getValue()));
            }
            catch (NumberFormatException e) {
                LOG.warn("Could not parse count from address_pool {}", (Object)(clientIdAtt != null ? clientIdAtt.getValue() : "<NO_CLIENT_ID>"), (Object)e);
            }
        }
        if ((editorXAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_JFED_LOCATION_X)) != null) {
            try {
                addressPool.setEditorX(Double.parseDouble(editorXAtt.getValue()));
            }
            catch (NumberFormatException ex) {
                LOG.warn("Could not parse {} into a valid double as editorX-location for addresspool", (Object)editorXAtt.getValue());
            }
        }
        if ((editorYAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_JFED_LOCATION_Y)) != null) {
            try {
                addressPool.setEditorY(Double.parseDouble(editorYAtt.getValue()));
            }
            catch (NumberFormatException ex) {
                LOG.warn("Could not parse {} into a valid double as editorY-location for addresspool", (Object)editorYAtt.getValue());
            }
        }
        while (eventReader.hasNext()) {
            XMLEvent e = eventReader.nextEvent();
            if (e.isStartElement()) {
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_IPV4)) {
                    Attribute netmaskAtt;
                    String address = null;
                    String netmask = null;
                    Attribute addressAtt = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_IPV4_ADDRESS);
                    if (addressAtt != null) {
                        address = addressAtt.getValue();
                    }
                    if ((netmaskAtt = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_IPV4_NETMASK)) != null) {
                        netmask = netmaskAtt.getValue();
                    }
                    addressPool.addIPv4(this.rspecFactory.createIPv4(rspec, address, netmask));
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                LOG.warn("Unexpected element in <routable_pool>: {}", (Object)e.asStartElement().getName());
            }
            if (e.isEndElement() && Objects.equals(e.asEndElement().getName(), RspecXmlConstants.Q_ROUTABLE_POOL)) {
                return addressPool;
            }
            if (e.isAttribute() || e.isNamespace()) continue;
            if (e.isProcessingInstruction()) {
                // empty if block
            }
            if ((!e.isCharacters() || !e.asCharacters().isWhiteSpace()) && !e.isEntityReference()) continue;
        }
        throw new RspecParseException(startNodeEvent.getLocation(), "<routable_pool> tag was never closed");
    }

    @Nullable
    private ExecuteAnsiblePlaybook readExecuteAnsibleCookbook(ModelRspec rspec, XMLEvent startNodeEvent, XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        assert (startNodeEvent.isStartElement());
        assert (Objects.equals(startNodeEvent.asStartElement().getName(), RspecXmlConstants.Q_JFED_EXECUTE_ANSIBLE_PLAYBOOK));
        Attribute sourceAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_JFED_EXECUTE_ANSIBLE_PLAYBOOK_SOURCE);
        if (sourceAtt == null) {
            LOG.warn(String.valueOf(RspecXmlConstants.Q_JFED_EXECUTE_ANSIBLE_PLAYBOOK) + " has no " + String.valueOf(RspecXmlConstants.Q_ATT_JFED_EXECUTE_ANSIBLE_PLAYBOOK_SOURCE) + ". ignoring.");
            StaxRspecParser.discardRestOfTag(startNodeEvent, eventReader);
            return null;
        }
        Attribute outputFileAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_JFED_EXECUTE_ANSIBLE_PLAYBOOK_OUTPUT_FILE);
        StaxRspecParser.discardRestOfTag(startNodeEvent, eventReader);
        return this.rspecFactory.createExecuteAnsibleCookbook(rspec, sourceAtt.getValue(), outputFileAtt == null ? null : outputFileAtt.getValue());
    }

    @Nonnull
    private DistributeSshKeypair readDistributeSshKeypair(ModelRspec rspec, XMLEvent startNodeEvent, XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        GeniUrn userUrn;
        String location;
        assert (startNodeEvent.isStartElement());
        assert (Objects.equals(startNodeEvent.asStartElement().getName(), RspecXmlConstants.Q_JFED_DISTRIBUTE_SSH_KEYPAIR));
        Attribute locationAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_LOCATION);
        Attribute userAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_USER);
        String string = location = locationAtt != null ? locationAtt.getValue() : null;
        if (userAtt != null) {
            try {
                userUrn = new GeniUrn(userAtt.getValue());
            }
            catch (GeniUrn.GeniUrnParseException ex) {
                LOG.warn("Could not parse user-urn {} in {}. Ignoring.", (Object)userAtt.getValue(), (Object)RspecXmlConstants.Q_JFED_DISTRIBUTE_SSH_KEYPAIR);
                userUrn = null;
            }
        } else {
            userUrn = null;
        }
        StaxRspecParser.discardRestOfTag(startNodeEvent, eventReader);
        return this.rspecFactory.createDistributeSshKeypair(rspec, location, userUrn);
    }

    @Nonnull
    private HardwareTypeInfo.Entry readHardwareTypeEntry(XMLEvent startNodeEvent, XMLEventReader eventReader) throws XMLStreamException {
        Attribute hrefAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_HWINFO_HREF);
        Attribute mediaTypeAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_HWINFO_MEDIA_TYPE);
        String href = hrefAtt != null ? hrefAtt.getValue() : null;
        String mediaType = mediaTypeAtt != null ? mediaTypeAtt.getValue() : null;
        StaxHelper.Pair<String, Boolean> resPair = StaxHelper.getTextExpectingNoNestedElements(startNodeEvent, eventReader);
        String text = resPair.getKey().trim().isEmpty() ? null : resPair.getKey();
        return new HardwareTypeInfo.Entry(mediaType, href, text);
    }

    @Nonnull
    private HardwareTypeInfo readHardwareTypeInfo(ModelRspec rspec, XMLEvent startNodeEvent, XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        assert (startNodeEvent.isStartElement());
        assert (Objects.equals(startNodeEvent.asStartElement().getName(), RspecXmlConstants.Q_HWINFO_HARDWARE_TYPE_INFO));
        ArrayList<HardwareTypeInfo.Entry> overview = new ArrayList<HardwareTypeInfo.Entry>();
        ArrayList<HardwareTypeInfo.HardwareTypeInfoEntry> entries = new ArrayList<HardwareTypeInfo.HardwareTypeInfoEntry>();
        ArrayList<HardwareTypeInfo.Entry> infos = null;
        String typename = null;
        String hrn = null;
        while (eventReader.hasNext()) {
            XMLEvent e = eventReader.nextEvent();
            if (e.isStartElement()) {
                if (infos == null) {
                    if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_HWINFO_HARDWARE_TYPE)) {
                        Attribute hrnAtt = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_HWINFO_HRN);
                        hrn = hrnAtt != null ? hrnAtt.getValue() : null;
                        Attribute nameAtt = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_HWINFO_NAME);
                        String string = typename = nameAtt != null ? nameAtt.getValue() : null;
                        assert (typename != null);
                        infos = new ArrayList<HardwareTypeInfo.Entry>();
                        continue;
                    }
                    if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_HWINFO_OVERVIEW)) {
                        overview.add(this.readHardwareTypeEntry(e, eventReader));
                        continue;
                    }
                    throw new RspecParseException(startNodeEvent.getLocation(), "Unexpected element in <hardware_type_info>: " + String.valueOf(e.asStartElement().getName()));
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_HWINFO_INFO)) {
                    infos.add(this.readHardwareTypeEntry(e, eventReader));
                    continue;
                }
                throw new RspecParseException(startNodeEvent.getLocation(), "Unexpected element in <hardware_type_info><hardware_type>: " + String.valueOf(e.asStartElement().getName()));
            }
            if (e.isEndElement()) {
                if (infos == null) {
                    if (Objects.equals(e.asEndElement().getName(), RspecXmlConstants.Q_HWINFO_HARDWARE_TYPE_INFO)) {
                        return new HardwareTypeInfo(overview, entries);
                    }
                } else if (Objects.equals(e.asEndElement().getName(), RspecXmlConstants.Q_HWINFO_HARDWARE_TYPE)) {
                    entries.add(new HardwareTypeInfo.HardwareTypeInfoEntry(typename, hrn, (List<HardwareTypeInfo.Entry>)infos));
                    infos = null;
                    typename = null;
                    hrn = null;
                    continue;
                }
            }
            if (e.isAttribute() || e.isNamespace()) continue;
            if (e.isProcessingInstruction()) {
                // empty if block
            }
            if ((!e.isCharacters() || !e.asCharacters().isWhiteSpace()) && !e.isEntityReference()) continue;
        }
        throw new RspecParseException(startNodeEvent.getLocation(), "<hardware_type_info> tag was never closed");
    }

    @Nonnull
    private DiskImageList readDiskImageList(@Nonnull ModelRspec rspec, @Nonnull XMLEvent startNodeEvent, @Nonnull XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        assert (startNodeEvent.isStartElement());
        assert (Objects.equals(startNodeEvent.asStartElement().getName(), RspecXmlConstants.Q_DISK_IMAGE_LIST));
        Attribute idAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_DISK_IMAGE_LIST_ID);
        ArrayList<DiskImage> diskImageList = new ArrayList<DiskImage>();
        while (eventReader.hasNext()) {
            XMLEvent e = eventReader.nextEvent();
            if (e.isStartElement()) {
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_NODE_SLIVERTYPE_DISKIMAGE)) {
                    diskImageList.add(this.readDiskImage(e));
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                throw new RspecParseException(startNodeEvent.getLocation(), "Unexpected element in <disk_image_list>: " + String.valueOf(e.asStartElement().getName()));
            }
            if (e.isEndElement() && Objects.equals(e.asEndElement().getName(), RspecXmlConstants.Q_DISK_IMAGE_LIST)) {
                return new DiskImageList(idAtt.getValue(), diskImageList);
            }
            if (e.isAttribute() || e.isNamespace()) continue;
            if (e.isProcessingInstruction()) {
                // empty if block
            }
            if ((!e.isCharacters() || !e.asCharacters().isWhiteSpace()) && !e.isEntityReference()) continue;
        }
        throw new RspecParseException(startNodeEvent.getLocation(), "<disk_image_list> tag was never closed");
    }

    @Nonnull
    private String readFlavor(XMLEvent e) {
        Attribute attName = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_FLAVOR_TYPE_NAME);
        return attName.getValue();
    }

    @Nonnull
    private FlavorList readFlavorList(@Nonnull ModelRspec rspec, @Nonnull XMLEvent startNodeEvent, @Nonnull XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        assert (startNodeEvent.isStartElement());
        assert (Objects.equals(startNodeEvent.asStartElement().getName(), RspecXmlConstants.Q_FLAVOR_LIST));
        Attribute idAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_DISK_IMAGE_LIST_ID);
        ArrayList<String> flavorList = new ArrayList<String>();
        while (eventReader.hasNext()) {
            XMLEvent e = eventReader.nextEvent();
            if (e.isStartElement()) {
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_FLAVOR_TYPE)) {
                    flavorList.add(this.readFlavor(e));
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                throw new RspecParseException(startNodeEvent.getLocation(), "Unexpected element in <flavor_list>: " + String.valueOf(e.asStartElement().getName()));
            }
            if (e.isEndElement() && Objects.equals(e.asEndElement().getName(), RspecXmlConstants.Q_FLAVOR_LIST)) {
                return new FlavorList(idAtt.getValue(), flavorList);
            }
            if (e.isAttribute() || e.isNamespace()) continue;
            if (e.isProcessingInstruction()) {
                // empty if block
            }
            if ((!e.isCharacters() || !e.asCharacters().isWhiteSpace()) && !e.isEntityReference()) continue;
        }
        throw new RspecParseException(startNodeEvent.getLocation(), "<flavor_list> tag was never closed");
    }

    @Nonnull
    private OpenflowDataPath readOpenflowDataPath(@Nonnull ModelRspec rspec, @Nonnull XMLEvent startNodeEvent, @Nonnull XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        assert (startNodeEvent.isStartElement());
        assert (Objects.equals(startNodeEvent.asStartElement().getName(), RspecXmlConstants.Q_OPENFLOW_DATAPATH));
        Attribute idAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_OPENFLOW_COM_ID);
        Attribute compManAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_OPENFLOW_COM_MAN_ID);
        Attribute dpidAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_OPENFLOW_DPID);
        EventListExtraXml allXml = new EventListExtraXml(startNodeEvent.asStartElement(), eventReader);
        return this.rspecFactory.createOpenflowDataPath(rspec, allXml, compManAtt == null ? null : compManAtt.getValue(), idAtt == null ? null : idAtt.getValue(), dpidAtt == null ? null : dpidAtt.getValue());
    }

    @Nonnull
    private OpenflowSliver readOpenflowSliver(@Nonnull ModelRspec rspec, @Nonnull XMLEvent startNodeEvent, @Nonnull XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        assert (startNodeEvent.isStartElement());
        assert (Objects.equals(startNodeEvent.asStartElement().getName(), RspecXmlConstants.Q_OPENFLOW_SLIVER));
        Attribute refAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_OPENFLOW_SLIVER_REF);
        Attribute emailAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_OPENFLOW_SLIVER_EMAIL);
        Attribute descAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_OPENFLOW_SLIVER_DESCRIPTION);
        EventListExtraXml allXml = new EventListExtraXml(startNodeEvent.asStartElement(), eventReader);
        ArrayList<OpenflowSliver.Group> groups = new ArrayList<OpenflowSliver.Group>();
        String curGroupName = null;
        ArrayList<OpenflowDataPath> curDataPaths = new ArrayList<OpenflowDataPath>();
        XMLEventReader tmpEventReader = allXml.getAsEventReader();
        while (tmpEventReader.hasNext()) {
            XMLEvent e = tmpEventReader.nextEvent();
            if (e.isStartElement()) {
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_OPENFLOW_SLIVER_GROUP)) {
                    Attribute nameAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_OPENFLOW_SLIVER_GROUP_NAME);
                    String string = curGroupName = nameAtt == null ? null : nameAtt.getValue();
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_OPENFLOW_DATAPATH)) {
                    OpenflowDataPath dp = this.readOpenflowDataPath(rspec, e, tmpEventReader);
                    curDataPaths.add(dp);
                }
            }
            if (!e.isEndElement() || !Objects.equals(e.asEndElement().getName(), RspecXmlConstants.Q_OPENFLOW_SLIVER_GROUP)) continue;
            groups.add(new OpenflowSliver.Group(curGroupName, curDataPaths));
            curDataPaths = new ArrayList();
            curGroupName = null;
        }
        return new OpenflowSliver(allXml, emailAtt == null ? null : emailAtt.getValue(), descAtt == null ? null : descAtt.getValue(), refAtt == null ? null : refAtt.getValue(), groups);
    }

    private static void discardRestOfTag(XMLEvent startNodeEvent, XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        QName name = startNodeEvent.asStartElement().getName();
        int depth = 1;
        while (eventReader.hasNext()) {
            XMLEvent e = eventReader.nextEvent();
            if (e.isStartElement() && Objects.equals(e.asStartElement().getName(), name)) {
                ++depth;
            }
            if (!e.isEndElement() || !Objects.equals(e.asEndElement().getName(), name) || --depth != 0) continue;
            return;
        }
        throw new RspecParseException(startNodeEvent.getLocation(), "<" + name.getLocalPart() + "> tag was never closed");
    }

    private void readLinkProperty(RspecLink link, XMLEvent startNodeEvent, XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        Attribute attSource = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_LINK_PROPERTY_SOURCE);
        Attribute attDest = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_LINK_PROPERTY_DEST);
        Attribute attCapacity = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_LINK_PROPERTY_CAPACITY);
        Attribute attLatency = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_LINK_PROPERTY_LATENCY);
        Attribute attLoss = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_LINK_PROPERTY_LOSS);
        if (attSource == null || attDest == null) {
            this.ignorableParseError(startNodeEvent.getLocation(), "Error parsing link property: both source and destination are needed");
            return;
        }
        LinkSetting linkSetting = link.getLinkSettingByClientIds(attSource.getValue(), attDest.getValue());
        if (linkSetting == null) {
            this.ignorableParseError(startNodeEvent.getLocation(), "Error parsing link property: source and/or destination == unknown link interface");
            return;
        }
        if (attCapacity != null) {
            linkSetting.setCapacity_Kbps(Long.parseLong(attCapacity.getValue()));
        }
        if (attLatency != null) {
            linkSetting.setLatency_ms(Integer.parseInt(attLatency.getValue()));
        }
        if (attLoss != null) {
            linkSetting.setPacketLoss(Double.parseDouble(attLoss.getValue()));
        }
        if (!linkSetting.isActive()) {
            linkSetting.setShownIfNotActive(true);
        }
        StaxRspecParser.discardRestOfTag(startNodeEvent, eventReader);
    }

    @Nullable
    private RspecInterface findPartialMatchingInterface(LinkId linkId) {
        ArrayList<RspecInterface> match1 = new ArrayList<RspecInterface>();
        ArrayList<RspecInterface> match2 = new ArrayList<RspecInterface>();
        ArrayList<RspecInterface> match3 = new ArrayList<RspecInterface>();
        for (Map.Entry<LinkId, RspecInterface> e : this.interfacesByLinkId.entrySet()) {
            boolean otherHasOnlyClientId;
            LinkId li = e.getKey();
            RspecInterface iface = e.getValue();
            boolean thisHasOnlyClientId = linkId.compId == null && linkId.sliverId == null;
            boolean bl = otherHasOnlyClientId = li.compId == null && li.sliverId == null;
            if ((linkId.compId == null || li.compId == null) && li.equals(linkId, true, false)) {
                match1.add(iface);
            }
            if ((linkId.sliverId == null || li.sliverId == null) && li.equals(linkId, false, true)) {
                match2.add(iface);
            }
            if (!thisHasOnlyClientId && !otherHasOnlyClientId || !li.equals(linkId, true, true)) continue;
            match3.add(iface);
        }
        RspecInterface res = null;
        if (match1.size() == 1) {
            res = (RspecInterface)match1.get(0);
        } else if (match2.size() == 1) {
            res = (RspecInterface)match2.get(0);
        } else if (match3.size() == 1) {
            res = (RspecInterface)match3.get(0);
        }
        LOG.debug("    Did not find interface_ref by full link id " + String.valueOf(linkId) + ". Result after partial match (" + match1.size() + " " + match2.size() + " " + match3.size() + "): " + (res == null ? "still not found" : "found"));
        if (LOG.isTraceEnabled() && res == null) {
            LOG.trace("        Known links (" + this.interfacesByLinkId.size() + "): " + String.valueOf(this.interfacesByLinkId.keySet()));
        }
        return res;
    }

    @Nullable
    private RspecInterface readInterfaceRef(RspecLink parentLink, XMLEvent startNodeEvent, XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        Attribute idAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_CLIENT_ID);
        if (idAtt == null) {
            this.ignorableParseError(startNodeEvent.getLocation(), "Error parsing interface_ref property: client_id was not specified");
            return null;
        }
        String clientId = idAtt.getValue();
        Attribute comIdAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_COM_ID);
        Attribute sliverIdAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_SLIVER_ID);
        Attribute felixVlanAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_FELIX_VLAN);
        String comId = comIdAtt != null ? comIdAtt.getValue() : null;
        String sliverId = sliverIdAtt != null ? sliverIdAtt.getValue() : null;
        Integer felixVlan = null;
        if (felixVlanAtt != null) {
            try {
                felixVlan = Integer.parseInt(felixVlanAtt.getValue());
            }
            catch (NumberFormatException ex) {
                this.ignorableParseError(startNodeEvent.getLocation(), "Error parsing interface_ref property 'felix:vlan': the value '" + felixVlanAtt.getValue() + "' is not a valid number", ex);
            }
        }
        LinkId linkId = new LinkId(clientId, comId, sliverId);
        LOG.debug("Parsing interface_ref " + String.valueOf(linkId));
        RspecInterface res = this.interfacesByLinkId.get(linkId);
        if (res == null) {
            res = this.findPartialMatchingInterface(linkId);
        }
        if (res == null) {
            res = this.rspecFactory.createInterface(parentLink, clientId);
            this.interfacesByLinkId.put(linkId, res);
        } else {
            if (!res.isLinkUnbound()) {
                this.ignorableParseError(startNodeEvent.getLocation(), "Error parsing interface_ref property: interface has already been used in another link (this_link=" + parentLink.getUniqueId() + " other_link=" + res.getLink().getUniqueId() + ")");
                return null;
            }
            res.bindLink(parentLink);
        }
        if (comId != null) {
            res.setComponentId(comId);
        }
        if (sliverId != null) {
            res.setSliverId(sliverId);
        }
        if (felixVlan != null) {
            res.setFelixVlan(felixVlan);
        }
        res.getRefExtraXml().addAll(EventListExtraXml.readExtraElements(startNodeEvent, eventReader));
        return res;
    }

    @Nullable
    private RspecInterface readInterface(RspecNode parentNode, XMLEvent startNodeEvent, XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        Attribute macAddressAtt;
        String sliverId;
        assert (startNodeEvent.isStartElement());
        assert (Objects.equals(startNodeEvent.asStartElement().getName(), RspecXmlConstants.Q_INTERFACE));
        Attribute clientIdAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_CLIENT_ID);
        Attribute comIdAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_COM_ID);
        Attribute sliverIdAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_SLIVER_ID);
        String clientId = clientIdAtt == null ? null : clientIdAtt.getValue();
        String comId = comIdAtt != null ? comIdAtt.getValue() : null;
        String string = sliverId = sliverIdAtt != null ? sliverIdAtt.getValue() : null;
        if (clientId == null && comId == null) {
            this.ignorableParseError(startNodeEvent.getLocation(), "Error parsing interface property: both client_id and component_id are not specified");
            StaxRspecParser.discardRestOfTag(startNodeEvent, eventReader);
            return null;
        }
        LinkId linkId = new LinkId(clientId, comId, sliverId);
        LOG.debug("Parsing interface " + String.valueOf(linkId));
        RspecInterface res = this.interfacesByLinkId.get(linkId);
        if (res == null) {
            res = this.findPartialMatchingInterface(linkId);
        }
        if (res == null) {
            res = this.rspecFactory.createInterface(parentNode, clientId);
            this.interfacesByLinkId.put(linkId, res);
        } else {
            if (!res.isNodeUnbound()) {
                this.ignorableParseError(startNodeEvent.getLocation(), "Error parsing interface property: interface has already been used in another node (this_node=" + parentNode.getUniqueId() + " other_node=" + res.getNode().getUniqueId() + ")");
                return null;
            }
            res.bindNode(parentNode);
        }
        if (clientIdAtt != null) {
            res.setClientId(clientIdAtt.getValue());
        }
        if (comId != null) {
            res.setComponentId(comId);
        }
        if (sliverId != null) {
            res.setSliverId(sliverId);
        }
        if ((macAddressAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_INTERFACE_MAC)) != null) {
            res.setMacAddress(macAddressAtt.getValue());
        }
        Attribute comNameAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_COM_NAME);
        Attribute roleAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_IFACE_ROLE);
        Attribute publicIpv4Att = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_IFACE_PUBIP4);
        if (comNameAtt != null) {
            res.setComponentName(comNameAtt.getValue());
        }
        if (roleAtt != null) {
            res.setRole(roleAtt.getValue());
        }
        if (publicIpv4Att != null) {
            res.setPublicIpv4(publicIpv4Att.getValue());
        }
        int depth = 1;
        while (eventReader.hasNext()) {
            XMLEvent e = eventReader.nextEvent();
            if (e.isStartElement()) {
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_INTERFACE_IP)) {
                    Attribute attAddress = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_INTERFACE_IP_ADDRESS);
                    Attribute attNetmask = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_INTERFACE_IP_NETMASK);
                    Attribute attType = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_INTERFACE_IP_TYPE);
                    assert (attAddress != null);
                    RspecInterface.IpAddress ip = new RspecInterface.IpAddress(attAddress.getValue(), attNetmask == null ? null : attNetmask.getValue(), attType == null ? null : attType.getValue());
                    res.getIpAddresses().add(ip);
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_INTERFACE)) {
                    ++depth;
                }
                res.getExtraXml().add(new EventListExtraXml(e.asStartElement(), eventReader));
                continue;
            }
            if (!e.isEndElement() || !Objects.equals(e.asEndElement().getName(), RspecXmlConstants.Q_INTERFACE) || --depth != 0) continue;
            return res;
        }
        throw new RspecParseException(startNodeEvent.getLocation(), "<interface> tag was never closed");
    }

    private void readServices(RspecNode node, XMLEvent startNodeEvent, XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        assert (startNodeEvent.isStartElement());
        assert (Objects.equals(startNodeEvent.asStartElement().getName(), RspecXmlConstants.Q_NODE_SERVICES));
        int depth = 1;
        while (eventReader.hasNext()) {
            XMLEvent e = eventReader.nextEvent();
            if (e.isStartElement()) {
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_NODE_SERVICES_EXECUTE)) {
                    Attribute attCommand = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_NODE_SERVICES_EXECUTE_COMMAND);
                    Attribute attShell = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_NODE_SERVICES_EXECUTE_SHELL);
                    ExecuteService executeService = this.rspecFactory.createExecuteService(attShell == null ? null : attShell.getValue(), attCommand == null ? null : attCommand.getValue());
                    Attribute attFinishedFile = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_JFED_EXECUTE_FINISHED_FLAG);
                    if (attFinishedFile != null) {
                        executeService.setFinishedFile(attFinishedFile.getValue());
                    }
                    node.addExecuteService(executeService);
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_NODE_SERVICES_INSTALL)) {
                    Attribute attPath = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_NODE_SERVICES_INSTALL_PATH);
                    Attribute attUrl = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_NODE_SERVICES_INSTALL_URL);
                    node.addInstallService(this.rspecFactory.createInstallService(attPath == null ? null : attPath.getValue(), attUrl == null ? null : attUrl.getValue()));
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_NODE_SERVICES_LOGIN)) {
                    Attribute attAuth = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_NODE_SERVICES_LOGIN_AUTH);
                    Attribute attHostname = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_NODE_SERVICES_LOGIN_HOSTNAME);
                    Attribute attPort = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_NODE_SERVICES_LOGIN_PORT);
                    Attribute attUsername = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_NODE_SERVICES_LOGIN_USERNAME);
                    node.getLoginServices().add(new LoginService(attAuth == null ? null : attAuth.getValue(), attHostname == null ? null : attHostname.getValue(), attPort == null ? null : attPort.getValue(), attUsername == null ? null : attUsername.getValue()));
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_PROXY_PROXY)) {
                    Attribute attFor = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_FOR);
                    Attribute attProxy = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_PROXY);
                    Attribute attHostKey = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_HOSTKEY);
                    node.getProxyServices().add(new ProxyService(attProxy == null ? null : attProxy.getValue(), attFor == null ? null : attFor.getValue(), attHostKey == null ? null : attHostKey.getValue()));
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_JFED_ANSIBLE_SERVICE)) {
                    Attribute attInventory;
                    Attribute attDebug;
                    Attribute attLogfile;
                    Attribute attGalaxyCommand;
                    Attribute attPlaybookCommand;
                    Attribute attExecutePlaybook;
                    AnsibleService as = this.rspecFactory.createAnsibleService();
                    Attribute attInstallRequirements = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_INSTALL_REQUIREMENTS);
                    if (attInstallRequirements != null) {
                        as.setInstallRequirements(attInstallRequirements.getValue());
                    }
                    if ((attExecutePlaybook = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_EXECUTE_PLAYBOOK)) != null) {
                        as.setExecutePlaybook(attExecutePlaybook.getValue());
                    }
                    if ((attPlaybookCommand = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_PLAYBOOK_COMMAND)) != null) {
                        as.setPlaybookCommand(attPlaybookCommand.getValue());
                    }
                    if ((attGalaxyCommand = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_GALAXY_COMMAND)) != null) {
                        as.setGalaxyCommand(attGalaxyCommand.getValue());
                    }
                    if ((attLogfile = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_LOGFILE)) != null) {
                        as.setLogfile(attLogfile.getValue());
                    }
                    if ((attDebug = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_DEBUG)) != null) {
                        as.setDebug(Boolean.parseBoolean(attDebug.getValue()));
                    }
                    if ((attInventory = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_INVENTORY)) != null) {
                        as.setInventory(attInventory.getValue());
                    }
                    node.addAnsibleService(as);
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_NODE_SERVICES)) {
                    ++depth;
                }
                node.getExtraServicesXml().add(new EventListExtraXml(e.asStartElement(), eventReader));
            }
            if (!e.isEndElement() || !Objects.equals(e.asEndElement().getName(), RspecXmlConstants.Q_NODE_SERVICES) || --depth != 0) continue;
            if (node.getLoginServices().isEmpty() && node.getInstallServices().isEmpty() && node.getExecuteServices().isEmpty()) {
                node.addEmptyTag(RspecNode.EmptyTag.SERVICES);
            }
            return;
        }
        throw new RspecParseException(startNodeEvent.getLocation(), "<services> tag was never closed");
    }

    @Nonnull
    private DiskImage readDiskImage(XMLEvent e) {
        Attribute attName = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_DISKIMAGE_NAME);
        Attribute attUrl = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_DISKIMAGE_URL);
        Attribute attOs = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_DISKIMAGE_OS);
        Attribute attVer = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_DISKIMAGE_VERSION);
        Attribute attDesc = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_DISKIMAGE_DESCRIPTION);
        Attribute attDefault = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_DISKIMAGE_DEFAULT);
        return new DiskImage(attName == null ? null : attName.getValue(), attUrl == null ? null : attUrl.getValue(), attOs == null ? null : attOs.getValue(), attVer == null ? null : attVer.getValue(), attDesc == null ? null : attDesc.getValue(), attDefault == null ? null : TextUtil.objectToBoolean((Object)attDefault.getValue()));
    }

    @Nonnull
    private SliverType readSliverType(RspecNode node, StartElement startNodeEvent, XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        assert (Objects.equals(startNodeEvent.getName(), RspecXmlConstants.Q_NODE_SLIVERTYPE));
        Attribute att = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_NODE_SLIVERTYPE_NAME);
        SliverTypeBuilder sliverTypeBuilder = new SliverTypeBuilder(att == null ? null : att.getValue());
        int depth = 1;
        while (eventReader.hasNext()) {
            XMLEvent e = eventReader.nextEvent();
            if (e.isStartElement()) {
                Attribute id;
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_NODE_SLIVERTYPE_DISKIMAGE)) {
                    sliverTypeBuilder.addDiskImage(this.readDiskImage(e));
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_FLAVOR_TYPE)) {
                    id = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_FLAVOR_TYPE_NAME);
                    if (id != null && id.getValue() != null && !id.getValue().trim().isEmpty()) {
                        sliverTypeBuilder.addFlavor(id.getValue());
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_FLAVOR_LIST_REF)) {
                    id = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_FLAVOR_LIST_REF_ID);
                    if (id != null && id.getValue() != null && !id.getValue().trim().isEmpty()) {
                        sliverTypeBuilder.addFlavorListRef(id.getValue());
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_DISK_IMAGE_LIST_REF)) {
                    id = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_DISK_IMAGE_LIST_REF_ID);
                    if (id != null && id.getValue() != null && !id.getValue().trim().isEmpty()) {
                        sliverTypeBuilder.addDiskImageListRef(id.getValue());
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_NODE_SLIVERTYPE_XEN)) {
                    Attribute attCores = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_XEN_CORES);
                    if (attCores != null) {
                        try {
                            sliverTypeBuilder.xenCores(Integer.parseInt(attCores.getValue()));
                        }
                        catch (NumberFormatException e1) {
                            LOG.warn("Invalid integer in parsed Rspec xen cores", (Throwable)e1);
                        }
                    } else {
                        sliverTypeBuilder.xenCores(null);
                    }
                    Attribute attRam = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_XEN_RAM);
                    if (attRam != null) {
                        try {
                            sliverTypeBuilder.xenRam(Integer.parseInt(attRam.getValue()));
                        }
                        catch (NumberFormatException e1) {
                            LOG.warn("Invalid integer in parsed Rspec xen ram", (Throwable)e1);
                        }
                    } else {
                        sliverTypeBuilder.xenRam(null);
                    }
                    Attribute attDisk = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_XEN_DISK);
                    if (attDisk != null) {
                        try {
                            sliverTypeBuilder.xenDisk(Integer.parseInt(attDisk.getValue()));
                        }
                        catch (NumberFormatException e1) {
                            LOG.warn("Invalid integer in parsed Rspec xen disk", (Throwable)e1);
                        }
                        continue;
                    }
                    sliverTypeBuilder.xenDisk(null);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_NODE_SLIVERTYPE)) {
                    LOG.warn("Warning: nested <sliver_type> at " + String.valueOf(e.getLocation()));
                    ++depth;
                    continue;
                }
                sliverTypeBuilder.addExtraXml(new EventListExtraXml(e.asStartElement(), eventReader));
                continue;
            }
            if (!e.isEndElement() || !Objects.equals(e.asEndElement().getName(), RspecXmlConstants.Q_NODE_SLIVERTYPE) || --depth != 0) continue;
            if (!sliverTypeBuilder.isValid()) {
                LOG.warn("Invalid sliver_type in Rspec: name is required. Will be set to a default name (\"pc\").");
                sliverTypeBuilder.name("pc");
            }
            return sliverTypeBuilder.build();
        }
        throw new RspecParseException(startNodeEvent.getLocation(), "<sliver_type> tag was never closed");
    }

    @Nonnull
    private HardwareType readHardwareType(RspecNode node, StartElement startNodeEvent, XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        assert (Objects.equals(startNodeEvent.getName(), RspecXmlConstants.Q_NODE_HARDWARETYPE));
        Attribute attHwTypeNameAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_NODE_HARDWARETYPE_NAME);
        assert (attHwTypeNameAtt != null) : "<hardware_type> has no name attribute";
        Integer typeSlotsInt = null;
        String typeSlotsString = null;
        int depth = 1;
        while (eventReader.hasNext()) {
            XMLEvent e = eventReader.nextEvent();
            if (e.isStartElement()) {
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_NODE_HARDWARETYPE_NODETYPE)) {
                    Attribute attTypeSlots = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_NODE_HARDWARETYPE_NODETYPE_TYPESLOTS);
                    if (attTypeSlots != null) {
                        assert (typeSlotsString == null) : "multiple " + String.valueOf(RspecXmlConstants.Q_ATT_NODE_HARDWARETYPE_NODETYPE_TYPESLOTS) + " seen in same " + String.valueOf(RspecXmlConstants.Q_NODE_HARDWARETYPE);
                        typeSlotsString = attTypeSlots.getValue();
                        try {
                            typeSlotsInt = Integer.parseInt(typeSlotsString);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                this.ignorableParseError(startNodeEvent.getLocation(), "Unsupported extra XML in " + String.valueOf(RspecXmlConstants.Q_NODE_HARDWARETYPE) + ": " + String.valueOf(startNodeEvent.getName()));
                StaxRspecParser.discardRestOfTag(e, eventReader);
                continue;
            }
            if (!e.isEndElement() || !Objects.equals(e.asEndElement().getName(), RspecXmlConstants.Q_NODE_HARDWARETYPE) || --depth != 0) continue;
            return new HardwareType(attHwTypeNameAtt == null ? null : attHwTypeNameAtt.getValue(), typeSlotsInt, typeSlotsString);
        }
        throw new RspecParseException(startNodeEvent.getLocation(), "<" + String.valueOf(RspecXmlConstants.Q_NODE_HARDWARETYPE) + "> tag was never closed");
    }

    @Nonnull
    private RspecNode readNode(@Nonnull ModelRspec modelRspec, @Nonnull XMLEvent startNodeEvent, @Nonnull XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        assert (startNodeEvent.isStartElement());
        assert (Objects.equals(startNodeEvent.asStartElement().getName(), RspecXmlConstants.Q_NODE));
        Attribute idAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_CLIENT_ID);
        RspecNode res = this.rspecFactory.createNodeWithClientId(modelRspec, idAtt == null ? null : idAtt.getValue());
        Attribute comIdAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_COM_ID);
        Attribute comManIdAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_COM_MAN_ID);
        Attribute exclusiveAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_NODE_EXCLUSIVE);
        Attribute sliverIdAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_SLIVER_ID);
        Attribute conNameAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_COM_NAME);
        if (comManIdAtt != null) {
            res.setComponentManagerId(comManIdAtt.getValue());
        }
        if (comIdAtt != null) {
            res.setComponentId(comIdAtt.getValue());
        }
        if (exclusiveAtt != null) {
            res.setExclusive(TextUtil.stringToBoolean((String)exclusiveAtt.getValue()));
        }
        if (sliverIdAtt != null) {
            res.setSliverId(sliverIdAtt.getValue());
        }
        if (conNameAtt != null) {
            res.setComponentName(conNameAtt.getValue());
        }
        while (eventReader.hasNext()) {
            XMLEvent e = eventReader.nextEvent();
            if (e.isStartElement()) {
                Attribute attY;
                Attribute attX;
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_NODE_SLIVERTYPE)) {
                    res.getSliverTypes().add(this.readSliverType(res, e.asStartElement(), eventReader));
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_NODE_FLACK_NODE_INFO)) {
                    attX = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_FLACK_NODE_INFO_X);
                    attY = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_FLACK_NODE_INFO_Y);
                    if (attX != null) {
                        res.setFlackEditorX(Double.parseDouble(attX.getValue()));
                    }
                    if (attY != null) {
                        res.setFlackEditorY(Double.parseDouble(attY.getValue()));
                    }
                    res.getExtraXml().add(new EventListExtraXml(e.asStartElement(), eventReader));
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_INTERFACE)) {
                    this.readInterface(res, e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_JFED_LOCATION)) {
                    attX = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_JFED_LOCATION_X);
                    attY = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_JFED_LOCATION_Y);
                    if (attX != null) {
                        res.setEditorX(Double.parseDouble(attX.getValue()));
                    }
                    if (attY != null) {
                        res.setEditorY(Double.parseDouble(attY.getValue()));
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_NODE_SERVICES)) {
                    this.readServices(res, e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_NODE_HARDWARETYPE)) {
                    res.getHardwareTypes().add(this.readHardwareType(res, e.asStartElement(), eventReader));
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_NODE_ROUTABLECONTROLIP)) {
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    res.setRoutableControlIp(true);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_NODE_AVAILABLE)) {
                    Attribute att = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_NODE_AVAILABLE_NOW);
                    if (att != null) {
                        res.setAvailable(TextUtil.stringToBoolean((String)att.getValue()));
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_NODE_LOCATION)) {
                    Attribute attCountry = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_NODE_LOCATION_COUNTRY);
                    Attribute attLat = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_NODE_LOCATION_LAT);
                    Attribute attLong = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_NODE_LOCATION_LONG);
                    res.setLocation(new NodeLocation(attCountry == null ? null : attCountry.getValue(), attLat == null ? null : attLat.getValue(), attLong == null ? null : attLong.getValue()));
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_LEASE_REF)) {
                    Attribute leaseRefId = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_ID_REF);
                    if (leaseRefId != null) {
                        res.addLeaseIdRef(leaseRefId.getValue());
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_JFED_ANSIBLE_GROUP)) {
                    Attribute attName = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_ANSIBLE_GROUP_NAME);
                    if (attName != null) {
                        res.getAnsibleGroups().add(attName.getValue());
                    } else {
                        LOG.warn("Encountered ansible_group-tag without name-attribute. Ignoring");
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                EventListExtraXml extraXml = new EventListExtraXml(e.asStartElement(), eventReader);
                res.getExtraXml().add(extraXml);
                continue;
            }
            if (e.isEndElement() && Objects.equals(e.asEndElement().getName(), RspecXmlConstants.Q_NODE)) {
                return this.rspecFactory.convertToSpecialNode(res);
            }
            if (e.isAttribute() || e.isNamespace()) continue;
            if (e.isProcessingInstruction()) {
                // empty if block
            }
            if (e.isCharacters() && e.asCharacters().isWhiteSpace()) continue;
            if (e.isEntityReference()) {
                // empty if block
            }
            if (e.getEventType() != 5) continue;
            res.getExtraXml().add(new SingleElementExtraXml(e));
        }
        throw new RspecParseException(startNodeEvent.getLocation(), "<node> tag was never closed");
    }

    @Nonnull
    private RspecNode readFlexENodeB(@Nonnull ModelRspec modelRspec, @Nonnull XMLEvent startNodeEvent, @Nonnull XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        LOG.debug("NITOS flex:e_node_b HACK: readFlexENodeB");
        assert (startNodeEvent.isStartElement());
        assert (Objects.equals(startNodeEvent.asStartElement().getName(), RspecXmlConstants.Q_NITOS_E_NODE_B));
        Attribute idAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_CLIENT_ID);
        RspecNode res = this.rspecFactory.createNodeWithClientId(modelRspec, idAtt == null ? null : idAtt.getValue());
        Attribute comIdAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_COM_ID);
        Attribute comManIdAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_COM_MAN_ID);
        Attribute exclusiveAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_NODE_EXCLUSIVE);
        Attribute sliverIdAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_SLIVER_ID);
        Attribute conNameAtt = startNodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_COM_NAME);
        if (comManIdAtt != null) {
            res.setComponentManagerId(comManIdAtt.getValue());
        }
        if (comIdAtt != null) {
            if (comIdAtt.getValue() != null) {
                Matcher urnMatcher = E_NODE_B_URN_PATTERN.matcher(comIdAtt.getValue().trim());
                if (urnMatcher.matches()) {
                    String topLevelAuthority_enc = urnMatcher.group(1);
                    String resourceType_enc = urnMatcher.group(2);
                    String resourceName_enc = urnMatcher.group(3);
                    assert (resourceType_enc.equals("e_node_b"));
                    res.setComponentId(GeniUrn.createGeniUrnFromEncodedParts((String)topLevelAuthority_enc, (String)"node", (String)resourceName_enc));
                    LOG.debug("NITOS flex:e_node_b HACK: Changed URN from \"" + comIdAtt.getValue() + "\" to \"" + String.valueOf(res.getComponentId()) + "\"");
                } else {
                    LOG.debug("NITOS flex:e_node_b HACK: non e_node_b urn: \"" + comIdAtt.getValue() + "\"");
                    res.setComponentId(comIdAtt.getValue());
                }
            } else {
                LOG.debug("NITOS flex:e_node_b HACK: no urn: (\"" + comIdAtt.getValue() + "\")");
                res.setComponentId(comIdAtt.getValue());
            }
        } else {
            LOG.debug("NITOS flex:e_node_b HACK: comIdAtt == null");
        }
        if (exclusiveAtt != null) {
            res.setExclusive(TextUtil.stringToBoolean((String)exclusiveAtt.getValue()));
        }
        if (sliverIdAtt != null) {
            res.setSliverId(sliverIdAtt.getValue());
        }
        if (conNameAtt != null) {
            res.setComponentName(conNameAtt.getValue());
        }
        res.getHardwareTypes().add(new HardwareType("e_node_b"));
        while (eventReader.hasNext()) {
            XMLEvent e = eventReader.nextEvent();
            if (e.isStartElement()) {
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_JFED_LOCATION)) {
                    Attribute attX = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_JFED_LOCATION_X);
                    Attribute attY = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_JFED_LOCATION_Y);
                    if (attX != null) {
                        res.setEditorX(Double.parseDouble(attX.getValue()));
                    }
                    if (attY != null) {
                        res.setEditorY(Double.parseDouble(attY.getValue()));
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_NODE_AVAILABLE)) {
                    Attribute att = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_NODE_AVAILABLE_NOW);
                    if (att != null) {
                        res.setAvailable(TextUtil.stringToBoolean((String)att.getValue()));
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), RspecXmlConstants.Q_LEASE_REF)) {
                    Attribute leaseRefId = e.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_ID_REF);
                    if (leaseRefId != null) {
                        res.addLeaseIdRef(leaseRefId.getValue());
                    }
                    StaxHelper.readAllExpectingNothingMore(e, eventReader);
                    continue;
                }
                EventListExtraXml extraXml = new EventListExtraXml(e.asStartElement(), eventReader);
                res.getExtraXml().add(extraXml);
                continue;
            }
            if (e.isEndElement() && Objects.equals(e.asEndElement().getName(), RspecXmlConstants.Q_NITOS_E_NODE_B)) {
                return this.rspecFactory.convertToSpecialNode(res);
            }
            if (e.isAttribute() || e.isNamespace()) continue;
            if (e.isProcessingInstruction()) {
                // empty if block
            }
            if (e.isCharacters() && e.asCharacters().isWhiteSpace()) continue;
            if (e.isEntityReference()) {
                // empty if block
            }
            if (e.getEventType() != 5) continue;
            res.getExtraXml().add(new SingleElementExtraXml(e));
        }
        throw new RspecParseException(startNodeEvent.getLocation(), "<flex:e_node_b> tag was never closed");
    }

    private void ignorableParseError(Location location, String message) {
        this.ignorableParseError(location, message, null);
    }

    private void ignorableParseError(Location location, String message, Exception e) {
        LOG.error("Ignorable RspecParsingException: " + message + " @ " + RspecParseException.locationToString(location), (Throwable)e);
    }

    public double getTotalWork() {
        return this.totalWork;
    }

    public double getProgress() {
        return this.progress;
    }

    @Override
    public void addProgressHandler(ProgressHandler progressHandler) {
        this.progressHandlers.add(progressHandler);
    }

    @Override
    public void removeProgressHandler(ProgressHandler progressHandler) {
        this.progressHandlers.remove(progressHandler);
    }

    private void updateProgress(long currentProgress, long totalProgress) {
        this.progress = currentProgress;
        this.totalWork = totalProgress;
        for (ProgressHandler progressHandler : this.progressHandlers) {
            progressHandler.onProgressUpdate(currentProgress, totalProgress);
        }
    }

    private static class LinkId {
        private final String clientId;
        private final String compId;
        private final String sliverId;

        public LinkId(String clientId, String compId, String sliverId) {
            this.clientId = clientId;
            this.compId = compId;
            this.sliverId = sliverId;
        }

        public boolean equals(Object o) {
            return this.equals(o, false, false);
        }

        public boolean equals(Object o, boolean ignoreCompId, boolean ignoreSliverId) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LinkId)) {
                return false;
            }
            LinkId linkId = (LinkId)o;
            if (this.clientId != null ? !Objects.equals(this.clientId, linkId.clientId) : linkId.clientId != null) {
                return false;
            }
            if (!ignoreCompId && (this.compId != null ? !Objects.equals(this.compId, linkId.compId) : linkId.compId != null)) {
                return false;
            }
            return ignoreSliverId || !(this.sliverId != null ? !Objects.equals(this.sliverId, linkId.sliverId) : linkId.sliverId != null);
        }

        public int hashCode() {
            int result = this.clientId != null ? this.clientId.hashCode() : 0;
            result = 31 * result + (this.compId != null ? this.compId.hashCode() : 0);
            result = 31 * result + (this.sliverId != null ? this.sliverId.hashCode() : 0);
            return result;
        }

        public String toString() {
            Object res = "LinkId{";
            if (this.clientId != null) {
                res = (String)res + "\"" + this.clientId + "\"";
            }
            if (this.compId != null) {
                res = (String)res + " @ " + this.compId;
            }
            if (this.sliverId != null) {
                res = (String)res + " sliver=" + this.sliverId;
            }
            res = (String)res + "}";
            return res;
        }
    }
}

