/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.rspec_source;

import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecFactoryFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.SliverType;
import be.iminds.ilabt.jfed.rspec.model.StringRspec;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableRspecFactory;
import be.iminds.ilabt.jfed.rspec.parser.RspecCompare;
import be.iminds.ilabt.jfed.rspec.parser.RspecParseException;
import be.iminds.ilabt.jfed.rspec.parser.StaxRspecParser;
import be.iminds.ilabt.jfed.rspec.rspec_source.RspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImmutableRspecSource
implements RspecSource {
    private static final Logger LOG = LoggerFactory.getLogger(ImmutableRspecSource.class);
    protected final Map<ModelRspec.RequestRspecSpecialCases, StringRspec> stringRspecBySpecialCase = new EnumMap<ModelRspec.RequestRspecSpecialCases, StringRspec>(ModelRspec.RequestRspecSpecialCases.class);
    @Nullable
    protected ImmutableModelRspec immutableModelRspec = null;
    protected final boolean isXmlBased;
    @Nonnull
    private final ModelRspecType defaultMutableModelRspecType;
    protected boolean parseFailed = false;
    private RspecParseException lastInvalidRspecException = null;
    private final Map<ModelRspecType, RspecSource.LosingDataInfo> losingDataInfoMap = new HashMap<ModelRspecType, RspecSource.LosingDataInfo>();

    protected ImmutableRspecSource(@Nonnull RspecSource orig) {
        if (orig.isXmlBased()) {
            this.stringRspecBySpecialCase.put(ModelRspec.RequestRspecSpecialCases.NONE, orig.getStringRspec());
            this.isXmlBased = true;
            this.defaultMutableModelRspecType = ModelRspecType.BASIC;
        } else {
            ImmutableModelRspec origModelRspec = orig.getImmutableModelRspec();
            assert (origModelRspec != null);
            this.immutableModelRspec = ImmutableRspecFactory.getInstance().copyModelRspec(origModelRspec, null);
            this.defaultMutableModelRspecType = ModelRspecType.BASIC;
            this.isXmlBased = false;
        }
    }

    protected ImmutableRspecSource(@Nonnull StringRspec stringRspec) {
        this(stringRspec, ModelRspecType.BASIC);
    }

    protected ImmutableRspecSource(@Nonnull StringRspec stringRspec, @Nonnull ModelRspecType defaultMutableModelRspecType) {
        assert (stringRspec != null);
        this.stringRspecBySpecialCase.put(ModelRspec.RequestRspecSpecialCases.NONE, stringRspec);
        this.isXmlBased = true;
        this.defaultMutableModelRspecType = defaultMutableModelRspecType;
    }

    protected ImmutableRspecSource(@Nonnull ModelRspec modelRspec) {
        assert (modelRspec != null);
        this.immutableModelRspec = ImmutableRspecFactory.getInstance().copyModelRspec(modelRspec, null);
        this.defaultMutableModelRspecType = modelRspec.getModelRspecType();
        this.isXmlBased = false;
    }

    public ImmutableRspecSource(@Nonnull String xmlRspecString, @Nonnull ModelRspecType defaultMutableModelRspecType) {
        this(new StringRspec(xmlRspecString), defaultMutableModelRspecType);
    }

    @Override
    public boolean isXmlBased() {
        return this.isXmlBased;
    }

    @Override
    @Nullable
    public String getRspecXmlString() {
        return this.getRspecXmlString(ModelRspec.RequestRspecSpecialCases.NONE);
    }

    @Override
    @Nullable
    public String getRspecXmlString(@Nonnull ModelRspec.RequestRspecSpecialCases rspecSpecialCase) {
        StringRspec stringRspec = this.getStringRspec(rspecSpecialCase);
        if (stringRspec != null) {
            return stringRspec.getXmlString();
        }
        return null;
    }

    @Nonnull
    protected String modelToString(@Nonnull ModelRspec modelRspec, @Nonnull ModelRspec.RequestRspecSpecialCases rspecSpecialCase) {
        assert (modelRspec != null);
        return modelRspec.toGeni3Rspec(rspecSpecialCase);
    }

    @Override
    @Nullable
    public ModelRspec getMutableModelRspec() {
        return this.getModelRspec(this.defaultMutableModelRspecType, null);
    }

    @Override
    @Nullable
    public ImmutableModelRspec getImmutableModelRspec() {
        if (this.immutableModelRspec == null) {
            this.immutableModelRspec = this.getImmutableModelRspec(null);
        }
        return this.immutableModelRspec;
    }

    @Override
    @Nullable
    public ModelRspec getMutableModelRspec(ProgressHandler ... progressHandlers) {
        return this.getModelRspec(this.defaultMutableModelRspecType, progressHandlers);
    }

    @Override
    @Nullable
    public ImmutableModelRspec getImmutableModelRspec(ProgressHandler ... progressHandlers) {
        if (this.immutableModelRspec == null) {
            this.immutableModelRspec = (ImmutableModelRspec)this.getModelRspec(ModelRspecType.IMMUTABLE, null);
        }
        return this.immutableModelRspec;
    }

    @Override
    public boolean isModelRspecAvailable(@Nonnull ModelRspecType modelRspecType) {
        return modelRspecType == ModelRspecType.IMMUTABLE && this.immutableModelRspec != null;
    }

    @Override
    @Nullable
    public <M extends ModelRspec> M getModelRspec(@Nonnull ModelRspecType modelRspecType, ProgressHandler ... progressHandlers) {
        if (this.immutableModelRspec != null && modelRspecType == ModelRspecType.IMMUTABLE) {
            return (M)this.immutableModelRspec;
        }
        if (this.parseFailed) {
            return null;
        }
        if (this.immutableModelRspec != null) {
            return (M)RspecFactoryFactory.getRspecFactoryInstance(modelRspecType).copyModelRspec(this.immutableModelRspec, null);
        }
        try {
            ModelRspec res = this.parseStringToModelRspec(modelRspecType, progressHandlers);
            if (res != null && this.immutableModelRspec == null) {
                assert (res.getModelRspecType() == modelRspecType);
                this.immutableModelRspec = modelRspecType == ModelRspecType.IMMUTABLE ? (ImmutableModelRspec)res : ImmutableRspecFactory.getInstance().copyModelRspec(res, null);
                assert (this.immutableModelRspec.getModelRspecType() == ModelRspecType.IMMUTABLE);
            }
            return (M)res;
        }
        catch (RspecParseException e) {
            this.lastInvalidRspecException = e;
            LOG.warn("RSpec String parse failed. Will not return ModelRspec", (Throwable)e);
            this.parseFailed = true;
            return null;
        }
    }

    @Nullable
    private ModelRspec parseStringToModelRspec(@Nonnull ModelRspecType modelRspecType, ProgressHandler ... progressHandlers) throws RspecParseException {
        ModelRspec res;
        StringRspec stringRspec = this.stringRspecBySpecialCase.containsKey((Object)ModelRspec.RequestRspecSpecialCases.NONE) ? this.stringRspecBySpecialCase.get((Object)ModelRspec.RequestRspecSpecialCases.NONE) : (!this.stringRspecBySpecialCase.isEmpty() ? this.stringRspecBySpecialCase.get((Object)this.stringRspecBySpecialCase.keySet().iterator().next()) : this.getStringRspec());
        if (stringRspec == null) {
            return null;
        }
        String xmlString = stringRspec.getXmlString();
        if (xmlString.contains("<RSpec")) {
            LOG.debug("HACK: rewriting received planetlab manifest XML to make it parsable xml");
            xmlString = xmlString.replace("<RSpec type=\"SFA\"", "<rspec xmlns=\"http://www.geni.net/resources/rspec/3\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" type=\"manifest\"");
            xmlString = xmlString.replace("<RSpec ", "<rspec xmlns=\"http://www.geni.net/resources/rspec/3\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" type=\"manifest\"");
            xmlString = xmlString.replace("</RSpec>", "</rspec>");
            xmlString = xmlString.replace("<network name=\"ple\">", "");
            xmlString = xmlString.replace("</network>", "");
            LOG.debug("HACK: rewritten xml: " + xmlString);
        }
        RspecFactory factory = RspecFactoryFactory.getRspecFactoryInstance(modelRspecType);
        assert (factory.getModelRspecType() == modelRspecType);
        if (modelRspecType == ModelRspecType.IMMUTABLE) {
            factory = RspecFactoryFactory.getRspecFactoryInstance(ModelRspecType.BASIC);
        }
        StaxRspecParser parser = new StaxRspecParser(xmlString, factory);
        if (progressHandlers != null) {
            for (ProgressHandler handler : progressHandlers) {
                if (handler == null) continue;
                parser.addProgressHandler(handler);
            }
        }
        if ((res = parser.call()) != null && modelRspecType == ModelRspecType.IMMUTABLE) {
            res = RspecFactoryFactory.getRspecFactoryInstance(ModelRspecType.IMMUTABLE).copyModelRspec(res, null);
        }
        return res;
    }

    @Override
    @Nullable
    public RspecParseException getLastInvalidRspecException() {
        return this.lastInvalidRspecException;
    }

    @Override
    @Nullable
    public StringRspec getStringRspec() {
        return this.getStringRspec(ModelRspec.RequestRspecSpecialCases.NONE);
    }

    @Override
    @Nullable
    public StringRspec getStringRspec(@Nonnull ModelRspec.RequestRspecSpecialCases rspecSpecialCase) {
        if (this.stringRspecBySpecialCase.containsKey((Object)rspecSpecialCase)) {
            return this.stringRspecBySpecialCase.get((Object)rspecSpecialCase);
        }
        ImmutableModelRspec modelRspec = this.getImmutableModelRspec();
        if (modelRspec == null) {
            return null;
        }
        String rspecXml = this.modelToString(modelRspec, rspecSpecialCase);
        StringRspec stringRspec = new StringRspec(rspecXml);
        this.stringRspecBySpecialCase.put(rspecSpecialCase, stringRspec);
        return stringRspec;
    }

    @Override
    @Nonnull
    public List<GeniUrn> getAllComponentManagerUrns() {
        ImmutableModelRspec model = this.getImmutableModelRspec();
        if (model != null) {
            List<GeniUrn> res = model.getAllComponentManagerUrns();
            StringRspec stringRspec = this.getStringRspec();
            if (stringRspec == null) {
                return Collections.emptyList();
            }
            assert (stringRspec.isWellFormed());
            for (String urnString : StringRspec.parseOpenflowComponentManagers((String)stringRspec.getXmlString())) {
                GeniUrn geniUrn = GeniUrn.parse((String)urnString);
                if (geniUrn != null) {
                    res.add(geniUrn);
                    continue;
                }
                LOG.warn("Could not parse openflowComponentManager-urn {}", (Object)urnString);
            }
            return res;
        }
        StringRspec stringRspec = this.getStringRspec();
        if (stringRspec != null && stringRspec.isWellFormed()) {
            ArrayList<GeniUrn> res = new ArrayList<GeniUrn>();
            for (String urnString : stringRspec.getAllComponentManagerUrns()) {
                GeniUrn geniUrn = GeniUrn.parse((String)urnString);
                if (geniUrn != null) {
                    res.add(geniUrn);
                    continue;
                }
                LOG.warn("Could not parse openflowComponentManager-urn {}", (Object)urnString);
            }
            return res;
        }
        return Collections.emptyList();
    }

    @Override
    public List<BasicStringRspec.BasicNodeInfo> getBasicNodeInfo() {
        ImmutableModelRspec model = this.getImmutableModelRspec();
        if (model != null) {
            ArrayList<BasicStringRspec.BasicNodeInfo> res = new ArrayList<BasicStringRspec.BasicNodeInfo>();
            List<? extends RspecNode> modelNodes = model.getNodes();
            for (RspecNode rspecNode : modelNodes) {
                ArrayList<String> sliverTypeNames = new ArrayList<String>();
                for (SliverType sliverType : rspecNode.getSliverTypes()) {
                    sliverTypeNames.add(sliverType.getName());
                }
                BasicStringRspec.BasicNodeInfo ni = new BasicStringRspec.BasicNodeInfo(rspecNode.getClientId(), rspecNode.getComponentId() == null ? null : rspecNode.getComponentId().toString(), rspecNode.getComponentManagerId() == null ? null : rspecNode.getComponentManagerId().toString(), rspecNode.getAvailable(), rspecNode.getExclusive(), sliverTypeNames, rspecNode.getAnsibleGroups());
                res.add(ni);
            }
            return res;
        }
        StringRspec stringRspec = this.getStringRspec();
        LOG.debug("The RSpec could not be parsed using ModelRspec, will try StringRspec method.");
        if (stringRspec != null && stringRspec.isWellFormed()) {
            return stringRspec.getBasicNodeInfo();
        }
        LOG.warn("The RSpec could not be parsed using any method. Will return null.");
        return null;
    }

    @Nullable
    private RspecSource.LosingDataInfo getLosingDataInfo(ModelRspecType modelRspecType) {
        if (!this.isXmlBased) {
            return null;
        }
        if (!this.losingDataInfoMap.containsKey((Object)modelRspecType)) {
            RspecSource.LosingDataInfo losingDataInfo;
            Object modelRspec = this.getModelRspec(modelRspecType, new ProgressHandler[0]);
            String stringRspec = this.getRspecXmlString();
            if (modelRspec == null || stringRspec == null) {
                return null;
            }
            try {
                RspecCompare compareWithOrig = new RspecCompare(modelRspec.toGeni3Rspec(), stringRspec, "the converted RSpec", "the original RSpec");
                losingDataInfo = new RspecSource.LosingDataInfo(!compareWithOrig.isEqual(), compareWithOrig.getDifferences());
            }
            catch (XMLStreamException ex) {
                LOG.error("Exception while using RspecCompare at end of parse. location=" + RspecParseException.locationToString(ex.getLocation()), (Throwable)ex);
                losingDataInfo = new RspecSource.LosingDataInfo(true, null);
            }
            catch (AssertionError | Exception ex) {
                LOG.error("Exception while using RspecCompare at end of parse. location=unknown", (Throwable)ex);
                losingDataInfo = new RspecSource.LosingDataInfo(true, null);
            }
            this.losingDataInfoMap.put(modelRspecType, losingDataInfo);
        }
        return this.losingDataInfoMap.get((Object)modelRspecType);
    }

    @Override
    public boolean isLosingData(ModelRspecType modelRspecType) {
        RspecSource.LosingDataInfo losingDataInfo = this.getLosingDataInfo(modelRspecType);
        return losingDataInfo != null && losingDataInfo.isLosingData();
    }

    @Override
    public List<RspecCompare.Difference> getLosingDataDifferences(ModelRspecType modelRspecType) {
        RspecSource.LosingDataInfo losingDataInfo = this.getLosingDataInfo(modelRspecType);
        if (losingDataInfo != null) {
            return losingDataInfo.getLosingDataDifferences();
        }
        return null;
    }
}

