/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.rspec_source;

import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.LoginService;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.StringRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.CachingRspecSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ManifestRspecSource
extends CachingRspecSource {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestRspecSource.class);
    public static final Marker JOIN_MANIFEST_RSPEC_MARKER = MarkerFactory.getMarker((String)"joinManifestRspecs");

    public ManifestRspecSource(@Nonnull ManifestRspecSource orig) {
        super(orig);
    }

    public ManifestRspecSource(@Nonnull StringRspec stringRspec) {
        super(stringRspec);
    }

    public ManifestRspecSource(@Nonnull ModelRspec modelRspec) {
        super(modelRspec);
    }

    public ManifestRspecSource(@Nonnull String xmlRspecString, @Nonnull ModelRspecType modelRspecType) {
        super(xmlRspecString, modelRspecType);
    }

    @Override
    @Nonnull
    protected String modelToString(@Nonnull ModelRspec modelRspec, @Nonnull ModelRspec.RequestRspecSpecialCases rspecSpecialCase) {
        return modelRspec.toGeni3Rspec(rspecSpecialCase);
    }

    @Nonnull
    public List<BasicStringRspec.LoginService> getNodeLoginInfo(@Nonnull RspecNode requestNode) {
        List<BasicStringRspec.LoginService> res;
        String nodeId = requestNode.getUniqueId();
        ModelRspec mRSpec = this.getAnyModelRspec();
        if (mRSpec == null) {
            return this.getNodeLoginInfoWithoutModel(requestNode);
        }
        RspecNode manifestRspecNode = mRSpec.getNodeByUniqueId(nodeId);
        if (manifestRspecNode == null) {
            LOG.warn("Could not find node with uniqueId {}. Doing fallback to clientId", (Object)requestNode.getUniqueId());
            manifestRspecNode = mRSpec.getNodeByClientId(requestNode.getClientId());
        }
        if (!(manifestRspecNode != null && manifestRspecNode.getLoginServices().size() != 0 || (res = this.getNodeLoginInfoWithoutModel(requestNode)).isEmpty())) {
            LOG.warn("Possible jFed bug. Could not find login info for RspecNode{id=" + requestNode.getUniqueId() + " clientId=" + requestNode.getClientId() + " compId=" + String.valueOf(requestNode.getComponentId()) + " compManId=" + String.valueOf(requestNode.getComponentManagerId()) + "} but did find it using BasicStringRspec#findNodeLoginInfo: " + String.valueOf(res) + "  rspec=" + this.getRspecXmlString());
            return res;
        }
        if (manifestRspecNode == null || manifestRspecNode.getLoginServices().size() == 0) {
            return Collections.emptyList();
        }
        res = new ArrayList<BasicStringRspec.LoginService>();
        for (LoginService rspecLoginService : manifestRspecNode.getLoginServices()) {
            BasicStringRspec.LoginService ls = new BasicStringRspec.LoginService(rspecLoginService.getAuthentication(), rspecLoginService.getHostname(), Integer.parseInt(rspecLoginService.getPort()), rspecLoginService.getUsername(), null);
            res.add(ls);
        }
        return res;
    }

    @Nonnull
    public List<BasicStringRspec.LoginService> getNodeLoginInfoWithoutModel(@Nonnull RspecNode requestNode) {
        StringRspec stringRspec = this.getStringRspec();
        return stringRspec == null ? Collections.emptyList() : stringRspec.findNodeLoginInfoByUniqueId(requestNode.getUniqueId());
    }
}

