/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.groovy_dsl.helpers;

import be.iminds.ilabt.jfed.groovy_dsl.DSLEventWriter;
import be.iminds.ilabt.jfed.groovy_dsl.DSLStreamException;
import be.iminds.ilabt.jfed.groovy_dsl.events.ClosureEndElement;
import be.iminds.ilabt.jfed.groovy_dsl.events.ClosureStartElement;
import be.iminds.ilabt.jfed.groovy_dsl.events.DSLEvent;
import be.iminds.ilabt.jfed.groovy_dsl.helpers.DSLEventWriterDelegate;
import be.iminds.ilabt.jfed.groovy_dsl.impl.events.DSLEventImpl;
import java.io.IOException;
import java.io.Writer;

public class IndentingDSLEventWriter
extends DSLEventWriterDelegate {
    private int currentDepth = 0;

    public IndentingDSLEventWriter(DSLEventWriter out) {
        super(out);
    }

    @Override
    public void add(DSLEvent event) throws DSLStreamException {
        if (event instanceof ClosureEndElement) {
            --this.currentDepth;
        }
        StringBuilder spaces = new StringBuilder("");
        for (int i = 0; i < this.currentDepth; ++i) {
            spaces.append("\t");
        }
        super.add(new CharactersEvent(spaces.toString()));
        super.add(event);
        if (event instanceof ClosureStartElement) {
            ++this.currentDepth;
        }
    }

    private static class CharactersEvent
    extends DSLEventImpl {
        private final String data;

        private CharactersEvent(String data) {
            this.data = data;
        }

        public String getData() {
            return this.data;
        }

        @Override
        public void write(Writer writer) throws DSLStreamException {
            try {
                writer.write(this.data);
            }
            catch (IOException e) {
                throw new DSLStreamException(e);
            }
        }
    }
}

