/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.groovy_dsl.impl.events;

import be.iminds.ilabt.jfed.groovy_dsl.DSLStreamException;
import be.iminds.ilabt.jfed.groovy_dsl.events.FunctionArgument;
import be.iminds.ilabt.jfed.groovy_dsl.events.FunctionCallElement;
import be.iminds.ilabt.jfed.groovy_dsl.impl.events.DSLEventImpl;
import be.iminds.ilabt.jfed.groovy_dsl.impl.events.FunctionArgumentImpl;
import java.io.IOException;
import java.io.Writer;

public class FunctionCallElementImpl
extends DSLEventImpl
implements FunctionCallElement {
    private final String name;
    private final FunctionArgument[] arguments;

    public FunctionCallElementImpl(String name, FunctionArgument ... arguments) {
        this.name = name;
        this.arguments = arguments;
    }

    @Override
    public void write(Writer writer) throws DSLStreamException {
        try {
            writer.write(this.name);
            writer.write(" ");
            for (int i = 0; i < this.arguments.length - 1; ++i) {
                this.writeArgument(this.arguments[i], writer);
                writer.write(", ");
            }
            if (this.arguments.length >= 0) {
                this.writeArgument(this.arguments[this.arguments.length - 1], writer);
            }
            writer.write("\n");
        }
        catch (IOException ex) {
            throw new DSLStreamException(ex);
        }
    }

    private void writeArgument(FunctionArgument argument, Writer writer) throws DSLStreamException {
        assert (argument instanceof FunctionArgumentImpl);
        ((FunctionArgumentImpl)argument).write(writer);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FunctionArgument[] getArguments() {
        return this.arguments;
    }
}

