/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.groovy_dsl.impl.events;

import be.iminds.ilabt.jfed.groovy_dsl.DSLStreamException;
import be.iminds.ilabt.jfed.groovy_dsl.events.PropertyElement;
import be.iminds.ilabt.jfed.groovy_dsl.impl.events.DSLEventImpl;
import java.io.IOException;
import java.io.Writer;

public class NumberPropertyElementImpl
extends DSLEventImpl
implements PropertyElement<Number> {
    private final String name;
    private final Number value;

    public NumberPropertyElementImpl(String name, Number value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public void write(Writer writer) throws DSLStreamException {
        try {
            writer.write(this.name);
            writer.write(" = ");
            if (this.value instanceof Double) {
                writer.write(Double.toString(this.value.doubleValue()));
            }
            if (this.value instanceof Long) {
                writer.write(Long.toString(this.value.longValue()));
            }
            if (this.value instanceof Integer) {
                writer.write(Integer.toString(this.value.intValue()));
            }
            if (this.value instanceof Float) {
                writer.write(Float.toString(this.value.floatValue()));
            }
            if (this.value instanceof Short) {
                writer.write(Short.toString(this.value.shortValue()));
            }
            writer.write("\n");
        }
        catch (IOException e) {
            throw new DSLStreamException(e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Number getValue() {
        return this.value;
    }
}

