/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.gts;

import be.iminds.ilabt.jfed.gts.model.GtsAdjacency;
import be.iminds.ilabt.jfed.gts.model.GtsHost;
import be.iminds.ilabt.jfed.gts.model.GtsLink;
import be.iminds.ilabt.jfed.gts.model.GtsNode;
import be.iminds.ilabt.jfed.gts.model.GtsOfx;
import be.iminds.ilabt.jfed.gts.model.GtsPort;
import be.iminds.ilabt.jfed.gts.model.GtsType;
import be.iminds.ilabt.jfed.gts.model.impl.FXGtsFactory;
import be.iminds.ilabt.jfed.gts.model.impl.FXGtsType;
import be.iminds.ilabt.jfed.gts_reader.GTSBaseListener;
import be.iminds.ilabt.jfed.gts_reader.GTSLexer;
import be.iminds.ilabt.jfed.gts_reader.GTSParser;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtsDslReader
implements Callable<GtsType> {
    private static final Logger LOG = LoggerFactory.getLogger(GtsDslReader.class);
    private final Reader reader;

    public GtsDslReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public GtsType call() throws GtsDslParseException {
        try {
            GTSLexer lexer = new GTSLexer((CharStream)new ANTLRInputStream(this.reader));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            GTSParser parser = new GTSParser((TokenStream)tokens);
            final ArrayList errors = new ArrayList();
            parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

                public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                    errors.add(String.format("Error at [%d,%d]: %s", line, charPositionInLine, msg));
                }
            });
            FXGtsFactory factory = new FXGtsFactory();
            ParseTreeWalker walker = new ParseTreeWalker();
            GtsDslParseListener gtsDslParseListener = new GtsDslParseListener(factory);
            walker.walk((ParseTreeListener)gtsDslParseListener, (ParseTree)parser.composite());
            if (errors.isEmpty()) {
                return gtsDslParseListener.getResult();
            }
            throw new GtsDslParseException(errors.stream().collect(Collectors.joining("\n")));
        }
        catch (IOException e) {
            throw new GtsDslParseException("Unable to read input", e);
        }
    }

    private static class GtsDslParseListener
    extends GTSBaseListener {
        private final FXGtsFactory factory;
        private final Deque<GtsParentNode> parentStack = new LinkedList<GtsParentNode>();
        private GtsType result = null;

        public GtsDslParseListener(FXGtsFactory factory) {
            this.factory = factory;
        }

        @Override
        public void enterPort(@NotNull GTSParser.PortContext ctx) {
            this.parentStack.addFirst(new GtsPortParent(this.factory.createGtsPort()));
        }

        @Override
        public void exitPort(@NotNull GTSParser.PortContext ctx) {
            GtsParentNode firstParent = this.parentStack.pollFirst();
            if (!(firstParent instanceof GtsPortParent)) {
                throw new GtsDslParseException("Expected to find a port, put got a " + firstParent.getClass().getName());
            }
            this.parentStack.peek().registerPort(((GtsPortParent)firstParent).getPort());
        }

        @Override
        public void enterAtomic(@NotNull GTSParser.AtomicContext ctx) {
            switch (ctx.ATOMICTYPE().getText()) {
                case "host": {
                    this.parentStack.addFirst(new GtsNodeParent(this.factory.createGtsHost()));
                    break;
                }
                case "ofx": {
                    this.parentStack.addFirst(new GtsNodeParent(this.factory.createGtsOfx()));
                    break;
                }
                case "ExternalDomain": {
                    this.parentStack.addFirst(new GtsNodeParent(this.factory.createGtsExternalNetwork()));
                    break;
                }
                case "link": {
                    this.parentStack.addFirst(new GtsLinkParent(this.factory.createGtsLink()));
                    break;
                }
                default: {
                    throw new GtsDslParseException("Unexpected atomic type: " + ctx.ATOMICTYPE().getText());
                }
            }
        }

        @Override
        public void exitAtomic(@NotNull GTSParser.AtomicContext ctx) {
            assert (this.parentStack.peek() instanceof GtsNodeParent || this.parentStack.peek() instanceof GtsLinkParent) : "Unexpected type on stack: " + this.parentStack.peek().getClass().getName();
            GtsParentNode atomic = this.parentStack.poll();
            if (atomic instanceof GtsNodeParent) {
                GtsNode node = ((GtsNodeParent)atomic).getNode();
                this.parentStack.peek().registerNode(node);
            } else if (atomic instanceof GtsLinkParent) {
                GtsLink link = ((GtsLinkParent)atomic).getLink();
                this.parentStack.peek().registerLink(link);
            }
        }

        @Override
        public void exitProperty(@NotNull GTSParser.PropertyContext ctx) {
            String id = ctx.id().getText();
            String value = ctx.value().getText();
            if (value.length() > 1 && value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            this.parentStack.peek().registerProperty(id, value);
        }

        @Override
        public void exitAdjacency(@NotNull GTSParser.AdjacencyContext ctx) {
            GTSParser.PortNameContext portName1ctx = ctx.portName(0);
            GTSParser.PortNameContext portName2ctx = ctx.portName(1);
            this.parentStack.peek().registerAdjacency(new GtsType.Adjacency(this.createPortId(portName1ctx), this.createPortId(portName2ctx)));
        }

        private GtsAdjacency.PortId createPortId(GTSParser.PortNameContext ctx) {
            return new GtsAdjacency.PortId(ctx.hostId() != null ? ctx.hostId().getText() : null, ctx.portId().getText());
        }

        @Override
        public void enterComposite(@NotNull GTSParser.CompositeContext ctx) {
            String typeName = ctx.ID().getText();
            FXGtsType type = this.factory.createGtsType(typeName);
            type.setDefinition(ctx.COMPOSITE_DEFINITION() != null);
            this.parentStack.addFirst(new GtsTypeParent(type));
        }

        @Override
        public void exitComposite(GTSParser.CompositeContext ctx) {
            GtsParentNode firstParent = this.parentStack.pollFirst();
            if (!(firstParent instanceof GtsTypeParent)) {
                throw new GtsDslParseException("Expected to find a type, put got a " + firstParent.getClass().getName());
            }
            if (this.parentStack.isEmpty()) {
                this.result = ((GtsTypeParent)firstParent).getType();
            } else {
                this.parentStack.peek().registerType(((GtsTypeParent)firstParent).getType());
            }
        }

        public GtsType getResult() {
            return this.result;
        }

        private static class GtsPortParent
        implements GtsParentNode {
            private final GtsPort port;

            private GtsPortParent(GtsPort port) {
                this.port = port;
            }

            public GtsPort getPort() {
                return this.port;
            }

            @Override
            public void registerPort(GtsPort port) throws GtsDslParseException {
                throw new GtsDslParseException("Port cannot have a child port!");
            }

            @Override
            public void registerNode(GtsNode node) throws GtsDslParseException {
                throw new GtsDslParseException("Port cannot have a child node type");
            }

            @Override
            public void registerLink(GtsLink link) throws GtsDslParseException {
                throw new GtsDslParseException("Port cannot have a child link type");
            }

            @Override
            public void registerProperty(String name, String value) throws GtsDslParseException {
                switch (name) {
                    case "id": {
                        this.port.setId(value);
                        break;
                    }
                    case "mode": {
                        this.port.setMode(value);
                        break;
                    }
                    case "directionality": {
                        this.port.setDirectionality(value);
                        break;
                    }
                    case "lineRate": {
                        try {
                            this.port.setLineRate(Integer.parseInt(value));
                            break;
                        }
                        catch (NumberFormatException ex) {
                            LOG.warn("Could not parse lineRate to integer", (Throwable)ex);
                            throw new GtsDslParseException("Could not parse lineRate to integer", ex);
                        }
                    }
                    case "layoutX": {
                        this.port.setEditorX(Double.parseDouble(value));
                        break;
                    }
                    case "layoutY": {
                        this.port.setEditorY(Double.parseDouble(value));
                        break;
                    }
                    default: {
                        LOG.trace("Unexpected property in port: {}={}", (Object)name, (Object)value);
                        this.port.getExtraProperties().put(name, value);
                    }
                }
            }

            @Override
            public void registerAdjacency(GtsType.Adjacency adjacency) throws GtsDslParseException {
                throw new GtsDslParseException("Port cannot have an adjacency!");
            }

            @Override
            public void registerType(GtsType type) throws GtsDslParseException {
                throw new GtsDslParseException("Port cannot have a child type type");
            }
        }

        private static interface GtsParentNode {
            public void registerPort(GtsPort var1) throws GtsDslParseException;

            public void registerNode(GtsNode var1) throws GtsDslParseException;

            public void registerLink(GtsLink var1) throws GtsDslParseException;

            public void registerProperty(String var1, String var2) throws GtsDslParseException;

            public void registerAdjacency(GtsType.Adjacency var1) throws GtsDslParseException;

            public void registerType(GtsType var1) throws GtsDslParseException;
        }

        private static class GtsNodeParent
        implements GtsParentNode {
            private final GtsNode node;

            private GtsNodeParent(GtsNode node) {
                this.node = node;
            }

            @Override
            public void registerPort(GtsPort port) throws GtsDslParseException {
                this.node.addPort(port);
            }

            @Override
            public void registerNode(GtsNode node) throws GtsDslParseException {
                throw new GtsDslParseException("Node cannot have a child node type!");
            }

            @Override
            public void registerLink(GtsLink link) throws GtsDslParseException {
                throw new GtsDslParseException("Node cannot have a child link type!");
            }

            @Override
            public void registerType(GtsType type) throws GtsDslParseException {
                throw new GtsDslParseException("Node cannot have a child type type");
            }

            @Override
            public void registerProperty(String name, String value) throws GtsDslParseException {
                if (Objects.equals("id", name)) {
                    this.node.setId(value);
                } else if (Objects.equals("location", name)) {
                    this.node.setLocation(value);
                } else if (Objects.equals("layoutX", name)) {
                    this.node.setEditorX(Double.parseDouble(value));
                } else if (Objects.equals("layoutY", name)) {
                    this.node.setEditorY(Double.parseDouble(value));
                } else if (Objects.equals("cpuSpeed", name) && this.node instanceof GtsHost) {
                    ((GtsHost)this.node).setCpuSpeed(Double.parseDouble(value));
                } else if (Objects.equals("image", name) && this.node instanceof GtsHost) {
                    ((GtsHost)this.node).setImage(value);
                } else if (Objects.equals("disk", name) && this.node instanceof GtsHost) {
                    ((GtsHost)this.node).setDisk(Integer.parseInt(value));
                } else if (Objects.equals("controllerIPv4", name) && this.node instanceof GtsOfx) {
                    ((GtsOfx)this.node).setControllerIPv4(value);
                } else if (Objects.equals("controllerPort", name) && this.node instanceof GtsOfx) {
                    ((GtsOfx)this.node).setControllerPort(Integer.parseInt(value));
                } else if (Objects.equals("fabricIPv4", name) && this.node instanceof GtsOfx) {
                    ((GtsOfx)this.node).setFabricIPv4(value);
                } else if (Objects.equals("fabricSubnetMaskv4", name) && this.node instanceof GtsOfx) {
                    ((GtsOfx)this.node).setFabricSubnetmaskv4(value);
                } else {
                    this.node.getExtraProperties().put(name, value);
                }
            }

            @Override
            public void registerAdjacency(GtsType.Adjacency adjacency) throws GtsDslParseException {
                throw new GtsDslParseException("Node cannot have a child adjacency");
            }

            public GtsNode getNode() {
                return this.node;
            }
        }

        private static class GtsLinkParent
        implements GtsParentNode {
            private final GtsLink link;

            private GtsLinkParent(GtsLink link) {
                this.link = link;
            }

            @Override
            public void registerPort(GtsPort port) throws GtsDslParseException {
                this.link.addPort(port);
            }

            @Override
            public void registerNode(GtsNode node) throws GtsDslParseException {
                throw new GtsDslParseException("Link cannot have a child atomic type");
            }

            @Override
            public void registerLink(GtsLink link) throws GtsDslParseException {
                throw new GtsDslParseException("Link cannot have a child link type");
            }

            @Override
            public void registerType(GtsType type) throws GtsDslParseException {
                throw new GtsDslParseException("Link cannot have a child type type");
            }

            @Override
            public void registerProperty(String name, String value) throws GtsDslParseException {
                switch (name) {
                    case "id": {
                        this.link.setId(value);
                        break;
                    }
                    case "capacity": {
                        this.link.setCapacity(Integer.parseInt(value));
                        break;
                    }
                    default: {
                        this.link.getExtraProperties().put(name, value);
                    }
                }
            }

            @Override
            public void registerAdjacency(GtsType.Adjacency adjacency) throws GtsDslParseException {
                throw new GtsDslParseException("Link cannot have a child adjaceny");
            }

            public GtsLink getLink() {
                return this.link;
            }
        }

        private static class GtsTypeParent
        implements GtsParentNode {
            private final GtsType type;

            public GtsTypeParent(GtsType type) {
                this.type = type;
            }

            public GtsType getType() {
                return this.type;
            }

            @Override
            public void registerPort(GtsPort port) throws GtsDslParseException {
                this.type.addPort(port);
            }

            @Override
            public void registerNode(GtsNode node) throws GtsDslParseException {
                this.type.addNode(node);
            }

            @Override
            public void registerLink(GtsLink link) throws GtsDslParseException {
                this.type.addLink(link);
            }

            @Override
            public void registerProperty(String name, String value) throws GtsDslParseException {
                switch (name) {
                    case "description": {
                        this.type.setDescription(value);
                        break;
                    }
                    case "layoutX": {
                        this.type.setEditorX(Double.parseDouble(value));
                        break;
                    }
                    case "layoutY": {
                        this.type.setEditorY(Double.parseDouble(value));
                        break;
                    }
                    default: {
                        this.type.getExtraProperties().put(name, value);
                    }
                }
            }

            @Override
            public void registerAdjacency(GtsType.Adjacency adjacency) throws GtsDslParseException {
                this.type.getAdjacencies().add((Object)adjacency);
            }

            @Override
            public void registerType(GtsType childtype) throws GtsDslParseException {
                this.type.addType(childtype);
            }
        }
    }

    public static class GtsDslParseException
    extends RuntimeException {
        public GtsDslParseException() {
        }

        public GtsDslParseException(String message) {
            super(message);
        }

        public GtsDslParseException(String message, Throwable cause) {
            super(message, cause);
        }

        public GtsDslParseException(Throwable cause) {
            super(cause);
        }

        public GtsDslParseException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

