/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.gts;

import be.iminds.ilabt.jfed.groovy_dsl.DSLEventFactory;
import be.iminds.ilabt.jfed.groovy_dsl.DSLEventWriter;
import be.iminds.ilabt.jfed.groovy_dsl.DSLOutputFactory;
import be.iminds.ilabt.jfed.groovy_dsl.DSLStreamException;
import be.iminds.ilabt.jfed.groovy_dsl.events.ClosureRefArgument;
import be.iminds.ilabt.jfed.groovy_dsl.helpers.IndentingDSLEventWriter;
import be.iminds.ilabt.jfed.groovy_dsl.impl.events.ClosureRefArgumentImpl;
import be.iminds.ilabt.jfed.gts.model.GtsAdjacency;
import be.iminds.ilabt.jfed.gts.model.GtsExternalNetwork;
import be.iminds.ilabt.jfed.gts.model.GtsHost;
import be.iminds.ilabt.jfed.gts.model.GtsLink;
import be.iminds.ilabt.jfed.gts.model.GtsNode;
import be.iminds.ilabt.jfed.gts.model.GtsOfx;
import be.iminds.ilabt.jfed.gts.model.GtsPort;
import be.iminds.ilabt.jfed.gts.model.GtsType;
import java.io.StringWriter;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtsDslWriter
implements Callable<String> {
    private static final Logger LOG = LoggerFactory.getLogger(GtsDslWriter.class);
    private static final String[] LINK_PORT_IDS = new String[]{"src", "dst"};
    private final GtsType model;

    public GtsDslWriter(GtsType model) {
        this.model = model;
    }

    @Override
    public String call() throws DSLStreamException {
        DSLOutputFactory outputFactory = DSLOutputFactory.newInstance();
        StringWriter sw = new StringWriter();
        DSLEventWriter eventWriter = outputFactory.createDSLEventWriter(sw);
        eventWriter = new IndentingDSLEventWriter(eventWriter);
        DSLEventFactory eventFactory = DSLEventFactory.newInstance();
        this.writeType(this.model, eventWriter, eventFactory);
        return sw.toString();
    }

    private void writeType(GtsType model, DSLEventWriter eventWriter, DSLEventFactory eventFactory) throws DSLStreamException {
        eventWriter.add(eventFactory.createClosureStartElement((model.isDefinition() ? "type " : "") + model.getName()));
        if (model.getEditorX() != -1.0 || model.getEditorY() != -1.0) {
            eventWriter.add(eventFactory.createStringPropertyElement("layoutX", Double.toString(model.getEditorX())));
            eventWriter.add(eventFactory.createStringPropertyElement("layoutY", Double.toString(model.getEditorY())));
        }
        for (GtsType gtsType : model.getTypes()) {
            if (!gtsType.isDefinition()) continue;
            this.writeType(gtsType, eventWriter, eventFactory);
        }
        for (GtsType gtsType : model.getTypes()) {
            if (gtsType.isDefinition()) continue;
            this.writeType(gtsType, eventWriter, eventFactory);
        }
        for (GtsNode gtsNode : model.getNodes()) {
            if (gtsNode instanceof GtsPort) {
                this.writePort((GtsPort)((Object)gtsNode), eventWriter, eventFactory);
                continue;
            }
            if (gtsNode instanceof GtsOfx) {
                this.writeOFX((GtsOfx)gtsNode, eventWriter, eventFactory);
                continue;
            }
            if (gtsNode instanceof GtsExternalNetwork) {
                this.writeExternalInterface((GtsExternalNetwork)gtsNode, eventWriter, eventFactory);
                continue;
            }
            this.writeHost((GtsHost)gtsNode, eventWriter, eventFactory);
        }
        for (GtsLink gtsLink : model.getLinks()) {
            eventWriter.add(eventFactory.createClosureStartElement("link"));
            eventWriter.add(eventFactory.createStringPropertyElement("id", gtsLink.getId()));
            if (gtsLink.getCapacity() != null) {
                eventWriter.add(eventFactory.createStringPropertyElement("capacity", gtsLink.getCapacity().toString()));
            }
            for (Map.Entry<String, String> extraProperty : gtsLink.getExtraProperties().entrySet()) {
                eventWriter.add(eventFactory.createStringPropertyElement(extraProperty.getKey(), extraProperty.getValue()));
            }
            for (Map.Entry<String, String> portEntry : gtsLink.getPorts().entrySet()) {
                GtsPort port = (GtsPort)((Object)portEntry.getValue());
                assert (Objects.equals(portEntry.getKey(), port.getId()));
                this.writePort(port, eventWriter, eventFactory);
            }
            eventWriter.add(eventFactory.createClosureEndElement());
        }
        for (GtsPort gtsPort : model.getPorts().values()) {
            this.writePort(gtsPort, eventWriter, eventFactory);
        }
        for (GtsType.Adjacency adjacency : model.getAdjacencies()) {
            eventWriter.add(eventFactory.createFunctionCallElement("adjacency", this.createClosureRefArgumentFromPortId(adjacency.getPortId1()), this.createClosureRefArgumentFromPortId(adjacency.getPortId2())));
        }
        eventWriter.add(eventFactory.createClosureEndElement());
    }

    private ClosureRefArgument createClosureRefArgumentFromPortId(GtsAdjacency.PortId portId) {
        return portId.getParentId() != null ? new ClosureRefArgumentImpl(portId.getParentId(), portId.getPortId()) : new ClosureRefArgumentImpl(portId.getPortId());
    }

    private void writePort(GtsPort port, DSLEventWriter eventWriter, DSLEventFactory eventFactory) throws DSLStreamException {
        eventWriter.add(eventFactory.createClosureStartElement("port"));
        eventWriter.add(eventFactory.createStringPropertyElement("id", port.getId()));
        if (port.getLineRate() != null) {
            eventWriter.add(eventFactory.createStringPropertyElement("lineRate", port.getLineRate().toString()));
        }
        if (port.getDirectionality() != null) {
            eventWriter.add(eventFactory.createStringPropertyElement("directionality", port.getDirectionality()));
        }
        for (Map.Entry<String, String> extraProperty : port.getExtraProperties().entrySet()) {
            eventWriter.add(eventFactory.createStringPropertyElement(extraProperty.getKey(), extraProperty.getValue()));
        }
        if (port.getEditorX() != -1.0) {
            eventWriter.add(eventFactory.createNumberPropertyElement("layoutX", port.getEditorX()));
        }
        if (port.getEditorY() != -1.0) {
            eventWriter.add(eventFactory.createNumberPropertyElement("layoutY", port.getEditorY()));
        }
        eventWriter.add(eventFactory.createClosureEndElement());
    }

    private void writeHost(GtsHost host, DSLEventWriter eventWriter, DSLEventFactory eventFactory) throws DSLStreamException {
        eventWriter.add(eventFactory.createClosureStartElement("host"));
        this.writeNodeContents(host, eventWriter, eventFactory);
        if (host.getCpuSpeed() != null) {
            eventWriter.add(eventFactory.createStringPropertyElement("cpuSpeed", host.getCpuSpeed().toString()));
        }
        if (host.getImage() != null) {
            eventWriter.add(eventFactory.createStringPropertyElement("image", host.getImage()));
        }
        if (host.getDisk() != null) {
            eventWriter.add(eventFactory.createStringPropertyElement("disk", host.getDisk().toString()));
        }
        this.writePorts(host, eventWriter, eventFactory);
        eventWriter.add(eventFactory.createClosureEndElement());
    }

    private void writeNodeContents(GtsNode node, DSLEventWriter eventWriter, DSLEventFactory eventFactory) throws DSLStreamException {
        eventWriter.add(eventFactory.createStringPropertyElement("id", node.getId()));
        if (node.getLocation() != null) {
            eventWriter.add(eventFactory.createStringPropertyElement("location", node.getLocation()));
        }
        if (node.getEditorX() != -1.0) {
            eventWriter.add(eventFactory.createNumberPropertyElement("layoutX", node.getEditorX()));
        }
        if (node.getEditorY() != -1.0) {
            eventWriter.add(eventFactory.createNumberPropertyElement("layoutY", node.getEditorY()));
        }
        for (Map.Entry<String, String> extraProperty : node.getExtraProperties().entrySet()) {
            eventWriter.add(eventFactory.createStringPropertyElement(extraProperty.getKey(), extraProperty.getValue()));
        }
    }

    private void writeOFX(GtsOfx ofx, DSLEventWriter eventWriter, DSLEventFactory eventFactory) throws DSLStreamException {
        eventWriter.add(eventFactory.createClosureStartElement("ofx"));
        this.writeNodeContents(ofx, eventWriter, eventFactory);
        if (ofx.getControllerIPv4() != null) {
            eventWriter.add(eventFactory.createStringPropertyElement("controllerIPv4", ofx.getControllerIPv4()));
        }
        if (ofx.getControllerPort() != null) {
            eventWriter.add(eventFactory.createStringPropertyElement("controllerPort", ofx.getControllerPort().toString()));
        }
        if (ofx.getFabricIPv4() != null) {
            eventWriter.add(eventFactory.createStringPropertyElement("fabricIPv4", ofx.getFabricIPv4()));
        }
        if (ofx.getFabricSubnetmaskv4() != null) {
            eventWriter.add(eventFactory.createStringPropertyElement("fabricSubnetMaskv4", ofx.getFabricSubnetmaskv4()));
        }
        this.writePorts(ofx, eventWriter, eventFactory);
        eventWriter.add(eventFactory.createClosureEndElement());
    }

    private void writeExternalInterface(GtsExternalNetwork externalNetwork, DSLEventWriter eventWriter, DSLEventFactory eventFactory) throws DSLStreamException {
        eventWriter.add(eventFactory.createClosureStartElement("ExternalDomain"));
        this.writeNodeContents(externalNetwork, eventWriter, eventFactory);
        this.writePorts(externalNetwork, eventWriter, eventFactory);
        eventWriter.add(eventFactory.createClosureEndElement());
    }

    private void writePorts(GtsNode node, DSLEventWriter eventWriter, DSLEventFactory eventFactory) throws DSLStreamException {
        for (Map.Entry portEntry : node.getPorts().entrySet()) {
            assert (Objects.equals(portEntry.getKey(), ((GtsPort)portEntry.getValue()).getId()));
            eventWriter.add(eventFactory.createClosureStartElement("port"));
            eventWriter.add(eventFactory.createStringPropertyElement("id", this.convertIfaceNameToPortName(((GtsPort)portEntry.getValue()).getId())));
            eventWriter.add(eventFactory.createClosureEndElement());
        }
    }

    private String convertIfaceNameToPortName(String ifaceName) {
        while (ifaceName.indexOf(58) >= 0) {
            ifaceName = ifaceName.substring(ifaceName.indexOf(58) + 1);
        }
        return ifaceName;
    }
}

