/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.gts.model.impl;

import be.iminds.ilabt.jfed.gts.model.GtsAdjacency;
import be.iminds.ilabt.jfed.gts.model.GtsLink;
import be.iminds.ilabt.jfed.gts.model.GtsNode;
import be.iminds.ilabt.jfed.gts.model.GtsPort;
import be.iminds.ilabt.jfed.gts.model.GtsStatus;
import be.iminds.ilabt.jfed.gts.model.GtsType;
import be.iminds.ilabt.jfed.gts.model.impl.FXGtsLink;
import be.iminds.ilabt.jfed.gts.model.impl.FXGtsNode;
import be.iminds.ilabt.jfed.gts.model.impl.FXGtsPort;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FXGtsType
implements GtsType {
    private static final Logger LOG = LoggerFactory.getLogger(FXGtsType.class);
    private final StringProperty name = new SimpleStringProperty();
    private final StringProperty id = new SimpleStringProperty();
    private final StringProperty description = new SimpleStringProperty();
    private final StringProperty providerId = new SimpleStringProperty();
    private final BooleanProperty definition = new SimpleBooleanProperty();
    private final ObjectProperty<GtsStatus> status = new SimpleObjectProperty();
    private final ObservableMap<String, FXGtsPort> ports = FXCollections.observableHashMap();
    private final ObservableList<FXGtsNode> nodes = FXCollections.observableArrayList();
    private final ObservableList<FXGtsLink> links = FXCollections.observableArrayList();
    private final ObservableList<FXGtsType> types = FXCollections.observableArrayList();
    private final ObservableList<GtsType.Adjacency> adjacencies = FXCollections.observableArrayList();
    private final ObservableMap<String, String> extraProperties = FXCollections.observableHashMap();
    private final DoubleProperty editorX = new SimpleDoubleProperty(-1.0);
    private final DoubleProperty editorY = new SimpleDoubleProperty(-1.0);
    private final ObservableMap<GtsType.Adjacency, AdjacencyInfo> adjacencyInfos;
    private final Map<FXGtsPort, AdjacencyInfo> portToAdjacencyInfo;

    public FXGtsType() {
        this.adjacencies.addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(this::registerAdjacency);
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(this::unregisterAdjacency);
            }
        });
        this.adjacencyInfos = FXCollections.observableHashMap();
        this.portToAdjacencyInfo = new HashMap<FXGtsPort, AdjacencyInfo>();
    }

    public FXGtsType(String name) {
        this.adjacencies.addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(this::registerAdjacency);
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(this::unregisterAdjacency);
            }
        });
        this.adjacencyInfos = FXCollections.observableHashMap();
        this.portToAdjacencyInfo = new HashMap<FXGtsPort, AdjacencyInfo>();
        this.name.set((Object)name);
    }

    @Override
    public String getName() {
        return (String)this.name.get();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name.set((Object)name);
    }

    @Override
    public String getId() {
        return (String)this.id.get();
    }

    public StringProperty idProperty() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id.set((Object)id);
    }

    @Override
    public String getDescription() {
        return (String)this.description.get();
    }

    public StringProperty descriptionProperty() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description.set((Object)description);
    }

    public ObservableMap<String, FXGtsPort> getPorts() {
        return this.ports;
    }

    @Override
    public void setPorts(Map<String, ? extends GtsPort> ports) {
        ports.forEach((id, port) -> this.ports.put(id, (Object)new FXGtsPort((GtsPort)port)));
        this.ports.keySet().retainAll(ports.keySet());
    }

    @Override
    public String getProviderId() {
        return (String)this.providerId.get();
    }

    public StringProperty providerIdProperty() {
        return this.providerId;
    }

    @Override
    public void setProviderId(String providerId) {
        this.providerId.set((Object)providerId);
    }

    @Override
    public GtsStatus getStatus() {
        return (GtsStatus)((Object)this.status.get());
    }

    public ObjectProperty<GtsStatus> statusProperty() {
        return this.status;
    }

    @Override
    public void setStatus(GtsStatus status) {
        this.status.set((Object)status);
    }

    @Override
    public ObservableList<GtsType.Adjacency> getAdjacencies() {
        return this.adjacencies;
    }

    @Override
    public void setAdjacencies(List<GtsType.Adjacency> adjacencies) {
        this.adjacencies.setAll(adjacencies);
    }

    @Override
    public void addPort(GtsPort port) {
        assert (port instanceof FXGtsPort);
        this.ports.put((Object)port.getId(), (Object)((FXGtsPort)port));
    }

    public ObservableList<FXGtsNode> getNodes() {
        return this.nodes;
    }

    @Override
    public void addNode(GtsNode node) {
        assert (node instanceof FXGtsNode);
        this.nodes.add((Object)((FXGtsNode)node));
    }

    public ObservableList<FXGtsLink> getLinks() {
        return this.links;
    }

    @Override
    public void addLink(GtsLink link) {
        assert (link instanceof FXGtsLink);
        this.links.add((Object)((FXGtsLink)link));
    }

    public ObservableList<FXGtsType> getTypes() {
        return this.types;
    }

    @Override
    public void addType(GtsType type) {
        assert (type instanceof FXGtsType);
        this.types.add((Object)((FXGtsType)type));
    }

    public ObservableMap<String, String> getExtraProperties() {
        return this.extraProperties;
    }

    public FXGtsNode getNodeById(String id) {
        return this.nodes.stream().filter(node -> Objects.equals(id, node.getId())).findFirst().orElse(null);
    }

    public FXGtsLink getLinkById(String id) {
        return this.links.stream().filter(link -> Objects.equals(id, link.getId())).findFirst().orElse(null);
    }

    public FXGtsPort getPortById(String id) {
        return (FXGtsPort)this.ports.get((Object)id);
    }

    @Override
    public boolean isDefinition() {
        return this.definition.get();
    }

    public BooleanProperty definitionProperty() {
        return this.definition;
    }

    @Override
    public void setDefinition(boolean definition) {
        this.definition.set(definition);
    }

    private Stream<FXGtsType> getAllTypeStream() {
        return Stream.concat(this.types.stream(), this.types.stream().flatMap(FXGtsType::getAllTypeStream));
    }

    @Override
    public FXGtsType getTypeDefinitionByName(String name) {
        return this.getAllTypeStream().filter(type -> type.isDefinition() && name.equals(type.getName())).findFirst().orElse(null);
    }

    @Override
    public GtsType getTypeInstanceById(String id) {
        return this.types.stream().filter(type -> !type.isDefinition() && id.equals(type.getName())).findFirst().orElse(null);
    }

    public boolean isIdInUse(String id) {
        return this.getNodeById(id) != null || this.getLinkById(id) != null || this.getPortById(id) != null || this.getTypeInstanceById(id) != null;
    }

    public GtsType.Adjacency findAdjacency(String parentName, String portName) {
        GtsAdjacency.PortId portId = new GtsAdjacency.PortId(parentName, portName);
        return this.adjacencies.stream().filter(adj -> adj.getPortId1().equals(portId) || adj.getPortId2().equals(portId)).findFirst().orElse(null);
    }

    public AdjacencyInfo getAdjacencyInfo(GtsType.Adjacency adjacency) {
        return (AdjacencyInfo)this.adjacencyInfos.get((Object)adjacency);
    }

    public AdjacencyInfo getAdjacencyInfo(FXGtsPort port) {
        return this.portToAdjacencyInfo.get(port);
    }

    public ObservableMap<GtsType.Adjacency, AdjacencyInfo> getAdjacencyInfos() {
        return this.adjacencyInfos;
    }

    private void registerAdjacency(GtsType.Adjacency adjacency) {
        Object port1Parent = this.getPortParent(adjacency.getPortId1());
        Object port2Parent = this.getPortParent(adjacency.getPortId2());
        AdjacencyInfo adjacencyInfo = null;
        if (port1Parent instanceof FXGtsNode) {
            FXGtsNode node1 = (FXGtsNode)port1Parent;
            FXGtsPort node1Port = (FXGtsPort)node1.getPorts().get((Object)adjacency.getPortId1().getPortId());
            if (port2Parent instanceof FXGtsPort) {
                adjacencyInfo = new PortsAdjacencyInfo(adjacency, node1, node1Port, (FXGtsPort)port2Parent, true);
            } else if (port2Parent instanceof FXGtsLink) {
                FXGtsLink link2 = (FXGtsLink)port2Parent;
                FXGtsPort link2Port = (FXGtsPort)link2.getPorts().get((Object)adjacency.getPortId2().getPortId());
                adjacencyInfo = new NodeToLinkAdjacencyInfo(adjacency, node1, node1Port, link2, link2Port, true);
            }
        } else if (port1Parent instanceof FXGtsPort) {
            if (port2Parent instanceof FXGtsNode) {
                FXGtsNode node2 = (FXGtsNode)port2Parent;
                FXGtsPort node2Port = (FXGtsPort)node2.getPorts().get((Object)adjacency.getPortId2().getPortId());
                adjacencyInfo = new PortsAdjacencyInfo(adjacency, node2, node2Port, (FXGtsPort)port1Parent, false);
            }
        } else if (port1Parent instanceof FXGtsLink) {
            FXGtsLink link1 = (FXGtsLink)port1Parent;
            FXGtsPort link1Port = (FXGtsPort)link1.getPorts().get((Object)adjacency.getPortId1().getPortId());
            if (port2Parent instanceof FXGtsNode) {
                FXGtsNode node2 = (FXGtsNode)port2Parent;
                FXGtsPort node2Port = (FXGtsPort)node2.getPorts().get((Object)adjacency.getPortId2().getPortId());
                adjacencyInfo = new NodeToLinkAdjacencyInfo(adjacency, node2, node2Port, link1, link1Port, false);
            }
        }
        if (adjacencyInfo == null) {
            LOG.error("Adjacency {} is not valid: could not create a AdjacencyInfo for it", (Object)adjacency);
            return;
        }
        adjacencyInfo.register();
    }

    private void unregisterAdjacency(GtsType.Adjacency adjacency) {
        ((AdjacencyInfo)this.adjacencyInfos.get((Object)adjacency)).unregister();
    }

    private Object getPortParent(GtsAdjacency.PortId portId) {
        if (portId.getParentId() == null) {
            return this.getPorts().get((Object)portId.getPortId());
        }
        FXGtsNode node = this.getNodeById(portId.getParentId());
        if (node != null) {
            if (!node.getPorts().containsKey((Object)portId.getPortId())) {
                LOG.error("Found node with id {}, but it does not have a port called {}", (Object)portId.getParentId(), (Object)portId.getPortId());
                return null;
            }
            return node;
        }
        FXGtsLink link = this.getLinkById(portId.getParentId());
        if (link != null) {
            if (!link.getPorts().containsKey((Object)portId.getPortId())) {
                LOG.error("Found link with id {}, but it does not have a port called {}", (Object)portId.getParentId(), (Object)portId.getPortId());
                return null;
            }
            return link;
        }
        LOG.error("Could not find a node or link with id {}", (Object)portId.getParentId());
        return null;
    }

    @Override
    public double getEditorX() {
        return this.editorX.get();
    }

    public DoubleProperty editorXProperty() {
        return this.editorX;
    }

    @Override
    public void setEditorX(double editorX) {
        this.editorX.set(editorX);
    }

    @Override
    public double getEditorY() {
        return this.editorY.get();
    }

    public DoubleProperty editorYProperty() {
        return this.editorY;
    }

    @Override
    public void setEditorY(double editorY) {
        this.editorY.set(editorY);
    }

    public class AdjacencyInfo {
        private final GtsType.Adjacency adjacency;

        protected AdjacencyInfo(GtsType.Adjacency adjacency) {
            this.adjacency = adjacency;
        }

        public void register() {
            FXGtsType.this.adjacencyInfos.put((Object)this.adjacency, (Object)this);
        }

        public void unregister() {
            FXGtsType.this.adjacencyInfos.remove((Object)this.adjacency);
        }

        public GtsType.Adjacency getAdjacency() {
            return this.adjacency;
        }
    }

    public class PortsAdjacencyInfo
    extends AdjacencyInfo {
        private final FXGtsNode node;
        private final FXGtsPort nodePort;
        private final FXGtsPort standalonePort;
        private final boolean nodeIsPortId1;

        private PortsAdjacencyInfo(GtsType.Adjacency adjacency, FXGtsNode node, FXGtsPort nodePort, FXGtsPort standalonePort, boolean nodeIsPortId1) {
            super(adjacency);
            this.node = node;
            this.nodePort = nodePort;
            this.standalonePort = standalonePort;
            this.nodeIsPortId1 = nodeIsPortId1;
            node.idProperty().addListener(observable -> {
                GtsAdjacency.PortId newPortId = new GtsAdjacency.PortId(node.getId(), nodePort.getId());
                if (nodeIsPortId1) {
                    adjacency.setPortId1(newPortId);
                } else {
                    adjacency.setPortId2(newPortId);
                }
            });
            standalonePort.idProperty().addListener(observable -> {
                GtsAdjacency.PortId newPortId = new GtsAdjacency.PortId(null, standalonePort.getId());
                if (nodeIsPortId1) {
                    adjacency.setPortId2(newPortId);
                } else {
                    adjacency.setPortId1(newPortId);
                }
            });
        }

        public FXGtsNode getNode() {
            return this.node;
        }

        public FXGtsPort getNodePort() {
            return this.nodePort;
        }

        public FXGtsPort getStandalonePort() {
            return this.standalonePort;
        }

        @Override
        public void register() {
            super.register();
            FXGtsType.this.portToAdjacencyInfo.put(this.nodePort, this);
            FXGtsType.this.portToAdjacencyInfo.put(this.standalonePort, this);
        }

        @Override
        public void unregister() {
            super.unregister();
            FXGtsType.this.portToAdjacencyInfo.remove(this.nodePort);
            FXGtsType.this.portToAdjacencyInfo.remove(this.standalonePort);
        }
    }

    public class NodeToLinkAdjacencyInfo
    extends AdjacencyInfo {
        private final FXGtsNode node;
        private final FXGtsPort nodePort;
        private final FXGtsLink link;
        private final FXGtsPort linkPort;
        private final boolean nodeIsPortId1;

        private NodeToLinkAdjacencyInfo(GtsType.Adjacency adjacency, FXGtsNode node, FXGtsPort nodePort, FXGtsLink link, FXGtsPort linkPort, boolean nodeIsPortId1) {
            super(adjacency);
            this.node = node;
            this.nodePort = nodePort;
            this.link = link;
            this.linkPort = linkPort;
            this.nodeIsPortId1 = nodeIsPortId1;
            node.idProperty().addListener(observable -> {
                GtsAdjacency.PortId newPortId = new GtsAdjacency.PortId(node.getId(), nodePort.getId());
                if (nodeIsPortId1) {
                    adjacency.setPortId1(newPortId);
                } else {
                    adjacency.setPortId2(newPortId);
                }
            });
            link.idProperty().addListener(observable -> {
                GtsAdjacency.PortId newPortId = new GtsAdjacency.PortId(link.getId(), linkPort.getId());
                if (nodeIsPortId1) {
                    adjacency.setPortId2(newPortId);
                } else {
                    adjacency.setPortId1(newPortId);
                }
            });
        }

        public FXGtsNode getNode() {
            return this.node;
        }

        public FXGtsPort getNodePort() {
            return this.nodePort;
        }

        public FXGtsLink getLink() {
            return this.link;
        }

        public FXGtsPort getLinkPort() {
            return this.linkPort;
        }

        @Override
        public void register() {
            super.register();
            FXGtsType.this.portToAdjacencyInfo.put(this.nodePort, this);
            FXGtsType.this.portToAdjacencyInfo.put(this.linkPort, this);
        }

        @Override
        public void unregister() {
            super.unregister();
            FXGtsType.this.portToAdjacencyInfo.remove(this.nodePort, this);
            FXGtsType.this.portToAdjacencyInfo.remove(this.linkPort, this);
        }
    }

    public class TypeToLinkAdjacencyInfo
    extends AdjacencyInfo {
        private final FXGtsType type;
        private final FXGtsPort typePort;
        private final FXGtsLink link;
        private final FXGtsPort linkPort;
        private final boolean nodeIsPortId1;

        private TypeToLinkAdjacencyInfo(GtsType.Adjacency adjacency, FXGtsType type, FXGtsPort typePort, FXGtsLink link, FXGtsPort linkPort, boolean typeIsPortId1) {
            super(adjacency);
            this.type = type;
            this.typePort = typePort;
            this.link = link;
            this.linkPort = linkPort;
            this.nodeIsPortId1 = typeIsPortId1;
            type.idProperty().addListener(observable -> {
                GtsAdjacency.PortId newPortId = new GtsAdjacency.PortId(type.getId(), typePort.getId());
                if (typeIsPortId1) {
                    adjacency.setPortId1(newPortId);
                } else {
                    adjacency.setPortId2(newPortId);
                }
            });
            link.idProperty().addListener(observable -> {
                GtsAdjacency.PortId newPortId = new GtsAdjacency.PortId(link.getId(), linkPort.getId());
                if (typeIsPortId1) {
                    adjacency.setPortId2(newPortId);
                } else {
                    adjacency.setPortId1(newPortId);
                }
            });
        }

        public FXGtsType getType() {
            return this.type;
        }

        public FXGtsPort getTypePort() {
            return this.typePort;
        }

        public FXGtsLink getLink() {
            return this.link;
        }

        public FXGtsPort getLinkPort() {
            return this.linkPort;
        }

        @Override
        public void register() {
            super.register();
            FXGtsType.this.portToAdjacencyInfo.put(this.typePort, this);
            FXGtsType.this.portToAdjacencyInfo.put(this.linkPort, this);
        }

        @Override
        public void unregister() {
            super.unregister();
            FXGtsType.this.portToAdjacencyInfo.remove(this.typePort, this);
            FXGtsType.this.portToAdjacencyInfo.remove(this.linkPort, this);
        }
    }
}

