/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FedmonFullObjectLinkDeserializers;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestEmailConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestEmailConfigBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.User;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserBuilder;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkDeserializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkSerializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="testinstance", builderClass=TestInstanceBuilder.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.PRIMARY)
public class TestInstance
extends PrimaryIdObject<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(TestInstance.class);
    private final String name;
    private final TestDefinition testDefinition;
    private final String testVersion;
    private final Boolean enabled;
    private final Frequency frequency;
    private final Map<String, Object> parameters;
    private final Boolean selfTestImmune;
    private final URI resultsUri;
    private final URI graphsUri;

    @JsonCreator
    TestInstance(@JsonProperty(value="id") Integer id, @JsonProperty(value="name") String name, @JsonProperty(value="testDefinition") TestDefinition testDefinition, @JsonProperty(value="testVersion") String testVersion, @JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="frequency") Frequency frequency, @JsonProperty(value="parameters") Map<String, Object> parameters, @JsonProperty(value="selfTestImmune") Boolean selfTestImmune, @JsonProperty(value="@id") URI uri, @JsonProperty(value="results") URI resultsUri, @JsonProperty(value="graphs") URI graphsUri) {
        this(id, name, testDefinition, testVersion, enabled, frequency, parameters, selfTestImmune, uri, resultsUri, graphsUri, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    TestInstance(Integer id, String name, TestDefinition testDefinition, String testVersion, Boolean enabled, Frequency frequency, Map<String, Object> parameters, Boolean selfTestImmune, URI uri, URI resultsUri, URI graphsUri, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super((Object)id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.name = name;
        this.testDefinition = testDefinition;
        this.testVersion = testVersion;
        this.enabled = enabled;
        this.selfTestImmune = selfTestImmune;
        this.frequency = frequency;
        this.resultsUri = resultsUri;
        this.graphsUri = graphsUri;
        if (parameters != null) {
            PrimaryIdObject newO;
            Object type;
            Map oMap;
            Object o;
            HashMap<String, Object> usedParameters = new HashMap<String, Object>(parameters);
            if (usedParameters.containsKey("server")) {
                o = usedParameters.get("server");
                if (!(o instanceof Server)) {
                    if (o instanceof Integer) {
                        Server newO2 = ((ServerBuilder)new ServerBuilder().setId((Integer)o)).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY);
                        usedParameters.put("server", (Object)newO2);
                    } else if (o instanceof Map) {
                        oMap = (Map)o;
                        type = oMap.get("@type");
                        Object serverUri = oMap.get("@id");
                        Object serverId = oMap.get("id");
                        if (type == null || !type.equals("Server") || !(serverId instanceof Integer) || serverUri != null && !(serverUri instanceof String)) {
                            throw new IllegalArgumentException("parameters[\"server\"] must be a Server, not a Map containing: " + o);
                        }
                        usedParameters.put("server", (Object)new ServerBuilder(oMap).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY));
                    } else {
                        if (!(o instanceof String) || !((String)o).startsWith("http")) throw new IllegalArgumentException("parameters[\"server\"] must be a Server, not a " + o.getClass().getName());
                        String serverParamUri = (String)o;
                        try {
                            Integer serverParamId = (Integer)JsonLdObjectLinkDeserializer.uriToId((String)serverParamUri, Integer.class, (String)"server");
                            newO = ((ServerBuilder)((ServerBuilder)new ServerBuilder().setId(serverParamId)).setUri(new URI(serverParamUri))).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY);
                            usedParameters.put("server", newO);
                        }
                        catch (URISyntaxException e) {
                            throw new IllegalArgumentException("parameters[\"server\"] must be a Server, or server URI not the String \"" + serverParamUri + "\"");
                        }
                    }
                } else {
                    usedParameters.put("server", (Object)new ServerBuilder((Server)((Object)o)).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY));
                }
            }
            if (usedParameters.containsKey("email")) {
                o = usedParameters.get("email");
                if (!(o instanceof TestEmailConfig)) {
                    if (!(o instanceof Map)) throw new IllegalArgumentException("parameters[\"testEmailConfig\"] must be a TestEmailConfig, not a " + o.getClass().getName());
                    oMap = (Map)o;
                    type = oMap.get("@type");
                    if (type == null || !type.equals("TestEmailConfig")) {
                        throw new IllegalArgumentException("parameters[\"email\"] must be a TestEmailConfig, not a Map containing: " + o);
                    }
                    try {
                        usedParameters.put("email", new TestEmailConfigBuilder(oMap).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY));
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("parameters[\"email\"] is not a valid TestEmailConfig: " + o, e);
                    }
                } else {
                    usedParameters.put("email", new TestEmailConfigBuilder((TestEmailConfig)((Object)o)).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY));
                }
            }
            if (usedParameters.containsKey("user")) {
                o = usedParameters.get("user");
                if (!(o instanceof User)) {
                    if (o instanceof Map) {
                        oMap = (Map)o;
                        type = oMap.get("@type");
                        Object userUri = oMap.get("@id");
                        Object userId = oMap.get("id");
                        Object username = oMap.get("username");
                        if (type == null || !type.equals("User") || !(userId instanceof String) || username != null && !(username instanceof String) || userUri != null && !(userUri instanceof String)) {
                            throw new IllegalArgumentException("parameters[\"user\"] must be a User, not a Map containing: " + o);
                        }
                        usedParameters.put("user", (Object)new UserBuilder(oMap).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY));
                    } else {
                        if (!(o instanceof String)) throw new IllegalArgumentException("parameters[\"user\"] must be a User, not a " + o.getClass().getName());
                        String userParamUri = (String)o;
                        if (!userParamUri.startsWith("http")) throw new IllegalArgumentException("parameters[\"user\"] must be a User or a URI String, not the String \"" + o.getClass() + "\"");
                        try {
                            String userParamId = (String)JsonLdObjectLinkDeserializer.uriToId((String)userParamUri, String.class, (String)"user");
                            newO = ((UserBuilder)((UserBuilder)new UserBuilder().setId(userParamId)).setUri(new URI(userParamUri))).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY);
                            usedParameters.put("user", newO);
                        }
                        catch (URISyntaxException e) {
                            throw new IllegalArgumentException("parameters[\"user\"] must be a User, or user URI not the String \"" + userParamUri + "\"");
                        }
                    }
                } else {
                    usedParameters.put("user", (Object)new UserBuilder((User)((Object)o)).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY));
                }
            }
            this.parameters = Collections.unmodifiableMap(usedParameters);
            return;
        } else {
            this.parameters = null;
        }
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public String getTestDefinitionId() {
        return this.testDefinition == null ? null : (String)this.testDefinition.getId();
    }

    @JsonIgnore
    public URI getTestDefinitionUri() {
        return this.testDefinition == null ? null : this.testDefinition.getUri();
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.TestDefinitionDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.ParentLinkSerializer.class)
    public TestDefinition getTestDefinition() {
        return this.testDefinition;
    }

    @JsonProperty
    public String getTestVersion() {
        return this.testVersion;
    }

    @JsonProperty
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty
    public Boolean getSelfTestImmune() {
        return this.selfTestImmune;
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.FrequencyDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedParentLinkSerializer.class)
    Frequency getFrequency() {
        return this.frequency;
    }

    @JsonIgnore
    public Integer getFrequencyId() {
        return this.frequency == null ? null : (Integer)this.frequency.getId();
    }

    @JsonIgnore
    public URI getFrequencyUri() {
        return this.frequency == null ? null : this.frequency.getUri();
    }

    @JsonProperty
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedChildLinkMapSerializer.class)
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @JsonIgnore
    public Map<String, Object> getParametersExceptServerAndUser() {
        HashMap<String, Object> res = new HashMap<String, Object>(this.parameters);
        res.remove("server");
        res.remove("user");
        return res;
    }

    @JsonIgnore
    public String getParametersExceptServerAndUserAsJsonString() {
        ObjectMapper mapper = Jackson.newObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this.getParametersExceptServerAndUser());
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting Result details into JSON", (Throwable)e);
            throw new RuntimeException("Exception converting Result details into JSON");
        }
    }

    @JsonIgnore
    public Server getServerParameter() {
        if (this.parameters == null) {
            return null;
        }
        Object o = this.parameters.get("server");
        if (o == null) {
            return null;
        }
        assert (o instanceof Server);
        return (Server)((Object)o);
    }

    @JsonIgnore
    public TestEmailConfig getEmailParameter() {
        if (this.parameters == null) {
            return null;
        }
        Object o = this.parameters.get("email");
        if (o == null) {
            return null;
        }
        assert (o instanceof TestEmailConfig);
        return (TestEmailConfig)((Object)o);
    }

    @JsonIgnore
    public User getUserParameter() {
        if (this.parameters == null) {
            return null;
        }
        Object o = this.parameters.get("user");
        if (o == null) {
            return null;
        }
        assert (o instanceof User);
        return (User)((Object)o);
    }

    @JsonIgnore
    public Integer getServerIdParameter() {
        if (this.parameters == null) {
            return null;
        }
        Object o = this.parameters.get("server");
        if (o == null) {
            return null;
        }
        assert (o instanceof Server);
        return (Integer)((Server)((Object)o)).getId();
    }

    @JsonIgnore
    public String getUserIdParameter() {
        if (this.parameters == null) {
            return null;
        }
        Object o = this.parameters.get("user");
        if (o == null) {
            return null;
        }
        assert (o instanceof User);
        return (String)((User)((Object)o)).getId();
    }

    @JsonIgnore
    public String getUsernameParameter() {
        if (this.parameters == null) {
            return null;
        }
        Object o = this.parameters.get("user");
        if (o == null) {
            return null;
        }
        assert (o instanceof User);
        return ((User)((Object)o)).getUsername();
    }

    @JsonProperty(value="statistics")
    public URI getStatistics() {
        if (this.uri == null) {
            return null;
        }
        try {
            return new URI(this.uri.toASCIIString().replaceFirst("/testinstance/([0-9]*)$", "/testinstancestatistics/$1"));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unexpected URISyntaxException", e);
        }
    }

    @JsonProperty(value="statistics")
    void setStatistics(URI statistics) {
        if (this.id != null && statistics != null && !statistics.toASCIIString().endsWith("" + this.id)) {
            throw new IllegalArgumentException("statistics must end with id (id=" + this.id + "). (statistics=\"" + statistics.toASCIIString() + "\"");
        }
    }

    @JsonProperty(value="results")
    public URI getResultsUri() {
        return this.resultsUri;
    }

    @JsonProperty(value="graphs")
    public URI getGraphsUri() {
        return this.graphsUri;
    }

    @JsonIgnore
    @Nullable
    public Object getParameter(@Nonnull String name) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(name);
    }

    @JsonIgnore
    @Nullable
    public String getStringParameter(@Nonnull String name) {
        if (name.equals("server")) {
            throw new IllegalArgumentException("server parameter may not be requested with this accessor.");
        }
        if (name.equals("user")) {
            throw new IllegalArgumentException("user parameter may not be requested with this accessor.");
        }
        if (this.parameters == null) {
            return null;
        }
        Object res = this.parameters.get(name);
        if (res == null) {
            return null;
        }
        if (!(res instanceof String)) {
            throw new IllegalStateException("Parameter " + name + " is not a String but a " + res.getClass().getName());
        }
        return (String)res;
    }

    @JsonIgnore
    @Nullable
    public Boolean getBooleanParameter(@Nonnull String name) {
        if (this.parameters == null) {
            return null;
        }
        Object raw = this.parameters.get(name);
        if (raw == null) {
            return null;
        }
        Boolean res = TextUtil.objectToBoolean((Object)raw);
        if (res == null && raw instanceof String) {
            throw new IllegalStateException("Parameter " + name + " is not a Boolean or parsable String but the String \"" + raw + "\"");
        }
        if (res == null) {
            throw new IllegalStateException("Parameter " + name + " is not a Boolean or parsable String but a " + raw.getClass().getName());
        }
        return res;
    }

    @JsonIgnore
    @Nullable
    public Object getParameterOrDefault(@Nonnull String name, @Nullable TestDefinition testDefinition) {
        if (this.parameters == null) {
            return null;
        }
        Object res = this.parameters.get(name);
        if (testDefinition != null && res == null) {
            return testDefinition.getParameterDefault(name);
        }
        return res;
    }

    @JsonIgnore
    @Nullable
    public String getStringParameterOrDefault(@Nonnull String name, @Nullable TestDefinition testDefinition) {
        Object res;
        Object object = res = this.parameters == null ? null : this.parameters.get(name);
        if (res != null && !(res instanceof String)) {
            throw new IllegalStateException("Parameter " + name + " is not a String but a " + res.getClass().getName());
        }
        if (testDefinition != null && res == null) {
            return testDefinition.getStringParameterDefault(name);
        }
        return (String)res;
    }

    @JsonIgnore
    @Nullable
    public Boolean getBooleanParameterOrDefault(@Nonnull String name, @Nullable TestDefinition testDefinition) {
        Object raw;
        Object object = raw = this.parameters == null ? null : this.parameters.get(name);
        if (testDefinition != null && raw == null) {
            raw = testDefinition.getParameterDefault(name);
        }
        if (raw == null) {
            return null;
        }
        Boolean res = TextUtil.objectToBoolean((Object)raw);
        if (res == null && raw instanceof String) {
            throw new IllegalStateException("Parameter " + name + " is not a Boolean or parsable String but the String \"" + raw + "\"");
        }
        if (res == null) {
            throw new IllegalStateException("Parameter " + name + " is not a Boolean or parsable String but a " + raw.getClass().getName());
        }
        return res;
    }

    @JsonIgnore
    @Nullable
    public Integer getIntegerParameterOrDefault(@Nonnull String name, @Nullable TestDefinition testDefinition) {
        Object raw;
        Object object = raw = this.parameters == null ? null : this.parameters.get(name);
        if (testDefinition != null && raw == null) {
            raw = testDefinition.getParameterDefault(name);
        }
        if (raw == null) {
            return null;
        }
        if (raw instanceof Integer) {
            return (Integer)raw;
        }
        if (raw instanceof Long) {
            return ((Long)raw).intValue();
        }
        if (raw instanceof String) {
            try {
                return Integer.parseInt((String)raw);
            }
            catch (NumberFormatException e) {
                LOG.error("Error parsing integer parameter \"" + name + "\": \"" + raw + "\"", (Throwable)e);
                return null;
            }
        }
        throw new IllegalStateException("Parameter " + name + " is not an Integer or parsable String but a " + raw.getClass().getName());
    }

    @JsonIgnore
    @Nullable
    public Long getLongParameterOrDefault(@Nonnull String name, @Nullable TestDefinition testDefinition) {
        Object raw;
        Object object = raw = this.parameters == null ? null : this.parameters.get(name);
        if (testDefinition != null && raw == null) {
            raw = testDefinition.getParameterDefault(name);
        }
        if (raw == null) {
            return null;
        }
        if (raw instanceof Long) {
            return (Long)raw;
        }
        if (raw instanceof Integer) {
            return ((Integer)raw).longValue();
        }
        if (raw instanceof String) {
            try {
                return Long.parseLong((String)raw);
            }
            catch (NumberFormatException e) {
                LOG.error("Error parsing integer parameter \"" + name + "\": \"" + raw + "\"", (Throwable)e);
                return null;
            }
        }
        throw new IllegalStateException("Parameter " + name + " is not an Long or parsable String but a " + raw.getClass().getName());
    }

    @JsonIgnore
    public boolean isSelfTestImmune() {
        if (this.selfTestImmune == null) {
            return false;
        }
        return this.selfTestImmune;
    }

    @JsonIgnore
    public boolean isEnabled() {
        if (this.enabled == null) {
            return false;
        }
        return this.enabled;
    }

    @JsonIgnore
    public boolean isDisabled() {
        if (this.enabled == null) {
            return true;
        }
        return this.enabled == false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TestInstance that = (TestInstance)((Object)o);
        if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) {
            return false;
        }
        if (this.selfTestImmune != null ? !this.selfTestImmune.equals(that.selfTestImmune) : that.selfTestImmune != null) {
            return false;
        }
        if (this.getFrequencyId() != null ? !this.getFrequencyId().equals(that.getFrequencyId()) : that.getFrequencyId() != null) {
            return false;
        }
        if (this.id != null ? !((Integer)this.id).equals(that.id) : that.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        if (this.getTestDefinitionId() != null ? !this.getTestDefinitionId().equals(that.getTestDefinitionId()) : that.getTestDefinitionId() != null) {
            return false;
        }
        if (this.testVersion != null ? !this.testVersion.equals(that.testVersion) : that.testVersion != null) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(that.uri) : that.uri != null) {
            return false;
        }
        if (this.resultsUri != null ? !this.resultsUri.equals(that.resultsUri) : that.resultsUri != null) {
            return false;
        }
        return !(this.graphsUri != null ? !this.graphsUri.equals(that.graphsUri) : that.graphsUri != null);
    }

    public int hashCode() {
        int result = this.uri != null ? this.uri.hashCode() : 0;
        result = 31 * result + (this.id != null ? ((Integer)this.id).hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.resultsUri != null ? this.resultsUri.hashCode() : 0);
        result = 31 * result + (this.graphsUri != null ? this.graphsUri.hashCode() : 0);
        result = 31 * result + (this.getTestDefinitionId() != null ? this.getTestDefinitionId().hashCode() : 0);
        result = 31 * result + (this.testVersion != null ? this.testVersion.hashCode() : 0);
        result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
        result = 31 * result + (this.selfTestImmune != null ? this.selfTestImmune.hashCode() : 0);
        result = 31 * result + (this.getFrequencyId() != null ? this.getFrequencyId().hashCode() : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        return result;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting TestInstance " + this.getId() + " to JSON", (Throwable)e);
            return "Exception converting TestInstance " + this.getId() + " to JSON: " + e.getMessage();
        }
    }
}

