/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api;

import be.iminds.ilabt.jfed.lowlevel.connection.ApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.UnknownResponseCodeException;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetailsWithCodeValueError;
import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.lib.ReplyConverter;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGeniAggregateManager
extends AbstractApi {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGeniAggregateManager.class);

    public AbstractGeniAggregateManager(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull RetrySettings retrySettings, @Nonnull ApiInfo.Api serverType, @Nonnull JFedPreferences jFedPreferences) {
        super(logger, retrySettings, serverType, jFedPreferences);
    }

    protected <T> AggregateManagerReply<T> executeAndLogXmlRpcCommandGeni(@Nullable Map<String, Object> methodParams, @Nonnull SfaConnection con, @Nonnull String methodJavaName, @Nonnull String methodGeniName, @Nonnull List<Object> args, @Nonnull ReplyConverter<T> replyConverter) throws JFedException {
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, methodJavaName, methodGeniName, args, replyConverter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> AggregateManagerReply<T> executeAndLogXmlRpcCommandGeni(@Nullable Map<String, Object> methodParams, @Nonnull SfaConnection con, @Nonnull String methodJavaName, @Nonnull String methodGeniName, @Nonnull List<Object> args, @Nonnull ReplyConverter<T> replyConverter, @Nullable T defaultValue) throws JFedException {
        XMLRPCCallDetailsWithCodeValueError res = this.executeXmlRpcCommandGeni(con, methodGeniName, args, methodParams == null ? Collections.emptyMap() : methodParams);
        Object resultValueObject = res.getResultValueObject();
        AggregateManagerReply<T> r = null;
        try {
            if (resultValueObject != null && !Objects.equals(resultValueObject, 0)) {
                try {
                    r = new AggregateManagerReply<T>(res, replyConverter.convertXMLRPCCall(resultValueObject));
                }
                catch (AssertionError | Exception t) {
                    this.handleErrorProcessingArguments(res, methodJavaName, methodGeniName, con, (Throwable)t);
                    r = null;
                }
            } else {
                r = null;
            }
            if (r == null) {
                r = new AggregateManagerReply<T>(res, defaultValue);
            }
        }
        finally {
            this.log((XMLRPCCallDetails)res, (ApiCallReply)r, methodJavaName, methodGeniName, con, methodParams);
        }
        return r;
    }

    protected void handleErrorProcessingArguments(XMLRPCCallDetailsWithCodeValueError res, String methodJavaName, String methodGeniName, SfaConnection con, Throwable t) throws JFedException {
        if (AbstractGeniAggregateManager.isCallSuccess(res)) {
            this.log((XMLRPCCallDetails)res, null, methodJavaName, methodGeniName, con, null);
            throw new JFedException("Error parsing " + methodGeniName + " reply: " + (t == null ? "null" : t.getMessage()), t, (XMLRPCCallDetails)res);
        }
        LOG.error("Error parsing {} reply: {}", new Object[]{methodGeniName, t.getMessage(), t});
    }

    private static boolean isCallSuccess(XMLRPCCallDetailsWithCodeValueError res) {
        Object resultCode = res.getResultCode();
        if (!(resultCode instanceof Map)) {
            return false;
        }
        Map codeStruct = (Map)res.getResultCode();
        if (codeStruct == null) {
            return false;
        }
        Object geniCode = codeStruct.get("geni_code");
        if (!(geniCode instanceof Integer)) {
            return false;
        }
        try {
            GeniAMResponseCode genicode = GeniAMResponseCode.getByCode((int)((Integer)geniCode));
            return genicode.isSuccess();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Override
    protected boolean isBusyReply(XMLRPCCallDetails res) {
        if (res instanceof XMLRPCCallDetailsWithCodeValueError) {
            XMLRPCCallDetailsWithCodeValueError geniDetails = (XMLRPCCallDetailsWithCodeValueError)res;
            if (geniDetails.getResultCode() == null || !(geniDetails.getResultCode() instanceof Map)) {
                return false;
            }
            Map codeStruct = (Map)geniDetails.getResultCode();
            int code = (Integer)codeStruct.get("geni_code");
            try {
                if (GeniAMResponseCode.getByCode((int)code).isBusy()) {
                    return true;
                }
            }
            catch (UnknownResponseCodeException e) {
                LOG.error("Did not recognise AM response code to determine if it is busy", (Throwable)e);
            }
            if (code == 5 && geniDetails.getResultOutput() != null && geniDetails.getResultOutput().contains("cannot renew for now")) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isPossibleTemporaryErrorReply(XMLRPCCallDetails res) {
        if (res instanceof XMLRPCCallDetailsWithCodeValueError) {
            XMLRPCCallDetailsWithCodeValueError geniDetails = (XMLRPCCallDetailsWithCodeValueError)res;
            if (!(geniDetails.getResultCode() instanceof Map)) {
                return false;
            }
            Map codeStruct = (Map)geniDetails.getResultCode();
            if (codeStruct == null || !codeStruct.containsKey("geni_code")) {
                return false;
            }
            int code = (Integer)codeStruct.get("geni_code");
            if (code == 3 && Objects.equals(geniDetails.getResultOutput().trim(), "Credential owner does not match speaksfor target")) {
                LOG.warn("Received \"Credential owner does not match speaksfor target\" error. Will handle this as \"possible temporary error\" and try again.");
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public abstract AggregateManagerReply<? extends AbstractVersionInfo> getVersion(@Nonnull SfaConnection var1) throws JFedException;

    public static boolean isCommonError(@Nullable AggregateManagerReply reply, @Nonnull CommonAMError amError) {
        if (reply == null) {
            return false;
        }
        String value = reply.getValue() != null && reply.getValue() instanceof String ? (String)reply.getValue() : (reply.getRawValue() != null && reply.getRawValue() instanceof String ? (String)reply.getRawValue() : null);
        return AbstractGeniAggregateManager.isCommonError(reply.getGeniResponseCode() == null ? null : Integer.valueOf(reply.getGeniResponseCode().getCode()), reply.getOutput(), value, amError);
    }

    public static boolean isCommonError(@Nullable Integer code, @Nullable String output, @Nullable String value, @Nonnull CommonAMError amError) {
        Object allText;
        if (code != null) {
            try {
                GeniAMResponseCode geniAMResponseCode = GeniAMResponseCode.getByCode((int)code);
                if (geniAMResponseCode.isSuccess()) {
                    return false;
                }
                if (geniAMResponseCode.isBusy()) {
                    return false;
                }
            }
            catch (UnknownResponseCodeException geniAMResponseCode) {
                // empty catch block
            }
        }
        Object object = allText = output == null ? "" : output;
        if (value != null) {
            allText = (String)allText + " " + value;
        }
        return AbstractGeniAggregateManager.isCommonError((String)allText, amError);
    }

    public static boolean isCommonError(@Nonnull String allText, @Nonnull CommonAMError amError) {
        switch (amError.ordinal()) {
            case 0: {
                return AbstractGeniAggregateManager.isNotEnoughFreeResources(allText);
            }
            case 1: {
                return AbstractGeniAggregateManager.isReservationProblem(allText);
            }
            case 2: {
                return AbstractGeniAggregateManager.isTermsAndConditionsNotAccepted(allText);
            }
        }
        throw new RuntimeException("Implementation error: unsupported CommonAMError");
    }

    private static boolean isNotEnoughFreeResources(@Nonnull String output) {
        if ((output = output.toLowerCase()).contains("no available resources".toLowerCase())) {
            return true;
        }
        if (output.contains("could not map to resources".toLowerCase())) {
            return true;
        }
        if (output.contains("free resources".toLowerCase())) {
            return true;
        }
        if (output.contains("Not enough free routable IP addresses".toLowerCase())) {
            return true;
        }
        if (output.contains("failed to map".toLowerCase())) {
            return true;
        }
        if (output.contains("available resources".toLowerCase())) {
            return true;
        }
        if (output.contains("no possible mapping".toLowerCase())) {
            return true;
        }
        if (output.contains("ERROR: mapper: Unretriable error. Giving up".toLowerCase())) {
            return true;
        }
        if (output.contains("No available physical nodes of type ".toLowerCase())) {
            return true;
        }
        if (output.contains("insufficient resources to fulfill request".toLowerCase())) {
            return true;
        }
        if (output.contains("Not enough resources".toLowerCase())) {
            return true;
        }
        if (output.contains("insufficient resources available".toLowerCase())) {
            return true;
        }
        return output.contains("requested resources were unavailable".toLowerCase());
    }

    private static boolean isTermsAndConditionsNotAccepted(@Nonnull String output) {
        if ((output = output.toLowerCase()).contains("T&C-APPROVAL-MISSING".toLowerCase())) {
            return true;
        }
        if (output.contains("Approval of the Terms & Conditions is required".toLowerCase())) {
            return true;
        }
        if (output.contains("APPROVAL MISSING".toLowerCase())) {
            return true;
        }
        return output.contains("APPROVAL_MISSING".toLowerCase());
    }

    private static boolean isReservationProblem(@Nonnull String output) {
        return (output = output.toLowerCase()).contains("Refused cause ".toLowerCase()) && output.contains(" is pre-reserved.".toLowerCase());
    }

    public static class AggregateManagerReply<T>
    implements SfaApiCallReply<T> {
        @Nonnull
        private final GeniAMResponseCode genicode;
        private final T val;
        private final String output;
        private final Map rawResult;
        private final XMLRPCCallDetailsWithCodeValueError xMLRPCCallDetailsWithCodeValueError;

        public AggregateManagerReply(XMLRPCCallDetailsWithCodeValueError res, T val) {
            GeniAMResponseCode genicode;
            int code;
            this.xMLRPCCallDetailsWithCodeValueError = res;
            this.rawResult = res.getResult();
            Map r = res.getResult();
            Map codeStruct = (Map)res.getResultCode();
            if (codeStruct == null) {
                LOG.error("Failed to parse Geni AM reply code. codeStruct==null");
                code = GeniAMResponseCode.SERVER_REPLY_ERROR.getCode();
            } else {
                Object geniCode = codeStruct.get("geni_code");
                if (geniCode != null) {
                    if (geniCode instanceof Integer) {
                        code = (Integer)geniCode;
                    } else {
                        LOG.error("Failed to parse Geni AM reply code. codeStruct.get(\"geni_code\") is not Integer but a " + codeStruct.getClass().getName());
                        code = GeniAMResponseCode.SERVER_REPLY_ERROR.getCode();
                    }
                } else {
                    LOG.error("Failed to parse Geni AM reply code. codeStruct.get(\"geni_code\")==null");
                    code = GeniAMResponseCode.SERVER_REPLY_ERROR.getCode();
                }
            }
            try {
                genicode = GeniAMResponseCode.getByCode((int)code);
            }
            catch (UnknownResponseCodeException e) {
                LOG.error("Did not recognise response code", (Throwable)e);
                genicode = GeniAMResponseCode.SERVER_REPLY_ERROR;
            }
            this.genicode = genicode;
            String output = null;
            if (r.get("output") != null) {
                output = r.get("output").toString();
                if (r.get("output") instanceof Map && ((Map)r.get("output")).isEmpty()) {
                    output = "";
                }
                if (r.get("output") instanceof Object[] && ((Object[])r.get("output")).length == 0) {
                    output = "";
                }
            }
            this.output = output;
            this.val = val;
        }

        public static boolean isSuccess(XMLRPCCallDetails res) {
            if (res instanceof XMLRPCCallDetailsWithCodeValueError) {
                XMLRPCCallDetailsWithCodeValueError geniDetails = (XMLRPCCallDetailsWithCodeValueError)res;
                Map codeStruct = (Map)geniDetails.getResultCode();
                int code = (Integer)codeStruct.get("geni_code");
                try {
                    return GeniAMResponseCode.getByCode((int)code).isSuccess();
                }
                catch (UnknownResponseCodeException e) {
                    LOG.error("Did not recognise response code when determining success", (Throwable)e);
                    return false;
                }
            }
            return false;
        }

        public int getCode() {
            return this.genicode.getCode();
        }

        @Nonnull
        public GeniAMResponseCode getGeniResponseCode() {
            return this.genicode;
        }

        @Nullable
        public T getValue() {
            return this.val;
        }

        @Nullable
        public String getOutput() {
            return this.output;
        }

        @Nullable
        public XMLRPCCallDetailsWithCodeValueError getXMLRPCCallDetailsWithCodeValueError() {
            return this.xMLRPCCallDetailsWithCodeValueError;
        }

        @Nullable
        public XMLRPCCallDetails getXMLRPCCallDetails() {
            return this.xMLRPCCallDetailsWithCodeValueError;
        }

        @Nullable
        public Map getRawResult() {
            return this.rawResult;
        }

        @Nullable
        public Object getRawValue() {
            if (this.rawResult == null) {
                return null;
            }
            return this.rawResult.get("value");
        }
    }

    public static enum CommonAMError {
        NOT_ENOUGH_FREE_RESOURCES,
        RESERVATION_PROBLEM,
        TERMS_AND_SERVICES_NOT_ACCEPTED;

    }

    public static abstract class AbstractVersionInfo {
        public abstract int getApi();
    }
}

