/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api;

import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi2;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameterType;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationMemberAuthorityApi2
extends AbstractFederationApi2 {
    private static final Logger LOG = LoggerFactory.getLogger(FederationMemberAuthorityApi2.class);
    public static final String TYPE_MEMBER = "MEMBER";
    private static final List<AbstractFederationApi.GetVersionResult.FieldInfo> MINIMUM_MEMBER_FIELDS = Collections.unmodifiableList(Arrays.asList(new AbstractFederationApi.GetVersionResult.FieldInfo("MEMBER", "MEMBER_URN", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URN, true, AbstractFederationApi.GetVersionResult.FieldInfo.Protect.PUBLIC), new AbstractFederationApi.GetVersionResult.FieldInfo("MEMBER", "MEMBER_UID", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.UID, true, AbstractFederationApi.GetVersionResult.FieldInfo.Protect.PUBLIC), new AbstractFederationApi.GetVersionResult.FieldInfo("MEMBER", "MEMBER_FIRSTNAME", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, true, AbstractFederationApi.GetVersionResult.FieldInfo.Protect.IDENTIFYING), new AbstractFederationApi.GetVersionResult.FieldInfo("MEMBER", "MEMBER_LASTNAME", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, true, AbstractFederationApi.GetVersionResult.FieldInfo.Protect.IDENTIFYING), new AbstractFederationApi.GetVersionResult.FieldInfo("MEMBER", "MEMBER_USERNAME", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, true, AbstractFederationApi.GetVersionResult.FieldInfo.Protect.PUBLIC), new AbstractFederationApi.GetVersionResult.FieldInfo("MEMBER", "MEMBER_EMAIL", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, false, AbstractFederationApi.GetVersionResult.FieldInfo.Protect.IDENTIFYING)));
    private static final String TYPE_KEY = "KEY";
    private static final List<AbstractFederationApi.GetVersionResult.FieldInfo> MINIMUM_KEY_FIELDS = Collections.unmodifiableList(Arrays.asList(new AbstractFederationApi.GetVersionResult.FieldInfo("KEY", "KEY_MEMBER", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URN, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("KEY", "KEY_ID", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.NOT_ALLOWED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("KEY", "KEY_TYPE", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("KEY", "KEY_PUBLIC", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.KEY, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("KEY", "KEY_PRIVATE", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.KEY, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.ALLOWED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("KEY", "KEY_DESCRIPTION", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.ALLOWED, true, true)));
    private static final List<String> API_OBJECTS = Collections.unmodifiableList(Arrays.asList("MEMBER", "KEY"));

    public static String getApiName() {
        return "Uniform Federation Member Authority API v2";
    }

    @Override
    @Nonnull
    public String getName() {
        return FederationMemberAuthorityApi2.getApiName();
    }

    public FederationMemberAuthorityApi2(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull RetrySettings retrySettings, @Nonnull JFedPreferences jFedPreferences) {
        super(logger, retrySettings, new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_MA, 2), jFedPreferences);
    }

    public FederationMemberAuthorityApi2(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull JFedPreferences jFedPreferences) {
        this(logger, jFedPreferences.getRetrySettings(), jFedPreferences);
    }

    @Override
    @Nonnull
    public List<AbstractFederationApi.GetVersionResult.FieldInfo> getMinimumFields(String objectName) {
        if (objectName.equalsIgnoreCase(TYPE_MEMBER)) {
            return MINIMUM_MEMBER_FIELDS;
        }
        if (objectName.equalsIgnoreCase(TYPE_KEY)) {
            return MINIMUM_KEY_FIELDS;
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getApiObjects() {
        return API_OBJECTS;
    }

    @Override
    public List<String> getRequiredApiServices() {
        return Collections.singletonList(TYPE_MEMBER);
    }

    @Override
    public List<String> getOptionalApiServices() {
        return Collections.singletonList(TYPE_KEY);
    }

    @ApiMethod(order=1, hint="get_version call: Provide a structure detailing the version information as well as details of accepted options s for CH API calls.", unprotected=true)
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.GetVersionResult> getVersion(@Nonnull SfaConnection con) throws JFedException {
        return this.executeAndLogXmlRpcCommandGeni(null, con, "getVersion", "get_version", new ArrayList<Object>(), resultValueObject -> new AbstractFederationApi.GetVersionResult(resultValueObject, true));
    }

    @ApiMethod(order=2, hint="lookup call: Lookup information about objects matching given criteria", unprotected=true)
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.LookupResult<?>> lookup(@Nonnull SfaConnection con, @ApiMethodParameter(name="type", hint="object type to lookup", guiDefault="MEMBER", parameterType=ApiMethodParameterType.CH_API2_OBJECT_TYPE) @Nonnull String type, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nullable List<AnyCredential> credentialList, @ApiMethodParameter(name="match", required=false, parameterType=ApiMethodParameterType.CH_API2_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="filter", required=false, parameterType=ApiMethodParameterType.CH_API2_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationMemberAuthorityApi2.makeMethodParameters("type", type, "credentialList", credentialList, "match", match, "filter", filter, "extraOptions", extraOptions);
        return this.internalLookup(methodParams, con, "lookup", type, credentialList, match, filter, extraOptions, null, switch (type) {
            case TYPE_KEY -> AbstractFederationApi.MemberKeyInfoList::new;
            case TYPE_MEMBER -> AbstractFederationApi.MemberInfoList::new;
            default -> AbstractFederationApi.HTLookupResult::new;
        });
    }

    @ApiMethod(order=3, hint="update call: Update information about object")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<String> update(@Nonnull SfaConnection con, @ApiMethodParameter(name="type", hint="object type to update", guiDefault="MEMBER", parameterType=ApiMethodParameterType.CH_API2_OBJECT_TYPE) @Nonnull String type, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="urn", parameterType=ApiMethodParameterType.USER_URN) @Nonnull String urn, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API2_FIELDS) @Nonnull Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationMemberAuthorityApi2.makeMethodParameters("type", type, "credentialList", credentialList, "urn", urn, "fields", fields, "extraOptions", extraOptions);
        return this.update_internal(methodParams, con, "update", type, credentialList, urn, null, fields, extraOptions);
    }

    @ApiMethod(order=4, hint="create method")
    public AbstractFederationApi.FederationApiReply<Map<String, Object>> create(@Nonnull SfaConnection con, @ApiMethodParameter(name="type", hint="object type to create", guiDefault="KEY", parameterType=ApiMethodParameterType.CH_API2_OBJECT_TYPE) @Nonnull String type, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API2_FIELDS) @Nonnull Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationMemberAuthorityApi2.makeMethodParameters("type", type, "credentialList", credentialList, "type", type, "fields", fields, "extraOptions", extraOptions);
        return this.create_internal(methodParams, con, "create", type, credentialList, fields, extraOptions, AbstractApi::apiSpecifiesMapStringToObject);
    }

    @ApiMethod(order=5, hint="delete call: delete an OBJECT")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<Boolean> delete(@Nonnull SfaConnection con, @ApiMethodParameter(name="type", hint="object type to delete", guiDefault="KEY", parameterType=ApiMethodParameterType.CH_API2_OBJECT_TYPE) @Nonnull String type, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="urnToDelete", parameterType=ApiMethodParameterType.STRING) @Nonnull String urnToDelete, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationMemberAuthorityApi2.makeMethodParameters("type", type, "credentialList", credentialList, "urnToDelete", urnToDelete, "extraOptions", extraOptions);
        return this.delete_internal(methodParams, con, "delete", type, credentialList, urnToDelete, extraOptions);
    }

    @ApiMethod(order=10, hint="Convenience method for lookup call: Lookup information about members matching given criteria", unprotected=true, convenienceMethodFor="lookup", convenienceMethodObjectType="MEMBER")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.MemberInfoList> lookupMember(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nullable List<AnyCredential> credentialList, @ApiMethodParameter(name="match", required=false, parameterType=ApiMethodParameterType.CH_API2_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="filter", required=false, parameterType=ApiMethodParameterType.CH_API2_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationMemberAuthorityApi2.makeMethodParameters("credentialList", credentialList, "match", match, "filter", filter, "extraOptions", extraOptions);
        return this.internalLookup(methodParams, con, "lookupMember", TYPE_MEMBER, credentialList, match, filter, extraOptions, null, AbstractFederationApi.MemberInfoList::new);
    }

    @ApiMethod(order=11, hint="Convenience method for update call: Update MEMBER information", convenienceMethodFor="update", convenienceMethodObjectType="MEMBER")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<String> updateMember(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="urn", parameterType=ApiMethodParameterType.USER_URN) @Nonnull String urn, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API2_FIELDS) @Nonnull Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationMemberAuthorityApi2.makeMethodParameters("credentialList", credentialList, "urn", urn, "fields", fields, "extraOptions", extraOptions);
        return this.update_internal(methodParams, con, "updateMember", TYPE_MEMBER, credentialList, urn, "member", fields, extraOptions);
    }

    @ApiMethod(order=20, hint="get_credentials call: Provide list of credentials (signed statements) for given member\nThis is member-specific information suitable for passing as credentials in an AM API call for aggregate authorization.")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<List<AnyCredential>> getCredentials(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="memberUrn", parameterType=ApiMethodParameterType.USER_URN) @Nonnull GeniUrn memberUrn, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationMemberAuthorityApi2.makeMethodParameters("credentialList", credentialList, "memberUrn", memberUrn, "extraOptions", extraOptions);
        if (!Objects.equals(memberUrn.getEncodedResourceType(), "user")) {
            LOG.warn("member URN argument to getCredentials is not a valid member urn: \"" + String.valueOf(memberUrn) + "\" (will be used anyway)");
        }
        return this.getCredentials_internal(methodParams, con, "getCredentials", TYPE_MEMBER, credentialList, memberUrn, extraOptions);
    }

    @ApiMethod(order=30, hint="Convenience method for lookup call: Lookup information about KEYs matching given criteria", unprotected=true, convenienceMethodFor="lookup", convenienceMethodObjectType="KEY")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.MemberKeyInfoList> lookupKey(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nullable List<AnyCredential> credentialList, @ApiMethodParameter(name="keyId", parameterType=ApiMethodParameterType.STRING, required=false, guiDefaultOptional=true) @Nullable GeniUrn keyId, @ApiMethodParameter(name="match", required=false, parameterType=ApiMethodParameterType.CH_API2_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="filter", required=false, parameterType=ApiMethodParameterType.CH_API2_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        HashMap<String, Object> matchArg;
        Map<String, Object> methodParams = FederationMemberAuthorityApi2.makeMethodParameters("credentialList", credentialList, "keyId", keyId, "match", match, "filter", filter, "extraOptions", extraOptions);
        HashMap hashMap = matchArg = match == null ? null : new HashMap(match);
        if (keyId != null) {
            if (matchArg == null) {
                matchArg = new HashMap();
            }
            matchArg.put("KEY_ID", keyId.getValue());
        }
        return this.internalLookup(methodParams, con, "lookupKey", TYPE_KEY, credentialList, matchArg, filter, extraOptions, null, AbstractFederationApi.MemberKeyInfoList::new);
    }

    @ApiMethod(order=31, hint="Convenience method for lookup call: Lookup information about KEYs matching given criteria", unprotected=true, convenienceMethodFor="lookup", convenienceMethodObjectType="KEY")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.MemberKeyInfoList> lookupKeyForMember(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nullable List<AnyCredential> credentialList, @ApiMethodParameter(name="memberUrn", parameterType=ApiMethodParameterType.USER_URN, required=false, guiDefaultOptional=true) @Nullable GeniUrn memberUrn, @ApiMethodParameter(name="match", required=false, parameterType=ApiMethodParameterType.CH_API2_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="filter", required=false, parameterType=ApiMethodParameterType.CH_API2_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        HashMap<String, Object> matchArg;
        Map<String, Object> methodParams = FederationMemberAuthorityApi2.makeMethodParameters("credentialList", credentialList, "memberUrn", memberUrn, "match", match, "filter", filter, "extraOptions", extraOptions);
        HashMap hashMap = matchArg = match == null ? null : new HashMap(match);
        if (memberUrn != null) {
            if (matchArg == null) {
                matchArg = new HashMap();
            }
            matchArg.put("KEY_MEMBER", memberUrn.getValue());
        }
        return this.internalLookup(methodParams, con, "lookupKeyForMember", TYPE_KEY, credentialList, matchArg, filter, extraOptions, null, AbstractFederationApi.MemberKeyInfoList::new);
    }

    @ApiMethod(order=32, hint="Convenience method for update call: Update KEY information", convenienceMethodFor="update", convenienceMethodObjectType="KEY")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<String> updateKey(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="id", parameterType=ApiMethodParameterType.USER_URN) @Nonnull String id, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API2_FIELDS) @Nonnull Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationMemberAuthorityApi2.makeMethodParameters("credentialList", credentialList, "id", id, "fields", fields, "extraOptions", extraOptions);
        return this.update_internal(methodParams, con, "updateKey", TYPE_KEY, credentialList, id, null, fields, extraOptions);
    }

    @ApiMethod(order=33, hint="Convenience method for create call: create KEY", convenienceMethodFor="create", convenienceMethodObjectType="KEY")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.MemberKeyInfo> createKey(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="memberUrn", hint="URN of the owner of this key", parameterType=ApiMethodParameterType.USER_URN, required=false, guiDefaultOptional=true) @Nullable GeniUrn memberUrn, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API2_FIELDS) @Nullable Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationMemberAuthorityApi2.makeMethodParameters("credentialList", credentialList, "memberUrn", memberUrn, "fields", fields, "extraOptions", extraOptions);
        if (fields == null) {
            fields = new HashMap<String, String>();
        }
        if (memberUrn != null) {
            if (fields.containsKey("KEY_MEMBER")) {
                String fieldsKeyMember = fields.get("KEY_MEMBER");
                if (Objects.equals(fieldsKeyMember, memberUrn.getValue())) {
                    LOG.warn("Note: you specified both memberUrn and added KEY_MEMBER in fields, for createKey call.They are equal, so no problem. Note that the createKey call only requires one of them.");
                } else {
                    LOG.error("WARNING: you specified both memberUrn and added KEY_MEMBER in fields for createKey call.They are NOT equal! memberUrn='" + String.valueOf(memberUrn) + "' KEY_MEMBER field value='" + fieldsKeyMember + "' Will give preference to memberUrn parameter!");
                }
            }
            fields.put("KEY_MEMBER", memberUrn.getValue());
        }
        return this.create_internal(methodParams, con, "createKey", TYPE_KEY, credentialList, fields, extraOptions, resultValueObject -> new AbstractFederationApi.MemberKeyInfo(FederationMemberAuthorityApi2.apiSpecifiesMapStringToObject(resultValueObject)));
    }

    @ApiMethod(order=34, hint="Convenience method for delete call: delete a KEY", convenienceMethodFor="delete", convenienceMethodObjectType="KEY")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<Boolean> deleteKey(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="keyId", parameterType=ApiMethodParameterType.STRING) @Nonnull String keyId, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationMemberAuthorityApi2.makeMethodParameters("credentialList", credentialList, "keyId", keyId, "extraOptions", extraOptions);
        return this.delete_internal(methodParams, con, "delete", TYPE_KEY, credentialList, keyId, extraOptions);
    }
}

