/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api;

import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi2;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameterType;
import be.iminds.ilabt.jfed.lowlevel.lib.BadReplyGeniException;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationSliceAuthorityApi2
extends AbstractFederationApi2 {
    public static final String TYPE_SLICE = "SLICE";
    public static final String TYPE_PROJECT = "PROJECT";
    public static final String ROLE_MEMBER = "MEMBER";
    protected static final String TYPE_SLIVER_INFO = "SLIVER_INFO";
    protected static final String TYPE_SLICE_RSPEC = "SLICE_RSPEC";
    protected static final String FIELD_SLICE_NAME = "SLICE_NAME";
    protected static final String FIELD_PROJECT_NAME = "PROJECT_NAME";
    protected static final String FIELD_SLIVER_INFO_SLICE_URN = "SLIVER_INFO_SLICE_URN";
    protected static final String FIELD_SLIVER_INFO_URN = "SLIVER_INFO_URN";
    protected static final String FIELD_SLIVER_INFO_AGGREGATE_URN = "SLIVER_INFO_AGGREGATE_URN";
    protected static final String FIELD_SLIVER_INFO_CREATOR_URN = "SLIVER_INFO_CREATOR_URN";
    protected static final String FIELD_SLIVER_INFO_EXPIRATION = "SLIVER_INFO_EXPIRATION";
    protected static final String FIELD_SLIVER_INFO_CREATION = "SLIVER_INFO_CREATION";
    protected static final String FIELD_SLICE_RSPEC_ID = "SLICE_RSPEC_ID";
    protected static final String FIELD_SLICE_RSPEC_SLICE_URN = "SLICE_RSPEC_SLICE_URN";
    protected static final String FIELD_SLICE_RSPEC_AGGREGATE_URN = "SLICE_RSPEC_AGGREGATE_URN";
    protected static final String FIELD_SLICE_RSPEC_CREATOR_URN = "SLICE_RSPEC_CREATOR_URN";
    protected static final String FIELD_SLICE_RSPEC_TYPE = "SLICE_RSPEC_TYPE";
    protected static final String FIELD_SLICE_RSPEC_DELETION = "SLICE_RSPEC_DELETION";
    protected static final String FIELD_SLICE_RSPEC_PROVISION = "SLICE_RSPEC_PROVISION";
    protected static final String FIELD_SLICE_RSPEC_RSPEC = "SLICE_RSPEC_RSPEC";
    protected static final String FIELD_SLICE_RSPEC_METADATA = "SLICE_RSPEC_METADATA";
    private static final Logger LOG = LoggerFactory.getLogger(FederationSliceAuthorityApi2.class);
    private static final List<String> API_OBJECTS = Collections.unmodifiableList(Arrays.asList("SLICE", "PROJECT", "SLIVER_INFO", "SLICE_RSPEC"));
    private static final List<String> OPTIONAL_API_SERVICES = Collections.unmodifiableList(Arrays.asList("PROJECT", "SLICE_MEMBER", "PROJECT_MEMBER", "SLIVER_INFO", "SLICE_RSPEC"));
    private static final List<AbstractFederationApi.GetVersionResult.FieldInfo> MINIMUM_SLICE_FIELDS = Collections.unmodifiableList(Arrays.asList(new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE", "SLICE_URN", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URN, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.NOT_ALLOWED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE", "SLICE_UID", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.UID, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.NOT_ALLOWED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE", "SLICE_CREATION", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.DATETIME, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.NOT_ALLOWED, false, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE", "SLICE_EXPIRATION", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.DATETIME, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.ALLOWED, false, true), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE", "SLICE_EXPIRED", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.BOOLEAN, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.NOT_ALLOWED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE", "SLICE_NAME", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, false, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE", "SLICE_DESCRIPTION", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.ALLOWED, false, true), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE", "SLICE_PROJECT_URN", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URN, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, true, false)));
    private static final List<AbstractFederationApi.GetVersionResult.FieldInfo> MINIMUM_PROJECT_FIELDS = Collections.unmodifiableList(Arrays.asList(new AbstractFederationApi.GetVersionResult.FieldInfo("PROJECT", "PROJECT_URN", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URN, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.NOT_ALLOWED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("PROJECT", "PROJECT_UID", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.UID, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.NOT_ALLOWED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("PROJECT", "PROJECT_CREATION", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.DATETIME, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.NOT_ALLOWED, false, false), new AbstractFederationApi.GetVersionResult.FieldInfo("PROJECT", "PROJECT_EXPIRATION", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.DATETIME, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.ALLOWED, false, true), new AbstractFederationApi.GetVersionResult.FieldInfo("PROJECT", "PROJECT_EXPIRED", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.BOOLEAN, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.NOT_ALLOWED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("PROJECT", "PROJECT_NAME", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, false, false), new AbstractFederationApi.GetVersionResult.FieldInfo("PROJECT", "PROJECT_DESCRIPTION", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.ALLOWED, false, true)));
    private static final List<AbstractFederationApi.GetVersionResult.FieldInfo> MINIMUM_SLIVER_INFO_FIELDS = Collections.unmodifiableList(Arrays.asList(new AbstractFederationApi.GetVersionResult.FieldInfo("SLIVER_INFO", "SLIVER_INFO_SLICE_URN", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URN, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLIVER_INFO", "SLIVER_INFO_URN", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URN, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLIVER_INFO", "SLIVER_INFO_AGGREGATE_URN", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URN, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLIVER_INFO", "SLIVER_INFO_CREATOR_URN", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URN, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLIVER_INFO", "SLIVER_INFO_EXPIRATION", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.DATETIME, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, false, true), new AbstractFederationApi.GetVersionResult.FieldInfo("SLIVER_INFO", "SLIVER_INFO_CREATION", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.DATETIME, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.ALLOWED, false, false)));
    private static final List<AbstractFederationApi.GetVersionResult.FieldInfo> MINIMUM_SLICE_RSPEC_FIELDS = Collections.unmodifiableList(Arrays.asList(new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE_RSPEC", "SLICE_RSPEC_TYPE", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE_RSPEC", "SLICE_RSPEC_SLICE_URN", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URN, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE_RSPEC", "SLICE_RSPEC_AGGREGATE_URN", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URN, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE_RSPEC", "SLICE_RSPEC_CREATOR_URN", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URN, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE_RSPEC", "SLICE_RSPEC_RSPEC", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, false, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE_RSPEC", "SLICE_RSPEC_PROVISION", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.DATETIME, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.ALLOWED, false, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE_RSPEC", "SLICE_RSPEC_DELETION", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.DATETIME, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.ALLOWED, false, true), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE_RSPEC", "SLICE_RSPEC_ID", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.NOT_ALLOWED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE_RSPEC", "SLICE_RSPEC_METADATA", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.NOT_ALLOWED, false, false)));

    public FederationSliceAuthorityApi2(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull RetrySettings retrySettings, @Nonnull JFedPreferences jFedPreferences) {
        super(logger, retrySettings, new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_SA, 2), jFedPreferences);
    }

    public FederationSliceAuthorityApi2(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull JFedPreferences jFedPreferences) {
        this(logger, jFedPreferences.getRetrySettings(), jFedPreferences);
    }

    public static String getApiName() {
        return "Uniform Federation Slice Authority API v2";
    }

    @Nonnull
    private static List<UrnRoleTuple> processUrnRoleTuplesReply(Object resultValueObject, String typeName, String urnKeyName, String roleKeyName) throws BadReplyGeniException {
        List<Map> resDicts = FederationSliceAuthorityApi2.apiSpecifiesListOfT(Map.class, resultValueObject);
        ArrayList<UrnRoleTuple> resList = new ArrayList<UrnRoleTuple>();
        for (Map dict : resDicts) {
            resList.add(new UrnRoleTuple(dict, typeName, urnKeyName, roleKeyName));
        }
        return resList;
    }

    @Override
    @Nonnull
    public String getName() {
        return FederationSliceAuthorityApi2.getApiName();
    }

    @ApiMethod(order=1, hint="get_version call: Provide a structure detailing the version information as well as details of accepted options s for CH API calls.", unprotected=true)
    @Nonnull
    public AbstractFederationApi.FederationApiReply<GetVersionSAResult> getVersion(@Nonnull SfaConnection con) throws JFedException {
        return this.executeAndLogXmlRpcCommandGeni(null, con, "getVersion", "get_version", new ArrayList<Object>(), GetVersionSAResult::new);
    }

    @Override
    @Nonnull
    public List<AbstractFederationApi.GetVersionResult.FieldInfo> getMinimumFields(String objectName) {
        if (objectName.equalsIgnoreCase(TYPE_SLICE)) {
            return MINIMUM_SLICE_FIELDS;
        }
        if (objectName.equalsIgnoreCase(TYPE_PROJECT)) {
            return MINIMUM_PROJECT_FIELDS;
        }
        if (objectName.equalsIgnoreCase(TYPE_SLIVER_INFO)) {
            return MINIMUM_SLIVER_INFO_FIELDS;
        }
        if (objectName.equalsIgnoreCase(TYPE_SLICE_RSPEC)) {
            return MINIMUM_SLICE_RSPEC_FIELDS;
        }
        throw new IllegalArgumentException(objectName + " is invalid");
    }

    @Override
    public List<String> getApiObjects() {
        return API_OBJECTS;
    }

    @Override
    public List<String> getOptionalApiServices() {
        return OPTIONAL_API_SERVICES;
    }

    @Override
    public List<String> getRequiredApiServices() {
        return Collections.singletonList(TYPE_SLICE);
    }

    @ApiMethod(order=2, hint="lookup call: Lookup information about objects matching given criteria", unprotected=true)
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.LookupResult<?>> lookup(@Nonnull SfaConnection con, @ApiMethodParameter(name="type", hint="object type to lookup", guiDefault="SLICE", parameterType=ApiMethodParameterType.CH_API2_OBJECT_TYPE) @Nonnull String type, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="match", required=false, parameterType=ApiMethodParameterType.CH_API2_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="filter", required=false, parameterType=ApiMethodParameterType.CH_API2_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("type", type, "credentialList", credentialList, "match", match, "filter", filter, "extraOptions", extraOptions);
        return this.internalLookup(methodParams, con, "lookup", type, credentialList, match, filter, extraOptions, null, switch (type) {
            case TYPE_SLICE -> AbstractFederationApi.SliceInfoList::new;
            case TYPE_SLIVER_INFO -> AbstractFederationApi.SliverInfoList::new;
            case TYPE_SLICE_RSPEC -> AbstractFederationApi.SliceRspecList::new;
            case TYPE_PROJECT -> AbstractFederationApi.ProjectInfoMap::new;
            default -> AbstractFederationApi.HTLookupResult::new;
        });
    }

    @ApiMethod(order=3, hint="update call: Update information about object")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<String> update(@Nonnull SfaConnection con, @ApiMethodParameter(name="type", hint="object type to update", guiDefault="SLICE", parameterType=ApiMethodParameterType.CH_API2_OBJECT_TYPE) @Nonnull String type, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="urn", parameterType=ApiMethodParameterType.USER_URN) @Nonnull String urn, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API2_FIELDS) @Nonnull Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("type", type, "credentialList", credentialList, "urn", urn, "fields", fields, "extraOptions", extraOptions);
        return this.update_internal(methodParams, con, "update", type, credentialList, urn, null, fields, extraOptions);
    }

    @ApiMethod(order=4, hint="create method")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<?> create(@Nonnull SfaConnection con, @ApiMethodParameter(name="type", hint="object type to create", guiDefault="SLICE", parameterType=ApiMethodParameterType.CH_API2_OBJECT_TYPE) @Nonnull String type, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API2_FIELDS) @Nonnull Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("type", type, "credentialList", credentialList, "type", type, "fields", fields, "extraOptions", extraOptions);
        return this.create_internal(methodParams, con, "create", type, credentialList, fields, extraOptions, switch (type) {
            case TYPE_SLICE -> AbstractFederationApi.SliceInfo::new;
            case TYPE_SLIVER_INFO -> AbstractFederationApi.SliverInfo::new;
            case TYPE_SLICE_RSPEC -> AbstractFederationApi.SliceRspec::new;
            case TYPE_PROJECT -> AbstractFederationApi.ProjectInfo::new;
            default -> AbstractApi::apiSpecifiesMapStringToObject;
        });
    }

    @ApiMethod(order=5, hint="delete call: delete an OBJECT")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<Boolean> delete(@Nonnull SfaConnection con, @ApiMethodParameter(name="type", hint="object type to delete", guiDefault="SLICE", parameterType=ApiMethodParameterType.CH_API2_OBJECT_TYPE) String type, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="urnToDelete", parameterType=ApiMethodParameterType.STRING) @Nonnull String urnToDelete, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("type", type, "credentialList", credentialList, "urnToDelete", urnToDelete, "extraOptions", extraOptions);
        return this.delete_internal(methodParams, con, "delete", type, credentialList, urnToDelete, extraOptions);
    }

    @ApiMethod(order=10, hint="Convenience method for lookup call: Lookup information about SLICEs matching given criteria", unprotected=true, convenienceMethodFor="lookup", convenienceMethodObjectType="SLICE")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliceInfoList> lookupSlice(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="match", required=false, parameterType=ApiMethodParameterType.CH_API2_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="filter", required=false, parameterType=ApiMethodParameterType.CH_API2_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("credentialList", credentialList, "match", match, "filter", filter, "extraOptions", extraOptions);
        return this.internalLookup(methodParams, con, "lookup", TYPE_SLICE, credentialList, match, filter, extraOptions, null, AbstractFederationApi.SliceInfoList::new);
    }

    @ApiMethod(order=11, hint="Convenience method for update call: Update SLICE information", convenienceMethodFor="update", convenienceMethodObjectType="SLICE")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<String> updateSlice(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="sliceUrn", parameterType=ApiMethodParameterType.USER_URN) @Nonnull GeniUrn sliceUrn, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API2_FIELDS) @Nonnull Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("credentialList", credentialList, "sliceUrn", sliceUrn, "fields", fields, "extraOptions", extraOptions);
        return this.update_internal(methodParams, con, "update", TYPE_SLICE, credentialList, sliceUrn.getValue(), "slice", fields, extraOptions);
    }

    @ApiMethod(order=12, hint="Convenience method for create call: create SLICE", convenienceMethodFor="create", convenienceMethodObjectType="SLICE")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliceInfo> createSlice(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="sliceName", parameterType=ApiMethodParameterType.STRING) @Nonnull String sliceName, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API2_FIELDS) @Nonnull Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("credentialList", credentialList, "sliceName", sliceName, "fields", fields, "extraOptions", extraOptions);
        HashMap<String, String> allFields = new HashMap<String, String>(fields);
        assert (!allFields.containsKey(FIELD_SLICE_NAME)) : "Add SLICE_NAME with the sliceName option, not directly in the \"fields\" argument";
        allFields.put(FIELD_SLICE_NAME, sliceName);
        return this.create_internal(methodParams, con, "createSlice", TYPE_SLICE, credentialList, allFields, extraOptions, AbstractFederationApi.SliceInfo::new);
    }

    @ApiMethod(order=15, hint="get_credentials call: Provide list of credentials (signed statements) for given slice")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<List<AnyCredential>> getSliceCredentials(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="sliceUrn", parameterType=ApiMethodParameterType.SLICE_URN) @Nonnull GeniUrn sliceUrn, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("credentialList", credentialList, "sliceUrn", sliceUrn, "extraOptions", extraOptions);
        if (!Objects.equals(sliceUrn.getEncodedResourceType(), "slice")) {
            LOG.warn("slice URN argument to getCredentials is not a valid slice urn: \"" + String.valueOf(sliceUrn) + "\" (will be used anyway)");
        }
        return this.getCredentials_internal(methodParams, con, "getSliceCredentials", TYPE_SLICE, credentialList, sliceUrn, extraOptions);
    }

    @ApiMethod(order=16, hint="get_credentials call: Provide list of credentials (signed statements) (generic call)")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<List<AnyCredential>> getCredentials(@Nonnull SfaConnection con, @ApiMethodParameter(name="objectTypeName", parameterType=ApiMethodParameterType.STRING) @Nonnull String objectTypeName, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="urn", parameterType=ApiMethodParameterType.URN) @Nonnull GeniUrn urn, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("objectTypeName", objectTypeName, "credentialList", credentialList, "urn", urn, "extraOptions", extraOptions);
        return this.getCredentials_internal(methodParams, con, "getCredentials", objectTypeName, credentialList, urn, extraOptions);
    }

    @ApiMethod(order=20, hint="Convenience method for lookup call: Lookup information about SLIVER_INFOs matching given criteria", unprotected=true, convenienceMethodFor="lookup", convenienceMethodObjectType="SLIVER_INFO")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliverInfoList> lookupSliverInfo(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="sliceUrn", hint="convenience argument: SLIVER_INFO_SLICE_URN to add to match argument", parameterType=ApiMethodParameterType.SLICE_URN) @Nullable GeniUrn sliceUrn, @ApiMethodParameter(name="match", required=false, parameterType=ApiMethodParameterType.CH_API2_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="filter", required=false, parameterType=ApiMethodParameterType.CH_API2_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        HashMap<String, Object> matchArg;
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("credentialList", credentialList, "sliceUrn", sliceUrn, "match", match, "filter", filter, "extraOptions", extraOptions);
        HashMap hashMap = matchArg = match == null ? null : new HashMap(match);
        if (sliceUrn != null) {
            if (matchArg == null) {
                matchArg = new HashMap();
            }
            matchArg.put(FIELD_SLIVER_INFO_SLICE_URN, sliceUrn.getValue());
        }
        return this.internalLookup(methodParams, con, "lookupSliverInfo", TYPE_SLIVER_INFO, credentialList, matchArg, filter, extraOptions, null, AbstractFederationApi.SliverInfoList::new);
    }

    @ApiMethod(order=21, hint="Convenience method for update call: Update SLIVER_INFO information", convenienceMethodFor="update", convenienceMethodObjectType="SLIVER_INFO")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<String> updateSliverInfo(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="urn", parameterType=ApiMethodParameterType.SLIVER_URN) @Nonnull String urn, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API2_FIELDS) @Nonnull Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("credentialList", credentialList, "urn", urn, "fields", fields, "extraOptions", extraOptions);
        return this.update_internal(methodParams, con, "updateSliverInfo", TYPE_SLIVER_INFO, credentialList, urn, "sliver", fields, extraOptions);
    }

    @ApiMethod(order=22, hint="Convenience method for create call: create SLIVER_INFO", convenienceMethodFor="create", convenienceMethodObjectType="SLIVER_INFO")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliverInfo> createSliverInfo(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="sliceUrn", hint="convenience argument: add (required) SLIVER_INFO_SLICE_URN to fields option", parameterType=ApiMethodParameterType.SLICE_URN, required=false, guiDefaultOptional=true) @Nullable GeniUrn sliceUrn, @ApiMethodParameter(name="sliverUrn", hint="convenience argument: add (required) SLIVER_INFO_URN to fields option", parameterType=ApiMethodParameterType.SLIVER_URN, required=false, guiDefaultOptional=true) @Nullable GeniUrn sliverUrn, @ApiMethodParameter(name="aggregateUrn", hint="convenience argument: add (required) SLIVER_INFO_AGGREGATE_URN to fields option", parameterType=ApiMethodParameterType.AM_URN, required=false, guiDefaultOptional=true) @Nullable GeniUrn aggregateUrn, @ApiMethodParameter(name="creatorUrn", hint="convenience argument: add (required) SLIVER_INFO_CREATOR_URN to fields option", parameterType=ApiMethodParameterType.USER_URN, required=false, guiDefaultOptional=true) @Nullable GeniUrn creatorUrn, @ApiMethodParameter(name="sliverExpirationDate", hint="convenience argument: add (required) SLIVER_INFO_EXPIRATION  to fields option", parameterType=ApiMethodParameterType.DATE, required=false, guiDefaultOptional=true) @Nullable Date sliverExpirationDate, @ApiMethodParameter(name="sliverCreationDate", hint="convenience argument: add (optional) SLIVER_INFO_CREATION  to fields option", parameterType=ApiMethodParameterType.DATE, required=false, guiDefaultOptional=true) @Nullable Date sliverCreationDate, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API2_FIELDS, required=false) @Nullable Map<String, String> fields) throws JFedException {
        HashMap<String, String> allFields;
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("credentialList", credentialList, "sliceUrn", sliceUrn, "sliverUrn", sliverUrn, "aggregateUrn", aggregateUrn, "creatorUrn", creatorUrn, "sliverExpirationDate", sliverExpirationDate, "sliverCreationDate", sliverCreationDate, "fields", fields, "extraOptions", extraOptions);
        HashMap<String, String> hashMap = allFields = fields == null ? new HashMap<String, String>() : new HashMap<String, String>(fields);
        assert (allFields.containsKey(FIELD_SLIVER_INFO_SLICE_URN) == (sliceUrn == null)) : "Either specify sliceUrn (non-null) or add \"SLIVER_INFO_SLICE_URN\" to \"fields\". (exactly 1 is required)";
        assert (allFields.containsKey(FIELD_SLIVER_INFO_URN) == (sliverUrn == null)) : "Either specify sliverUrn (non-null) or add \"SLIVER_INFO_URN\" to \"fields\". (exactly 1 is required)";
        assert (allFields.containsKey(FIELD_SLIVER_INFO_AGGREGATE_URN) == (aggregateUrn == null)) : "Either specify aggregateUrn (non-null) or add \"SLIVER_INFO_AGGREGATE_URN\" to \"fields\". (exactly 1 is required)";
        assert (allFields.containsKey(FIELD_SLIVER_INFO_CREATOR_URN) == (creatorUrn == null)) : "Either specify creatorUrn (non-null) or add \"SLIVER_INFO_CREATOR_URN\" to \"fields\". (exactly 1 is required)";
        assert (allFields.containsKey(FIELD_SLIVER_INFO_EXPIRATION) == (sliverExpirationDate == null)) : "Either specify sliverExpirationDate (non-null) or add \"SLIVER_INFO_EXPIRATION\" to \"fields\". (exactly 1 is required)";
        assert (allFields.containsKey(FIELD_SLIVER_INFO_CREATION) || sliverCreationDate != null) : "Either specify sliverCreationDate (non-null) or add \"SLIVER_INFO_CREATION\" to \"fields\", not both. (only 1 is allowed)";
        if (sliceUrn != null) {
            allFields.put(FIELD_SLIVER_INFO_SLICE_URN, sliceUrn.toString());
        }
        if (sliverUrn != null) {
            allFields.put(FIELD_SLIVER_INFO_URN, sliverUrn.toString());
        }
        if (aggregateUrn != null) {
            allFields.put(FIELD_SLIVER_INFO_AGGREGATE_URN, aggregateUrn.toString());
        }
        if (creatorUrn != null) {
            allFields.put(FIELD_SLIVER_INFO_CREATOR_URN, creatorUrn.toString());
        }
        if (sliverExpirationDate != null) {
            allFields.put(FIELD_SLIVER_INFO_EXPIRATION, RFC3339Util.dateToRFC3339String((Date)sliverExpirationDate));
        }
        if (sliverCreationDate != null) {
            allFields.put(FIELD_SLIVER_INFO_CREATION, RFC3339Util.dateToRFC3339String((Date)sliverCreationDate));
        }
        return this.create_internal(methodParams, con, "createSliverInfo", TYPE_SLIVER_INFO, credentialList, allFields, extraOptions, AbstractFederationApi.SliverInfo::new);
    }

    @ApiMethod(order=23, hint="Convenience method for delete call: delete a SLIVER_INFO", convenienceMethodFor="delete", convenienceMethodObjectType="SLIVER_INFO")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<Boolean> deleteSliverInfo(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="urnToDelete", parameterType=ApiMethodParameterType.SLIVER_URN) @Nonnull String urnToDelete, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("credentialList", credentialList, "urnToDelete", urnToDelete, "extraOptions", extraOptions);
        return this.delete_internal(methodParams, con, "deleteSliverInfo", TYPE_SLIVER_INFO, credentialList, urnToDelete, extraOptions);
    }

    @ApiMethod(order=25, hint="Convenience method for lookup call: Lookup information about SLICE_RSPECs matching given criteria", unprotected=true, convenienceMethodFor="lookup", convenienceMethodObjectType="SLICE_RSPEC")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliceRspecList> lookupSliceRspec(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="sliceUrn", hint="convenience argument: SLICE_RSPEC_SLICE_URN to add to match argument", parameterType=ApiMethodParameterType.SLICE_URN) @Nullable GeniUrn sliceUrn, @ApiMethodParameter(name="match", required=false, parameterType=ApiMethodParameterType.CH_API2_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="filter", required=false, parameterType=ApiMethodParameterType.CH_API2_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        HashMap<String, Object> matchArg;
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("credentialList", credentialList, "sliceUrn", sliceUrn, "match", match, "filter", filter, "extraOptions", extraOptions);
        HashMap hashMap = matchArg = match == null ? null : new HashMap(match);
        if (sliceUrn != null) {
            if (matchArg == null) {
                matchArg = new HashMap();
            }
            matchArg.put(FIELD_SLICE_RSPEC_SLICE_URN, sliceUrn.getValue());
        }
        return this.internalLookup(methodParams, con, "lookupSliceRspec", TYPE_SLICE_RSPEC, credentialList, matchArg, filter, extraOptions, null, AbstractFederationApi.SliceRspecList::new);
    }

    @ApiMethod(order=26, hint="Convenience method for update call: Update SLICE_RSPEC information", convenienceMethodFor="update", convenienceMethodObjectType="SLICE_RSPEC")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<String> updateSliceRspec(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="id", parameterType=ApiMethodParameterType.STRING) @Nonnull String id, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API2_FIELDS) @Nonnull Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("credentialList", credentialList, "urn", id, "fields", fields, "extraOptions", extraOptions);
        return this.update_internal(methodParams, con, "updateSliceRspec", TYPE_SLICE_RSPEC, credentialList, id, "sliver", fields, extraOptions);
    }

    @ApiMethod(order=27, hint="Convenience method for create call: create SLICE_RSPEC", convenienceMethodFor="create", convenienceMethodObjectType="SLICE_RSPEC")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliceRspec> createSliceRspec(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="sliceUrn", hint="convenience argument: add (required) SLICE_RSPEC_SLICE_URN to fields option", parameterType=ApiMethodParameterType.SLICE_URN, required=false, guiDefaultOptional=true) @Nullable GeniUrn sliceUrn, @ApiMethodParameter(name="type", hint="convenience argument: add (required) SLICE_RSPEC_TYPE to fields option", parameterType=ApiMethodParameterType.STRING, required=false, guiDefaultOptional=true) @Nullable String type, @ApiMethodParameter(name="rspec", hint="convenience argument: add (required) SLICE_RSPEC_RSPEC to fields option", parameterType=ApiMethodParameterType.STRING, required=false, guiDefaultOptional=true) @Nullable String rspec, @ApiMethodParameter(name="aggregateUrn", hint="convenience argument: add (required) SLICE_RSPEC_AGGREGATE_URN to fields option", parameterType=ApiMethodParameterType.AM_URN, required=false, guiDefaultOptional=true) @Nullable GeniUrn aggregateUrn, @ApiMethodParameter(name="creatorUrn", hint="convenience argument: add (required) SLICE_RSPEC_CREATOR_URN to fields option", parameterType=ApiMethodParameterType.USER_URN, required=false, guiDefaultOptional=true) @Nullable GeniUrn creatorUrn, @ApiMethodParameter(name="provisionDate", hint="convenience argument: add (required) SLICE_RSPEC_PROVISION  to fields option", parameterType=ApiMethodParameterType.DATE, required=false, guiDefaultOptional=true) @Nullable Date provisionDate, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API2_FIELDS, required=false) @Nullable Map<String, String> fields) throws JFedException {
        HashMap<String, String> allFields;
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("credentialList", credentialList, "sliceUrn", sliceUrn, "rspec", rspec, "aggregateUrn", aggregateUrn, "creatorUrn", creatorUrn, "provisionDate", provisionDate, "fields", fields, "extraOptions", extraOptions);
        HashMap<String, String> hashMap = allFields = fields == null ? new HashMap<String, String>() : new HashMap<String, String>(fields);
        assert (allFields.containsKey(FIELD_SLICE_RSPEC_SLICE_URN) == (sliceUrn == null)) : "Either specify sliceUrn (non-null) or add \"SLICE_RSPEC_SLICE_URN\" to \"fields\". (exactly 1 is required)";
        assert (allFields.containsKey(FIELD_SLICE_RSPEC_RSPEC) == (rspec == null)) : "Either specify rspec (non-null) or add \"FIELD_SLICE_RSPEC_RSPEC\" to \"fields\". (exactly 1 is required)";
        assert (allFields.containsKey(FIELD_SLICE_RSPEC_TYPE) == (type == null)) : "Either specify type (non-null) or add \"FIELD_SLICE_RSPEC_TYPE\" to \"fields\". (exactly 1 is required)";
        assert (!allFields.containsKey(FIELD_SLICE_RSPEC_AGGREGATE_URN) || aggregateUrn == null) : "Either specify aggregateUrn (non-null) or add \"SLICE_RSPEC_AGGREGATE_URN\" to \"fields\". (both at the same time is not allowed)";
        assert (allFields.containsKey(FIELD_SLICE_RSPEC_CREATOR_URN) == (creatorUrn == null)) : "Either specify creatorUrn (non-null) or add \"SLICE_RSPEC_CREATOR_URN\" to \"fields\". (exactly 1 is required)";
        assert (allFields.containsKey(FIELD_SLICE_RSPEC_PROVISION) == (provisionDate == null)) : "Either specify provisionDate (non-null) or add \"FIELD_SLICE_RSPEC_PROVISION\" to \"fields\". (exactly 1 is required)";
        if (sliceUrn != null) {
            allFields.put(FIELD_SLICE_RSPEC_SLICE_URN, sliceUrn.toString());
        }
        if (rspec != null) {
            allFields.put(FIELD_SLICE_RSPEC_RSPEC, rspec);
        }
        if (type != null) {
            allFields.put(FIELD_SLICE_RSPEC_TYPE, type);
        }
        if (aggregateUrn != null) {
            allFields.put(FIELD_SLICE_RSPEC_AGGREGATE_URN, aggregateUrn.toString());
        }
        if (creatorUrn != null) {
            allFields.put(FIELD_SLICE_RSPEC_CREATOR_URN, creatorUrn.toString());
        }
        if (provisionDate != null) {
            allFields.put(FIELD_SLICE_RSPEC_PROVISION, RFC3339Util.dateToRFC3339String((Date)provisionDate));
        }
        return this.create_internal(methodParams, con, "createSliceRspec", TYPE_SLICE_RSPEC, credentialList, allFields, extraOptions, AbstractFederationApi.SliceRspec::new);
    }

    @ApiMethod(order=30, hint="Convenience method for lookup call: Lookup information about PROJECTs matching given criteria", unprotected=true, convenienceMethodFor="lookup", convenienceMethodObjectType="PROJECT")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.ProjectInfoList> lookupProject(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="match", required=false, parameterType=ApiMethodParameterType.CH_API2_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="filter", required=false, parameterType=ApiMethodParameterType.CH_API2_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("credentialList", credentialList, "match", match, "filter", filter, "extraOptions", extraOptions);
        return this.internalLookup(methodParams, con, "lookupProject", TYPE_PROJECT, credentialList, match, filter, extraOptions, null, AbstractFederationApi.ProjectInfoListFromListOrMap::new);
    }

    @ApiMethod(order=31, hint="Convenience method for update call: Update PROJECT information", convenienceMethodFor="update", convenienceMethodObjectType="PROJECT")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<String> updateProject(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="projectUrn", parameterType=ApiMethodParameterType.USER_URN) @Nonnull GeniUrn projectUrn, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API2_FIELDS) @Nonnull Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("credentialList", credentialList, "projectUrn", projectUrn, "fields", fields, "extraOptions", extraOptions);
        return this.update_internal(methodParams, con, "updateProject", TYPE_PROJECT, credentialList, projectUrn.getValue(), "project", fields, extraOptions);
    }

    @ApiMethod(order=32, hint="Convenience method for create call: create PROJECT", convenienceMethodFor="create", convenienceMethodObjectType="PROJECT")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.ProjectInfo> createProject(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="projectName", required=false, parameterType=ApiMethodParameterType.STRING) @Nullable String projectName, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API2_FIELDS) @Nonnull Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("credentialsList", credentialList, "projectName", projectName, "fields", fields, "extraOptions", extraOptions);
        HashMap<String, String> allFields = new HashMap<String, String>(fields);
        assert (fields.containsKey(FIELD_PROJECT_NAME) == (projectName == null)) : "Either specify projectName (non-null) or add \"PROJECT_NAME\" to \"fields\". (exactly 1 is required)";
        if (projectName != null) {
            allFields.put(FIELD_PROJECT_NAME, projectName);
        }
        return this.create_internal(methodParams, con, "createProject", TYPE_PROJECT, credentialList, allFields, extraOptions, AbstractFederationApi.ProjectInfo::new);
    }

    @ApiMethod(order=33, hint="Convenience method for delete call: delete a PROJECT", convenienceMethodFor="delete", convenienceMethodObjectType="PROJECT")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<Boolean> deleteProject(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="urnToDelete", parameterType=ApiMethodParameterType.STRING) @Nonnull String urnToDelete, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("credentialList", credentialList, "urnToDelete", urnToDelete, "extraOptions", extraOptions);
        return this.delete_internal(methodParams, con, "deleteProject", TYPE_PROJECT, credentialList, urnToDelete, extraOptions);
    }

    @ApiMethod(order=40, hint="modify_slice_membership call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<String> modifyMembership(@Nonnull SfaConnection con, @ApiMethodParameter(name="type", hint="object type for which members need to change", guiDefault="SLICE", parameterType=ApiMethodParameterType.CH_API2_OBJECT_TYPE) @Nonnull String type, @ApiMethodParameter(name="urn", parameterType=ApiMethodParameterType.URN) @Nonnull GeniUrn urn, @ApiMethodParameter(name="membersToAdd", parameterType=ApiMethodParameterType.CH_API_LIST_MEMBER_TUPLES) @Nullable List<UrnRoleTuple> membersToAdd, @ApiMethodParameter(name="membersToRemove", parameterType=ApiMethodParameterType.LIST_OF_URN_STRING) @Nullable List<GeniUrn> membersToRemove, @ApiMethodParameter(name="membersToChange", parameterType=ApiMethodParameterType.CH_API_LIST_MEMBER_TUPLES) @Nullable List<UrnRoleTuple> membersToChange, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("type", type, "urn", urn, "membersToAdd", membersToAdd, "membersToRemove", membersToRemove, "membersToChange", membersToChange, "credentialList", credentialList, "extraOptions", extraOptions);
        ArrayList<Object> args = new ArrayList<Object>(4);
        args.add(type);
        args.add(urn.getValue());
        args.add(FederationSliceAuthorityApi2.createCredentialsListWithTypeAndVersion(credentialList));
        HashMap<String, Object> options = new HashMap<String, Object>();
        ArrayList membersToAddList = new ArrayList();
        if (membersToAdd != null) {
            membersToAddList.addAll(membersToAdd.stream().map(UrnRoleTuple::toMemberTuple).collect(Collectors.toList()));
        }
        options.put("members_to_add", membersToAddList);
        ArrayList membersToRemoveList = new ArrayList();
        if (membersToRemove != null) {
            membersToRemoveList.addAll(membersToRemove.stream().map(GeniUrn::toString).collect(Collectors.toList()));
        }
        options.put("members_to_remove", membersToRemoveList);
        ArrayList membersToChangeList = new ArrayList();
        if (membersToChange != null) {
            membersToChangeList.addAll(membersToChange.stream().map(UrnRoleTuple::toMemberTuple).collect(Collectors.toList()));
        }
        options.put("members_to_change", membersToChangeList);
        if (extraOptions != null) {
            options.putAll(extraOptions);
        }
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "modifyMembership", "modify_membership", args, STRING_REPLY_CONVERTER);
    }

    @ApiMethod(order=41, hint="lookup_members call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<List<UrnRoleTuple>> lookupMembers(@Nonnull SfaConnection con, @ApiMethodParameter(name="type", hint="object type for which members need to change", guiDefault="SLICE", parameterType=ApiMethodParameterType.CH_API2_OBJECT_TYPE) @Nonnull String type, @ApiMethodParameter(name="urn", parameterType=ApiMethodParameterType.SLICE_URN) @Nonnull GeniUrn urn, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("type", type, "credentialList", credentialList, "urn", urn, "extraOptions", extraOptions);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(type);
        args.add(urn.toString());
        args.add(FederationSliceAuthorityApi2.createCredentialsListWithTypeAndVersion(credentialList));
        args.add(FederationSliceAuthorityApi2.createOptionsMap(extraOptions));
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "lookupMembers", "lookup_members", args, resultValueObject -> FederationSliceAuthorityApi2.processUrnRoleTuplesReply(resultValueObject, type, type + "_MEMBER", type + "_ROLE"));
    }

    @ApiMethod(order=42, hint="lookup_for_member call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<List<UrnRoleTuple>> lookupForMember(@Nonnull SfaConnection con, @ApiMethodParameter(name="type", hint="object type for which members need to change", guiDefault="SLICE", parameterType=ApiMethodParameterType.CH_API2_OBJECT_TYPE) @Nonnull String type, @ApiMethodParameter(name="memberUrn", parameterType=ApiMethodParameterType.USER_URN) @Nonnull GeniUrn memberUrn, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi2.makeMethodParameters("type", type, "credentialList", credentialList, "memberUrn", memberUrn, "extraOptions", extraOptions);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(type);
        args.add(memberUrn.toString());
        args.add(FederationSliceAuthorityApi2.createCredentialsListWithTypeAndVersion(credentialList));
        args.add(FederationSliceAuthorityApi2.createOptionsMap(extraOptions));
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "lookupForMember", "lookup_for_member", args, resultValueObject -> FederationSliceAuthorityApi2.processUrnRoleTuplesReply(resultValueObject, type, type + "_URN", type + "_ROLE"));
    }

    public static class UrnRoleTuple {
        @Nonnull
        public final GeniUrn urn;
        @Nonnull
        public final String typeName;
        @Nonnull
        public final String role;
        @Nullable
        public final Map dictRaw;

        public UrnRoleTuple(@Nonnull String typeName, @Nonnull GeniUrn urn, @Nonnull String role) {
            this.typeName = typeName;
            this.dictRaw = null;
            this.urn = urn;
            this.role = role;
        }

        public UrnRoleTuple(@Nonnull Map dictRaw, @Nonnull String typeName, @Nonnull String urnKeyName, @Nonnull String roleKeyName) throws BadReplyGeniException {
            this.typeName = typeName;
            Map<String, Object> dict = AbstractApi.apiSpecifiesMapStringToObject(dictRaw);
            String urnString = (String)dict.get(urnKeyName);
            if (urnString == null) {
                throw new BadReplyGeniException("Dictionary should contain keys '" + urnKeyName + "' and '" + roleKeyName + "'. It contains only: " + String.valueOf(dict.keySet()));
            }
            try {
                this.urn = new GeniUrn(urnString);
            }
            catch (GeniUrn.GeniUrnParseException e) {
                throw new BadReplyGeniException("Could not parse urn '" + urnString + "'", (Exception)((Object)e));
            }
            this.role = (String)dict.get(roleKeyName);
            if (this.role == null) {
                throw new BadReplyGeniException("Dictionary should contain keys '" + urnKeyName + "' and '" + roleKeyName + "'. It contains only: " + String.valueOf(dict.keySet()));
            }
            this.dictRaw = dictRaw;
        }

        public Map toMemberTuple() {
            HashMap<CallSite, String> v = new HashMap<CallSite, String>();
            v.put((CallSite)((Object)(this.typeName + "_MEMBER")), this.urn.toString());
            v.put((CallSite)((Object)(this.typeName + "_ROLE")), this.role);
            return v;
        }

        @Nonnull
        public GeniUrn getUrn() {
            return this.urn;
        }

        @Nonnull
        public String getRole() {
            return this.role;
        }

        public boolean isExpired() {
            if (this.dictRaw == null) {
                return false;
            }
            if (this.dictRaw.containsKey("EXPIRED") && TextUtil.objectToBoolean(this.dictRaw.get("EXPIRED")).booleanValue()) {
                return true;
            }
            if (this.dictRaw.containsKey("PROJECT_EXPIRED") && TextUtil.objectToBoolean(this.dictRaw.get("PROJECT_EXPIRED")).booleanValue()) {
                return true;
            }
            return this.dictRaw.containsKey("SLICE_EXPIRED") && TextUtil.objectToBoolean(this.dictRaw.get("SLICE_EXPIRED")) != false;
        }

        public boolean hasExpiredKey() {
            return this.dictRaw != null && (this.dictRaw.containsKey("EXPIRED") || this.dictRaw.containsKey("PROJECT_EXPIRED") || this.dictRaw.containsKey("SLICE_EXPIRED"));
        }

        public String toString() {
            return "UrnRoleTuple{urn=\"" + String.valueOf(this.urn) + "\", role=\"" + this.role + "\"}";
        }
    }

    public static class GetVersionSAResult
    extends AbstractFederationApi.GetVersionResult {
        private final List<String> services;
        private final List<String> roles;

        public GetVersionSAResult(Object resultValueObject) throws BadReplyGeniException {
            super(resultValueObject, true);
            Map<String, Object> versionInfo = AbstractApi.apiSpecifiesMapStringToObject(resultValueObject);
            this.services = new ArrayList<String>(AbstractApi.apiSpecifiesListOfString(versionInfo.get("SERVICES")));
            this.roles = versionInfo.get("ROLES") != null ? new ArrayList<String>(AbstractApi.apiSpecifiesListOfString(versionInfo.get("ROLES"))) : Collections.emptyList();
        }

        public List<String> getServices() {
            return this.services;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        @Override
        public String toString() {
            return "GetVersionSAResult{version='" + this.version + "', supportedCredentialTypes=" + String.valueOf(this.supportedCredentialTypes) + ", fieldInfos=" + String.valueOf(this.fieldInfos) + ", services=" + String.valueOf(this.services) + ", roles=" + String.valueOf(this.roles) + "}";
        }
    }
}

