/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api;

import be.iminds.ilabt.jfed.lowlevel.connection.ApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.HttpCallDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.HttpConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetails;
import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestApi
extends AbstractApi {
    private static final Logger LOG = LoggerFactory.getLogger(RestApi.class);
    protected static final Map<String, Object> EMPTY_URL_PARAMS = Collections.emptyMap();

    public RestApi(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull ApiInfo.Api serverType, @Nonnull JFedPreferences jFedPreferences) {
        super(logger, serverType, jFedPreferences);
    }

    @Override
    protected boolean isBusyReply(XMLRPCCallDetails res) {
        return false;
    }

    public RestReply<String> internalGet(HttpConnection con, String javaName, String relUrl, Map<String, Object> methodParams, Map<String, Object> urlParams) throws JFedException {
        return this.internalGet(con, javaName, relUrl, methodParams, urlParams, null);
    }

    public RestReply<String> internalGet(HttpConnection con, String javaName, String relUrl, Map<String, Object> methodParams, Map<String, Object> urlParams, Map<String, String> extraHeaders) throws JFedException {
        HttpCallDetails reply;
        LOG.trace(this.getName() + "." + javaName + " params: " + String.valueOf(methodParams));
        assert (con != null);
        String url = con.getServerUrl() + relUrl;
        try {
            reply = this.executeHttpCall(con, relUrl, AbstractApi.HttpVerb.GET, url, null, null, javaName, methodParams, urlParams, extraHeaders);
        }
        catch (MalformedURLException e) {
            throw new JFedException("Internal error constructing new URL. Invalid URL: \"" + url + "\"", (Throwable)e);
        }
        RestReply<String> res = new RestReply<String>(reply, reply.getResultHttpContent());
        this.logNonSfa(reply, res, javaName, relUrl, (JFedConnection)con, methodParams, null);
        return res;
    }

    public RestReply<String> internalPost(HttpConnection con, String javaName, String relUrl, Map<String, Object> methodParams, Map<String, Object> urlParams, HttpEntity content) throws JFedException {
        return this.internalPost(con, javaName, relUrl, methodParams, urlParams, content, null);
    }

    public RestReply<String> internalPost(HttpConnection con, String javaName, String relUrl, Map<String, Object> methodParams, Map<String, Object> urlParams, HttpEntity content, Map<String, String> extraHeaders) throws JFedException {
        HttpCallDetails reply;
        LOG.trace(this.getName() + "." + javaName + " params: " + String.valueOf(methodParams));
        assert (con != null);
        String url = con.getServerUrl() + relUrl;
        try {
            reply = this.executeHttpCall(con, relUrl, AbstractApi.HttpVerb.POST, url, content, javaName, methodParams, urlParams, extraHeaders);
        }
        catch (MalformedURLException e) {
            throw new JFedException("Internal error constructing new URL. Invalid URL: \"" + url + "\"", (Throwable)e);
        }
        RestReply<String> res = new RestReply<String>(reply, reply.getResultHttpContent());
        this.logNonSfa(reply, res, javaName, relUrl, (JFedConnection)con, methodParams, null);
        return res;
    }

    public RestReply<String> internalPost(HttpConnection con, String javaName, String relUrl, Map<String, Object> methodParams, Map<String, Object> urlParams, ContentType contentType, String content) throws JFedException {
        return this.internalPost(con, javaName, relUrl, methodParams, urlParams, contentType, content, null);
    }

    public RestReply<String> internalPost(HttpConnection con, String javaName, String relUrl, Map<String, Object> methodParams, Map<String, Object> urlParams, ContentType contentType, String content, Map<String, String> extraHeaders) throws JFedException {
        HttpCallDetails reply;
        LOG.trace(this.getName() + "." + javaName + " params: " + String.valueOf(methodParams));
        assert (con != null);
        String url = con.getServerUrl() + relUrl;
        try {
            reply = this.executeHttpCall(con, relUrl, AbstractApi.HttpVerb.POST, url, contentType, content, javaName, methodParams, urlParams, extraHeaders);
        }
        catch (MalformedURLException e) {
            throw new JFedException("Internal error constructing new URL. Invalid URL: \"" + url + "\"", (Throwable)e);
        }
        RestReply<String> res = new RestReply<String>(reply, reply.getResultHttpContent());
        this.logNonSfa(reply, res, javaName, relUrl, (JFedConnection)con, methodParams, null);
        return res;
    }

    public RestReply<String> internalPut(HttpConnection con, String javaName, String relUrl, Map<String, Object> methodParams, Map<String, Object> urlParams, ContentType contentType, String content) throws JFedException {
        return this.internalPut(con, javaName, relUrl, methodParams, urlParams, contentType, content, null);
    }

    public RestReply<String> internalPut(HttpConnection con, String javaName, String relUrl, Map<String, Object> methodParams, Map<String, Object> urlParams, ContentType contentType, String content, Map<String, String> extraHeaders) throws JFedException {
        HttpCallDetails reply;
        LOG.trace(this.getName() + "." + javaName + " params: " + String.valueOf(methodParams));
        assert (con != null);
        String url = con.getServerUrl() + relUrl;
        try {
            reply = this.executeHttpCall(con, relUrl, AbstractApi.HttpVerb.PUT, url, contentType, content, javaName, methodParams, urlParams, extraHeaders);
        }
        catch (MalformedURLException e) {
            throw new JFedException("Internal error constructing new URL. Invalid URL: \"" + url + "\"", (Throwable)e);
        }
        RestReply<String> res = new RestReply<String>(reply, reply.getResultHttpContent());
        this.logNonSfa(reply, res, javaName, relUrl, (JFedConnection)con, methodParams, null);
        return res;
    }

    public RestReply<String> internalDelete(HttpConnection con, String javaName, String relUrl, Map<String, Object> methodParams, Map<String, Object> urlParams) throws JFedException {
        return this.internalDelete(con, javaName, relUrl, methodParams, urlParams, null);
    }

    public RestReply<String> internalDelete(HttpConnection con, String javaName, String relUrl, Map<String, Object> methodParams, Map<String, Object> urlParams, Map<String, String> extraHeaders) throws JFedException {
        HttpCallDetails reply;
        LOG.trace(this.getName() + "." + javaName + " params: " + String.valueOf(methodParams));
        assert (con != null);
        String url = con.getServerUrl() + relUrl;
        try {
            reply = this.executeHttpCall(con, relUrl, AbstractApi.HttpVerb.DELETE, url, null, null, javaName, methodParams, urlParams, extraHeaders);
        }
        catch (MalformedURLException e) {
            throw new JFedException("Internal error constructing new URL. Invalid URL: \"" + url + "\"", (Throwable)e);
        }
        RestReply<String> res = new RestReply<String>(reply, reply.getResultHttpContent());
        this.logNonSfa(reply, res, javaName, relUrl, (JFedConnection)con, methodParams, null);
        return res;
    }

    public RestReply<String> internalDelete(HttpConnection con, String javaName, String relUrl, Map<String, Object> methodParams, Map<String, Object> urlParams, HttpEntity content, Map<String, String> extraHeaders) throws JFedException {
        HttpCallDetails reply;
        LOG.trace(this.getName() + "." + javaName + " params: " + String.valueOf(methodParams));
        assert (con != null);
        String url = con.getServerUrl() + relUrl;
        try {
            reply = this.executeHttpCall(con, relUrl, AbstractApi.HttpVerb.DELETE, url, content, javaName, methodParams, urlParams, extraHeaders);
        }
        catch (MalformedURLException e) {
            throw new JFedException("Internal error constructing new URL. Invalid URL: \"" + url + "\"", (Throwable)e);
        }
        RestReply<String> res = new RestReply<String>(reply, reply.getResultHttpContent());
        this.logNonSfa(reply, res, javaName, relUrl, (JFedConnection)con, methodParams, null);
        return res;
    }

    public static class RestReply<T>
    implements ApiCallReply<T> {
        private final T value;
        private final HttpCallDetails httpCallDetails;
        private final int httpCode;
        private final String httpCodeDescription;
        private boolean busy;

        public RestReply(HttpCallDetails httpCallDetails, T value) {
            this.httpCallDetails = httpCallDetails;
            this.httpCode = httpCallDetails.getResultHttpStatusCode();
            this.httpCodeDescription = httpCallDetails.getResultHttpStatusLine();
            this.value = value;
        }

        @Nonnull
        public GeniResponseCode getGeniResponseCode() {
            return new GeniResponseCode(){

                public boolean isSuccess() {
                    return httpCode >= 200 && httpCode < 300;
                }

                public boolean isBusy() {
                    return httpCode == 500 || httpCode == 503;
                }

                public int getCode() {
                    return httpCode;
                }

                public String getDescription() {
                    return httpCodeDescription;
                }
            };
        }

        public T getValue() {
            return this.value;
        }

        public String getOutput() {
            return null;
        }

        public Object getRawResult() {
            return null;
        }

        public Object getRawValue() {
            return this.getValue();
        }

        public HttpCallDetails getHttpCallDetails() {
            return this.httpCallDetails;
        }

        public String toString() {
            return "RestReply{value=" + String.valueOf(this.value) + ", httpCallDetails=" + String.valueOf(this.httpCallDetails) + ", httpCode=" + this.httpCode + ", httpCodeDescription='" + this.httpCodeDescription + "', busy=" + this.busy + "}";
        }
    }
}

