/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api_scripts;

import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticUserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameterType;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetUsersInProject {
    private static final Logger LOG = LoggerFactory.getLogger(GetUsersInProject.class);
    private final be.iminds.ilabt.jfed.log.Logger logger;
    private final UserAndSliceApiWrapper samaWrapper;
    private final GeniUserProvider geniUserProvider;
    private boolean sliceChecked = false;
    private boolean sliceOk = false;
    private UserAndSliceApiWrapper.SliceInfo sliceInfo = null;

    @Inject
    public GetUsersInProject(be.iminds.ilabt.jfed.log.Logger logger, AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory automaticUserAndSliceApiWrapperFactory, GeniUserProvider geniUserProvider) {
        this.logger = logger;
        this.geniUserProvider = geniUserProvider;
        this.samaWrapper = automaticUserAndSliceApiWrapperFactory.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserAndSliceApiWrapper.SliceInfo checkDummySlice(@Nonnull String projectName) throws JFedException {
        String authUrnPart = this.geniUserProvider.getLoggedInGeniUser().getUserUrn().getEncodedTopLevelAuthority_withoutSubAuth();
        GeniUrn sliceUrn = GeniUrn.createGeniUrnFromEncodedParts((String)(authUrnPart + ":" + projectName), (String)"slice", (String)"dummy");
        if (this.sliceChecked) {
            if (this.sliceOk && this.sliceInfo != null && !this.sliceInfo.getCredentials().isEmpty()) {
                return this.sliceInfo;
            }
            throw new RuntimeException("Something went wrong with slice last time. Not trying again.");
        }
        this.sliceOk = false;
        try {
            this.samaWrapper.getLocalUserCredentials(this.logger);
            List<AnyCredential> sliceCredentials = this.samaWrapper.getSliceCredentials(this.logger, sliceUrn);
            if (sliceCredentials != null && !sliceCredentials.isEmpty()) {
                this.sliceInfo = new UserAndSliceApiWrapper.SliceInfo(sliceUrn.getEncodedResourceName(), sliceUrn, sliceCredentials);
                this.sliceOk = true;
            } else {
                this.sliceInfo = null;
                LOG.error("getSliceCredentials problem: sliceCredentials='{}'", sliceCredentials);
            }
        }
        catch (JFedException e) {
            LOG.info("Could not get slice credential. Probably slice does not exist.", (Throwable)e);
            this.sliceInfo = null;
        }
        finally {
            this.sliceChecked = true;
        }
        if (this.sliceInfo == null) {
            Date expirationDate = new Date(System.currentTimeMillis() + 172800000L);
            this.sliceInfo = this.samaWrapper.createSlice(this.logger, sliceUrn.getEncodedResourceName(), expirationDate, sliceUrn.getEncodedSubAuthName());
            boolean bl = this.sliceOk = this.sliceInfo != null && !this.sliceInfo.getCredentials().isEmpty();
            if (!this.sliceOk) {
                LOG.error("Slice creation problem: sliceInfo='{}'", (Object)this.sliceInfo);
            }
        } else {
            LOG.info("Got sliceInfo='{}'", (Object)this.sliceInfo);
        }
        if (this.sliceOk) {
            return this.sliceInfo;
        }
        throw new RuntimeException("Something went wrong with slice creation.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiMethod(order=1, hint="Get All SSH Keys for all users in a specified project")
    public List<UserSpec> getUsersInProject(@ApiMethodParameter(name="projectName", hint="Name of the project/subauthority", parameterType=ApiMethodParameterType.STRING) @Nonnull String projectName) throws JFedException {
        this.samaWrapper.getLocalUserCredentials(this.logger);
        LOG.info("Got credential for user");
        List<GeniUrn> users = this.samaWrapper.getUsersForSubAuthority(this.logger, projectName);
        LOG.info("Got users in project {}: {}", (Object)projectName, users);
        ArrayList<UserSpec> res = new ArrayList<UserSpec>();
        for (GeniUrn user : users) {
            boolean mustGetKeys = true;
            boolean triedAddingSingleToSlice = false;
            int tryCount = 3;
            while (mustGetKeys) {
                if (tryCount-- <= 0) {
                    throw new RuntimeException("Implementation error: loop safety triggered");
                }
                try {
                    List<String> sshKeys = this.samaWrapper.getSshKeysForUser(this.logger, user);
                    String keyInfo = "   Got user " + String.valueOf(user) + " SSH keys:";
                    for (String sshKey : sshKeys) {
                        if (sshKey.length() > 30) {
                            keyInfo = keyInfo + "\n      - " + sshKey.substring(0, 15) + " ... " + sshKey.substring(sshKey.length() - 10);
                            continue;
                        }
                        keyInfo = keyInfo + "\n      - " + sshKey;
                    }
                    LOG.info(keyInfo);
                    res.add(new UserSpec(user.getValue(), sshKeys));
                    mustGetKeys = false;
                    System.out.println("Got " + sshKeys.size() + " keys for: " + user.getEncodedResourceName());
                }
                catch (Exception e) {
                    System.err.println("Failed fetching key for: " + user.getEncodedResourceName());
                    e.printStackTrace();
                    mustGetKeys = false;
                    if (!triedAddingSingleToSlice) {
                        LOG.error("Failed to get SSH key for user " + String.valueOf(user) + ". Will try to add them to slice first.", (Throwable)e);
                        try {
                            UserAndSliceApiWrapper.SliceInfo slice = this.checkDummySlice(projectName);
                            this.samaWrapper.shareSlice(this.logger, slice.getUrn(), slice.getCredentials(), Collections.singletonList(user), "MEMBER");
                            mustGetKeys = true;
                            continue;
                        }
                        catch (JFedException e2) {
                            if (e2.getXmlRpcResult() != null && e2.getXmlRpcResult().getResultXmlRpcString().contains("DUPLICATE_ERROR")) {
                                LOG.error("User " + user.getEncodedResourceName() + " already in slice: OK!");
                                System.err.println("User " + user.getEncodedResourceName() + " already in slice: OK!");
                                mustGetKeys = true;
                                continue;
                            }
                            LOG.error("Failed to add user to slice.", (Throwable)e2);
                            System.err.println("Failed to add user to slice.");
                            e2.printStackTrace();
                            continue;
                        }
                        catch (Exception e2) {
                            LOG.error("Failed to add user to slice.", (Throwable)e2);
                            System.err.println("Failed to add user to slice.");
                            e2.printStackTrace();
                            continue;
                        }
                        finally {
                            triedAddingSingleToSlice = true;
                            continue;
                        }
                    }
                    LOG.error("Failed to get SSH key for user " + String.valueOf(user) + " despite adding user to slice first.", (Throwable)e);
                    System.err.println("Failed to get SSH key for user " + String.valueOf(user) + " despite adding user to slice first.");
                    e.printStackTrace();
                }
            }
        }
        System.out.println("DONE: Got " + res.size() + " user-keys infos.");
        return res;
    }

    public void save(String projectName, File dir) throws JFedException {
        List<UserSpec> users = this.getUsersInProject(projectName);
        for (UserSpec user : users) {
            boolean success;
            File userDir;
            GeniUrn urn = GeniUrn.parse((String)user.getUrn());
            assert (urn != null);
            String username = urn.getEncodedResourceName();
            if (username.length() > 8) {
                String shortUsername = username.replaceAll("[_ -]", "").toLowerCase();
                if (shortUsername.length() > 8) {
                    shortUsername = shortUsername.substring(0, 8);
                }
                username = shortUsername;
            }
            if (!((userDir = new File(dir, "user_" + username)).exists() && userDir.isDirectory() || (success = userDir.mkdirs()))) {
                throw new RuntimeException("Failed to create dir \"" + String.valueOf(userDir) + "\"");
            }
            File usernameFile = new File(userDir, "username");
            File pubKeyFile = new File(userDir, "public_key_openssh.pub");
            Object pubKeys = "";
            for (String pubKey : user.getSshKey()) {
                pubKeys = (String)pubKeys + pubKey + "\n";
            }
            IOUtils.stringToFile((File)usernameFile, (String)username);
            IOUtils.stringToFile((File)pubKeyFile, (String)pubKeys);
        }
    }
}

