/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl;

import be.iminds.ilabt.jfed.lowlevel.api.PlanetlabSfaRegistryInterface;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.lib.CredentialException;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanetlabRegistryUserAndSliceApiWrapper
extends UserAndSliceApiWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(PlanetlabRegistryUserAndSliceApiWrapper.class);
    List<AnyCredential> userCredentials;
    final Map<String, List<AnyCredential>> authCredentialsByHrn = new HashMap<String, List<AnyCredential>>();
    private final Map<GeniUrn, Map> resolveReplyByUrn = new HashMap<GeniUrn, Map>();

    public PlanetlabRegistryUserAndSliceApiWrapper(be.iminds.ilabt.jfed.log.Logger logger, GeniUserProvider geniUserProvider, JFedConnectionProvider connectionProvider, JFedPreferences jFedPreferences) {
        super(logger, geniUserProvider, connectionProvider, jFedPreferences);
    }

    private SfaConnection getCon() throws JFedException {
        return this.getConnection(new ApiInfo.Api(ApiInfo.ApiName.PLANETLAB_SLICE_REGISTRY, 1));
    }

    private PlanetlabSfaRegistryInterface registry(be.iminds.ilabt.jfed.log.Logger logger) {
        return new PlanetlabSfaRegistryInterface(logger, this.jFedPreferences);
    }

    @Override
    public synchronized List<AnyCredential> getUserCredentials(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn userUrn) throws JFedException {
        this.userCredentials = null;
        ArrayList<AnyCredential> res = new ArrayList<AnyCredential>();
        PlanetlabSfaRegistryInterface.SimpleApiCallReply<AnyCredential> replyUserCred = this.registry(logger).getSelfCredential_AutomaticArguments(this.getCon(), this.getLoggedInUser());
        if (!replyUserCred.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Could not retrieve user credential from server: code=" + String.valueOf(replyUserCred.getGeniResponseCode()) + " output=" + replyUserCred.getOutput(), replyUserCred);
        }
        AnyCredential userCred = replyUserCred.getValue();
        res.add(userCred);
        this.userCredentials = new ArrayList<AnyCredential>(res);
        LOG.debug("stored planetlab credential at " + String.valueOf(this));
        return res;
    }

    public synchronized List<AnyCredential> getAuthCredentials(be.iminds.ilabt.jfed.log.Logger logger, GeniUrn userUrn, String authHrn) throws JFedException {
        this.userCredentials = null;
        List authCredentials = this.authCredentialsByHrn.computeIfAbsent(authHrn, k -> new ArrayList());
        authCredentials.clear();
        this.userCredentials = this.getUserCredentials(logger, userUrn);
        AnyCredential userCredential = this.userCredentials.get(0);
        PlanetlabSfaRegistryInterface.SimpleApiCallReply<AnyCredential> replyAuthorityCred = this.registry(logger).getCredential(this.getCon(), userCredential, authHrn, "authority");
        if (!replyAuthorityCred.getGeniResponseCode().isSuccess()) {
            LOG.error("Could not retrieve authority credential from server: code=" + String.valueOf(replyAuthorityCred.getGeniResponseCode()) + " output=" + replyAuthorityCred.getOutput(), replyAuthorityCred);
            return null;
        }
        authCredentials.add(replyAuthorityCred.getValue());
        return authCredentials;
    }

    @Override
    public boolean hasUserCredentials() {
        return this.hasUserCredentials(this.userCredentials);
    }

    @Override
    public List<AnyCredential> getCachedUserCredentialsForAM() {
        return this.userCredentials;
    }

    @Override
    public List<AnyCredential> getSliceCredentials(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn) throws JFedException {
        assert (this.userCredentials != null);
        PlanetlabSfaRegistryInterface.SimpleApiCallReply<AnyCredential> replyCred = this.registry(logger).getCredential(this.getCon(), AnyCredential.toSingleCredential(this.userCredentials), sliceUrn.getValue(), "slice");
        if (!replyCred.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Could not retrieve slice credential from server: code=" + String.valueOf(replyCred.getGeniResponseCode()) + " output=" + replyCred.getOutput(), replyCred);
        }
        return Collections.singletonList(replyCred.getValue());
    }

    private Map getResolveReply(be.iminds.ilabt.jfed.log.Logger logger, GeniUrn urn) throws JFedException {
        PlanetlabSfaRegistryInterface.SimpleApiCallReply<Map> reply;
        Map res = this.resolveReplyByUrn.get(urn);
        if (res == null && (reply = this.registry(logger).resolve(this.getCon(), AnyCredential.toSingleCredential(this.userCredentials), urn.toString())).getGeniResponseCode().isSuccess()) {
            res = reply.getValue();
            this.resolveReplyByUrn.put(urn, res);
        }
        return res;
    }

    @Override
    public List<GeniUrn> getSlicesForUser(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn userUrn) throws JFedException {
        assert (this.userCredentials != null);
        assert (!this.userCredentials.isEmpty());
        ArrayList<GeniUrn> res = new ArrayList<GeniUrn>();
        Map struct = this.getResolveReply(logger, userUrn);
        Object regSlicesO = struct.get("reg-slices");
        if (regSlicesO != null && regSlicesO instanceof Object[]) {
            List<String> regSlicesList = AbstractApi.apiSpecifiesListOfString(regSlicesO);
            for (String regSliceHrn : regSlicesList) {
                String[] parts = regSliceHrn.split(Pattern.quote("."));
                if (parts.length >= 2) {
                    GeniUrn sliceUrn = PlanetlabSfaRegistryInterface.sfaHrnToUrn(regSliceHrn, "slice");
                    res.add(sliceUrn);
                    continue;
                }
                LOG.warn("PlanetlabSfaRegistryInterface Resolve reply error: parts.length=" + parts.length + " for regSliceHrn=" + regSliceHrn);
            }
        } else {
            LOG.warn("PlanetlabSfaRegistryInterface Resolve reply error: no reg-slices or not List: " + String.valueOf(regSlicesO));
        }
        return res;
    }

    @Override
    public List<GeniUrn> getAggregatesForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn) throws JFedException {
        return new ArrayList<GeniUrn>();
    }

    @Override
    public Date getSliceExpiration(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn) throws JFedException {
        return null;
    }

    @Override
    public void shareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn userUrn) throws JFedException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void unshareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn userUrn) throws JFedException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public UserAndSliceApiWrapper.SliceInfo createSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull String sliceName, Date expirationDate, String subAuthName) throws JFedException {
        List<AnyCredential> sliceCredentials;
        PlanetlabSfaRegistryInterface.SimpleApiCallReply<String> replyRegister;
        GeniUrn userUrn = this.getRelevantUserUrn();
        String userHrn = PlanetlabSfaRegistryInterface.urnToSfaHrn(userUrn);
        String sliceHrn = subAuthName + "." + sliceName;
        ArrayList<String> researcherHrns = new ArrayList<String>();
        researcherHrns.add(userHrn);
        GeniUrn sliceUrn = PlanetlabSfaRegistryInterface.sfaHrnToUrn(sliceHrn, "slice");
        List<AnyCredential> authCreds = this.authCredentialsByHrn.get(subAuthName);
        if (authCreds == null || authCreds.isEmpty()) {
            authCreds = this.getAuthCredentials(logger, userUrn, subAuthName);
            assert (authCreds != null);
            assert (!authCreds.isEmpty());
        }
        AnyCredential authCred = AnyCredential.toSingleCredential(authCreds);
        if (expirationDate == null) {
            Calendar cal = Calendar.getInstance();
            cal.add(10, 3);
            expirationDate = cal.getTime();
        }
        if (!(replyRegister = this.registry(logger).registerSlice(this.getCon(), authCred, sliceHrn, null, expirationDate, researcherHrns, null, null)).getGeniResponseCode().isSuccess()) {
            throw new JFedException("Could not create slice: code=" + String.valueOf(replyRegister.getGeniResponseCode()) + " output=" + replyRegister.getOutput(), replyRegister);
        }
        String res = replyRegister.getValue();
        try {
            AnyCredential sliceCredential = AnyCredential.createSfa2("Register slice credential", res);
            sliceCredentials = new ArrayList<AnyCredential>();
            sliceCredentials.add(sliceCredential);
        }
        catch (CredentialException e) {
            sliceCredentials = this.getSliceCredentials(logger, sliceUrn);
        }
        return new UserAndSliceApiWrapper.SliceInfo(sliceName, sliceUrn, sliceCredentials);
    }

    @Override
    public List<AnyCredential> renewSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull Date newExpirationDate) throws JFedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getSshKeysForUser(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn userUrn) throws JFedException {
        Map struct = this.getResolveReply(logger, userUrn);
        Object regSshKeys = struct.get("reg-keys");
        if (regSshKeys != null && regSshKeys instanceof Object[]) {
            return AbstractApi.apiSpecifiesListOfString(regSshKeys);
        }
        LOG.warn("No ssh keys returned (reg-keys), not even empty list. struct=" + String.valueOf(struct));
        return null;
    }

    @Override
    public UserAndSliceApiWrapper.SubAuthoritySupport getSubAuthoritySupport(@Nonnull be.iminds.ilabt.jfed.log.Logger logger) throws JFedException {
        return UserAndSliceApiWrapper.SubAuthoritySupport.SUB_AUTHORITY_MANDATORY;
    }

    @Override
    public List<String> getSubAuthorityNames(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn user) throws JFedException {
        Map struct;
        Object regPiAuths;
        HashSet<String> res = new HashSet<String>();
        if (user.getEncodedSubAuthName() != null) {
            res.add(user.getEncodedSubAuthName());
        }
        if ((regPiAuths = (struct = this.getResolveReply(logger, user)).get("reg-pi-authorities")) != null && regPiAuths instanceof Object[]) {
            List<String> regPiAuthsList = AbstractApi.apiSpecifiesListOfString(regPiAuths);
            LOG.debug("PlanetlabSfaRegistryInterface getSubAuthorityNames Resolve processing " + String.valueOf(regPiAuthsList));
            for (String regPiAuthName : regPiAuthsList) {
                String[] parts = regPiAuthName.split(Pattern.quote("."));
                if (parts.length > 1) {
                    res.add(regPiAuthName);
                    continue;
                }
                LOG.warn("PlanetlabSfaRegistryInterface getSubAuthorityNames Resolve reply error: parts.length=" + parts.length + " for regSliceHrn=" + regPiAuthName);
            }
        } else {
            LOG.warn("PlanetlabSfaRegistryInterface getSubAuthorityNames Resolve reply error: no reg-pi-authorities or not List: " + String.valueOf(regPiAuths));
        }
        return new ArrayList<String>(res);
    }

    @Override
    public List<GeniUrn> getUsersForSubAuthority(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull String projectName) throws JFedException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public List<GeniUrn> getUsersForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        Map struct = this.getResolveReply(logger, sliceUrn);
        Object regUsers = struct.get("reg-researchers");
        if (regUsers != null && regUsers instanceof Object[]) {
            ArrayList<GeniUrn> res = new ArrayList<GeniUrn>();
            for (String userHrn : AbstractApi.apiSpecifiesListOfString(regUsers)) {
                GeniUrn u = PlanetlabSfaRegistryInterface.sfaHrnToUserUrn(userHrn);
                if (u != null) {
                    res.add(u);
                    continue;
                }
                LOG.warn("Unsupported sfa user hrn: \"" + userHrn + "\"");
            }
            return res;
        }
        LOG.warn("No slice users returned (reg-researchers), not even empty list. struct=" + String.valueOf(struct));
        return null;
    }

    @Override
    public boolean hasSubAuthDetailsSupport() {
        return false;
    }

    @Override
    public void getSubAuthorityDetails(@NotNull be.iminds.ilabt.jfed.log.Logger logger, @NotNull String projectName) throws JFedException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void shareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull List<GeniUrn> userUrns, @Nonnull String role) throws JFedException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean isRegisterAggregatesForSliceSupported() {
        return false;
    }

    @Override
    public boolean hasSpeaksForSupport() {
        return false;
    }
}

