/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.FederationMemberAuthorityApi1;
import be.iminds.ilabt.jfed.lowlevel.api.FederationSliceAuthorityApi1;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniformFederationApi1UserAndSliceApiWrapper
extends UserAndSliceApiWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(UniformFederationApi1UserAndSliceApiWrapper.class);
    @Nullable
    List<AnyCredential> userCredentials;

    public UniformFederationApi1UserAndSliceApiWrapper(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUserProvider geniUserProvider, @Nonnull JFedConnectionProvider connectionProvider, @Nonnull JFedPreferences jFedPreferences) {
        super(logger, geniUserProvider, connectionProvider, jFedPreferences);
    }

    @Nonnull
    private FederationMemberAuthorityApi1 ma(@Nonnull be.iminds.ilabt.jfed.log.Logger logger) {
        return new FederationMemberAuthorityApi1(logger, this.jFedPreferences);
    }

    @Nonnull
    private FederationSliceAuthorityApi1 sa(@Nonnull be.iminds.ilabt.jfed.log.Logger logger) {
        return new FederationSliceAuthorityApi1(logger, this.jFedPreferences);
    }

    private SfaConnection getSaConnection() throws JFedException {
        return this.getConnection(new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_SA, 1));
    }

    private SfaConnection getMaConnection() throws JFedException {
        return this.getConnection(new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_MA, 1));
    }

    public FederationSliceAuthorityApi1.GetVersionSAResult getGetVersionSAResult(@Nonnull be.iminds.ilabt.jfed.log.Logger logger) throws JFedException {
        AbstractFederationApi.FederationApiReply<FederationSliceAuthorityApi1.GetVersionSAResult> reply = this.sa(logger).getVersion(this.getSaConnection());
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("GetVersion call to SA not successful", reply);
        }
        return reply.getValue();
    }

    @Override
    @Nullable
    public List<AnyCredential> getUserCredentials(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn user) throws JFedException {
        AbstractFederationApi.FederationApiReply<List<AnyCredential>> reply;
        this.userCredentials = null;
        ArrayList<AnyCredential> reqCredCreds = new ArrayList<AnyCredential>();
        if (this.speaksForCredentials != null && !this.speaksForCredentials.isEmpty()) {
            reqCredCreds.addAll(this.speaksForCredentials);
            assert (this.speaksForUserUrn != null);
            user = this.speaksForUserUrn;
        }
        if (!(reply = this.ma(logger).getCredentials(this.getMaConnection(), reqCredCreds, user, null)).getGeniResponseCode().isSuccess()) {
            throw new JFedException("Could not retrieve user credential from server", reply);
        }
        assert (reply.getValue() != null);
        assert (!reply.getValue().isEmpty());
        this.userCredentials = new ArrayList<AnyCredential>();
        if (this.speaksForCredentials != null && !this.speaksForCredentials.isEmpty()) {
            this.userCredentials.addAll(this.speaksForCredentials);
        }
        this.userCredentials.addAll((Collection<AnyCredential>)reply.getValue());
        return this.userCredentials;
    }

    @Override
    public boolean hasUserCredentials() {
        return this.hasUserCredentials(this.userCredentials);
    }

    @Override
    @Nullable
    public List<AnyCredential> getCachedUserCredentialsForAM() {
        return this.userCredentials;
    }

    @Override
    @Nonnull
    public List<AnyCredential> getSliceCredentials(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn) throws JFedException {
        if (this.userCredentials == null) {
            throw new IllegalStateException("Cannot fetch SliceCredentials when userCredentials are unknown");
        }
        AbstractFederationApi.FederationApiReply<List<AnyCredential>> reply = this.sa(logger).getSliceCredentials(this.getSaConnection(), this.addSpeaksForCredentials(this.userCredentials), sliceUrn, null);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Could not retrieve slice credential from server", reply);
        }
        ArrayList<AnyCredential> sliceCredentials = new ArrayList<AnyCredential>();
        if (this.speaksForCredentials != null && !this.speaksForCredentials.isEmpty()) {
            sliceCredentials.addAll(this.speaksForCredentials);
        }
        sliceCredentials.addAll((Collection)reply.getValue());
        return sliceCredentials;
    }

    @Override
    @Nonnull
    public List<GeniUrn> getSlicesForUser(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn user) throws JFedException {
        if (this.userCredentials == null) {
            throw new IllegalStateException("Cannot fetch SlicesForUser when userCredentials are unknown");
        }
        AbstractFederationApi.FederationApiReply<List<FederationSliceAuthorityApi1.UrnRoleTuple>> reply = this.sa(logger).lookupSlicesForMember(this.getSaConnection(), user, this.addSpeaksForCredentials(this.userCredentials), null);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Could not retrieve slices for user from server", reply);
        }
        ArrayList<GeniUrn> res = new ArrayList<GeniUrn>();
        ArrayList<String> resStrings = new ArrayList<String>();
        List<FederationSliceAuthorityApi1.UrnRoleTuple> urnRoleTuples = reply.getValue();
        for (FederationSliceAuthorityApi1.UrnRoleTuple urnRoleTuple : urnRoleTuples) {
            res.add(urnRoleTuple.getUrn());
            resStrings.add(urnRoleTuple.getUrn().toString());
        }
        Map sliceMatch = Collections.singletonMap("SLICE_URN", resStrings);
        this.sa(logger).lookupSlices(this.getSaConnection(), this.addSpeaksForCredentials(this.userCredentials), sliceMatch, null, null);
        return res;
    }

    @Nonnull
    public List<GeniUrn> getUserProjects(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, GeniUrn user) throws JFedException {
        ArrayList<GeniUrn> res;
        block11: {
            if (this.userCredentials == null) {
                throw new IllegalStateException("Cannot fetch UserProjects when userCredentials are unknown");
            }
            AbstractFederationApi.FederationApiReply<List<FederationSliceAuthorityApi1.UrnRoleTuple>> reply = this.sa(logger).lookupProjectsForMember(this.getSaConnection(), user, this.addSpeaksForCredentials(this.userCredentials), null);
            if (!reply.getGeniResponseCode().isSuccess()) {
                throw new JFedException("Could not retrieve slices for user from server", reply);
            }
            res = new ArrayList<GeniUrn>();
            List<FederationSliceAuthorityApi1.UrnRoleTuple> urnRoleTuples = reply.getValue();
            boolean hasExpired = false;
            for (FederationSliceAuthorityApi1.UrnRoleTuple urnRoleTuple : urnRoleTuples) {
                if (urnRoleTuple.isExpired()) {
                    hasExpired = true;
                    LOG.debug("skipping expired project: " + String.valueOf(urnRoleTuple.getUrn()));
                    continue;
                }
                if (urnRoleTuple.hasExpiredKey()) {
                    hasExpired = true;
                }
                res.add(urnRoleTuple.getUrn());
            }
            if (!hasExpired) {
                LOG.debug("Doing second call to check for expired projects");
                assert (this.getLoggedInUserAuthorityServer() != null);
                Map<Object, Object> match = this.getLoggedInUserAuthorityServer().hasFlag(Server.Flag.workaroundFedMaMatchProjectExpired) ? Collections.singletonMap("EXPIRED", Boolean.FALSE) : Collections.emptyMap();
                List<String> filter = Collections.singletonList("PROJECT_URN");
                try {
                    AbstractFederationApi.FederationApiReply<AbstractFederationApi.ProjectInfoMap> nonExpiredProj = this.sa(logger).lookupProjects(this.getSaConnection(), this.addSpeaksForCredentials(this.userCredentials), match, filter, null);
                    if (nonExpiredProj.getGeniResponseCode().isSuccess() && nonExpiredProj.getValue() != null) {
                        LOG.debug("Found " + nonExpiredProj.getValue().size() + " non expired projects on server.");
                        res.removeIf(projUrn -> !((AbstractFederationApi.ProjectInfoMap)((Object)((Object)nonExpiredProj.getValue()))).containsKey(projUrn));
                        break block11;
                    }
                    LOG.warn("lookup_projects call failed. Could not check for expired projects. This error will be ignored (possibly leaving expired projects in the list).");
                }
                catch (AssertionError | Exception e) {
                    LOG.warn("lookup_projects call failed. Could not check for expired projects. This error will be ignored (possibly leaving expired projects in the list).", (Throwable)e);
                }
            } else {
                LOG.debug("No second call needed to check for expired projects");
            }
        }
        LOG.debug("UniformFederationApi1UserAndSliceApiWrapper#getUserProjects res.size()={}", (Object)res.size());
        return res;
    }

    public AbstractFederationApi.MemberInfoList getUserIdentifyingInfo(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn user) throws JFedException {
        if (this.userCredentials == null) {
            throw new IllegalStateException("Cannot fetch userIdentifyingInfo when userCredentials are unknown");
        }
        if (this.getRelevantUserUrnString() == null) {
            throw new IllegalStateException("No relevateUserUrnString available to do getUserIdentifiyingInfo call");
        }
        Map<String, String> match = Collections.singletonMap("MEMBER_URN", user.getValue());
        AbstractFederationApi.FederationApiReply<AbstractFederationApi.MemberInfoList> reply = this.ma(logger).lookupIdentifyingMemberInfo(this.getMaConnection(), this.addSpeaksForCredentials(this.userCredentials), match, null, null);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Problem looking up user info for " + String.valueOf(user), reply);
        }
        return reply.getValue();
    }

    @Override
    @Nullable
    public List<GeniUrn> getAggregatesForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn) throws JFedException {
        AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliverInfoList> reply = this.sa(logger).lookupSliverInfo(this.getSaConnection(), sliceCredentials, sliceUrn, null, null, null);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Problem looking up aggregates for slice '" + String.valueOf(sliceUrn) + "'", reply);
        }
        return reply.getValue().values().stream().map(AbstractFederationApi.SliverInfo::getAggregateUrn).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Date getSliceExpiration(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn) throws JFedException {
        return null;
    }

    @Override
    public void shareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn userUrn) throws JFedException {
        ArrayList<FederationSliceAuthorityApi1.UrnRoleTuple> membersToAdd = new ArrayList<FederationSliceAuthorityApi1.UrnRoleTuple>();
        membersToAdd.add(new FederationSliceAuthorityApi1.UrnRoleTuple(userUrn, "MEMBER"));
        AbstractFederationApi.FederationApiReply<String> reply = this.sa(logger).modifySliceMembership(this.getSaConnection(), sliceUrn, membersToAdd, new ArrayList<GeniUrn>(), new ArrayList<FederationSliceAuthorityApi1.UrnRoleTuple>(), sliceCredentials, null);
        if (!reply.getGeniResponseCode().isSuccess()) {
            if (reply.getOutput() != null && reply.getOutput().contains("DUPLICATE")) {
                LOG.warn("Reply to shared slice was \"" + reply.getOutput() + "\". Assuming this means it is successfully shared already.");
                return;
            }
            throw new JFedException("Sharing slice with " + String.valueOf(userUrn) + " did not succeed", reply);
        }
    }

    @Override
    public void unshareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn userUrn) throws JFedException {
        ArrayList<GeniUrn> membersToRemove = new ArrayList<GeniUrn>();
        membersToRemove.add(userUrn);
        AbstractFederationApi.FederationApiReply<String> reply = this.sa(logger).modifySliceMembership(this.getSaConnection(), sliceUrn, new ArrayList<FederationSliceAuthorityApi1.UrnRoleTuple>(), membersToRemove, new ArrayList<FederationSliceAuthorityApi1.UrnRoleTuple>(), sliceCredentials, null);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Unsharing slice with " + String.valueOf(userUrn) + " did not succeed", reply);
        }
    }

    @Override
    public List<GeniUrn> getUsersForSubAuthority(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull String projectName) throws JFedException {
        if (this.userCredentials == null) {
            throw new IllegalStateException("Cannot fetch usersForSubAuthority when userCredentials are unknown");
        }
        assert (this.getLoggedInUserAuthorityServer() != null);
        GeniUrn projectUrn = GeniUrn.createGeniUrnFromEncodedParts((String)this.getLoggedInUserAuthorityServer().getUrnTld(), (String)"project", (String)projectName);
        AbstractFederationApi.FederationApiReply<List<FederationSliceAuthorityApi1.UrnRoleTuple>> reply = this.sa(logger).lookupProjectMembers(this.getSaConnection(), projectUrn, this.addSpeaksForCredentials(this.userCredentials), null);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Error getting users in project " + String.valueOf(projectUrn), reply);
        }
        return reply.getValue().stream().map(FederationSliceAuthorityApi1.UrnRoleTuple::getUrn).collect(Collectors.toList());
    }

    @Override
    public List<GeniUrn> getUsersForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        AbstractFederationApi.FederationApiReply<List<FederationSliceAuthorityApi1.UrnRoleTuple>> reply = this.sa(logger).lookupSliceMembers(this.getSaConnection(), sliceUrn, sliceCredentials, null);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Error getting users in " + String.valueOf(sliceUrn), reply);
        }
        return reply.getValue().stream().map(FederationSliceAuthorityApi1.UrnRoleTuple::getUrn).collect(Collectors.toList());
    }

    @Override
    public boolean hasSubAuthDetailsSupport() {
        return true;
    }

    @Override
    public void getSubAuthorityDetails(@NotNull be.iminds.ilabt.jfed.log.Logger logger, @NotNull String projectName) throws JFedException {
        if (this.userCredentials == null) {
            throw new IllegalStateException("Cannot fetch SubAuthority Details when userCredentials are unknown");
        }
        assert (this.getLoggedInUserAuthorityServer() != null);
        HashMap<String, String> match = new HashMap<String, String>();
        List<String> filter = null;
        match.put("PROJECT_NAME", projectName);
        AbstractFederationApi.FederationApiReply<AbstractFederationApi.ProjectInfoMap> reply = this.sa(logger).lookupProjects(this.getSaConnection(), this.addSpeaksForCredentials(this.userCredentials), match, filter, null);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Error getting project info for " + projectName, reply);
        }
        if (reply.getValue() == null) {
            throw new JFedException("Null reply value getting project info for \"" + projectName + "\"", reply);
        }
    }

    @Override
    public void shareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull List<GeniUrn> userUrns, @Nonnull String role) throws JFedException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    @Nonnull
    public UserAndSliceApiWrapper.SliceInfo createSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull String sliceName, @Nullable Date expirationDate, @Nullable String subAuthName) throws JFedException {
        AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliceInfo> reply;
        if (this.userCredentials == null) {
            throw new IllegalStateException("Cannot do createSlice when userCredentials are unknown");
        }
        SfaConnection con = this.getSaConnection();
        FederationSliceAuthorityApi1.GetVersionSAResult gv = this.getGetVersionSAResult(logger);
        assert (gv != null);
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("SLICE_DESCRIPTION", "jFed Experimenter GUI slice '" + sliceName + "' for user " + this.getRelevantUserUrnString());
        GeniUrn chosenProject = null;
        boolean projectSupported = true;
        if (projectSupported) {
            if (subAuthName == null) {
                throw new JFedException("Slice creation requires a project, but user did not specify any project.");
            }
            assert (this.getRelevantUserUrn() != null);
            chosenProject = GeniUrn.createGeniUrnFromEncodedParts((String)this.getRelevantUserUrn().getEncodedTopLevelAuthority(), (String)"project", (String)subAuthName);
        }
        if (!projectSupported && subAuthName != null) {
            LOG.warn("The server does not support PROJECTS, but the user specified a project name. Will ignore project");
        }
        if (chosenProject != null) {
            fields.put("SLICE_PROJECT_URN", chosenProject.getValue());
        }
        if (gv.getFieldsForObject("PROJECT").containsKey("_GENI_SLICE_EMAIL")) {
            AbstractFederationApi.MemberInfoList userIdentifyingInfo = this.getUserIdentifyingInfo(logger, this.getRelevantUserUrn());
            if (userIdentifyingInfo != null && !((AbstractFederationApi.MemberInfo)userIdentifyingInfo.get(this.getRelevantUserUrn())).getEmail().isEmpty()) {
                String userEmail = ((AbstractFederationApi.MemberInfo)userIdentifyingInfo.get(this.getRelevantUserUrn())).getEmail();
                fields.put("_GENI_SLICE_EMAIL", userEmail);
            } else {
                throw new JFedException("Slice creation requires a user email, but the user email is not known.");
            }
        }
        if (expirationDate != null) {
            fields.put("SLICE_EXPIRATION", RFC3339Util.dateToRFC3339String((Date)expirationDate, (boolean)true, (boolean)true, (boolean)true));
        }
        if (!(reply = this.sa(logger).createSlice(con, this.addSpeaksForCredentials(this.userCredentials), sliceName, fields, null)).getGeniResponseCode().isSuccess()) {
            throw new JFedException("Error creating slice", reply);
        }
        AbstractFederationApi.SliceInfo sliceInfo = reply.getValue();
        AbstractFederationApi.FederationApiReply<List<AnyCredential>> credReply = this.sa(logger).getSliceCredentials(con, this.addSpeaksForCredentials(this.userCredentials), sliceInfo.getSliceUrn(), null);
        ArrayList<AnyCredential> sliceCredentials = new ArrayList<AnyCredential>();
        if (this.speaksForCredentials != null && !this.speaksForCredentials.isEmpty()) {
            sliceCredentials.addAll(this.speaksForCredentials);
        }
        sliceCredentials.addAll((Collection)credReply.getValue());
        return new UserAndSliceApiWrapper.SliceInfo(sliceName, sliceInfo.getSliceUrn(), sliceCredentials);
    }

    @Override
    @Nonnull
    public List<AnyCredential> renewSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull Date newExpirationDate) throws JFedException {
        GeniUrn sliceUrn;
        if (this.userCredentials == null) {
            throw new IllegalStateException("Cannot do renewSlice when userCredentials are unknown");
        }
        try {
            sliceUrn = UniformFederationApi1UserAndSliceApiWrapper.findSliceUrn(sliceCredentials);
        }
        catch (IllegalArgumentException e) {
            throw new JFedException("Could not find slice URN in provided slice credential list.");
        }
        Map<String, String> fields = Collections.singletonMap("SLICE_EXPIRATION", RFC3339Util.dateToRFC3339String((Date)newExpirationDate));
        AbstractFederationApi.FederationApiReply<String> updateReply = this.sa(logger).updateSlice(this.getSaConnection(), sliceCredentials, sliceUrn, fields, null);
        if (!updateReply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Failed to update SLICE_EXPIRATION", updateReply);
        }
        AbstractFederationApi.FederationApiReply<List<AnyCredential>> credReply = this.sa(logger).getSliceCredentials(this.getSaConnection(), this.addSpeaksForCredentials(this.userCredentials), sliceUrn, null);
        if (!credReply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Failed to get updated slice credentials", credReply);
        }
        ArrayList<AnyCredential> newSliceCredentials = new ArrayList<AnyCredential>();
        if (this.speaksForCredentials != null && !this.speaksForCredentials.isEmpty()) {
            newSliceCredentials.addAll(this.speaksForCredentials);
        }
        newSliceCredentials.addAll((Collection)credReply.getValue());
        return newSliceCredentials;
    }

    @Override
    @Nonnull
    public List<String> getSshKeysForUser(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn userUrn) throws JFedException {
        if (this.userCredentials == null) {
            throw new IllegalStateException("Cannot fetch sshKeysForUser when userCredentials are unknown");
        }
        Map<String, String> match = Collections.singletonMap("KEY_MEMBER", userUrn.toString());
        AbstractFederationApi.FederationApiReply<Map<GeniUrn, List<AbstractFederationApi.MemberKeyInfo>>> reply = this.ma(logger).lookupKeys(this.getMaConnection(), this.addSpeaksForCredentials(this.userCredentials), match, null, null);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Failed to get SSH keys", reply);
        }
        return reply.getValue().get(userUrn).stream().map(AbstractFederationApi.MemberKeyInfo::getPublicKey).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public UserAndSliceApiWrapper.SubAuthoritySupport getSubAuthoritySupport(@Nonnull be.iminds.ilabt.jfed.log.Logger logger) throws JFedException {
        FederationSliceAuthorityApi1.GetVersionSAResult getSAVersionRes = this.getGetVersionSAResult(logger);
        if (!getSAVersionRes.getServices().contains("PROJECT")) {
            return UserAndSliceApiWrapper.SubAuthoritySupport.SUB_AUTHORITY_FORBIDDEN;
        }
        return UserAndSliceApiWrapper.SubAuthoritySupport.SUB_AUTHORITY_MANDATORY;
    }

    @Override
    @Nonnull
    public List<String> getSubAuthorityNames(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn user) throws JFedException {
        List<String> res = this.getUserProjects(logger, user).stream().map(GeniUrn::getEncodedResourceName).collect(Collectors.toList());
        LOG.debug("Returning subauthorities: {}", res);
        return res;
    }

    @Override
    public boolean isRegisterAggregatesForSliceSupported() {
        return false;
    }

    @Override
    public boolean hasSpeaksForSupport() {
        return true;
    }

    @Override
    public void setSpeaksFor(List<AnyCredential> speaksForCredentials, @Nullable GeniUrn speakingForUrn) {
        super.setSpeaksFor(speaksForCredentials, speakingForUrn);
        if (speakingForUrn != null) {
            this.setExtraOptionsForCallsWithCredential(Collections.singletonMap("speaking_for", speakingForUrn.getValue()));
        }
    }
}

