/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.authority.legacy;

import be.iminds.ilabt.jfed.lowlevel.authority.legacy.LegacySfaAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.lib.Gid;
import be.iminds.ilabt.jfed.lowlevel.lib.ServerType;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LegacyAuthorityListModel {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyAuthorityListModel.class);
    private final List<LegacySfaAuthority> authorities;
    private final List<AuthorityListModelListener> changeListeners = new ArrayList<AuthorityListModelListener>();
    private Boolean forceExoSM = null;

    public LegacyAuthorityListModel() {
        this.authorities = new ArrayList<LegacySfaAuthority>();
    }

    public List<LegacySfaAuthority> getAuthorities() {
        assert (!this.authorities.contains(null));
        return Collections.unmodifiableList(this.authorities);
    }

    public int size() {
        return this.authorities.size();
    }

    public LegacySfaAuthority getByUrn(GeniUrn urn, SubAuthMatchAllowed matchAllowed, SubAuthMatchPreference matchPreferred, boolean ignoreUrnTypeAndName) {
        LegacySfaAuthority auth2;
        LOG.trace("AuthorityListModel.getByUrn(" + String.valueOf(urn) + ", " + String.valueOf((Object)matchAllowed) + ", " + String.valueOf((Object)matchPreferred) + ", " + ignoreUrnTypeAndName + ")");
        if (!ignoreUrnTypeAndName && !Objects.equals(urn.getResourceType(), "authority")) {
            LOG.warn("Tried to lookup SfaAuthorityBackwardCompatibility with non-authority URN \"" + String.valueOf(urn) + "\". It will likely not be found in list of authority URNs");
            assert (false);
        }
        ArrayList<LegacySfaAuthority> exactMatches = new ArrayList<LegacySfaAuthority>();
        ArrayList<LegacySfaAuthority> topLevelMatches = new ArrayList<LegacySfaAuthority>();
        ArrayList<LegacySfaAuthority> ignoreSubAuthMatches = new ArrayList<LegacySfaAuthority>();
        int urnSubAuthCount = urn.getSubAuthCount();
        for (LegacySfaAuthority auth2 : this.authorities) {
            GeniUrn authUrn = auth2.getUrn();
            int authSubAuthCount = authUrn.getSubAuthCount();
            if (!ignoreUrnTypeAndName && (!Objects.equals(authUrn.getResourceType(), urn.getResourceType()) || !Objects.equals(authUrn.getResourceName(), urn.getResourceName())) || !Objects.equals(authUrn.getTopLevelAuthority_withoutSubAuth(), urn.getTopLevelAuthority_withoutSubAuth())) continue;
            if (Objects.equals(authUrn.getTopLevelAuthority(), urn.getTopLevelAuthority())) {
                exactMatches.add(auth2);
            }
            if (!authUrn.hasSubAuthority()) {
                topLevelMatches.add(auth2);
            }
            if (authSubAuthCount > 0 && authSubAuthCount < urnSubAuthCount && Objects.equals(urn.getSubAuthNames(authSubAuthCount), authUrn.getSubAuthName())) {
                topLevelMatches.add(auth2);
            }
            ignoreSubAuthMatches.add(auth2);
        }
        switch (matchAllowed.ordinal()) {
            case 0: {
                topLevelMatches.clear();
                ignoreSubAuthMatches.clear();
                break;
            }
            case 1: {
                ignoreSubAuthMatches.clear();
                break;
            }
        }
        switch (matchPreferred.ordinal()) {
            case 0: {
                Iterator<LegacySfaAuthority> iterator = exactMatches.iterator();
                if (iterator.hasNext()) {
                    auth2 = iterator.next();
                    return auth2;
                }
                iterator = LegacyAuthorityListModel.sortBySubAuthDifference(topLevelMatches, urn).iterator();
                if (iterator.hasNext()) {
                    auth2 = iterator.next();
                    return auth2;
                }
                iterator = LegacyAuthorityListModel.sortBySubAuthDifference(ignoreSubAuthMatches, urn).iterator();
                if (iterator.hasNext()) {
                    auth2 = iterator.next();
                    return auth2;
                }
                return null;
            }
            case 1: {
                Iterator<LegacySfaAuthority> iterator = LegacyAuthorityListModel.sortBySubAuthNumber(topLevelMatches).iterator();
                if (iterator.hasNext()) {
                    auth2 = iterator.next();
                    return auth2;
                }
                iterator = exactMatches.iterator();
                if (iterator.hasNext()) {
                    auth2 = iterator.next();
                    return auth2;
                }
                iterator = LegacyAuthorityListModel.sortBySubAuthNumber(ignoreSubAuthMatches).iterator();
                if (iterator.hasNext()) {
                    auth2 = iterator.next();
                    return auth2;
                }
                return null;
            }
        }
        throw new RuntimeException("match preference not implemented: " + String.valueOf((Object)matchPreferred));
    }

    static List<LegacySfaAuthority> sortBySubAuthDifference(List<LegacySfaAuthority> l, GeniUrn urn) {
        l.sort(Comparator.comparing(auth -> LegacyAuthorityListModel.getDistance(urn, auth)));
        return l;
    }

    private static int getDistance(GeniUrn urn, LegacySfaAuthority a) {
        return Math.abs(a.getUrn().getSubAuthCount() - urn.getSubAuthCount());
    }

    static List<LegacySfaAuthority> sortBySubAuthNumber(List<LegacySfaAuthority> l) {
        l.sort(Comparator.comparing(auth -> auth.getUrn().getSubAuthCount()));
        return l;
    }

    public LegacySfaAuthority getByUrn(String urnString, SubAuthMatchAllowed matchAllowed, SubAuthMatchPreference matchPreferred, boolean ignoreUrnTypeAndName) {
        GeniUrn u = GeniUrn.parse((String)urnString);
        if (u == null) {
            LOG.warn("Tried to lookup SfaAuthorityBackwardCompatibility using the invalid URN \"" + urnString + "\" -> solving problem by returning null");
            return null;
        }
        return this.getByUrn(u, matchAllowed, matchPreferred, ignoreUrnTypeAndName);
    }

    public LegacySfaAuthority getByUrn(String urnString, SubAuthMatchAllowed matchAllowed, SubAuthMatchPreference matchPreferred) {
        return this.getByUrn(urnString, matchAllowed, matchPreferred, false);
    }

    public LegacySfaAuthority getByUrn(GeniUrn urn, SubAuthMatchAllowed matchAllowed, SubAuthMatchPreference matchPreferred) {
        return this.getByUrn(urn, matchAllowed, matchPreferred, false);
    }

    public LegacySfaAuthority getByUrnExact(String urnString) {
        return this.getByUrn(urnString, SubAuthMatchAllowed.ALLOW_ONLY_EXACT_SUBAUTHORITY, SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY, false);
    }

    public LegacySfaAuthority getByUrnExact(GeniUrn urn) {
        return this.getByUrn(urn, SubAuthMatchAllowed.ALLOW_ONLY_EXACT_SUBAUTHORITY, SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY, false);
    }

    public LegacySfaAuthority getFromAnyUrn(String urnString, SubAuthMatchAllowed matchAllowed, SubAuthMatchPreference matchPreferred) {
        return this.getByUrn(urnString, matchAllowed, matchPreferred, true);
    }

    public LegacySfaAuthority getFromAnyUrn(GeniUrn urn, SubAuthMatchAllowed matchAllowed, SubAuthMatchPreference matchPreferred) {
        return this.getByUrn(urn, matchAllowed, matchPreferred, true);
    }

    public LegacySfaAuthority getFromAnyUrnExact(String urnString) {
        return this.getByUrn(urnString, SubAuthMatchAllowed.ALLOW_ONLY_EXACT_SUBAUTHORITY, SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY, true);
    }

    public LegacySfaAuthority getFromAnyUrnExact(GeniUrn urn) {
        return this.getByUrn(urn, SubAuthMatchAllowed.ALLOW_ONLY_EXACT_SUBAUTHORITY, SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY, true);
    }

    public LegacySfaAuthority getByUrl(URL scsUrl) {
        for (LegacySfaAuthority auth : this.authorities) {
            if (!auth.getUrls().values().contains(scsUrl)) continue;
            return auth;
        }
        return null;
    }

    public boolean removeByUrn(String urn) {
        for (LegacySfaAuthority auth : this.authorities) {
            if (!Objects.equals(auth.getUrnString(), urn)) continue;
            this.authorities.remove(auth);
            this.fireChange();
            return true;
        }
        return false;
    }

    void removeAll() {
        if (this.authorities.isEmpty()) {
            return;
        }
        this.authorities.clear();
        this.fireChange();
    }

    public LegacySfaAuthority createOrUpdate(String urn, String name, Map<ServerType, URL> urls, List<LegacySfaAuthority.ProxyInfo> proxies, Gid gid, String type) {
        for (LegacySfaAuthority auth : this.authorities) {
            if (!Objects.equals(auth.getUrnString(), urn)) continue;
            auth.updateAll(name, urls, gid, type);
            return auth;
        }
        try {
            LegacySfaAuthority newAuth = new LegacySfaAuthority(urn, name, null, urls, proxies, gid, type);
            this.authorities.add(newAuth);
            return newAuth;
        }
        catch (JFedException e) {
            LOG.warn("WARNING: Error adding authority (=> authority not added!): \"" + urn + "\": " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public LegacySfaAuthority mergeOrAdd(LegacySfaAuthority auth) {
        for (LegacySfaAuthority existingAuth : this.authorities) {
            if (!Objects.equals(existingAuth.getUrnString(), auth.getUrnString())) continue;
            existingAuth.updateAll(auth.getName(), auth.getUrls(), auth.getGid(), auth.getType());
            return existingAuth;
        }
        this.authorities.add(auth);
        return auth;
    }

    public void addAuthority(LegacySfaAuthority auth) {
        assert (auth != null);
        assert (auth.getUrn() != null);
        assert (auth.getUrnString() != null);
        assert (!this.authorities.contains(auth)) : "this already contains SfaAuthorityBackwardCompatibility with urn " + auth.getUrnString();
        this.authorities.add(auth);
        this.fireChange();
    }

    public void fireChange() {
        this.changeListeners.forEach(AuthorityListModelListener::onAuthorityListChanged);
    }

    public void addAuthorityListModelListener(AuthorityListModelListener l) {
        this.changeListeners.add(l);
    }

    public void removeAuthorityListModelListener(AuthorityListModelListener l) {
        this.changeListeners.remove(l);
    }

    public static enum SubAuthMatchAllowed {
        ALLOW_ONLY_EXACT_SUBAUTHORITY,
        ALLOW_TOPLEVEL,
        ALLOW_OTHER_SUBAUTHORITY;

    }

    public static enum SubAuthMatchPreference {
        PREFER_EXACT_SUBAUTHORITY,
        PREFER_TOPLEVEL;

    }

    public static interface AuthorityListModelListener {
        public void onAuthorityListChanged();
    }
}

