/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.lib;

import be.iminds.ilabt.jfed.util.lib.SSHKeyHelper;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class TestCertHelper {
    public static final int defaultValidityDays = 2;
    public static final String authority1Hostname = "authority.example.com";
    public static final String authority1Urn = "urn:publicid:IDN+authority.example.com+authority+root";
    public static final String authority2Hostname = "authority2.example.com";
    public static final String authority2Urn = "urn:publicid:IDN+authority2.example.com+authority+root";
    public static final String authority3Hostname = "authority3.example.com";
    public static final String authority3Urn = "urn:publicid:IDN+authority3.example.com+authority+root";
    public static final String fakeHostname = "fake.example.com";
    public static final String username = "tester";
    public static final String userUuid;
    public static final String userEmail = "tester@authority.example.com";
    public static final String userUuidUrn;
    public static final String userUrn = "urn:publicid:IDN+authority.example.com+user+tester";
    public static final String am1Uuid;
    public static final String am1Email = "am1@authority.example.com";
    public static final String am1UuidUrn;
    public static final String am1Urn = "urn:publicid:IDN+authority.example.com+authority+cm";
    public static final String am2Uuid;
    public static final String am2Email = "am2@authority2.example.com";
    public static final String am2UuidUrn;
    public static final String am2Urn = "urn:publicid:IDN+authority2.example.com+authority+cm";
    public static final String am3Uuid;
    public static final String am3Email = "am3@authority3.example.com";
    public static final String am3UuidUrn;
    public static final String am3Urn = "urn:publicid:IDN+authority3.example.com+authority+cm";
    public static final String scsUuid;
    public static final String scsEmail = "scs@authority3.example.com";
    public static final String scsUuidUrn;
    public static final String scsUrn = "urn:publicid:IDN+authority3.example.com+authority+cm";
    public static final String fakeAmUrn = "urn:publicid:IDN+fake.example.com+authority+cm";
    public static final String saUuid;
    public static final String saEmail = "sa@authority.example.com";
    public static final String saUuidUrn;
    public static final String saUrn = "urn:publicid:IDN+authority.example.com+authority+sa";
    public static final String sa2Uuid;
    public static final String sa2Email = "sa@authority2.example.com";
    public static final String sa2UuidUrn;
    public static final String sa2Urn = "urn:publicid:IDN+authority2.example.com+authority+sa";
    public static final String toolUuid;
    public static final String toolUrn = "urn:publicid:IDN+authority.example.com+tool+jfed_unit_test";
    public static final String toolUuidUrn;
    public final SSHKeyHelper authority1Keys;
    public final SSHKeyHelper authority2Keys;
    public final SSHKeyHelper authority3Keys;
    public final SSHKeyHelper userKeys;
    public final SSHKeyHelper saKeys;
    public final SSHKeyHelper am1Keys;
    public final SSHKeyHelper am2Keys;
    public final SSHKeyHelper scsKeys;
    public final SSHKeyHelper toolKeys;
    public final X509Certificate authority1Cert;
    public final X509Certificate authority2Cert;
    public final X509Certificate authority3Cert;
    public final X509Certificate saCert;
    public final X509Certificate am1Cert;
    public final X509Certificate am2Cert;
    public final X509Certificate scsCert;
    public final X509Certificate userCert;
    public final X509Certificate toolCert;
    public final KeyStore testTrustStore;

    public TestCertHelper() {
        try {
            this.authority1Keys = new SSHKeyHelper();
            this.authority2Keys = new SSHKeyHelper();
            this.authority3Keys = new SSHKeyHelper();
            this.userKeys = new SSHKeyHelper();
            this.saKeys = new SSHKeyHelper();
            this.am1Keys = new SSHKeyHelper();
            this.am2Keys = new SSHKeyHelper();
            this.scsKeys = new SSHKeyHelper();
            this.toolKeys = new SSHKeyHelper();
            this.authority1Cert = TestCertHelper.makeAuthCert(this.authority1Keys, authority1Hostname, authority1Urn);
            this.authority2Cert = TestCertHelper.makeAuthCert(this.authority2Keys, authority2Hostname, authority2Urn);
            this.authority3Cert = TestCertHelper.makeAuthCert(this.authority3Keys, authority3Hostname, authority3Urn);
            this.userCert = TestCertHelper.makeUserCert(this.authority1Keys, authority1Hostname, authority1Urn, this.userKeys, userEmail, userUrn, userUuid, userUuidUrn);
            this.saCert = TestCertHelper.makeServerCert(this.authority1Keys, authority1Hostname, authority1Urn, this.saKeys, saEmail, saUrn, saUuid, saUuidUrn);
            this.am1Cert = TestCertHelper.makeServerCert(this.authority1Keys, authority1Hostname, authority1Urn, this.am1Keys, am1Email, am1Urn, am1Uuid, am1UuidUrn);
            this.am2Cert = TestCertHelper.makeServerCert(this.authority1Keys, authority1Hostname, authority1Urn, this.am2Keys, am2Email, am2Urn, am2Uuid, am2UuidUrn);
            this.scsCert = TestCertHelper.makeServerCert(this.authority3Keys, authority3Hostname, authority3Urn, this.scsKeys, scsEmail, "urn:publicid:IDN+authority3.example.com+authority+cm", scsUuid, scsUuidUrn);
            this.toolCert = TestCertHelper.makeToolCert(this.authority1Keys, authority1Hostname, authority1Urn, this.toolKeys, toolUrn, toolUuid, toolUuidUrn);
            this.testTrustStore = KeyStore.getInstance("jks");
            this.testTrustStore.load(null, null);
            this.testTrustStore.setCertificateEntry("testTrustRoot1", this.authority1Cert);
            this.testTrustStore.setCertificateEntry("testTrustRoot2", this.authority2Cert);
            this.testTrustStore.setCertificateEntry("testTrustRoot3", this.authority3Cert);
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating test keys and/or certificate", e);
        }
    }

    public static X509Certificate makeUserCert(SSHKeyHelper authorityKeys, String authHostname, String authUrn, SSHKeyHelper userKeys, String userEmail, String userUrn, String userUuid, String userUuidUrn) throws NoSuchAlgorithmException, IOException, CertificateException, SignatureException, NoSuchProviderException, InvalidKeyException {
        return TestCertHelper.makeUserCert(authorityKeys, authHostname, authUrn, userKeys, userEmail, userUrn, userUuid, userUuidUrn, 2);
    }

    public static X509Certificate makeUserCert(SSHKeyHelper authorityKeys, String authHostname, String authUrn, SSHKeyHelper userKeys, String userEmail, String userUrn, String userUuid, String userUuidUrn, int validityDays) throws NoSuchAlgorithmException, IOException, CertificateException, SignatureException, NoSuchProviderException, InvalidKeyException {
        RSAPublicKey pubKey = userKeys.getSshPublicKey();
        RSAPrivateKey privKey = authorityKeys.getSshPrivateKey();
        Date firstDate = new Date(System.currentTimeMillis() - 86400000L);
        Date lastDate = new Date(System.currentTimeMillis() + (long)validityDays * 24L * 60L * 60L * 1000L);
        X500Name issuer = new X500Name("CN=" + authHostname);
        X500Name subject = new X500Name("EMAILADDRESS=" + userEmail + ", CN=" + userUuid);
        BigInteger serial = BigInteger.valueOf(System.currentTimeMillis());
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(issuer, serial, firstDate, lastDate, subject, SubjectPublicKeyInfo.getInstance((Object)pubKey.getEncoded()));
        GeneralNames subjectAlternativeNames = new GeneralNames(new GeneralName[]{new GeneralName(1, userEmail), new GeneralName(6, userUrn), new GeneralName(6, userUuidUrn)});
        certBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeNames);
        try {
            return TestCertHelper.signCertificate(certBuilder, privKey);
        }
        catch (OperatorCreationException e) {
            throw new RuntimeException(e);
        }
    }

    private static X509Certificate signCertificate(X509v3CertificateBuilder certificateBuilder, PrivateKey caPrivateKey) throws OperatorCreationException, CertificateException {
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider("BC").build(caPrivateKey);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateBuilder.build(signer));
    }

    public static X509Certificate makeServerCert(SSHKeyHelper authorityKeys, String authHostname, String authUrn, SSHKeyHelper serverKeys, String serverEmail, String serverUrn, String serverUuid, String serverUuidUrn) throws NoSuchAlgorithmException, IOException, CertificateException, SignatureException, NoSuchProviderException, InvalidKeyException {
        return TestCertHelper.makeServerCert(authorityKeys, authHostname, authUrn, serverKeys, serverEmail, serverUrn, serverUuid, serverUuidUrn, 2);
    }

    public static X509Certificate makeServerCert(SSHKeyHelper authorityKeys, String authHostname, String authUrn, SSHKeyHelper serverKeys, String serverEmail, String serverUrn, String serverUuid, String serverUuidUrn, int validityDays) throws NoSuchAlgorithmException, IOException, CertificateException, SignatureException, NoSuchProviderException, InvalidKeyException {
        RSAPublicKey pubKey = serverKeys.getSshPublicKey();
        RSAPrivateKey privKey = authorityKeys.getSshPrivateKey();
        String sigAlgName = KeyUtil.getCompatibleSigAlgName((String)privKey.getAlgorithm());
        Date firstDate = new Date(System.currentTimeMillis() - 86400000L);
        Date lastDate = new Date(System.currentTimeMillis() + (long)validityDays * 24L * 60L * 60L * 1000L);
        X500Name issuer = new X500Name("CN=" + authHostname);
        X500Name subject = new X500Name("EMAILADDRESS=" + serverEmail + ", CN=" + serverUuid);
        BigInteger serial = BigInteger.valueOf(System.currentTimeMillis());
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(issuer, serial, firstDate, lastDate, subject, SubjectPublicKeyInfo.getInstance((Object)pubKey.getEncoded()));
        GeneralNames subjectAlternativeNames = new GeneralNames(new GeneralName[]{new GeneralName(1, saEmail), new GeneralName(6, saUrn), new GeneralName(6, saUuidUrn)});
        certBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeNames);
        try {
            X509Certificate cert = TestCertHelper.signCertificate(certBuilder, privKey);
            assert (Objects.equals(cert.getSubjectDN().getName(), subject.toString()));
            assert (Objects.equals(cert.getIssuerDN().getName(), issuer.toString()));
            return cert;
        }
        catch (OperatorCreationException e) {
            throw new RuntimeException(e);
        }
    }

    public static X509Certificate makeToolCert(SSHKeyHelper authorityKeys, String authHostname, String authUrn, SSHKeyHelper toolKeys, String toolUrn, String toolUuid, String toolUuidUrn) throws NoSuchAlgorithmException, IOException, CertificateException, SignatureException, NoSuchProviderException, InvalidKeyException {
        return TestCertHelper.makeToolCert(authorityKeys, authHostname, authUrn, toolKeys, toolUrn, toolUuid, toolUuidUrn, 2);
    }

    public static X509Certificate makeToolCert(SSHKeyHelper authorityKeys, String authHostname, String authUrn, SSHKeyHelper toolKeys, String toolUrn, String toolUuid, String toolUuidUrn, int validityDays) throws NoSuchAlgorithmException, IOException, CertificateException, SignatureException, NoSuchProviderException, InvalidKeyException {
        RSAPublicKey pubKey = toolKeys.getSshPublicKey();
        RSAPrivateKey privKey = authorityKeys.getSshPrivateKey();
        String sigAlgName = KeyUtil.getCompatibleSigAlgName((String)privKey.getAlgorithm());
        Date firstDate = new Date(System.currentTimeMillis() - 86400000L);
        Date lastDate = new Date(System.currentTimeMillis() + (long)validityDays * 24L * 60L * 60L * 1000L);
        X500Name issuer = new X500Name("CN=" + authHostname);
        X500Name subject = new X500Name("CN=" + toolUuid);
        BigInteger serial = BigInteger.valueOf(System.currentTimeMillis());
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(issuer, serial, firstDate, lastDate, subject, SubjectPublicKeyInfo.getInstance((Object)pubKey.getEncoded()));
        GeneralNames subjectAlternativeNames = new GeneralNames(new GeneralName[]{new GeneralName(6, toolUrn), new GeneralName(6, toolUuidUrn)});
        certBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeNames);
        try {
            X509Certificate cert = TestCertHelper.signCertificate(certBuilder, privKey);
            assert (Objects.equals(cert.getSubjectDN().getName(), subject.toString()));
            assert (Objects.equals(cert.getIssuerDN().getName(), issuer.toString()));
            return cert;
        }
        catch (OperatorCreationException e) {
            throw new RuntimeException(e);
        }
    }

    public static X509Certificate makeAuthCert(SSHKeyHelper authorityKeys, String authHostname, String authUrn) throws NoSuchAlgorithmException, IOException, CertificateException, SignatureException, NoSuchProviderException, InvalidKeyException {
        return TestCertHelper.makeAuthCert(authorityKeys, authHostname, authUrn, 2);
    }

    public static X509Certificate makeAuthCert(SSHKeyHelper authorityKeys, String authHostname, String authUrn, int validityDays) throws NoSuchAlgorithmException, IOException, CertificateException, SignatureException, NoSuchProviderException, InvalidKeyException {
        RSAPublicKey pubKey = authorityKeys.getSshPublicKey();
        RSAPrivateKey privKey = authorityKeys.getSshPrivateKey();
        String sigAlgName = KeyUtil.getCompatibleSigAlgName((String)privKey.getAlgorithm());
        Date firstDate = new Date(System.currentTimeMillis() - 86400000L);
        Date lastDate = new Date(System.currentTimeMillis() + (long)validityDays * 24L * 60L * 60L * 1000L);
        X500Name issuer = new X500Name("CN=" + authHostname);
        X500Name subject = new X500Name("CN=" + authHostname);
        BigInteger serial = BigInteger.valueOf(System.currentTimeMillis());
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(issuer, serial, firstDate, lastDate, subject, SubjectPublicKeyInfo.getInstance((Object)pubKey.getEncoded()));
        certBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(new GeneralName(6, authUrn)));
        certBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(1));
        try {
            X509Certificate cert = TestCertHelper.signCertificate(certBuilder, privKey);
            assert (Objects.equals(cert.getSubjectDN().getName(), subject.toString()));
            assert (Objects.equals(cert.getIssuerDN().getName(), issuer.toString()));
            return cert;
        }
        catch (OperatorCreationException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUserPem() {
        String privKeyPem = new String(this.userKeys.getPEMAnyPrivateKey());
        String certPem = KeyUtil.x509certificateToPem((X509Certificate)this.userCert);
        return privKeyPem + "\n" + certPem;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        userUuid = UUID.randomUUID().toString();
        userUuidUrn = "urn:uuid:" + userUuid;
        am1Uuid = UUID.randomUUID().toString();
        am1UuidUrn = "urn:uuid:" + am1Uuid;
        am2Uuid = UUID.randomUUID().toString();
        am2UuidUrn = "urn:uuid:" + am2Uuid;
        am3Uuid = UUID.randomUUID().toString();
        am3UuidUrn = "urn:uuid:" + am3Uuid;
        scsUuid = UUID.randomUUID().toString();
        scsUuidUrn = "urn:uuid:" + scsUuid;
        saUuid = UUID.randomUUID().toString();
        saUuidUrn = "urn:uuid:" + saUuid;
        sa2Uuid = UUID.randomUUID().toString();
        sa2UuidUrn = "urn:uuid:" + sa2Uuid;
        toolUuid = UUID.randomUUID().toString();
        toolUuidUrn = "urn:uuid:" + toolUuid;
    }
}

