/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.ssh_key_info;

import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.BasicSshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.GeniUserSshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.InvalidSshKeyInfoException;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.annotation.Nonnull;

public class SshKeyInfoFactory {
    private SshKeyInfoFactory() {
    }

    public static BasicSshKeyInfo createBasicSshKeyInfo(PublicKey publicKey, PrivateKey privateKey) throws InvalidSshKeyInfoException {
        if (publicKey == null || privateKey == null) {
            throw new InvalidSshKeyInfoException("Both public key and private key may not be null");
        }
        return new BasicSshKeyInfo(publicKey, privateKey);
    }

    public static BasicSshKeyInfo createBasicSshKeyInfo(KeyPair keyPair) throws InvalidSshKeyInfoException {
        if (keyPair == null || keyPair.getPrivate() == null || keyPair.getPublic() == null) {
            throw new InvalidSshKeyInfoException("Both public key and private key may not be null");
        }
        return new BasicSshKeyInfo(keyPair);
    }

    public static BasicSshKeyInfo createBasicSshKeyInfoFromPrivateKeyOnly(PrivateKey privateKey) throws InvalidSshKeyInfoException {
        if (privateKey instanceof RSAPrivateKey) {
            RSAPublicKey pubKey = KeyUtil.rsaPrivateKeyToRsaPublicKey((RSAPrivateKey)((RSAPrivateKey)privateKey));
            if (pubKey == null) {
                throw new InvalidSshKeyInfoException("Could not extract public key from the provided private key");
            }
            return SshKeyInfoFactory.createBasicSshKeyInfo(pubKey, privateKey);
        }
        throw new InvalidSshKeyInfoException("Could not extract public key from the provided private key (type: " + (privateKey != null ? privateKey.getClass().getSimpleName() : "null") + ")");
    }

    public static GeniUserSshKeyInfo createGeniUserSshKeyInfo(@Nonnull GeniUser geniUser) {
        return new GeniUserSshKeyInfo(geniUser);
    }
}

