/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.ssh_key_info.pref_ssh_key_info;

import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.InvalidSshKeyInfoException;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.pref_ssh_key_info.PreferencesPuttySshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.pref_ssh_key_info.PreferencesSshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.putty.PuTTYPrivateKeyFile;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesSshKeyInfoFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PreferencesSshKeyInfoFactory.class);

    private PreferencesSshKeyInfoFactory() {
    }

    public static PreferencesPuttySshKeyInfo createPreferencesPuttySshKeyInfo(JFedPreferences jFedPreferences, JFedPreferences.PreferenceKey overridePref, JFedPreferences.PreferenceKey puttyKeyFilePref) throws InvalidSshKeyInfoException {
        boolean overrideVal = jFedPreferences.getBoolean(overridePref);
        assert (overrideVal);
        File puttyKeyFile = jFedPreferences.getFile(puttyKeyFilePref);
        try {
            if (puttyKeyFile == null) {
                throw new InvalidSshKeyInfoException("Could not find PPK file");
            }
            PuTTYPrivateKeyFile ppk = PuTTYPrivateKeyFile.read(puttyKeyFile);
            if (ppk == null) {
                throw new InvalidSshKeyInfoException("Could not process PPK file");
            }
            return new PreferencesPuttySshKeyInfo(puttyKeyFile, ppk);
        }
        catch (IOException e) {
            LOG.error("Failed to read putty key file: " + e.getMessage(), (Throwable)e);
            throw new InvalidSshKeyInfoException("Could not read PPK file", e);
        }
    }

    public static PreferencesSshKeyInfo createPreferencesSshKeyInfo(JFedPreferences jFedPreferences, JFedPreferences.PreferenceKey overridePref, JFedPreferences.PreferenceKey pubKeyFilePref, JFedPreferences.PreferenceKey privKeyFilePref, JFedPreferences.PreferenceKey pubKeyTextPref, JFedPreferences.PreferenceKey privKeyTextPref) throws InvalidSshKeyInfoException {
        boolean overrideVal = jFedPreferences.getBoolean(overridePref);
        assert (overrideVal);
        File pubKeyFile = jFedPreferences.getFile(pubKeyFilePref);
        File privKeyFile = jFedPreferences.getFile(privKeyFilePref);
        String pubKeyText = jFedPreferences.getString(pubKeyTextPref);
        String privKeyText = jFedPreferences.getString(privKeyTextPref);
        if (privKeyFile == null && privKeyText == null) {
            throw new InvalidSshKeyInfoException("No private key was provided");
        }
        if (privKeyText == null) {
            try {
                privKeyText = IOUtils.fileToString((File)privKeyFile);
            }
            catch (IOException e) {
                LOG.debug("Could not open private key file from preferences: {}", (Object)privKeyFile.getPath(), (Object)e);
                throw new InvalidSshKeyInfoException("Could not read private key file " + privKeyFile.getAbsolutePath(), e);
            }
        }
        if (pubKeyText == null && pubKeyFile != null) {
            try {
                pubKeyText = IOUtils.fileToString((File)pubKeyFile);
            }
            catch (IOException e) {
                LOG.debug("Could not open public key file from preferences: {}", (Object)pubKeyFile.getPath(), (Object)e);
            }
        }
        return new PreferencesSshKeyInfo(privKeyFile, pubKeyFile, privKeyText, pubKeyText);
    }
}

