/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.ssh_key_info.putty;

import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import ch.ethz.ssh2.crypto.cipher.AES;
import ch.ethz.ssh2.crypto.cipher.BlockCipher;
import ch.ethz.ssh2.crypto.cipher.CBCMode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PuTTYPrivateKeyFile {
    private static final Logger LOG = LoggerFactory.getLogger(PuTTYPrivateKeyFile.class);
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private boolean encrypted;
    private Map<String, String> lines = new HashMap<String, String>();

    private PuTTYPrivateKeyFile() {
    }

    public static PuTTYPrivateKeyFile parse(String content) {
        PuTTYPrivateKeyFile res = new PuTTYPrivateKeyFile();
        res.lines = PuTTYPrivateKeyFile.contentToLines(content);
        assert (Objects.equals(res.lines.get("PuTTY-User-Key-File-2"), "ssh-rsa"));
        res.publicKey = PuTTYPrivateKeyFile.linesToPublicKey(res.lines);
        res.encrypted = PuTTYPrivateKeyFile.linesToEncrypted(res.lines);
        if (!res.isEncrypted()) {
            res.privateKey = PuTTYPrivateKeyFile.linesToPrivateKey(res.lines, null);
        }
        return res;
    }

    public static PuTTYPrivateKeyFile read(File file) throws IOException {
        String content = IOUtils.fileToString((File)file);
        return PuTTYPrivateKeyFile.parse(content);
    }

    public static boolean isPuttyPrivateKey(File file) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(file));
        String firstLine = r.readLine();
        r.close();
        return firstLine != null && PuTTYPrivateKeyFile.isPuttyPrivateKey(firstLine);
    }

    public static boolean isPuttyPrivateKey(String fileContent) {
        return fileContent.startsWith("PuTTY-User-Key-File-2");
    }

    @Nonnull
    private static Map<String, String> contentToLines(@Nonnull String content) {
        HashMap<String, String> lines = new HashMap<String, String>();
        try (BufferedReader r = new BufferedReader(new StringReader(content));){
            String line;
            while ((line = r.readLine()) != null) {
                int colonPos = line.indexOf(": ");
                if (colonPos <= 0) {
                    throw new MalformedPPKException("PPK contains invalid line: \"" + line + "\"");
                }
                String key = line.substring(0, colonPos);
                String value = line.substring(colonPos + 2);
                if (!key.endsWith("-Lines")) {
                    lines.put(key, value);
                    continue;
                }
                int lineCount = Integer.parseInt(value);
                Object fullVall = "";
                for (int i = 0; i < lineCount; ++i) {
                    String valLine = r.readLine();
                    if (valLine == null) {
                        throw new MalformedPPKException("PPK ended prematurely. Was reading " + lineCount + " lines for \"" + key + "\" but got EOF at line " + i);
                    }
                    fullVall = (String)fullVall + valLine;
                }
                lines.put(key, (String)fullVall);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return lines;
    }

    private static PublicKey linesToPublicKey(Map<String, String> lines) {
        String pk = lines.get("Public-Lines");
        if (pk == null) {
            throw new MalformedPPKException("PPK contains no \"Public-Lines\" lines");
        }
        byte[] publicLines = Base64.decodeBase64((String)pk);
        ByteBuffer bb = ByteBuffer.wrap(publicLines).order(ByteOrder.BIG_ENDIAN);
        int algoLen = bb.getInt();
        byte[] algo = new byte[algoLen];
        bb.get(algo);
        int publicExponentLen = bb.getInt();
        byte[] publicExponent = new byte[publicExponentLen];
        bb.get(publicExponent);
        BigInteger publicExponentInt = new BigInteger(publicExponent);
        int modulusLen = bb.getInt();
        byte[] modulus = new byte[modulusLen];
        bb.get(modulus);
        BigInteger modulusInt = new BigInteger(modulus);
        RSAPublicKeySpec spec = new RSAPublicKeySpec(modulusInt, publicExponentInt);
        Object res = null;
        try {
            KeyFactory keyFact = KeyFactory.getInstance("RSA");
            PublicKey key = keyFact.generatePublic(spec);
            return (RSAPublicKey)key;
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating RSAPublicKey: " + e.getMessage(), e);
        }
    }

    private static boolean linesToEncrypted(Map<String, String> lines) {
        String enc = lines.get("Encryption");
        if (enc == null) {
            throw new MalformedPPKException("PPK contains no \"Encryption\" lines");
        }
        if (Objects.equals(enc, "none")) {
            return false;
        }
        if (Objects.equals(enc, "aes256-cbc")) {
            return true;
        }
        throw new MalformedPPKException("PPK contains unsupported \"Encryption\" line: \"" + enc + "\"");
    }

    private static PrivateKey linesToPrivateKey(Map<String, String> lines, String passphrase) {
        BigInteger modulusInt;
        BigInteger publicExponentInt;
        String pk = lines.get("Private-Lines");
        if (pk == null) {
            throw new MalformedPPKException("PPK contains no \"Private-Lines\" lines");
        }
        String algorithm = lines.get("PuTTY-User-Key-File-2");
        String encryption = lines.get("Encryption");
        String publicLinesString = lines.get("Public-Lines");
        byte[] publicLines = Base64.decodeBase64((String)publicLinesString);
        ByteBuffer bb = ByteBuffer.wrap(publicLines).order(ByteOrder.BIG_ENDIAN);
        try {
            int algoLen = bb.getInt();
            byte[] algo = new byte[algoLen];
            bb.get(algo);
            int publicExponentLen = bb.getInt();
            byte[] publicExponent = new byte[publicExponentLen];
            bb.get(publicExponent);
            publicExponentInt = new BigInteger(publicExponent);
            int modulusLen = bb.getInt();
            byte[] modulus = new byte[modulusLen];
            bb.get(modulus);
            modulusInt = new BigInteger(modulus);
        }
        catch (BufferUnderflowException e) {
            LOG.error("Error reading public key PuTTY putty key file. Probably error in PuTTY key file.");
            return null;
        }
        String privateLinesString = lines.get("Private-Lines");
        byte[] privateLines = Base64.decodeBase64((String)privateLinesString);
        if (!encryption.equalsIgnoreCase("None")) {
            assert (passphrase != null);
            privateLines = PuTTYPrivateKeyFile.decryptPPkPrivateLines(encryption, passphrase, privateLines);
        }
        bb = ByteBuffer.wrap(privateLines).order(ByteOrder.BIG_ENDIAN);
        BigInteger privateExponentInt = null;
        BigInteger pInt = null;
        BigInteger qInt = null;
        BigInteger iqmpInt = null;
        try {
            int privateExponentLen = bb.getInt();
            if (privateExponentLen <= 0) {
                return null;
            }
            byte[] privateExponent = new byte[privateExponentLen];
            bb.get(privateExponent);
            privateExponentInt = new BigInteger(privateExponent);
            int pLen = bb.getInt();
            if (pLen <= 0) {
                return null;
            }
            byte[] p = new byte[pLen];
            bb.get(p);
            pInt = new BigInteger(p);
            int qLen = bb.getInt();
            if (qLen <= 0) {
                return null;
            }
            byte[] q = new byte[qLen];
            bb.get(q);
            qInt = new BigInteger(q);
            int iqmpLen = bb.getInt();
            if (iqmpLen <= 0) {
                return null;
            }
            byte[] iqmp = new byte[iqmpLen];
            bb.get(iqmp);
            iqmpInt = new BigInteger(iqmp);
        }
        catch (BufferUnderflowException e) {
            LOG.error("Error reading private key PuTTY putty key file. Probably error in PuTTY key file.");
            return null;
        }
        BigInteger dmp1 = privateExponentInt.mod(pInt.subtract(BigInteger.ONE));
        BigInteger dmq1 = privateExponentInt.mod(qInt.subtract(BigInteger.ONE));
        RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(modulusInt, publicExponentInt, privateExponentInt, pInt, qInt, dmp1, dmq1, iqmpInt);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPrivateCrtKey)keyFactory.generatePrivate(rSAPrivateCrtKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOG.error("Error while creating Rsa Private Key: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private boolean verifyMac(String passphrase) {
        String mac = this.calcMac(passphrase);
        return Objects.equals(mac, this.lines.get("Private-MAC"));
    }

    public String getComment() {
        return this.lines.get("Comment");
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public boolean unlock(String passphrase) {
        this.privateKey = PuTTYPrivateKeyFile.linesToPrivateKey(this.lines, passphrase);
        if (this.privateKey != null) {
            if (!this.verifyMac(passphrase)) {
                throw new MalformedPPKException("PPK file MAC is incorrect.");
            }
            return true;
        }
        return false;
    }

    public PrivateKey getPrivateKey() {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        assert (this.isEncrypted());
        throw new RuntimeException("PPK file is encrypted. Cannot retrieve private key without passphrase.");
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getPublicKeyOpenSshString() {
        String algo = this.lines.get("PuTTY-User-Key-File-2");
        String pubkey = this.lines.get("Public-Lines").replace("\n", "");
        String comment = this.lines.get("Comment");
        return algo + " " + pubkey + " " + comment;
    }

    private static String singleLinesMaker(Map<String, String> lines, String key) {
        String val = lines.get(key);
        return key + ": " + val + "\n";
    }

    private static String multiLinesMaker(Map<String, String> lines, String key) {
        String val = lines.get(key);
        if (val.endsWith("\n")) {
            val = val.substring(0, val.length() - 1);
        }
        int valLineCount = val.length() - val.replace("\n", "").length() + 1;
        return key + ": " + valLineCount + "\n" + val + "\n";
    }

    private static String linesToContent(Map<String, String> lines) {
        return PuTTYPrivateKeyFile.singleLinesMaker(lines, "PuTTY-User-Key-File-2") + PuTTYPrivateKeyFile.singleLinesMaker(lines, "Encryption") + PuTTYPrivateKeyFile.singleLinesMaker(lines, "Comment") + PuTTYPrivateKeyFile.multiLinesMaker(lines, "Public-Lines") + PuTTYPrivateKeyFile.multiLinesMaker(lines, "Private-Lines") + PuTTYPrivateKeyFile.singleLinesMaker(lines, "Private-MAC");
    }

    private String calcMac(String passphrase) {
        try {
            MessageDigest passMd = MessageDigest.getInstance("SHA-1");
            passMd.update("putty-private-key-file-mac-key".getBytes(Charset.forName("US-ASCII")));
            if (passphrase != null) {
                passMd.update(passphrase.getBytes(Charset.forName("US-ASCII")));
            }
            byte[] keyBytes = passMd.digest();
            SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            byte[] algoBytes = this.lines.get("PuTTY-User-Key-File-2").getBytes(Charset.forName("US-ASCII"));
            byte[] encBytes = this.lines.get("Encryption").getBytes(Charset.forName("US-ASCII"));
            byte[] commentBytes = this.lines.get("Comment").getBytes(Charset.forName("US-ASCII"));
            byte[] pubKeyBytes = Base64.decodeBase64((byte[])this.lines.get("Public-Lines").getBytes(Charset.forName("US-ASCII")));
            byte[] privKeyBytes = PuTTYPrivateKeyFile.getMacPrivateKeyBytes((RSAPrivateCrtKey)this.privateKey, passphrase);
            int totalMacLen = algoBytes.length + encBytes.length + commentBytes.length + pubKeyBytes.length + privKeyBytes.length + 20;
            byte[] macDataBytes = new byte[totalMacLen];
            ByteBuffer bbMac = ByteBuffer.wrap(macDataBytes);
            bbMac.putInt(algoBytes.length);
            bbMac.put(algoBytes);
            bbMac.putInt(encBytes.length);
            bbMac.put(encBytes);
            bbMac.putInt(commentBytes.length);
            bbMac.put(commentBytes);
            bbMac.putInt(pubKeyBytes.length);
            bbMac.put(pubKeyBytes);
            bbMac.putInt(privKeyBytes.length);
            bbMac.put(privKeyBytes);
            byte[] rawHmac = mac.doFinal(macDataBytes);
            byte[] hexBytes = new Hex().encode(rawHmac);
            return new String(hexBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            LOG.error("Failed to calculate PPK MAC: " + e.getMessage(), (Throwable)e);
            return "error";
        }
    }

    private static byte[] getMacPrivateKeyBytes(RSAPrivateCrtKey rsaPrivateCrtKey, String passphrase) {
        BigInteger privExp = rsaPrivateCrtKey.getPrivateExponent();
        BigInteger p = rsaPrivateCrtKey.getPrimeP();
        BigInteger q = rsaPrivateCrtKey.getPrimeQ();
        BigInteger iqmp = rsaPrivateCrtKey.getCrtCoefficient();
        byte[] privExpBytes = privExp.toByteArray();
        byte[] pBytes = p.toByteArray();
        byte[] qBytes = q.toByteArray();
        byte[] iqmpBytes = iqmp.toByteArray();
        int totalLen = 16 + privExpBytes.length + pBytes.length + qBytes.length + iqmpBytes.length;
        byte[] privKeyBytes = new byte[totalLen];
        ByteBuffer bb = ByteBuffer.wrap(privKeyBytes).order(ByteOrder.BIG_ENDIAN);
        bb.clear();
        bb.putInt(privExpBytes.length);
        bb.put(privExpBytes);
        bb.putInt(pBytes.length);
        bb.put(pBytes);
        bb.putInt(qBytes.length);
        bb.put(qBytes);
        bb.putInt(iqmpBytes.length);
        bb.put(iqmpBytes);
        assert (bb.position() == totalLen) : "bb.position() (" + bb.position() + ") != totalLen (" + totalLen + ")";
        if (passphrase != null) {
            return PuTTYPrivateKeyFile.padPPkPrivateLinesForEncryption(privKeyBytes);
        }
        return privKeyBytes;
    }

    private static String privateKeyToLines(PrivateKey privateKey, String passphrase) {
        byte[] privKeyBytes = PuTTYPrivateKeyFile.getMacPrivateKeyBytes((RSAPrivateCrtKey)privateKey, passphrase);
        if (passphrase != null) {
            byte[] encyPrivKeyBytes = PuTTYPrivateKeyFile.encryptPPkPrivateLines("aes256-cbc", passphrase, privKeyBytes);
            return TextUtil.wrap((String)new String(Base64.encodeBase64((byte[])encyPrivKeyBytes), Charset.forName("UTF-8")), (int)64);
        }
        return TextUtil.wrap((String)new String(Base64.encodeBase64((byte[])privKeyBytes), Charset.forName("UTF-8")), (int)64);
    }

    private static String publicKeyToLines(PublicKey publicKey) {
        String publicLine = KeyUtil.publicKeyToOpenSshAuthorizedKeysFormatData((PublicKey)publicKey);
        return TextUtil.wrap((String)publicLine, (int)64);
    }

    public static String createContent(@Nullable String comment, @Nonnull PublicKey publicKey, @Nonnull PrivateKey privateKey, @Nullable String pass) {
        PuTTYPrivateKeyFile res = new PuTTYPrivateKeyFile();
        res.publicKey = publicKey;
        res.privateKey = privateKey;
        res.encrypted = pass != null;
        res.lines.put("PuTTY-User-Key-File-2", "ssh-rsa");
        res.lines.put("Comment", comment == null ? "" : comment);
        if (pass != null) {
            res.lines.put("Encryption", "aes256-cbc");
        } else {
            res.lines.put("Encryption", "none");
        }
        res.lines.put("Public-Lines", PuTTYPrivateKeyFile.publicKeyToLines(publicKey));
        res.lines.put("Private-Lines", PuTTYPrivateKeyFile.privateKeyToLines(privateKey, pass));
        res.lines.put("Private-MAC", res.calcMac(pass));
        return PuTTYPrivateKeyFile.linesToContent(res.lines);
    }

    public static void createFile(String comment, PublicKey publicKey, PrivateKey privateKey, File file, String pass) {
        String content = PuTTYPrivateKeyFile.createContent(comment, publicKey, privateKey, pass);
        IOUtils.stringToFile((File)file, (String)content);
    }

    private static byte[] passPhraseToPuttyKey(String passphrase) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(new byte[]{0, 0, 0, 0});
            digest.update(passphrase.getBytes());
            byte[] key1 = digest.digest();
            digest.update(new byte[]{0, 0, 0, 1});
            digest.update(passphrase.getBytes());
            byte[] key2 = digest.digest();
            byte[] r = new byte[32];
            System.arraycopy(key1, 0, r, 0, 20);
            System.arraycopy(key2, 0, r, 20, 12);
            return r;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static byte[] decryptPPkPrivateLines(String encryption, String pass, byte[] data) {
        assert (data.length % 16 == 0) : "data.length=" + data.length + " data.length%16=" + data.length % 16;
        if (Objects.equals(encryption, "aes256-cbc")) {
            AES aes = new AES();
            byte[] key = PuTTYPrivateKeyFile.passPhraseToPuttyKey(pass);
            aes.init(false, key);
            CBCMode cbc = new CBCMode((BlockCipher)aes, new byte[16], false);
            LOG.trace("DEC cbc.getBlockSize()=" + cbc.getBlockSize() + " data.length=" + data.length + " d.len/bs=" + (double)data.length * 1.0 / (double)cbc.getBlockSize());
            byte[] res = new byte[data.length];
            for (int i = 0; i < data.length / cbc.getBlockSize(); ++i) {
                cbc.transformBlock(data, i * cbc.getBlockSize(), res, i * cbc.getBlockSize());
            }
            return res;
        }
        throw new RuntimeException("Unsupported encryption: \"" + encryption + "\"");
    }

    private static byte[] padPPkPrivateLinesForEncryption(byte[] data) {
        int BLOCK_SIZE = 16;
        int padded_size = data.length + 16 - 1;
        padded_size -= padded_size % 16;
        byte[] res = new byte[padded_size];
        LOG.trace("Padding " + data.length + " bytes to " + res.length + " diff=" + (res.length - data.length) + " mods:" + data.length % 16 + " to " + res.length % 16);
        System.arraycopy(data, 0, res, 0, data.length);
        if (data.length % 16 == 0) {
            return res;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(data);
            byte[] padding = digest.digest();
            System.arraycopy(padding, 0, res, data.length, res.length - data.length);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("SHA-1 not working: " + e.getMessage(), (Throwable)e);
        }
        return res;
    }

    private static byte[] encryptPPkPrivateLines(String encryption, String pass, byte[] data) {
        assert (data.length % 16 == 0) : "data.length=" + data.length + " data.length%16=" + data.length % 16;
        if (Objects.equals(encryption, "aes256-cbc")) {
            byte[] key = PuTTYPrivateKeyFile.passPhraseToPuttyKey(pass);
            assert (key.length == 32);
            AES aes = new AES();
            aes.init(true, key);
            CBCMode cbc = new CBCMode((BlockCipher)aes, new byte[16], true);
            LOG.trace("ENC cbc.getBlockSize()=" + cbc.getBlockSize() + " data.length=" + data.length + " d.len/bs=" + (double)data.length * 1.0 / (double)cbc.getBlockSize());
            byte[] res = new byte[data.length];
            for (int i = 0; i < data.length / cbc.getBlockSize(); ++i) {
                cbc.transformBlock(data, i * cbc.getBlockSize(), res, i * cbc.getBlockSize());
            }
            return res;
        }
        throw new RuntimeException("Unsupported encryption: \"" + encryption + "\"");
    }

    private static class MalformedPPKException
    extends RuntimeException {
        private MalformedPPKException() {
        }

        private MalformedPPKException(String message) {
            super(message);
        }

        private MalformedPPKException(String message, Throwable cause) {
            super(message, cause);
        }

        private MalformedPPKException(Throwable cause) {
            super(cause);
        }
    }
}

