/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.stitching;

import be.iminds.ilabt.jfed.lowlevel.stitching.StitchingData;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.jfed.util.library.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Element;

public class AdvertisementStitchInfo {
    private final String aggregateId;
    private final String aggregateUrl;
    private final String aggregateType;
    private final String nodeId;
    private final String portId;
    private final String linkId;
    private final String linkCapacity;
    private final String remoteLinkId;
    private final String vlanRangeAvailability;
    private final boolean vlanTranslation;

    private AdvertisementStitchInfo(String aggregateId, String aggregateUrl, String aggregateType, String nodeId, String portId, String linkId, String linkCapacity, String remoteLinkId, String vlanRangeAvailability, boolean vlanTranslation) {
        this.aggregateId = aggregateId;
        this.aggregateUrl = aggregateUrl;
        this.aggregateType = aggregateType;
        this.nodeId = nodeId;
        this.portId = portId;
        this.linkId = linkId;
        this.linkCapacity = linkCapacity;
        this.remoteLinkId = remoteLinkId;
        this.vlanRangeAvailability = vlanRangeAvailability;
        this.vlanTranslation = vlanTranslation;
    }

    public static List<AdvertisementStitchInfo> parse(String advertisementRspec) {
        ArrayList<AdvertisementStitchInfo> res = new ArrayList<AdvertisementStitchInfo>();
        Element stitchingElement = StitchingData.extractStitchingElementFromRspec(advertisementRspec);
        assert (stitchingElement != null) : "no stitching data in advertisement RSpec";
        List aggregateEls = XmlUtil.getDomElementChildElementsNS((Element)stitchingElement, (String)"http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", (String)"aggregate");
        for (Element aggregateEl : aggregateEls) {
            String aggregateId = aggregateEl.getAttribute("id");
            String aggregateUrl = aggregateEl.getAttribute("url");
            String aggregateType = XmlUtil.getDomElementFirstChildElementText((Element)aggregateEl, (String)"aggregatetype");
            List nodeEls = XmlUtil.getDomElementChildElementsNS((Element)stitchingElement, (String)"http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", (String)"node");
            for (Element nodeEl : nodeEls) {
                String nodeId = nodeEl.getAttribute("id");
                List portEls = XmlUtil.getDomElementChildElementsNS((Element)stitchingElement, (String)"http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", (String)"port");
                for (Element portEl : portEls) {
                    String portId = portEl.getAttribute("id");
                    List linkEls = XmlUtil.getDomElementChildElementsNS((Element)stitchingElement, (String)"http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", (String)"link");
                    for (Element linkEl : linkEls) {
                        String linkId = linkEl.getAttribute("id");
                        String linkCapacity = XmlUtil.getDomElementFirstChildElementText((Element)linkEl, (String)"capacity");
                        String remoteLinkId = XmlUtil.getDomElementFirstChildElementText((Element)linkEl, (String)"remoteLinkId");
                        Element scDescriptorEl = XmlUtil.getDomElementFirstChildElement((Element)linkEl, (String)"switchingCapabilityDescriptor");
                        Element scSpecificInfoEl = XmlUtil.getDomElementFirstChildElement((Element)scDescriptorEl, (String)"switchingCapabilitySpecificInfo");
                        Element scSpecificInfo_L2scEl = XmlUtil.getDomElementFirstChildElement((Element)scSpecificInfoEl, (String)"switchingCapabilitySpecificInfo_L2sc");
                        Element vlanRangeAvailabilityEl = XmlUtil.getDomElementFirstChildElement((Element)scSpecificInfo_L2scEl, (String)"vlanRangeAvailability");
                        Element vlanTranslationEl = XmlUtil.getDomElementFirstChildElement((Element)scSpecificInfo_L2scEl, (String)"vlanTranslation");
                        String vlanRangeAvailability = vlanRangeAvailabilityEl.getTextContent();
                        boolean vlanTranslation = Objects.equals(TextUtil.objectToBoolean((Object)vlanTranslationEl.getTextContent()), Boolean.TRUE);
                        res.add(new AdvertisementStitchInfo(aggregateId, aggregateUrl, aggregateType, nodeId, portId, linkId, linkCapacity, remoteLinkId, vlanRangeAvailability, vlanTranslation));
                    }
                }
            }
        }
        return res;
    }

    public String getAggregateId() {
        return this.aggregateId;
    }

    public String getAggregateUrl() {
        return this.aggregateUrl;
    }

    public String getAggregateType() {
        return this.aggregateType;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getPortId() {
        return this.portId;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public String getLinkCapacity() {
        return this.linkCapacity;
    }

    public String getRemoteLinkId() {
        return this.remoteLinkId;
    }

    public String getVlanRangeAvailability() {
        return this.vlanRangeAvailability;
    }

    public boolean isVlanTranslation() {
        return this.vlanTranslation;
    }
}

