/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.stitching;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.stitching.StitchingCallData;
import be.iminds.ilabt.jfed.lowlevel.stitching.StitchingHopData;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.library.XmlUtil;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StitchingData {
    private final Logger log;
    public static final String NAMESPACE_STITCHING = "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/";
    public static final String NAMESPACE_RSPEC = "http://www.geni.net/resources/rspec/3";
    private final List<StitchingHopData> stitchingHopDataList = new ArrayList<StitchingHopData>();
    private final Map<String, StitchingCallData> stitchingCallDataByAuthUrn = new HashMap<String, StitchingCallData>();
    private final List<StitchingCallData> orderedStitchingCallDataList = new ArrayList<StitchingCallData>();
    private final List<Server> orderedSfaAuths = new ArrayList<Server>();
    private final Set<Server> fakeSfaAuths = new HashSet<Server>();
    private final String scsReplyRspec;

    /*
     * WARNING - void declaration
     */
    public StitchingData(String scsReplyRspec, Map workflow, TestbedInfoSource testbedInfoSource, AuthorityFinder authFinder, Logger log) throws JFedException {
        boolean bl;
        if (log == null) {
            log = LoggerFactory.getLogger(StitchingData.class);
        }
        this.log = log;
        this.scsReplyRspec = scsReplyRspec;
        Element stitchingElement = StitchingData.extractStitchingElementFromRspec(scsReplyRspec, log);
        assert (stitchingElement != null) : "No stitching element in rspec";
        Map<String, Object> workflowData = AbstractApi.apiSpecifiesMapStringToObject(workflow);
        HashMap<String, String> aggUrnsToAggUrl = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : workflowData.entrySet()) {
            String string = entry.getKey();
            Map<String, Object> linkData = AbstractApi.apiSpecifiesMapStringToObject(entry.getValue());
            List<Map> linkDeps = AbstractApi.apiSpecifiesListOfT(Map.class, linkData.get("dependencies"));
            LinkedList<Map> hops = new LinkedList<Map>();
            hops.addAll(linkDeps);
            while (!hops.isEmpty()) {
                void var16_39;
                String string2;
                Server hopServer;
                Map<String, Object> map = AbstractApi.apiSpecifiesMapStringToObject(hops.poll());
                if (map.containsKey("dependencies")) {
                    List<Map> list = AbstractApi.apiSpecifiesListOfT(Map.class, map.get("dependencies"));
                    hops.addAll(list);
                }
                if ((hopServer = authFinder.findByUrn(string2 = AbstractApi.apiSpecifiesNullableString(map.get("aggregate_urn")), AuthorityFinder.Purpose.STITCHING)) == null) {
                    String aggregateUrlString = AbstractApi.apiSpecifiesStringInMap(map, "aggregate_url");
                    if (Objects.equals(aggregateUrlString, "https://uvanl-hn.exogeni.net:11443/orca/xmlrpc")) {
                        aggregateUrlString = "https://uva-nl-hn.exogeni.net:11443/orca/xmlrpc";
                    }
                    log.debug("Did not find authority \"" + string2 + "\" by using URN. Falling back to searching for URL \"" + aggregateUrlString + "\"");
                    if (aggregateUrlString != null) {
                        try {
                            URL aggregateUrl = new URL(aggregateUrlString);
                            hopServer = testbedInfoSource.getServerByUrl(aggregateUrl);
                            if (hopServer != null) {
                                log.debug("Found auth by URL. Real URN is: \"" + hopServer.getDefaultComponentManagerUrn() + "\"");
                            }
                        }
                        catch (MalformedURLException e) {
                            log.warn("Malformed URL in workflow aggregate_url: \"" + aggregateUrlString + "\"", (Throwable)e);
                        }
                    }
                }
                if (hopServer == null) {
                    log.warn("Could not find the authority \"" + string2 + "\" which is described in the stitching workflow. Will ignore this.");
                    this.fakeSfaAuths.add(hopServer);
                } else {
                    if (!Objects.equals(hopServer.getDefaultComponentManagerUrn(), string2)) {
                        log.debug("Hop with auth " + string2 + " will be seen as hop with auth " + hopServer.getDefaultComponentManagerUrn());
                        String string3 = hopServer.getDefaultComponentManagerUrn();
                        map.put("aggregate_urn", string3);
                    } else {
                        log.debug("Hop with auth " + string2);
                    }
                    if (hopServer.isEdgeVlan()) {
                        this.fakeSfaAuths.add(hopServer);
                    }
                }
                Object stitchingHopData = new StitchingHopData(string, map, stitchingElement, log);
                if (this.stitchingHopDataList.contains(stitchingHopData)) {
                    int i = this.stitchingHopDataList.indexOf(stitchingHopData);
                    assert (i >= 0);
                    assert (i < this.stitchingHopDataList.size());
                    stitchingHopData = this.stitchingHopDataList.get(i);
                    ((StitchingHopData)stitchingHopData).processExtraWorkflowData(string, map);
                } else {
                    this.stitchingHopDataList.add((StitchingHopData)stitchingHopData);
                }
                assert (hopServer == null || Objects.equals(((StitchingHopData)stitchingHopData).getAggregateUrn(), hopServer.getDefaultComponentManagerUrn()));
                assert (Objects.equals(((StitchingHopData)stitchingHopData).getAggregateUrn(), var16_39));
                if (aggUrnsToAggUrl.containsKey(((StitchingHopData)stitchingHopData).getAggregateUrn())) continue;
                aggUrnsToAggUrl.put(((StitchingHopData)stitchingHopData).getAggregateUrn(), ((StitchingHopData)stitchingHopData).getAggregateUrl());
            }
        }
        for (StitchingHopData stitchingHopData : this.stitchingHopDataList) {
            stitchingHopData.linkDeps(this.stitchingHopDataList);
        }
        log.debug("stitchingHopDataList=" + String.valueOf(this.stitchingHopDataList));
        HashSet<String> stitchedAuthorityUrns = new HashSet<String>();
        for (Map.Entry entry : aggUrnsToAggUrl.entrySet()) {
            String urn = (String)entry.getKey();
            String url = (String)entry.getValue();
            StitchingCallData stitchingCallData = new StitchingCallData(urn, url, testbedInfoSource, log);
            this.stitchingCallDataByAuthUrn.put(urn, stitchingCallData);
            stitchedAuthorityUrns.add(urn);
        }
        for (StitchingHopData stitchingHopData : this.stitchingHopDataList) {
            StitchingCallData stitchingCallData = this.stitchingCallDataByAuthUrn.get(stitchingHopData.getAggregateUrn());
            assert (stitchingCallData != null);
            stitchingCallData.addHopData(stitchingHopData);
        }
        for (StitchingCallData stitchingCallData : this.stitchingCallDataByAuthUrn.values()) {
            stitchingCallData.linkDeps(this.stitchingCallDataByAuthUrn.values());
        }
        log.debug("stitchedAuthorityUrns=" + String.valueOf(stitchedAuthorityUrns));
        log.debug("stitchingCallDataByAuthUrn=" + String.valueOf(this.stitchingCallDataByAuthUrn));
        boolean bl2 = false;
        HashSet<Object> hashSet = new HashSet<Object>();
        for (StitchingHopData stitchingHopData : this.stitchingHopDataList) {
            GeniUrn hopAuthUrn = GeniUrn.parse((String)stitchingHopData.getAggregateUrn());
            if (hopAuthUrn == null || !Objects.equals(hopAuthUrn.getEncodedTopLevelAuthority_withoutSubAuth(), "exogeni.net")) continue;
            if (hopAuthUrn.hasSubAuthority()) {
                hashSet.add(hopAuthUrn);
                continue;
            }
            bl = true;
        }
        if (!hashSet.isEmpty() && bl) {
            throw new JFedException("Exogeni stitching with a too complex scenario: both sub authorities and top level authority need to be involved. jFed cannot handle this.");
        }
        List<String> allAuthorityUrns = new BasicStringRspec(scsReplyRspec).getAllComponentManagerUrns();
        HashSet<String> nonStitchedAuthorityUrns = new HashSet<String>(allAuthorityUrns);
        for (String string : allAuthorityUrns) {
            try {
                boolean bl3;
                GeniUrn geniUrn = new GeniUrn(string);
                if (!Objects.equals(geniUrn.getEncodedTopLevelAuthority_withoutSubAuth(), "exogeni.net")) continue;
                if (geniUrn.hasSubAuthority() && geniUrn.getEncodedSubAuthName() != null && geniUrn.getEncodedSubAuthName().endsWith("Net")) {
                    nonStitchedAuthorityUrns.remove(string);
                    continue;
                }
                if (!geniUrn.hasSubAuthority()) {
                    if (bl3) continue;
                    if (!hashSet.isEmpty()) {
                        throw new JFedException("Exogeni stitching with a too complex scenario: both sub authorities and top level authority need to be involved. jFed cannot handle this.");
                    }
                    bl3 = true;
                    nonStitchedAuthorityUrns.add(geniUrn.toString());
                    continue;
                }
                if (bl3 || hashSet.contains(geniUrn)) continue;
                hashSet.add(geniUrn);
                nonStitchedAuthorityUrns.add(geniUrn.toString());
            }
            catch (GeniUrn.GeniUrnParseException geniUrnParseException) {
                log.warn("Could not parse URN {}. Ignoring!", (Object)string);
            }
        }
        nonStitchedAuthorityUrns.removeAll(stitchedAuthorityUrns);
        log.debug("nonStitchedAuthorityUrns=" + String.valueOf(nonStitchedAuthorityUrns));
        for (String string : nonStitchedAuthorityUrns) {
            StitchingCallData stitchingCallData = new StitchingCallData(string, null, testbedInfoSource, log);
            this.stitchingCallDataByAuthUrn.put(string, stitchingCallData);
        }
        HashMap<StitchingCallData, StitchingCallDataDepGrahpHelper> depGraphCopy = new HashMap<StitchingCallData, StitchingCallDataDepGrahpHelper>();
        for (StitchingCallData stitchingCallData : this.stitchingCallDataByAuthUrn.values()) {
            depGraphCopy.put(stitchingCallData, new StitchingCallDataDepGrahpHelper(stitchingCallData));
        }
        if (!this.stitchingCallDataByAuthUrn.isEmpty()) {
            while (this.orderedStitchingCallDataList.size() != this.stitchingCallDataByAuthUrn.size()) {
                int n = this.orderedStitchingCallDataList.size();
                for (StitchingCallDataDepGrahpHelper h : depGraphCopy.values()) {
                    if (!h.dependencies.isEmpty() || this.orderedStitchingCallDataList.contains(h.s)) continue;
                    for (StitchingCallData dep : h.dependingOnThis) {
                        StitchingCallDataDepGrahpHelper hDep = (StitchingCallDataDepGrahpHelper)depGraphCopy.get(dep);
                        hDep.dependencies.remove(h.s);
                    }
                    h.dependingOnThis.clear();
                    this.orderedStitchingCallDataList.add(h.s);
                }
                if (n != this.orderedStitchingCallDataList.size()) continue;
                throw new JFedException("Loop in depgraph (size stays " + n + " targetsize=" + this.stitchingCallDataByAuthUrn.size() + "): unlooped: " + String.valueOf(this.orderedStitchingCallDataList) + " all: " + String.valueOf(depGraphCopy.values()));
            }
        }
        boolean bl4 = false;
        ArrayList<GeniUrn> arrayList = new ArrayList<GeniUrn>();
        for (StitchingCallData dep : this.orderedStitchingCallDataList) {
            GeniUrn serverUrn;
            assert (!this.orderedSfaAuths.contains(dep.getServer())) : "duplicate auth: " + String.valueOf(this.orderedSfaAuths) + " + " + String.valueOf(dep.getServer());
            try {
                serverUrn = new GeniUrn(dep.getServer().getDefaultComponentManagerUrn());
            }
            catch (GeniUrn.GeniUrnParseException e) {
                throw new JFedException("Failed to parse server URN: \"" + dep.getServer().getDefaultComponentManagerUrn() + "\" for server " + String.valueOf(dep.getServer().getId()));
            }
            boolean isExoGeni = Objects.equals(serverUrn.getEncodedTopLevelAuthority_withoutSubAuth(), "exogeni.net");
            if (isExoGeni) {
                boolean bl5;
                assert (!bl5) : "more then one exogeni auth: " + String.valueOf(this.orderedSfaAuths) + " + " + String.valueOf(dep.getServer());
                bl5 = true;
            }
            this.orderedSfaAuths.add(dep.getServer());
            arrayList.add(serverUrn);
        }
        log.debug("orderedSfaAuthUrns=" + String.valueOf(arrayList));
    }

    public static Element extractStitchingElementFromRspec(String rspec) {
        return StitchingData.extractStitchingElementFromRspec(rspec, null);
    }

    public static Element extractStitchingElementFromRspec(String rspec, @Nullable Logger log) {
        if (log == null) {
            log = LoggerFactory.getLogger(StitchingData.class);
        }
        try {
            NodeList stitchingList;
            Document doc = XmlUtil.parseXmlFromString((String)rspec, (boolean)true);
            doc.getDocumentElement().normalize();
            NodeList rspecListNS = doc.getElementsByTagNameNS(NAMESPACE_RSPEC, "rspec");
            NodeList rspecList = rspecListNS.getLength() == 0 ? doc.getElementsByTagName("rspec") : rspecListNS;
            assert (rspecList.getLength() == 1) : "not a single rspec element, but " + rspecList.getLength() + " in " + rspec;
            Node rspecNode = rspecList.item(0);
            assert (rspecNode != null);
            assert (rspecNode.getNodeType() == 1);
            Element rspecElement = (Element)rspecNode;
            NodeList stitchingListNS = rspecElement.getElementsByTagNameNS(NAMESPACE_STITCHING, "stitching");
            if (stitchingListNS.getLength() == 0) {
                NodeList stitchingListNoNS = rspecElement.getElementsByTagName("stitching");
                if (stitchingListNoNS.getLength() == 0) {
                    return null;
                }
                stitchingList = stitchingListNoNS;
            } else {
                stitchingList = stitchingListNS;
            }
            assert (stitchingList.getLength() == 1) : "not a single stitching element, but " + stitchingList.getLength() + " in " + rspec;
            Node stitchingNode = stitchingList.item(0);
            assert (stitchingNode != null);
            assert (stitchingNode.getNodeType() == 1);
            return (Element)stitchingNode;
        }
        catch (IOException | SAXException e) {
            log.error("Error parsing rspec", (Throwable)e);
            return null;
        }
    }

    public String getCurrentRequestRspec(Collection<GeniUrn> aggUrnsNotSupportingAny, boolean useExpires, @Nullable Date expireDate) {
        this.log.trace("getCurrentRequestRspec");
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new InputSource(new StringReader(this.scsReplyRspec)));
            assert (doc != null);
            doc.getDocumentElement().normalize();
            Element root = doc.getDocumentElement();
            NodeList rspecList = doc.getElementsByTagNameNS(NAMESPACE_RSPEC, "rspec");
            assert (rspecList.getLength() == 1) : "not a single rspec element, but " + rspecList.getLength() + " in " + this.scsReplyRspec;
            Node rspecNode = rspecList.item(0);
            assert (rspecNode != null);
            assert (rspecNode.getNodeType() == 1);
            Element rspecElement = (Element)rspecNode;
            if (useExpires) {
                if (expireDate != null) {
                    rspecElement.setAttribute("expires", RFC3339Util.dateToRFC3339String((Date)expireDate, (boolean)true));
                }
            } else {
                rspecElement.removeAttribute("expires");
            }
            NodeList stitchingListNoNS = rspecElement.getElementsByTagNameNS(NAMESPACE_STITCHING, "stitching");
            assert (stitchingListNoNS.getLength() == 1) : "not a single stitching element, but " + stitchingListNoNS.getLength() + " in " + this.scsReplyRspec;
            Node stitchingNode = stitchingListNoNS.item(0);
            assert (stitchingNode != null);
            assert (stitchingNode.getNodeType() == 1);
            Element stitchingElement = (Element)stitchingNode;
            List pathEls = XmlUtil.getDomElementChildElementsNS((Element)stitchingElement, (String)NAMESPACE_STITCHING, (String)"path");
            for (Element pathEl : pathEls) {
                String linkName = pathEl.getAttribute("id");
                assert (linkName != null) : "<stitching> has <path> element without id attribute: " + String.valueOf(pathEl);
                List origHopElements = XmlUtil.getDomElementChildElementsNS((Element)pathEl, (String)NAMESPACE_STITCHING, (String)"hop");
                this.log.trace("getCurrentRequestRspec() rewriting path with link id=" + linkName + " orig el count: " + origHopElements.size());
                for (Element hopElement : origHopElements) {
                    hopElement.getParentNode().removeChild(hopElement);
                }
                ArrayList<StitchingHopData> filteredHopData = new ArrayList<StitchingHopData>(this.stitchingHopDataList);
                ListIterator it = filteredHopData.listIterator();
                while (it.hasNext()) {
                    StitchingHopData hop = (StitchingHopData)it.next();
                    if (Objects.equals(hop.getLinkName(), linkName)) continue;
                    it.remove();
                }
                ArrayList<StitchingHopData> sortedHopData = new ArrayList<StitchingHopData>(filteredHopData);
                sortedHopData.sort(Comparator.comparing(StitchingHopData::getRspecStitchingHopId));
                HashMap<StitchingHopData, CallSite> hopDataToFixedVlans = new HashMap<StitchingHopData, CallSite>();
                for (StitchingHopData hop : sortedHopData) {
                    assert (hop != null);
                    for (StitchingHopData depHop : hop.getDependencies()) {
                        Integer fixVlan;
                        if (depHop.getStitchingExtensionSource() != StitchingHopData.StitchingExtensionSource.MANIFEST || (fixVlan = depHop.getSuggestedVlan()) == null) continue;
                        hopDataToFixedVlans.put(hop, (CallSite)((Object)("" + fixVlan)));
                    }
                }
                this.log.debug("hopDataToFixedVlans=" + String.valueOf(hopDataToFixedVlans));
                for (StitchingHopData hop : sortedHopData) {
                    Element rspecStitchingHopElement;
                    assert (hop != null);
                    boolean useAny = true;
                    GeniUrn hopAggregateU = GeniUrn.parse((String)hop.getAggregateUrn());
                    if (hopAggregateU == null) {
                        useAny = false;
                    } else {
                        String hopAggregateTLA = hopAggregateU.getEncodedTopLevelAuthority_withoutSubAuth();
                        for (GeniUrn aggUrn : aggUrnsNotSupportingAny) {
                            if (!Objects.equals(aggUrn.getEncodedTopLevelAuthority_withoutSubAuth(), hopAggregateTLA)) continue;
                            useAny = false;
                        }
                    }
                    this.log.debug("useAny=" + useAny + " for " + hop.getAggregateUrn());
                    String fixedVlan = (String)hopDataToFixedVlans.get(hop);
                    if (fixedVlan != null) {
                        this.log.debug("using fixed vlan (" + fixedVlan + ") (due to dep) for " + hop.getAggregateUrn());
                        rspecStitchingHopElement = hop.getRspecStitchingHopElement(fixedVlan, fixedVlan);
                    } else {
                        rspecStitchingHopElement = hop.getRspecStitchingHopElement(useAny);
                    }
                    assert (rspecStitchingHopElement != null);
                    Node importedNode = doc.importNode(rspecStitchingHopElement, true);
                    assert (importedNode != null);
                    pathEl.appendChild(importedNode);
                }
            }
            try {
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer transformer = transFactory.newTransformer();
                StringWriter buffer = new StringWriter();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(new DOMSource(rspecNode), new StreamResult(buffer));
                return buffer.toString();
            }
            catch (TransformerConfigurationException e) {
                this.log.error("TransformerConfigurationException in getCurrentRequestRspec()", (Throwable)e);
            }
            catch (TransformerException e) {
                this.log.error("TransformerException in getCurrentRequestRspec()", (Throwable)e);
            }
        }
        catch (Exception e) {
            this.log.error("Exception in getCurrentRequestRspec()", (Throwable)e);
        }
        return null;
    }

    public List<StitchingCallData> getOrderedStitchingCallDataList() {
        return this.orderedStitchingCallDataList;
    }

    public StitchingCallData getStitchingCallData(String authUrn) {
        return this.stitchingCallDataByAuthUrn.get(authUrn);
    }

    public List<StitchingHopData> getStitchingHopDataList() {
        return this.stitchingHopDataList;
    }

    public List<Server> getOrderedSfaAuths() {
        return this.orderedSfaAuths;
    }

    public Collection<Server> getFakeSfaAuths() {
        return this.fakeSfaAuths;
    }

    public String toString() {
        Object orderedStitchingCallDataListString = "{";
        for (StitchingCallData stitchingCallData : this.orderedStitchingCallDataList) {
            orderedStitchingCallDataListString = (String)orderedStitchingCallDataListString + "\n    " + String.valueOf(stitchingCallData);
        }
        orderedStitchingCallDataListString = (String)orderedStitchingCallDataListString + "}";
        return "StitchingData{orderedStitchingCallDataList=" + (String)orderedStitchingCallDataListString + "}";
    }

    private static class StitchingCallDataDepGrahpHelper {
        final List<StitchingCallData> dependencies = new ArrayList<StitchingCallData>();
        final List<StitchingCallData> dependingOnThis = new ArrayList<StitchingCallData>();
        final StitchingCallData s;

        public StitchingCallDataDepGrahpHelper(StitchingCallData s) {
            this.s = s;
            this.dependencies.addAll(s.getDependencies());
            this.dependingOnThis.addAll(s.getDependingOnThis());
        }

        public String toString() {
            return "{" + String.valueOf(this.s.getServer()) + " deps=" + this.dependencies.size() + " depOnThis=" + this.dependingOnThis.size() + "}";
        }
    }
}

