/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.stitching;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager2;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager3;
import be.iminds.ilabt.jfed.lowlevel.api.StitchingComputationService;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.stitching.StitchingCallData;
import be.iminds.ilabt.jfed.lowlevel.stitching.StitchingData;
import be.iminds.ilabt.jfed.lowlevel.stitching.StitchingHopData;
import be.iminds.ilabt.jfed.lowlevel.stitching.VlanRange;
import be.iminds.ilabt.jfed.lowlevel.stitching.info.Hop;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StitchingDirector {
    public static final Logger ACTUAL_LOG = LoggerFactory.getLogger(StitchingDirector.class);
    @Nonnull
    private final Logger log;
    public static final int MAX_UNAVAILABLE_VLANS_BEFORE_GIVEUP = 5;
    private static final boolean AUTOMATIC_NEXT_SUGGESTED_VLAN = true;
    @Nonnull
    private final TestbedInfoSource testbedInfoSource;
    @Nonnull
    private final AuthorityFinder authFinder;
    @Nullable
    private final Date expireDate;
    private boolean insecure;
    private StitchingComputationService.ComputePathResult computePathResult;
    private StitchingData computePathResultStitchingData;
    private final Set<Server> allAuthorities = new HashSet<Server>();
    private final Set<Server> activelyInvolvedAuthorities = new HashSet<Server>();
    private final Set<GeniUrn> aggUrnsNotSupportingAny = new HashSet<GeniUrn>();
    private boolean gaveUp = false;
    private static final Pattern UNAVAILABLE_VLAN_PATTERN_1 = Pattern.compile("vlan tag ([0-9]*) for .* not available");
    private static final Pattern UNAVAILABLE_VLAN_PATTERN_2 = Pattern.compile(".*requested VLAN unavailable.* VLAN=([0-9]*)".toLowerCase());

    public StitchingDirector(@Nonnull TestbedInfoSource testbedInfoSource, @Nonnull AuthorityFinder authFinder, @Nullable Date expireDate, @Nonnull Logger log) {
        this.testbedInfoSource = testbedInfoSource;
        this.authFinder = authFinder;
        this.expireDate = expireDate;
        this.log = log;
    }

    public StitchingDirector(TestbedInfoSource testbedInfoSource, AuthorityFinder authFinder, @Nullable Date expireDate) {
        this(testbedInfoSource, authFinder, expireDate, ACTUAL_LOG);
    }

    public synchronized void setComputePathResult(@Nonnull StitchingComputationService.ComputePathResult computePathResult) throws JFedException {
        this.computePathResult = computePathResult;
        assert (computePathResult.getWorkflowData() != null);
        this.computePathResultStitchingData = new StitchingData(computePathResult.getServiceRspec(), computePathResult.getWorkflowData(), this.testbedInfoSource, this.authFinder, this.log);
        this.log.debug("setComputePathResult created new computePathResultStitchingData. size=" + this.computePathResultStitchingData.getOrderedStitchingCallDataList().size());
        for (StitchingCallData stitchingCallData : this.computePathResultStitchingData.getOrderedStitchingCallDataList()) {
            if (!stitchingCallData.getServer().isEdgeVlan()) {
                this.allAuthorities.add(stitchingCallData.getServer());
            }
            if (stitchingCallData.getServer().hasFlag(Server.Flag.featureStitchingAny)) continue;
            try {
                this.aggUrnsNotSupportingAny.add(new GeniUrn(stitchingCallData.getServer().getDefaultComponentManagerUrn()));
            }
            catch (GeniUrn.GeniUrnParseException e) {
                throw new JFedException("Failed to parse server defaultComponentManagerUrn: \"" + stitchingCallData.getServer().getDefaultComponentManagerUrn() + "\"", (Throwable)e);
            }
        }
        this.log.debug("setComputePathResult allAuthorities.size=" + this.allAuthorities.size());
        if (this.log.isDebugEnabled()) {
            Object tmp = "";
            for (Server auth : this.allAuthorities) {
                tmp = (String)tmp + auth.getDefaultComponentManagerUrn() + " ";
            }
            this.log.debug("setComputePathResult allAuthorities=" + (String)tmp);
        }
    }

    public synchronized List<StitchAction> getStitchActions() {
        assert (this.computePathResult != null) : "Call setComputePathResult first";
        assert (this.computePathResultStitchingData != null) : "Call setComputePathResult first";
        ArrayList<StitchAction> res = new ArrayList<StitchAction>();
        for (StitchingCallData stitchingCallData : this.computePathResultStitchingData.getOrderedStitchingCallDataList()) {
            StitchAction stitchAction;
            if (stitchingCallData.getServer() == null || stitchingCallData.getServer().isEdgeVlan()) {
                if (stitchingCallData.getServer() == null) {
                    this.log.debug("getStitchActions() stitchingCallData.getAuth() == null");
                }
                if (!stitchingCallData.getServer().isEdgeVlan()) continue;
                this.log.debug("getStitchActions() stitchingCallData.getAuth().isEdgeVlan()");
                continue;
            }
            if (stitchingCallData.getState() == StitchingCallData.State.MUST_DELETE) {
                this.log.debug("getStitchActions() creates DELETE StitchAction for " + stitchingCallData.getServer().getUrnTld());
                stitchAction = new StitchAction(StichActionType.DELETE, stitchingCallData.getServer(), null, null, stitchingCallData);
                stitchingCallData.setState(StitchingCallData.State.DELETING);
                res.add(stitchAction);
            }
            if (stitchingCallData.needsAdvertisementRspec() && stitchingCallData.getState() == StitchingCallData.State.NONE) {
                this.log.debug("getStitchActions() creates LISTRESOURCES StitchAction for " + stitchingCallData.getServer().getUrnTld());
                stitchAction = new StitchAction(StichActionType.LISTRESOURCES, stitchingCallData.getServer(), null, null, stitchingCallData);
                stitchingCallData.setState(StitchingCallData.State.LISTING_RESOURCES);
                res.add(stitchAction);
            }
            if (!stitchingCallData.areAllDepsReady() || !stitchingCallData.areAllDependingOnThisReady() || stitchingCallData.getState() != StitchingCallData.State.NONE) continue;
            boolean addExpires = stitchingCallData.getServer().hasFlag(Server.Flag.workaroundAddExpiresAttributeToRequestRspec);
            this.log.debug("getStitchActions() creates ALLOCATE StitchAction for " + stitchingCallData.getServer().getUrnTld() + " vlans=" + String.valueOf(stitchingCallData.getSuggestedVlans()) + " addExpires=" + addExpires + " expireDate=" + String.valueOf(this.expireDate));
            StitchAction stitchAction2 = new StitchAction(StichActionType.ALLOCATE, stitchingCallData.getServer(), this.computePathResultStitchingData.getCurrentRequestRspec(this.aggUrnsNotSupportingAny, addExpires, this.expireDate), stitchingCallData.getSuggestedVlans(), stitchingCallData);
            stitchingCallData.setState(StitchingCallData.State.ALLOCATING);
            res.add(stitchAction2);
        }
        return res;
    }

    public boolean areAnyActionsLeft() {
        assert (this.computePathResult != null) : "Call setComputePathResult first";
        assert (this.computePathResultStitchingData != null) : "Call setComputePathResult first";
        if (this.gaveUp) {
            return false;
        }
        for (StitchingCallData stitchingCallData : this.computePathResultStitchingData.getOrderedStitchingCallDataList()) {
            if (stitchingCallData.getServer() == null || stitchingCallData.getServer().isEdgeVlan()) continue;
            if (stitchingCallData.getState() != StitchingCallData.State.ALLOCATED) {
                return true;
            }
            if (!stitchingCallData.areAllDepsReady()) {
                return true;
            }
            if (stitchingCallData.isAllocated()) continue;
            return true;
        }
        return false;
    }

    public boolean isGaveUp() {
        return this.gaveUp;
    }

    public synchronized Map<String, List<Hop>> getHopOverview() {
        HashMap<String, Hop> hopsByUrn = new HashMap<String, Hop>();
        for (StitchingCallData stitchingCallData : this.computePathResultStitchingData.getOrderedStitchingCallDataList()) {
            for (StitchingHopData hopData : stitchingCallData.getAllHopData()) {
                Hop hop = new Hop(hopData.getLinkName(), stitchingCallData.getAuthUrnString(), stitchingCallData.getState(), hopData.getHopUrn(), hopData.getAvailableVlans(), new VlanRange(hopData.getUnavailableVlans()), hopData.getSuggestedVlan(), stitchingCallData.getState() == StitchingCallData.State.ALLOCATED ? hopData.getLastManifestVlan() : null, hopData.getImportVlans(), Collections.emptyList(), Collections.emptyList());
                assert (!hopsByUrn.containsKey(hop.getHopUrn())) : "hopsByUrn already contains " + hop.getHopUrn();
                hopsByUrn.put(hop.getHopUrn(), hop);
            }
        }
        HashMap<String, List<Hop>> res = new HashMap<String, List<Hop>>();
        for (StitchingCallData stitchingCallData : this.computePathResultStitchingData.getOrderedStitchingCallDataList()) {
            for (StitchingHopData hopData : stitchingCallData.getAllHopData()) {
                Hop h;
                List<StitchingHopData> depOn = hopData.getDependencies();
                List<StitchingHopData> depOnThis = hopData.getDependingOnThis();
                Hop hop = (Hop)hopsByUrn.get(hopData.getHopUrn());
                assert (hop != null);
                ArrayList<Hop> hopDepOn = new ArrayList<Hop>();
                ArrayList<Hop> hopDepOnThis = new ArrayList<Hop>();
                for (StitchingHopData shd : depOn) {
                    h = (Hop)hopsByUrn.get(shd.getHopUrn());
                    assert (h != null);
                    hopDepOn.add(h);
                }
                for (StitchingHopData shd : depOnThis) {
                    h = (Hop)hopsByUrn.get(shd.getHopUrn());
                    assert (h != null);
                    hopDepOnThis.add(h);
                }
                Hop newHop = new Hop(hop, hopDepOn, hopDepOnThis);
                if (!res.containsKey(hop.getLinkName())) {
                    res.put(hop.getLinkName(), new ArrayList());
                }
                ((List)res.get(newHop.getLinkName())).add(newHop);
            }
        }
        return res;
    }

    public synchronized List<Server> getHopsLeft() {
        assert (this.computePathResult != null) : "Call setComputePathResult first";
        assert (this.computePathResultStitchingData != null) : "Call setComputePathResult first";
        return this.computePathResultStitchingData.getOrderedStitchingCallDataList().stream().filter(stitchingCallData -> !stitchingCallData.isAllocated() && !stitchingCallData.getServer().isEdgeVlan()).map(StitchingCallData::getServer).collect(Collectors.toList());
    }

    public static boolean isUnavailableVlan(AbstractGeniAggregateManager.AggregateManagerReply reply) {
        if (reply == null) {
            return false;
        }
        if (reply.getGeniResponseCode() == null) {
            return false;
        }
        if (reply.getOutput() == null) {
            return false;
        }
        if (Objects.equals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_VLAN_UNAVAILABLE)) {
            return true;
        }
        if (reply.getValue() != null && (reply.getValue() instanceof AggregateManager3.AllocateAndProvisionInfo || reply.getValue() instanceof AggregateManager3.StatusInfo)) {
            List<AggregateManager3.SliverInfo> sliverInfos;
            if (reply.getValue() instanceof AggregateManager3.AllocateAndProvisionInfo) {
                sliverInfos = ((AggregateManager3.AllocateAndProvisionInfo)reply.getValue()).getSliverInfo();
            } else {
                assert (reply.getValue() instanceof AggregateManager3.StatusInfo);
                sliverInfos = ((AggregateManager3.StatusInfo)reply.getValue()).getSliverInfo();
            }
            if (sliverInfos != null) {
                for (AggregateManager3.SliverInfo si : sliverInfos) {
                    if (si.getOperationalStatus() != null && !si.getOperationalStatus().equals("geni_failed")) continue;
                    if (si.getError() != null && si.getError().toLowerCase().matches("vlan [0-9]* is unavailable")) {
                        return true;
                    }
                    if (si.getError() == null || !si.getError().toLowerCase().matches("VLAN PCE(PCE_CREATE_FAILED): 'There are no VLANs available on link .* on reservation .* in VLAN PCE'".toLowerCase())) continue;
                    return true;
                }
            }
        }
        if (reply.getGeniResponseCode().isSuccess() && reply.getValue() != null && reply.getValue() instanceof AggregateManager2.SliverStatus) {
            AggregateManager2.SliverStatus status = (AggregateManager2.SliverStatus)reply.getValue();
            if (status.getStatus().equalsIgnoreCase("failed") || status.getStatus().equalsIgnoreCase("fail")) {
                for (AggregateManager2.SliverStatus.ResourceStatus rs : status.getResources()) {
                    String error;
                    String string = error = rs.getError() == null ? null : rs.getError().toLowerCase();
                    if (error != null && error.matches("vlan [0-9]* is unavailable")) {
                        return true;
                    }
                    if (error == null || !error.matches(".*There are no VLANs available on link .* on reservation .* in VLAN PCE.*".toLowerCase())) continue;
                    return true;
                }
            }
            return false;
        }
        if (reply.getGeniResponseCode().equals((Object)GeniAMResponseCode.GENIRESPONSE_BADARGS) || reply.getGeniResponseCode().equals((Object)GeniAMResponseCode.GENIRESPONSE_ERROR)) {
            Object output = reply.getOutput().toLowerCase();
            if (reply.getValue() != null && reply.getValue() instanceof String) {
                output = (String)output + ((String)reply.getValue()).toLowerCase();
            } else if (reply.getRawValue() != null && reply.getRawValue() instanceof String) {
                output = (String)output + ((String)reply.getRawValue()).toLowerCase();
            }
            if (((String)output).startsWith("vlan tag") && ((String)output).endsWith("not available")) {
                return true;
            }
            if (((String)output).startsWith("Exception: requested VLAN unavailable".toLowerCase())) {
                return true;
            }
            if (((String)output).contains("requested VLAN unavailable".toLowerCase())) {
                return true;
            }
            if (((String)output).contains("Error in building the dependency tree, probably not available vlan path OR trying to reuse a stitching tag".toLowerCase())) {
                return true;
            }
        }
        return false;
    }

    public static Integer getUnavailableVlan(AbstractGeniAggregateManager.AggregateManagerReply reply) {
        return StitchingDirector.getUnavailableVlan(reply, null);
    }

    public static Integer getUnavailableVlan(AbstractGeniAggregateManager.AggregateManagerReply reply, Logger log) {
        Matcher m2;
        if (log == null) {
            log = LoggerFactory.getLogger(StitchingDirector.class);
        }
        if (reply == null) {
            return null;
        }
        if (reply.getOutput() == null) {
            return null;
        }
        Matcher matchingMatcher = null;
        Matcher m1 = UNAVAILABLE_VLAN_PATTERN_1.matcher(reply.getOutput().toLowerCase());
        if (m1.matches()) {
            matchingMatcher = m1;
        }
        if (matchingMatcher == null && (m2 = UNAVAILABLE_VLAN_PATTERN_2.matcher(reply.getOutput().toLowerCase())).matches()) {
            matchingMatcher = m2;
        }
        if (matchingMatcher != null) {
            String vlanPart = matchingMatcher.group(1);
            log.trace("detected that vlan \"" + vlanPart + "\" is unavailable.");
            try {
                return Integer.parseInt(vlanPart);
            }
            catch (NumberFormatException e) {
                log.warn("Could not find vlan in returned error output \"" + reply.getOutput() + "\" (because the found \"" + vlanPart + " is not an integer\")");
                return null;
            }
        }
        log.warn("Could not find vlan in returned error output \"" + reply.getOutput() + "\"");
        return null;
    }

    public static boolean isAnyNotSupported(AbstractGeniAggregateManager.AggregateManagerReply reply) {
        if (reply == null) {
            return false;
        }
        if (reply.getGeniResponseCode() == null) {
            return false;
        }
        if (reply.getOutput() == null) {
            return false;
        }
        if (reply.getOutput().equalsIgnoreCase("vlan range any is invalid")) {
            return true;
        }
        if (reply.getOutput().contains("vlan") && reply.getOutput().contains("any")) {
            return true;
        }
        return !reply.getGeniResponseCode().isSuccess() && reply.getOutput() != null && reply.getOutput().contains("any") && reply.getOutput().length() < 100;
    }

    public synchronized void processDeleteResult(@Nonnull Server auth) throws JFedException {
        this.log.debug("processDeleteResult(" + auth.getDefaultComponentManagerUrn() + ")");
        StitchingCallData authStitchingCallData = null;
        for (StitchingCallData curStitchingCallData : this.computePathResultStitchingData.getOrderedStitchingCallDataList()) {
            if (!Objects.equals(curStitchingCallData.getServer(), auth)) continue;
            authStitchingCallData = curStitchingCallData;
            break;
        }
        assert (authStitchingCallData != null);
        assert (this.gaveUp || authStitchingCallData.getState() == StitchingCallData.State.DELETING);
        this.deleteDeps(authStitchingCallData);
        authStitchingCallData.setState(StitchingCallData.State.NONE);
    }

    public synchronized void processListResourcesResult(@Nonnull Server auth, @Nullable String advertisementRspec) {
        this.log.debug("processListResourcesResult(" + auth.getDefaultComponentManagerUrn() + ", rspec.length=" + (advertisementRspec == null ? null : Integer.valueOf(advertisementRspec.length())) + ")");
        StitchingCallData authStitchingCallData = null;
        for (StitchingCallData curStitchingCallData : this.computePathResultStitchingData.getOrderedStitchingCallDataList()) {
            if (!Objects.equals(curStitchingCallData.getServer(), auth)) continue;
            authStitchingCallData = curStitchingCallData;
            break;
        }
        assert (authStitchingCallData != null);
        if (authStitchingCallData.getState() == StitchingCallData.State.LISTING_RESOURCES) {
            authStitchingCallData.setState(StitchingCallData.State.NONE);
        }
        authStitchingCallData.seeAdvertismentRspec(advertisementRspec);
    }

    private void deleteDeps(StitchingCallData target) throws JFedException {
        int safety = 0;
        LinkedList<StitchingCallData> dependingOnThis = new LinkedList<StitchingCallData>(target.getDependingOnThis());
        while (!dependingOnThis.isEmpty()) {
            StitchingCallData depStitchingCallData = (StitchingCallData)dependingOnThis.removeFirst();
            if (depStitchingCallData.getState() == StitchingCallData.State.ALLOCATED) {
                depStitchingCallData.setState(StitchingCallData.State.MUST_DELETE);
            }
            if (depStitchingCallData.getState() == StitchingCallData.State.ALLOCATING) {
                depStitchingCallData.setState(StitchingCallData.State.ALLOCATING_BUT_MUST_DELETE);
            }
            dependingOnThis.addAll(depStitchingCallData.getDependingOnThis());
            if (safety++ <= 50) continue;
            throw new JFedException("Detected possible infinite loop! (looped " + safety + " times)" + String.valueOf(dependingOnThis));
        }
    }

    public synchronized void reportGiveup() {
        this.gaveUp = true;
    }

    public synchronized AllocateVerdict reportReadyForRetry(Server auth) {
        return this.reportMustDelete(auth, false, true);
    }

    public synchronized AllocateVerdict reportMustDelete(Server auth, boolean vlansUnavailable, boolean forceAllocateFinished) {
        this.log.debug("reportMustDelete(" + auth.getDefaultComponentManagerUrn() + ", " + vlansUnavailable + ", " + forceAllocateFinished + ")");
        assert (auth.getDefaultComponentManagerUrn() != null);
        StitchingCallData stitchingCallData = this.computePathResultStitchingData.getStitchingCallData(auth.getDefaultComponentManagerUrn());
        if (stitchingCallData == null) {
            this.log.warn("Unexpected: no stitchingCallData found for " + auth.getDefaultComponentManagerUrn() + " (is exogeni cause?). Doing fallback: ignoring the mustDelete.");
            return AllocateVerdict.DIRECTOR_ACTION;
        }
        this.log.debug("reportMustDelete auth state=" + String.valueOf((Object)stitchingCallData.getState()));
        if (stitchingCallData.getState() == StitchingCallData.State.DELETING) {
            this.log.debug("reportMustDelete return DIRECTOR_ACTION -> already deleting: nothing to do");
            return AllocateVerdict.DIRECTOR_ACTION;
        }
        assert (stitchingCallData.getState() == StitchingCallData.State.ALLOCATED || stitchingCallData.getState() == StitchingCallData.State.ALLOCATING) : "reportMustDelete Unexpected state: " + String.valueOf((Object)stitchingCallData.getState());
        if (forceAllocateFinished) {
            assert (stitchingCallData.getState() == StitchingCallData.State.ALLOCATING) : "reportMustDelete forceAllocateFinished=true Unexpected state: " + String.valueOf((Object)stitchingCallData.getState());
            if (stitchingCallData.getState() == StitchingCallData.State.ALLOCATING) {
                stitchingCallData.setState(StitchingCallData.State.MUST_DELETE);
            }
        } else if (stitchingCallData.getState() == StitchingCallData.State.ALLOCATING) {
            stitchingCallData.setState(StitchingCallData.State.ALLOCATING_BUT_MUST_DELETE);
        } else {
            stitchingCallData.setState(StitchingCallData.State.MUST_DELETE);
        }
        if (vlansUnavailable) {
            HashSet<Integer> vlansUsed = new HashSet<Integer>();
            for (StitchingHopData hopData : stitchingCallData.getAllHopData()) {
                this.log.debug("reportMustDelete  searches vlans in use at hop " + hopData.getHopUrn() + ": " + hopData.getLastManifestVlan());
                Integer vlan = hopData.getLastManifestVlan();
                if (vlan == null) continue;
                vlansUsed.add(vlan);
            }
            this.log.debug("reportMustDelete will mark the following vlans as unavailable: " + String.valueOf(vlansUsed));
            Iterator<StitchingHopData> iterator = vlansUsed.iterator();
            while (iterator.hasNext()) {
                int vlan = (Integer)((Object)iterator.next());
                boolean vlansLeft = stitchingCallData.setVlanUnavailable(vlan);
                if (vlansLeft) continue;
                this.gaveUp = true;
                this.log.debug("reportMustDelete return GIVEUP (no more vlans)");
                return AllocateVerdict.GIVEUP;
            }
        }
        if (!stitchingCallData.getDependingOnThis().isEmpty()) {
            this.log.debug("reportMustDelete DEPDEL: CreateSliver changed VLAN for " + stitchingCallData.getAuthUrnString() + ", but other hops depends on this one. Forcing redo for these.");
            HashSet<StitchingCallData> allDeps = new HashSet<StitchingCallData>();
            LinkedList<StitchingCallData> newDeps = new LinkedList<StitchingCallData>(stitchingCallData.getDependingOnThis());
            while (!newDeps.isEmpty()) {
                StitchingCallData scd = (StitchingCallData)newDeps.removeFirst();
                allDeps.add(scd);
                for (StitchingCallData dep : scd.getDependingOnThis()) {
                    if (allDeps.contains(dep)) continue;
                    newDeps.addLast(dep);
                }
            }
            this.log.debug("reportMustDelete DEPDEL:     allDeps.size()=" + allDeps.size());
            for (StitchingCallData dep : allDeps) {
                if (dep.isAllocated()) {
                    this.log.debug("reportMustDelete DEPDEL:      forcing delete on " + dep.getAuthUrnString());
                    dep.setState(StitchingCallData.State.MUST_DELETE);
                }
                if (dep.getState() != StitchingCallData.State.ALLOCATING) continue;
                this.log.debug("reportMustDelete DEPDEL:      forcing delete after allocate on " + dep.getAuthUrnString());
                dep.setState(StitchingCallData.State.ALLOCATING_BUT_MUST_DELETE);
            }
        }
        this.log.debug("reportMustDelete return DIRECTOR_ACTION - new auth state=" + String.valueOf((Object)stitchingCallData.getState()));
        return AllocateVerdict.DIRECTOR_ACTION;
    }

    public synchronized AllocateVerdict processAllocateResult(@Nonnull StitchAction hop, @Nullable AbstractGeniAggregateManager.AggregateManagerReply reply) throws JFedException {
        boolean otherFailure;
        if (reply == null) {
            this.log.warn("Didn't get a reply. Giving up.");
            this.gaveUp = true;
        }
        if (this.gaveUp) {
            this.log.warn("processAllocateResult called when already gave up.");
            hop.stitchingCallData.setState(StitchingCallData.State.MUST_DELETE);
            return AllocateVerdict.GIVEUP;
        }
        this.log.debug("processAllocateResult with hop=" + String.valueOf(hop) + " hop.vlans=" + String.valueOf(hop.vlans) + " reply.code=" + String.valueOf(reply.getGeniResponseCode()) + " reply.output=" + reply.getOutput());
        if (!this.activelyInvolvedAuthorities.contains(hop.getServer())) {
            this.activelyInvolvedAuthorities.add(hop.getServer());
        }
        boolean vlanNotAvailable = StitchingDirector.isUnavailableVlan(reply);
        boolean success = reply.getGeniResponseCode().isSuccess();
        boolean anyNotSupported = StitchingDirector.isAnyNotSupported(reply);
        boolean permanentFailure = StitchingDirector.isUnrecoverableError(reply);
        boolean bl = otherFailure = !success && !anyNotSupported && !vlanNotAvailable && !permanentFailure;
        assert ((vlanNotAvailable ? 1 : 0) + (anyNotSupported ? 1 : 0) + (success ? 1 : 0) + (otherFailure ? 1 : 0) + (permanentFailure ? 1 : 0) == 1);
        assert (!hop.stitchingCallData.isAllocated());
        assert (hop.stitchingCallData.getState() != StitchingCallData.State.NONE);
        assert (hop.stitchingCallData.getState() != StitchingCallData.State.LISTING_RESOURCES);
        assert (hop.stitchingCallData.getState() != StitchingCallData.State.MUST_DELETE);
        if (hop.stitchingCallData.getState() == StitchingCallData.State.ALLOCATING_BUT_MUST_DELETE) {
            Integer unsupportedVlan;
            this.log.warn("ALLOCATING_BUT_MUST_DELETE hop=" + String.valueOf(hop));
            hop.stitchingCallData.setState(StitchingCallData.State.MUST_DELETE);
            if (vlanNotAvailable && (unsupportedVlan = StitchingDirector.getUnavailableVlan(reply, this.log)) != null) {
                hop.stitchingCallData.setVlanUnavailable(unsupportedVlan);
            }
            if (anyNotSupported) {
                try {
                    this.aggUrnsNotSupportingAny.add(new GeniUrn(hop.getServer().getDefaultComponentManagerUrn()));
                }
                catch (GeniUrn.GeniUrnParseException e) {
                    throw new JFedException("Failed to parse server defaultComponentManagerUrn: \"" + hop.getServer().getDefaultComponentManagerUrn() + "\"", (Throwable)e);
                }
            }
            this.deleteDeps(hop.stitchingCallData);
            return AllocateVerdict.DIRECTOR_ACTION;
        }
        assert (hop.stitchingCallData.getState() == StitchingCallData.State.ALLOCATING) : "Illegal state: " + String.valueOf((Object)hop.stitchingCallData.getState());
        if (!hop.stitchingCallData.areAllDepsReady()) {
            Integer unsupportedVlan;
            this.log.warn("This allocate cannot be used. The dependencies are no longer met (probably due to some other allocate failing while this one was in progress). It will have to be deleted (and probably tried again later) hop=" + String.valueOf(hop));
            if (success) {
                hop.stitchingCallData.setState(StitchingCallData.State.MUST_DELETE);
            } else {
                hop.stitchingCallData.setState(StitchingCallData.State.NONE);
            }
            if (vlanNotAvailable && (unsupportedVlan = StitchingDirector.getUnavailableVlan(reply, this.log)) != null) {
                hop.stitchingCallData.setVlanUnavailable(unsupportedVlan);
            }
            if (anyNotSupported) {
                try {
                    this.aggUrnsNotSupportingAny.add(new GeniUrn(hop.getServer().getDefaultComponentManagerUrn()));
                }
                catch (GeniUrn.GeniUrnParseException e) {
                    throw new JFedException("Failed to parse server defaultComponentManagerUrn: \"" + hop.getServer().getDefaultComponentManagerUrn() + "\"", (Throwable)e);
                }
            }
            this.deleteDeps(hop.stitchingCallData);
            return AllocateVerdict.DIRECTOR_ACTION;
        }
        assert (hop.stitchingCallData.getState() == StitchingCallData.State.ALLOCATING) : "hop is in unsupported state: " + String.valueOf((Object)hop.stitchingCallData.getState());
        if (permanentFailure) {
            this.log.debug("Detected error that cannot be handled in CreateSliver and cannot be fixed with retry. Give up.");
            this.gaveUp = true;
            hop.stitchingCallData.setState(StitchingCallData.State.NONE);
            return AllocateVerdict.GIVEUP;
        }
        if (anyNotSupported) {
            try {
                this.aggUrnsNotSupportingAny.add(new GeniUrn(hop.getServer().getDefaultComponentManagerUrn()));
            }
            catch (GeniUrn.GeniUrnParseException e) {
                throw new JFedException("Failed to parse server defaultComponentManagerUrn: \"" + hop.getServer().getDefaultComponentManagerUrn() + "\"", (Throwable)e);
            }
            this.log.info("VLAN \"any\" was not supported on aggregate \"" + hop.getServer().getDefaultComponentManagerUrn() + "\"");
            hop.stitchingCallData.setState(StitchingCallData.State.NONE);
            return AllocateVerdict.DIRECTOR_ACTION;
        }
        if (vlanNotAvailable) {
            boolean vlansLeft;
            this.log.debug("detected error \"vlan tag ... not available\" will try to pick other VLAN automatically. hop.vlans=" + String.valueOf(hop.vlans));
            if (hop.stitchingCallData.getUnavailableVlans().size() > 5) {
                this.log.debug("error \"vlan tag ... not available\" received too many times. Giving up.   hop.vlans=" + String.valueOf(hop.vlans) + "  unavailable=" + String.valueOf(hop.stitchingCallData.getUnavailableVlans()));
                this.gaveUp = true;
                hop.stitchingCallData.setState(StitchingCallData.State.NONE);
                return AllocateVerdict.GIVEUP;
            }
            Integer unsupportedVlan = StitchingDirector.getUnavailableVlan(reply, this.log);
            if (unsupportedVlan != null) {
                vlansLeft = hop.stitchingCallData.setVlanUnavailable(unsupportedVlan);
            } else {
                this.log.warn("Could not find vlan in returned error output \"" + reply.getOutput() + "\" Will mark all used vlans as unavailable as fallback: " + String.valueOf(hop.vlans));
                assert (hop.vlans != null);
                assert (!hop.vlans.isEmpty());
                vlansLeft = true;
                for (int vlan : hop.vlans) {
                    vlansLeft = hop.stitchingCallData.setVlanUnavailable(vlan) && vlansLeft;
                }
            }
            if (vlansLeft && hop.stitchingCallData.getDependencies().isEmpty()) {
                hop.stitchingCallData.setState(StitchingCallData.State.NONE);
                return AllocateVerdict.DIRECTOR_ACTION;
            }
            if (!hop.stitchingCallData.getDependencies().isEmpty()) {
                this.log.debug("DEPDEL: No alternative vlans are left for " + hop.stitchingCallData.getAuthUrnString() + ", but hop depends on others. Checking to redo these.");
                HashSet<StitchingCallData> allDeps = new HashSet<StitchingCallData>();
                LinkedList<StitchingCallData> newDeps = new LinkedList<StitchingCallData>(hop.stitchingCallData.getDependencies());
                while (!newDeps.isEmpty()) {
                    StitchingCallData scd = (StitchingCallData)newDeps.removeFirst();
                    allDeps.add(scd);
                    for (StitchingCallData dep : scd.getDependencies()) {
                        if (allDeps.contains(dep)) continue;
                        newDeps.addLast(dep);
                    }
                }
                this.log.debug("DEPDEL:     allDeps.size()=" + allDeps.size());
                assert (unsupportedVlan != null);
                boolean depHasVlansLeft = true;
                for (StitchingCallData dep : allDeps) {
                    this.log.debug("DEPDEL:     marking " + unsupportedVlan + " as unavailable on " + dep.getAuthUrnString());
                    boolean hasVlanLeft = dep.setVlanUnavailable(unsupportedVlan);
                    if (!hasVlanLeft) {
                        depHasVlansLeft = false;
                        this.log.debug("DEPDEL:       no vlans left on " + dep.getAuthUrnString());
                        continue;
                    }
                    if (!dep.isAllocated()) continue;
                    this.log.debug("DEPDEL:       need to delete on " + dep.getAuthUrnString());
                    if (dep.getState() == StitchingCallData.State.ALLOCATING) {
                        dep.setState(StitchingCallData.State.ALLOCATING_BUT_MUST_DELETE);
                        continue;
                    }
                    dep.setState(StitchingCallData.State.MUST_DELETE);
                }
                this.log.warn("DEPDEL:     depHasVlansLeft=" + depHasVlansLeft);
                if (depHasVlansLeft) {
                    hop.stitchingCallData.setState(StitchingCallData.State.NONE);
                    return AllocateVerdict.DIRECTOR_ACTION;
                }
                this.gaveUp = true;
                hop.stitchingCallData.setState(StitchingCallData.State.NONE);
                return AllocateVerdict.GIVEUP;
            }
            this.log.warn("The vlan was not available according to CreateSliver. No alternative vlans are left for " + hop.stitchingCallData.getAuthUrnString() + ", so giving up on stitching.");
            this.gaveUp = true;
            hop.stitchingCallData.setState(StitchingCallData.State.NONE);
            return AllocateVerdict.GIVEUP;
        }
        if (success) {
            GeniUrn serverUrn;
            this.log.debug("Allocate call successful - processing manifest");
            Object replyValue = reply.getValue();
            String manifestRspec = null;
            if (replyValue instanceof AggregateManager3.AllocateAndProvisionInfo) {
                manifestRspec = ((AggregateManager3.AllocateAndProvisionInfo)replyValue).getRspec();
            }
            if (replyValue instanceof String) {
                manifestRspec = (String)replyValue;
            }
            if (manifestRspec == null) {
                this.log.warn("Detected error that cannot be handled in CreateSliver (unknown reply value, type=" + replyValue.getClass().getName() + "). Maybe retry? Otherwise, give up.");
                assert (hop.stitchingCallData.getState() == StitchingCallData.State.ALLOCATING);
                return AllocateVerdict.CALLER_DELAYED_RETRY;
            }
            try {
                serverUrn = new GeniUrn(hop.getServer().getDefaultComponentManagerUrn());
            }
            catch (GeniUrn.GeniUrnParseException e) {
                throw new JFedException("Failed to parse server defaultComponentManagerUrn: \"" + hop.getServer().getDefaultComponentManagerUrn() + "\"", (Throwable)e);
            }
            if (serverUrn.getEncodedTopLevelAuthority_withoutSubAuth().equalsIgnoreCase("exogeni.net")) {
                List<Integer> vlans = hop.stitchingCallData.getSuggestedVlans();
                assert (vlans.size() == 1);
                hop.stitchingCallData.exogeniBugWorkAround_registerVlan(vlans.get(0));
            } else {
                hop.stitchingCallData.processManifestRspec(manifestRspec);
            }
            hop.stitchingCallData.setState(StitchingCallData.State.ALLOCATED);
            this.log.debug("Allocate call successful - state is ALLOCATED, returning OK");
            return AllocateVerdict.OK;
        }
        this.log.warn("Detected error that cannot be handled in CreateSliver. Maybe retry? Otherwise, give up.");
        assert (hop.stitchingCallData.getState() == StitchingCallData.State.ALLOCATING);
        return AllocateVerdict.CALLER_DELAYED_RETRY;
    }

    public static Boolean isUnrecoverableError(SfaApiCallReply reply) {
        AbstractGeniAggregateManager.AggregateManagerReply amReply;
        if (reply == null) {
            return null;
        }
        if (reply.getGeniResponseCode() == null) {
            return null;
        }
        if (Objects.equals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_ERROR) && reply.getOutput() != null && reply.getOutput().startsWith("Could not reserve vlan tags for ")) {
            return true;
        }
        if (!reply.getGeniResponseCode().isSuccess() && reply.getOutput() != null && reply.getOutput().startsWith("TEST BUG DETECTED")) {
            return true;
        }
        if (reply.getValue() != null && (reply.getValue() instanceof AggregateManager3.AllocateAndProvisionInfo || reply.getValue() instanceof AggregateManager3.StatusInfo)) {
            List<AggregateManager3.SliverInfo> sliverInfos;
            if (reply.getValue() instanceof AggregateManager3.AllocateAndProvisionInfo) {
                sliverInfos = ((AggregateManager3.AllocateAndProvisionInfo)reply.getValue()).getSliverInfo();
            } else {
                assert (reply.getValue() instanceof AggregateManager3.StatusInfo);
                sliverInfos = ((AggregateManager3.StatusInfo)reply.getValue()).getSliverInfo();
            }
            if (sliverInfos != null) {
                for (AggregateManager3.SliverInfo si : sliverInfos) {
                    if (si.getOperationalStatus() != null && !si.getOperationalStatus().equals("geni_failed")) continue;
                    if (si.getError() != null && si.getError().toLowerCase().contains("bandwidth")) {
                        return true;
                    }
                    if (si.getError() != null && si.getError().toLowerCase().contains("bandwith")) {
                        return true;
                    }
                    if (si.getError() == null || !si.getError().toLowerCase().contains("There are no VLANs available on link".toLowerCase())) continue;
                    return true;
                }
            }
        }
        if (reply.getGeniResponseCode().isSuccess() && reply.getValue() != null && reply.getValue() instanceof AggregateManager2.SliverStatus) {
            AggregateManager2.SliverStatus status = (AggregateManager2.SliverStatus)reply.getValue();
            for (AggregateManager2.SliverStatus.ResourceStatus rs : status.getResources()) {
                if (rs.getError() != null && rs.getError().toLowerCase().contains("bandwidth")) {
                    return true;
                }
                if (rs.getError() == null || !rs.getError().toLowerCase().contains("bandwith")) continue;
                return true;
            }
            return false;
        }
        if (reply.getGeniResponseCode().isSuccess()) {
            return false;
        }
        Object output = "";
        if (reply.getOutput() != null) {
            output = (String)output + reply.getOutput().toLowerCase();
        }
        if (reply.getValue() != null && reply.getValue() instanceof String) {
            output = (String)output + " " + ((String)reply.getValue()).toLowerCase();
        } else if (reply instanceof AbstractGeniAggregateManager.AggregateManagerReply && (amReply = (AbstractGeniAggregateManager.AggregateManagerReply)reply).getRawValue() != null && amReply.getRawValue() instanceof String) {
            output = (String)output + " " + ((String)amReply.getRawValue()).toLowerCase();
        }
        if (((String)output).isEmpty()) {
            return null;
        }
        if (((String)output).contains("Could not map to resources: Not enough bandwidth to connect some nodes".toLowerCase())) {
            return true;
        }
        if (((String)output).contains("could not map to resources")) {
            return true;
        }
        if (((String)output).contains("not enough bandwidth")) {
            return true;
        }
        if (((String)output).contains("mapping failed")) {
            return true;
        }
        if (((String)output).contains("bandwidth")) {
            return true;
        }
        if (((String)output).contains("bandwith")) {
            return true;
        }
        if (reply.getOutput() != null && Objects.equals(reply.getOutput(), "Could not verify topo")) {
            return true;
        }
        return false;
    }

    public static Boolean isUnrecoverableError(JFedException e) {
        if (e == null) {
            return null;
        }
        if (AbstractApi.isTimeout(e)) {
            return true;
        }
        SfaApiCallReply reply = e.getSfaReply();
        if (reply == null) {
            return null;
        }
        return StitchingDirector.isUnrecoverableError(reply);
    }

    public synchronized List<Server> getActivelyInvolvedAuthorities() {
        return new ArrayList<Server>(this.activelyInvolvedAuthorities);
    }

    @Nonnull
    public synchronized List<Server> getAllAuthorities() {
        return new ArrayList<Server>(this.allAuthorities);
    }

    @Nonnull
    public List<SuggestedAvailableOverview> getSuggestedAvailableOverviews() {
        ArrayList<SuggestedAvailableOverview> res = new ArrayList<SuggestedAvailableOverview>();
        if (this.computePathResultStitchingData != null) {
            for (StitchingHopData stitchingHopData : this.computePathResultStitchingData.getStitchingHopDataList()) {
                SuggestedAvailableOverview o = new SuggestedAvailableOverview(stitchingHopData.getHopUrn(), "" + stitchingHopData.getSuggestedVlan(), stitchingHopData.getAvailableVlansString());
                res.add(o);
            }
        }
        return res;
    }

    public synchronized String getSuggestedAvailableOverviewsString() {
        Object res = "";
        List<SuggestedAvailableOverview> overviews = this.getSuggestedAvailableOverviews();
        for (SuggestedAvailableOverview o : overviews) {
            res = (String)res + String.valueOf(o) + "\n";
        }
        return res;
    }

    public static class StitchAction {
        private final StichActionType type;
        private final Server server;
        private final String requestRspec;
        private final StitchingCallData stitchingCallData;
        private List<Integer> vlans;

        public StitchAction(StichActionType type, Server server, String requestRspec, List<Integer> vlans, StitchingCallData stitchingCallData) {
            assert (type != null);
            assert (server != null);
            this.type = type;
            this.server = server;
            this.requestRspec = requestRspec;
            this.stitchingCallData = stitchingCallData;
            this.vlans = vlans;
        }

        public Server getServer() {
            return this.server;
        }

        public String getRequestRspec() {
            return this.requestRspec;
        }

        public String toString() {
            return "StitchAction{" + String.valueOf((Object)this.type) + ", vlans=" + String.valueOf(this.vlans) + ", server=" + String.valueOf(this.server.getId()) + "(" + this.server.getName() + ")}";
        }

        public StichActionType getType() {
            return this.type;
        }
    }

    public static enum StichActionType {
        ALLOCATE,
        DELETE,
        LISTRESOURCES;

    }

    public static enum AllocateVerdict {
        GIVEUP,
        CALLER_DELAYED_RETRY,
        DIRECTOR_ACTION,
        OK;

    }

    public static class SuggestedAvailableOverview {
        private final String hopUrn;
        private final String suggestedVlan;
        private final String availableVlans;

        public SuggestedAvailableOverview(String hopUrn, String suggestedVlan, String availableVlans) {
            this.hopUrn = hopUrn;
            this.suggestedVlan = suggestedVlan;
            this.availableVlans = availableVlans;
        }

        public String getHopUrn() {
            return this.hopUrn;
        }

        public String getSuggestedVlan() {
            return this.suggestedVlan;
        }

        public String getAvailableVlans() {
            return this.availableVlans;
        }

        public String toString() {
            return this.hopUrn + " -> suggestedVlan='" + this.suggestedVlan + "', availableVlans='" + this.availableVlans + "'";
        }
    }
}

