/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.testbed_info;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Federation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Organisation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategory;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicTestbedInfoSource
extends TestbedInfoSource {
    private static final Logger LOG = LoggerFactory.getLogger(BasicTestbedInfoSource.class);
    private final List<Testbed> testbeds = new ArrayList<Testbed>();
    private final List<Server> servers = new ArrayList<Server>();
    private final List<Service> services = new ArrayList<Service>();
    private final Map<String, Federation> federationsById;
    private final Map<String, Organisation> organisationsById;
    private final Map<Integer, TestbedCategory> testbedCategoriesById;
    private final Map<String, TestbedCategory> testbedCategoriesByName;
    private final Map<String, Testbed> testbedsById = new HashMap<String, Testbed>();
    private final Map<Integer, Server> serversById = new HashMap<Integer, Server>();
    private final Map<Integer, Service> servicesById = new HashMap<Integer, Service>();
    private final Map<String, Service> servicesByUrl = new HashMap<String, Service>();
    private final Map<String, List<Service>> servicesByApi = new HashMap<String, List<Service>>();

    protected BasicTestbedInfoSource(@Nonnull Collection<TestbedBuilder> testbedBuilders, @Nonnull Class<TestbedBuilder> testbedBuilderClass, @Nonnull Collection<Federation> federations, @Nonnull Collection<Organisation> organisations, @Nonnull Collection<TestbedCategory> testbedCategories) {
        this.initCollectionsFromTestbedBuilders(testbedBuilders);
        this.federationsById = this.initMapHelper(federations, PrimaryIdObject::getId);
        this.organisationsById = this.initMapHelper(organisations, PrimaryIdObject::getId);
        this.testbedCategoriesById = this.initMapHelper(testbedCategories, PrimaryIdObject::getId);
        this.testbedCategoriesByName = this.initMapHelper(testbedCategories, TestbedCategory::getName);
    }

    protected BasicTestbedInfoSource(@Nonnull Collection<Testbed> testbeds, @Nonnull Collection<Federation> federations, @Nonnull Collection<Organisation> organisations, @Nonnull Collection<TestbedCategory> testbedCategories) {
        this.initCollectionsFromTestbeds(testbeds);
        this.federationsById = this.initMapHelper(federations, PrimaryIdObject::getId);
        this.organisationsById = this.initMapHelper(organisations, PrimaryIdObject::getId);
        this.testbedCategoriesById = this.initMapHelper(testbedCategories, PrimaryIdObject::getId);
        this.testbedCategoriesByName = this.initMapHelper(testbedCategories, TestbedCategory::getName);
    }

    private <K, V> Map<K, V> initMapHelper(Collection<V> coll, Function<V, K> keyExtractor) {
        try {
            return Collections.unmodifiableMap(coll.stream().collect(Collectors.toMap(keyExtractor, Function.identity())));
        }
        catch (Exception e) {
            LOG.error("Exception while initialising federations, organisations and categories. Will be ignored ", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static BasicTestbedInfoSource createFromTestbeds(@Nonnull Collection<Testbed> testbeds) {
        return new BasicTestbedInfoSource(testbeds, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public static BasicTestbedInfoSource createFromTestbeds(@Nonnull Collection<Testbed> testbeds, @Nonnull Collection<Federation> federations, @Nonnull Collection<Organisation> organisation, @Nonnull Collection<TestbedCategory> testbedCategories) {
        return new BasicTestbedInfoSource(testbeds, federations, organisation, testbedCategories);
    }

    public static BasicTestbedInfoSource createFromTestbedBuilders(@Nonnull Collection<TestbedBuilder> testbedBuilders, @Nonnull Collection<Federation> federations, @Nonnull Collection<Organisation> organisation, @Nonnull Collection<TestbedCategory> testbedCategories) {
        return new BasicTestbedInfoSource(testbedBuilders, TestbedBuilder.class, federations, organisation, testbedCategories);
    }

    public static BasicTestbedInfoSource createFromTestbedBuilders(@Nonnull Collection<TestbedBuilder> testbedBuilders) {
        return new BasicTestbedInfoSource(testbedBuilders, TestbedBuilder.class, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    protected void initCollectionsFromTestbedBuilders(Collection<TestbedBuilder> testbedBuilders) {
        if (testbedBuilders == null) {
            return;
        }
        testbedBuilders.forEach(this::initTestbed);
        this.checkCollisions();
    }

    protected void initCollectionsFromTestbeds(Collection<Testbed> testbeds) {
        if (testbeds == null) {
            return;
        }
        testbeds.forEach(this::initTestbed);
        this.checkCollisions();
    }

    private void checkCollisions() {
        String urn;
        HashMap<String, List> usedComponentManagers = new HashMap<String, List>();
        for (Testbed testbed : this.testbeds) {
            urn = testbed.getDefaultComponentManagerUrn();
            if (urn == null && testbed.getServers() != null && !testbed.getServers().isEmpty() && (urn = ((Server)testbed.getServers().get(0)).getDefaultComponentManagerUrn()) == null && ((Server)testbed.getServers().get(0)).getServices() != null) {
                for (Service s2 : ((Server)testbed.getServers().get(0)).getServices()) {
                    if (urn != null) continue;
                    urn = s2.getUrn();
                }
            }
            if (urn == null) continue;
            usedComponentManagers.computeIfAbsent(urn, s -> new ArrayList()).add(testbed);
        }
        for (Map.Entry entry : usedComponentManagers.entrySet()) {
            urn = (String)entry.getKey();
            List testbeds = (List)entry.getValue();
            if (testbeds.size() <= 1) continue;
            String testbedDetails = testbeds.stream().map(tb -> (String)tb.getId() + " (" + tb.getLongName() + ")").collect(Collectors.joining(", "));
            LOG.warn("Shared URN '" + urn + "' for " + testbeds.size() + " testbeds: " + testbedDetails);
        }
    }

    protected void initTestbed(Testbed testbed) {
        this.initTestbed(new TestbedBuilder(testbed, true));
    }

    protected void initTestbed(TestbedBuilder testbedBuilder) {
        InitHelper helper = new InitHelper();
        helper.test(testbedBuilder != null, "testbed == null");
        helper.test(testbedBuilder.getDefaultComponentManagerUrn() != null, "testbed.getDefaultComponentManagerUrn() == null");
        helper.test(GeniUrn.parse((String)testbedBuilder.getDefaultComponentManagerUrn()) != null, "GeniUrn.parse(testbed.getDefaultComponentManagerUrn()) == null");
        helper.test(testbedBuilder.getId() != null, "testbed.getId() == null");
        helper.test(testbedBuilder.getLongName() != null, "testbed.getLongName() == null");
        assert (testbedBuilder.getServers() == null) : "Testbed should use ServerBuilders. testbedId=" + (String)testbedBuilder.getId();
        helper.test(testbedBuilder.getServers() == null, "testbed.getServers() != null");
        helper.test(testbedBuilder.getServerBuilders() != null, "testbed.getServerBuilders() == null");
        if (testbedBuilder.getServerBuilders() != null) {
            helper.test(!testbedBuilder.getServerBuilders().isEmpty(), "testbed.getServerBuilders().isEmpty()");
        }
        if (helper.ok) {
            if (testbedBuilder.getServerBuilders() != null) {
                ArrayList<ServerBuilder> usedServerBuilders = new ArrayList<ServerBuilder>(testbedBuilder.getServerBuilders().size());
                for (ServerBuilder serverBuilder : testbedBuilder.getServerBuilders()) {
                    helper.test(serverBuilder != null, "server == null");
                    helper.test(serverBuilder.getDefaultComponentManagerUrn() != null, "server.getDefaultComponentManagerUrn() == null");
                    if (serverBuilder.getDefaultComponentManagerUrn() != null) {
                        helper.test(GeniUrn.parse((String)serverBuilder.getDefaultComponentManagerUrn()) != null, "GeniUrn.parse(server.getDefaultComponentManagerUrn()) == null");
                    }
                    helper.test(serverBuilder.getUrnTld() != null, "server.getUrnTld() == null");
                    helper.test(serverBuilder.getName() != null, "server.getName() != null");
                    assert (serverBuilder.getServices() == null) : "ServerBuilder should use ServiceBuilders. serverId=" + String.valueOf(serverBuilder.getId());
                    helper.test(serverBuilder.getServices() == null, "serverBuilder.getServices() != null");
                    if (serverBuilder.getServiceBuilders() != null && !serverBuilder.getServiceBuilders().isEmpty()) {
                        helper.test(serverBuilder.getBaseUrl() != null, "server.getBaseUrl() == null");
                    }
                    if (helper.ok) {
                        if (serverBuilder.getServiceBuilders() != null) {
                            ArrayList<ServiceBuilder> usedServiceBuilders = new ArrayList<ServiceBuilder>();
                            for (ServiceBuilder serviceBuilder : serverBuilder.getServiceBuilders()) {
                                InitHelper serviceHelper = new InitHelper();
                                serviceHelper.test(serviceBuilder.getApi() != null, "service.getApi() == null");
                                serviceHelper.test(serviceBuilder.getApiVersion() != null, "service.getApiVersion() == null");
                                serviceHelper.test(serviceBuilder.getId() != null, "service.getId() == null");
                                serviceHelper.test(serviceBuilder.getUrn() != null, "service.getUrn() == null");
                                if (serviceBuilder.getUrn() != null) {
                                    serviceHelper.test(GeniUrn.parse((String)serviceBuilder.getUrn()) != null, "GeniUrn.parse(service.getUrn()) == null");
                                }
                                serviceHelper.test(serviceBuilder.getUrl() != null, "service.getUrl() == null");
                                try {
                                    URL serviceUrl = new URL(serviceBuilder.getUrl());
                                    serviceHelper.test(serviceUrl != null, "serviceUrl != null");
                                }
                                catch (MalformedURLException e) {
                                    LOG.error("Service " + String.valueOf(serviceBuilder.getId()) + " has invalid URL", (Throwable)e);
                                    serviceHelper.test(false, "Service " + String.valueOf(serviceBuilder.getId()) + " has invalid URL \"" + serviceBuilder.getUrl() + "\"");
                                }
                                if (serviceHelper.ok) {
                                    usedServiceBuilders.add(serviceBuilder);
                                    continue;
                                }
                                LOG.error("There is something wrong with Service " + String.valueOf(serviceBuilder.getId()) + " of Server " + String.valueOf(serverBuilder.getId()) + " of testbed " + (String)testbedBuilder.getId() + " -> ignoring Service! " + String.valueOf(serviceHelper.errors));
                            }
                            serverBuilder.setServiceBuilders(usedServiceBuilders);
                        } else {
                            serverBuilder.setServiceBuilders(Collections.emptyList());
                        }
                        usedServerBuilders.add(serverBuilder);
                        continue;
                    }
                    LOG.error("There is something wrong with Server " + String.valueOf(serverBuilder.getId()) + " of testbed " + (String)testbedBuilder.getId() + " -> ignoring Server! " + String.valueOf(helper.errors));
                }
                testbedBuilder.setServerBuilders(usedServerBuilders);
            } else {
                testbedBuilder.setServerBuilders(Collections.emptyList());
            }
            Testbed testbed = testbedBuilder.create();
            if (testbed.getServers() != null) {
                for (Server server : testbed.getServers()) {
                    assert (server != null);
                    assert (server.getTestbed() != null);
                    assert (Objects.equals(server.getTestbed().getId(), testbed.getId()));
                    assert (server.getTestbed() == testbed);
                    this.servers.add(server);
                    this.serversById.put((Integer)server.getId(), server);
                    if (server.getServices() == null) continue;
                    for (Service service : server.getServices()) {
                        assert (service.getServer() != null);
                        assert (Objects.equals(service.getServer().getId(), server.getId()));
                        assert (service.getServer() == server);
                        this.services.add(service);
                        this.servicesById.put((Integer)service.getId(), service);
                        Service sameUrlService = this.servicesByUrl.put(service.getUrl(), service);
                        if (sameUrlService != null) {
                            LOG.warn("2 Services have the same URL: " + String.valueOf(service.getId()) + " and " + String.valueOf(sameUrlService.getId()));
                        }
                        List sameApiServices = this.servicesByApi.computeIfAbsent(service.getApi(), k -> new ArrayList());
                        sameApiServices.add(service);
                    }
                }
            }
            this.testbeds.add(testbed);
            this.testbedsById.put((String)testbed.getId(), testbed);
        } else {
            LOG.error("There is something wrong with Testbed " + (String)testbedBuilder.getId() + " -> ignoring Testbed! " + String.valueOf(helper.errors));
        }
    }

    @Override
    public List<Server> getServers() {
        return this.servers;
    }

    @Override
    public List<Testbed> getTestbeds() {
        return this.testbeds;
    }

    @Override
    public int getServiceCount() {
        return this.services.size();
    }

    @Override
    @Nullable
    public Collection<Federation> getFederations() {
        return this.federationsById.values();
    }

    @Override
    @Nullable
    public Collection<Organisation> getOrganisation() {
        return this.organisationsById.values();
    }

    @Override
    @Nullable
    public Collection<TestbedCategory> getTestbedCategories() {
        return this.testbedCategoriesById.values();
    }

    @Override
    @Nullable
    public Federation getFederation(@Nonnull String id) {
        return this.federationsById.get(id);
    }

    @Override
    @Nullable
    public Organisation getOrganisation(@Nonnull String id) {
        return this.organisationsById.get(id);
    }

    @Override
    @Nullable
    public TestbedCategory getTestbedCategory(@Nonnull String name) {
        return this.testbedCategoriesByName.get(name);
    }

    @Override
    @Nullable
    public TestbedCategory getTestbedCategory(@Nonnull Integer id) {
        return this.testbedCategoriesById.get(id);
    }

    @Override
    public Service getServiceById(Integer id) {
        return this.servicesById.get(id);
    }

    @Override
    public Server getServerById(Integer id) {
        if (id == null) {
            return null;
        }
        return this.serversById.get(id);
    }

    @Override
    public Testbed getTestbedById(String id) {
        return this.testbedsById.get(id);
    }

    @Override
    public Service getServiceByUrl(String serviceUrlString) {
        return this.servicesByUrl.get(serviceUrlString);
    }

    @Override
    public Service getServiceByUrl(URL serviceUrl) {
        return this.servicesByUrl.get(serviceUrl.toExternalForm());
    }

    @Override
    public Service getServiceByUrn(GeniUrn wantedUrn, TestbedInfoSource.SubAuthMatchAllowed matchAllowed, TestbedInfoSource.SubAuthMatchPreference matchPreferred, boolean ignoreUrnTypeAndName, String api, String version) {
        List<Service> servicesWithApi = this.servicesByApi.get(api);
        ArrayList exactResultSet = new ArrayList();
        ArrayList sameTldResultSet = new ArrayList();
        ArrayList ignoreTldResultSet = new ArrayList();
        for (Service service : servicesWithApi) {
            if (!Objects.equals(version, service.getApiVersion())) continue;
            try {
                GeniUrn curUrn = new GeniUrn(service.getUrn());
                if (this.matchUrn(curUrn, wantedUrn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_ONLY_EXACT_SUBAUTHORITY, ignoreUrnTypeAndName)) {
                    exactResultSet.add(new PairWithUrn<Service>(curUrn, service));
                }
                if (matchAllowed == TestbedInfoSource.SubAuthMatchAllowed.ALLOW_ONLY_EXACT_SUBAUTHORITY) continue;
                if (this.matchUrn(curUrn, wantedUrn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL, ignoreUrnTypeAndName)) {
                    sameTldResultSet.add(new PairWithUrn<Service>(curUrn, service));
                }
                if (matchAllowed == TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL || !this.matchUrn(curUrn, wantedUrn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_OTHER_SUBAUTHORITY, ignoreUrnTypeAndName)) continue;
                ignoreTldResultSet.add(new PairWithUrn<Service>(curUrn, service));
            }
            catch (GeniUrn.GeniUrnParseException e) {
                throw new IllegalStateException("TestbedInfoSource contains a Service with an invalid URN \"" + service.getUrn() + "\" id=" + String.valueOf(service.getId()), e);
            }
        }
        return (Service)BasicTestbedInfoSource.findPreferredResult(wantedUrn, exactResultSet, sameTldResultSet, ignoreTldResultSet, matchPreferred);
    }

    @Override
    public Testbed getTestbedByUrn(GeniUrn wantedUrn, TestbedInfoSource.SubAuthMatchAllowed matchAllowed, TestbedInfoSource.SubAuthMatchPreference matchPreferred, boolean ignoreUrnTypeAndName) {
        ArrayList exactResultSet = new ArrayList();
        ArrayList sameTldResultSet = new ArrayList();
        ArrayList ignoreTldResultSet = new ArrayList();
        for (Testbed testbed : this.testbeds) {
            try {
                GeniUrn curUrn = new GeniUrn(testbed.getDefaultComponentManagerUrn());
                if (this.matchUrn(curUrn, wantedUrn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_ONLY_EXACT_SUBAUTHORITY, ignoreUrnTypeAndName)) {
                    exactResultSet.add(new PairWithUrn<Testbed>(curUrn, testbed));
                }
                if (matchAllowed == TestbedInfoSource.SubAuthMatchAllowed.ALLOW_ONLY_EXACT_SUBAUTHORITY) continue;
                if (this.matchUrn(curUrn, wantedUrn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL, ignoreUrnTypeAndName)) {
                    sameTldResultSet.add(new PairWithUrn<Testbed>(curUrn, testbed));
                }
                if (matchAllowed == TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL || !this.matchUrn(curUrn, wantedUrn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_OTHER_SUBAUTHORITY, ignoreUrnTypeAndName)) continue;
                ignoreTldResultSet.add(new PairWithUrn<Testbed>(curUrn, testbed));
            }
            catch (GeniUrn.GeniUrnParseException e) {
                throw new IllegalStateException("TestbedInfoSource contains a Testbed with an invalid URN \"" + testbed.getDefaultComponentManagerUrn() + "\" id=" + (String)testbed.getId(), e);
            }
        }
        return (Testbed)BasicTestbedInfoSource.findPreferredResult(wantedUrn, exactResultSet, sameTldResultSet, ignoreTldResultSet, matchPreferred);
    }

    @Override
    @Nullable
    public Server getByUrn(@Nonnull GeniUrn wantedUrn, @Nonnull TestbedInfoSource.SubAuthMatchAllowed matchAllowed, @Nonnull TestbedInfoSource.SubAuthMatchPreference matchPreferred, boolean ignoreUrnTypeAndName) {
        assert (wantedUrn != null);
        assert (matchAllowed != null);
        assert (matchPreferred != null);
        ArrayList exactResultSet = new ArrayList();
        ArrayList sameTldResultSet = new ArrayList();
        ArrayList ignoreTldResultSet = new ArrayList();
        for (Server server : this.servers) {
            HashSet<String> curUrns = new HashSet<String>();
            assert (server != null);
            assert (server.getDefaultComponentManagerUrn() != null);
            curUrns.add(server.getDefaultComponentManagerUrn());
            if (server.getServices() != null) {
                for (Service service : server.getServices()) {
                    assert (service != null);
                    assert (service.getUrn() != null) : "service " + String.valueOf(service.getId()) + " of server " + String.valueOf(server.getId()) + " has urn == null";
                    curUrns.add(service.getUrn());
                }
            }
            for (String curUrnString : curUrns) {
                assert (curUrnString != null);
                try {
                    GeniUrn curUrn = new GeniUrn(curUrnString);
                    if (this.matchUrn(curUrn, wantedUrn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_ONLY_EXACT_SUBAUTHORITY, ignoreUrnTypeAndName)) {
                        exactResultSet.add(new PairWithUrn<Server>(curUrn, server));
                    }
                    if (matchAllowed == TestbedInfoSource.SubAuthMatchAllowed.ALLOW_ONLY_EXACT_SUBAUTHORITY) continue;
                    if (this.matchUrn(curUrn, wantedUrn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL, ignoreUrnTypeAndName)) {
                        sameTldResultSet.add(new PairWithUrn<Server>(curUrn, server));
                    }
                    if (matchAllowed == TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL || !this.matchUrn(curUrn, wantedUrn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_OTHER_SUBAUTHORITY, ignoreUrnTypeAndName)) continue;
                    ignoreTldResultSet.add(new PairWithUrn<Server>(curUrn, server));
                }
                catch (GeniUrn.GeniUrnParseException e) {
                    throw new IllegalStateException("TestbedInfoSource contains a Server with an invalid URN \"" + server.getDefaultComponentManagerUrn() + "\" id=" + String.valueOf(server.getId()), e);
                }
            }
        }
        return (Server)BasicTestbedInfoSource.findPreferredResult(wantedUrn, exactResultSet, sameTldResultSet, ignoreTldResultSet, matchPreferred);
    }

    @Nullable
    public static <T> T findPreferredResult(GeniUrn requested, List<PairWithUrn<T>> foundExactMatch, List<PairWithUrn<T>> foundWithTldMatch, List<PairWithUrn<T>> foundIgnoreSubTld, TestbedInfoSource.SubAuthMatchPreference preference) {
        assert (foundExactMatch != null);
        assert (foundWithTldMatch != null);
        assert (foundIgnoreSubTld != null);
        switch (preference) {
            case PREFER_EXACT_SUBAUTHORITY: {
                return Stream.concat(foundExactMatch.stream(), Stream.concat(BasicTestbedInfoSource.sortBySubAuthDifference(foundWithTldMatch, requested).stream(), BasicTestbedInfoSource.sortBySubAuthDifference(foundIgnoreSubTld, requested).stream())).map(pair -> pair.object).findFirst().orElse(null);
            }
            case PREFER_TOPLEVEL: {
                return Stream.concat(BasicTestbedInfoSource.sortBySubAuthNumber(foundWithTldMatch).stream(), Stream.concat(foundExactMatch.stream(), BasicTestbedInfoSource.sortBySubAuthNumber(foundIgnoreSubTld).stream())).map(pair -> pair.object).findFirst().orElse(null);
            }
        }
        throw new RuntimeException("SubAuthMatchPreference " + String.valueOf((Object)preference) + " no supported");
    }

    static <T> List<PairWithUrn<T>> sortBySubAuthDifference(List<PairWithUrn<T>> l, GeniUrn urn) {
        l.sort(Comparator.comparing(pair -> BasicTestbedInfoSource.getDistance(urn, pair)));
        return l;
    }

    private static <T> int getDistance(GeniUrn urn, PairWithUrn<T> pair) {
        return Math.abs(pair.getUrn().getSubAuthCount() - urn.getSubAuthCount());
    }

    static <T> List<PairWithUrn<T>> sortBySubAuthNumber(List<PairWithUrn<T>> l) {
        l.sort(Comparator.comparing(pair -> pair.getUrn().getSubAuthCount()));
        return l;
    }

    protected static class InitHelper {
        public final List<String> errors = new ArrayList<String>();
        public boolean ok = true;

        protected InitHelper() {
        }

        public void test(boolean ok, String error) {
            if (!ok) {
                this.ok = false;
                this.errors.add(error);
            }
        }
    }

    static class PairWithUrn<T> {
        public final GeniUrn urn;
        public final T object;

        public PairWithUrn(GeniUrn urn, T object) {
            this.urn = urn;
            this.object = object;
        }

        public PairWithUrn(String urnString, T object) {
            this.urn = GeniUrn.parse((String)urnString);
            assert (this.urn != null);
            this.object = object;
        }

        public GeniUrn getUrn() {
            return this.urn;
        }
    }
}

