/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.user;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.user.AbstractUserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserFactory;
import be.iminds.ilabt.jfed.lowlevel.user.UserLoginInfo;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class KeyCertUrlUserLoginInfo
extends AbstractUserLoginInfo {
    private final URL url;

    KeyCertUrlUserLoginInfo(URL url, GeniUserFactory geniUserFactory, AuthorityFinder authorityFinder) throws IOException {
        super(url != null ? IOUtils.urlToString((URL)url, (Charset)StandardCharsets.UTF_8) : null, geniUserFactory, authorityFinder);
        this.url = url;
        this.checkForErrors();
    }

    KeyCertUrlUserLoginInfo(URL url, GeniUrn userUrn, Server userAuthority, GeniUserFactory geniUserFactory) throws IOException {
        super(url != null ? IOUtils.urlToString((URL)url, (Charset)StandardCharsets.UTF_8) : null, userUrn, userAuthority, geniUserFactory);
        this.url = url;
        this.checkForErrors();
    }

    private void checkForErrors() {
        if (this.url != null && this.keyCertContent == null) {
            this.addError("Could not read key-certificate-pair from url");
        }
    }

    @Override
    public String getUserLoginTypeName() {
        return "Login Certificate Url";
    }

    @Override
    public boolean equals(UserLoginInfo o) {
        if (!(o instanceof KeyCertUrlUserLoginInfo)) {
            return false;
        }
        if (!Objects.equals(this.url, ((KeyCertUrlUserLoginInfo)o).url)) {
            return false;
        }
        return super.equalInfo(o);
    }

    public URL getUrl() {
        return this.url;
    }
}

