/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.user;

import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserFactory;
import be.iminds.ilabt.jfed.lowlevel.user.KeyCertFileUserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.KeyCertUrlUserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.ManualUserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.UserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.UserLoginInfoManager;
import be.iminds.ilabt.jfed.lowlevel.userloginmodel.InvalidLoginException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesUserLoginInfoManager
implements UserLoginInfoManager {
    private static final Logger LOG = LoggerFactory.getLogger(PreferencesUserLoginInfoManager.class);
    private static final String PREFS_KEY_SOURCE = "source";
    private static final String PREFS_KEY_CERT_FILE_URI = "keyCertFileURI";
    private static final String PREFS_USER_AUTH_URN = "userauthurn";
    private static final String PREFS_USER_URN = "userurn";
    protected static final String SOURCE_FILE = "FILE";
    protected static final String SOURCE_URL = "URL";
    protected static final String SOURCE_STRING = "STRING";
    private final Configuration configuration;
    private final GeniUserFactory geniUserFactory;
    private final AuthorityFinder authorityFinder;

    public PreferencesUserLoginInfoManager(Configuration configuration, GeniUserFactory geniUserFactory, AuthorityFinder authorityFinder) {
        this.configuration = configuration;
        this.geniUserFactory = geniUserFactory;
        this.authorityFinder = authorityFinder;
    }

    @Override
    public void save(UserLoginInfo userLoginInfo) {
        this.clearConfiguration();
        if (userLoginInfo instanceof KeyCertFileUserLoginInfo) {
            KeyCertFileUserLoginInfo keyCertFileUserLoginInfo = (KeyCertFileUserLoginInfo)userLoginInfo;
            this.configuration.setProperty(PREFS_KEY_SOURCE, (Object)SOURCE_FILE);
            this.configuration.setProperty(PREFS_KEY_CERT_FILE_URI, (Object)keyCertFileUserLoginInfo.getFile().toURI().toString());
        } else if (userLoginInfo instanceof KeyCertUrlUserLoginInfo) {
            KeyCertUrlUserLoginInfo keyCertUrlUserLoginInfo = (KeyCertUrlUserLoginInfo)userLoginInfo;
            this.configuration.setProperty(PREFS_KEY_SOURCE, (Object)SOURCE_URL);
            this.configuration.setProperty(PREFS_KEY_CERT_FILE_URI, (Object)keyCertUrlUserLoginInfo.getUrl().toString());
        } else if (userLoginInfo instanceof ManualUserLoginInfo) {
            ManualUserLoginInfo manualUserLoginInfo = (ManualUserLoginInfo)userLoginInfo;
            this.configuration.setProperty(PREFS_KEY_SOURCE, (Object)SOURCE_STRING);
            if (manualUserLoginInfo.getUserUrn() != null) {
                this.configuration.setProperty(PREFS_USER_URN, (Object)manualUserLoginInfo.getUserUrn().toString());
            }
            if (manualUserLoginInfo.getUserAuthorityServer() != null) {
                this.configuration.setProperty(PREFS_USER_AUTH_URN, (Object)manualUserLoginInfo.getUserAuthorityServer().getDefaultComponentManagerUrn());
            }
        }
    }

    private void clearConfiguration() {
        this.configuration.clearProperty(PREFS_KEY_SOURCE);
        this.configuration.clearProperty(PREFS_KEY_CERT_FILE_URI);
        this.configuration.clearProperty(PREFS_USER_URN);
        this.configuration.clearProperty(PREFS_USER_AUTH_URN);
    }

    @Override
    public UserLoginInfo load() throws InvalidLoginException {
        String sourceType = this.configuration.getString(PREFS_KEY_SOURCE);
        if (Objects.equals(SOURCE_FILE, sourceType)) {
            File file;
            String fileLocation = this.configuration.getString(PREFS_KEY_CERT_FILE_URI);
            if (fileLocation == null) {
                throw new InvalidLoginException("File location is not present in configuration");
            }
            try {
                URL fileUrl = new URL(fileLocation);
                file = new File(fileUrl.toURI());
            }
            catch (MalformedURLException | URISyntaxException e) {
                LOG.debug("Could not parse file URI in configuration. Trying to revert to non-URI file path.");
                file = new File(this.configuration.getString(PREFS_KEY_CERT_FILE_URI));
            }
            try {
                return new KeyCertFileUserLoginInfo(file, this.geniUserFactory, this.authorityFinder);
            }
            catch (IOException e) {
                throw new InvalidLoginException("Cannot process login file '" + fileLocation + "'", e);
            }
        }
        if (Objects.equals(SOURCE_URL, sourceType)) {
            String url = this.configuration.getString(PREFS_KEY_CERT_FILE_URI);
            if (url == null) {
                throw new InvalidLoginException("URL is not present in configuration");
            }
            try {
                return new KeyCertUrlUserLoginInfo(new URL(url), this.geniUserFactory, this.authorityFinder);
            }
            catch (IOException e) {
                throw new InvalidLoginException("Cannot process login url '" + url + "'", e);
            }
        }
        if (Objects.equals(SOURCE_STRING, sourceType)) {
            return null;
        }
        LOG.info("No configuration found. Reverting to defaults");
        return this.defaults();
    }

    @Override
    public UserLoginInfo reset() {
        this.clearConfiguration();
        return this.defaults();
    }

    @Override
    public UserLoginInfo defaults() {
        return null;
    }
}

