/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.user;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class UserLoginModelPreferences {
    private final Map<String, Object> map = new HashMap<String, Object>();

    public void save(PropertiesConfiguration config) {
        try {
            config.clear();
            for (Map.Entry<String, Object> e : this.map.entrySet()) {
                if (e.getValue() == null) continue;
                if (e.getValue() instanceof Boolean) {
                    Boolean v = (Boolean)e.getValue();
                    config.setProperty(e.getKey(), (Object)v);
                    continue;
                }
                config.setProperty(e.getKey(), (Object)e.getValue().toString());
            }
            config.save();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Problem saving login configuration", e);
        }
    }

    public void load(PropertiesConfiguration config) {
        Iterator keys = config.getKeys();
        this.map.clear();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object val = config.getProperty(key);
            if (val != null && val instanceof String) {
                String sval = (String)val;
                if (sval.equalsIgnoreCase("true") || sval.equalsIgnoreCase("false")) {
                    this.map.put(key, sval.equalsIgnoreCase("true"));
                } else {
                    this.map.put(key, sval);
                }
            }
            if (val == null || !(val instanceof Boolean)) continue;
            Boolean bval = (Boolean)val;
            this.map.put(key, bval);
        }
    }

    public void put(String key, String value) {
        this.map.put(key, value);
    }

    public void putBoolean(String key, boolean value) {
        this.map.put(key, value);
    }

    public String get(String key, String defaultValue) {
        Object r = this.map.get(key);
        if (r == null) {
            return defaultValue;
        }
        return r.toString();
    }

    public String get(String key) {
        Object r = this.map.get(key);
        if (r != null) {
            return r.toString();
        }
        return null;
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Object v = this.map.get(key);
        if (v != null && v instanceof Boolean) {
            return (Boolean)v;
        }
        return defaultValue;
    }

    public boolean contains(String key) {
        return this.map.containsKey(key);
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public String toString() {
        return "UserLoginModelPreferences" + String.valueOf(this.map);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserLoginModelPreferences that = (UserLoginModelPreferences)o;
        return Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }
}

