/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.preferences;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GDPRInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.json.util.JsonInstantRFC3339Deserializer;
import be.iminds.ilabt.jfed.json.util.JsonInstantRFC3339Serializer;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.library.JFedUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.dropwizard.jackson.Jackson;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TestbedGdprConsentPreferences {
    private static final Logger LOG = LoggerFactory.getLogger(TestbedGdprConsentPreferences.class);
    private final Map<ConsentKey, Instant> storedConsentExpiration = new HashMap<ConsentKey, Instant>();

    public TestbedGdprConsentPreferences() {
        try {
            File consentPrefFile = JFedUtils.createPreferencesFile((String)"gdpr-consent.json");
            ObjectMapper mapper = Jackson.newObjectMapper();
            List consentObjs = (List)mapper.readValue(consentPrefFile, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, ConsentObj.class));
            if (consentObjs != null) {
                for (ConsentObj consentObj : consentObjs) {
                    ConsentKey key = consentObj.toConsentKey();
                    LOG.debug("Restored consent for " + String.valueOf(key) + " " + String.valueOf(consentObj.getExpire()));
                    this.storedConsentExpiration.put(key, consentObj.getExpire());
                }
            }
        }
        catch (IOException e) {
            LOG.warn("Error restoring GDPR Consent preferences", (Throwable)e);
        }
    }

    private void save() {
        try {
            File consentPrefFile = JFedUtils.createPreferencesFile((String)"gdpr-consent.json");
            ObjectMapper mapper = Jackson.newMinimalObjectMapper();
            ArrayList<ConsentObj> consentObjs = new ArrayList<ConsentObj>();
            for (Map.Entry<ConsentKey, Instant> e : this.storedConsentExpiration.entrySet()) {
                ConsentKey k = e.getKey();
                Instant expire = e.getValue();
                consentObjs.add(new ConsentObj(k, expire));
            }
            mapper.writerWithDefaultPrettyPrinter().writeValue(consentPrefFile, consentObjs);
        }
        catch (IOException e) {
            LOG.warn("Error saving GDPR Consent preferences", (Throwable)e);
        }
    }

    @Nullable
    private ConsentKey createConsentKey(@Nonnull Testbed testbed, @Nonnull String projectName, @Nonnull GeniUrn userUrn) {
        GDPRInfo gdprInfo = testbed.getGdprInfo();
        if (gdprInfo == null) {
            return null;
        }
        if (gdprInfo.getGrpdUrl() == null) {
            return null;
        }
        if (gdprInfo.getAcceptSubject() == null) {
            return null;
        }
        return new ConsentKey(gdprInfo.getGrpdUrl(), gdprInfo.getVersion(), gdprInfo.getAcceptSubject(), switch (gdprInfo.getAcceptSubject()) {
            case GDPRInfo.AcceptSubject.USER -> userUrn.toString();
            case GDPRInfo.AcceptSubject.PROJECT -> projectName;
            default -> throw new RuntimeException("Unsupported AcceptSubject: " + String.valueOf(gdprInfo.getAcceptSubject()));
        });
    }

    public boolean isConsentManaged(@Nonnull Testbed testbed, @Nonnull String projectName, @Nonnull GeniUrn userUrn) {
        ConsentKey consentKey = this.createConsentKey(testbed, projectName, userUrn);
        if (consentKey == null) {
            return true;
        }
        Instant expire = this.storedConsentExpiration.get(consentKey);
        if (expire == null) {
            return false;
        }
        boolean res = expire.isAfter(Instant.now().plus(Duration.ofMinutes(10L)));
        return res;
    }

    public void markConsentNotManaged(@Nonnull Testbed testbed, @Nonnull String projectName, @Nonnull GeniUrn userUrn) {
        ConsentKey consentKey = this.createConsentKey(testbed, projectName, userUrn);
        if (consentKey == null) {
            return;
        }
        this.storedConsentExpiration.remove(consentKey);
        this.save();
    }

    public void markConsentManaged(@Nonnull Testbed testbed, @Nonnull String projectName, @Nonnull GeniUrn userUrn) {
        this.markConsentManaged(testbed, projectName, userUrn, null);
    }

    public void markConsentManaged(@Nonnull Testbed testbed, @Nonnull String projectName, @Nonnull GeniUrn userUrn, @Nullable Instant until) {
        ConsentKey consentKey;
        if (testbed.getGdprInfo() == null) {
            return;
        }
        if (until == null) {
            if (testbed.getGdprInfo().getAcceptPeriodInDays() == null) {
                return;
            }
            until = Instant.now().plus(Duration.ofDays(testbed.getGdprInfo().getAcceptPeriodInDays().intValue()));
        }
        if ((consentKey = this.createConsentKey(testbed, projectName, userUrn)) == null) {
            return;
        }
        this.storedConsentExpiration.put(consentKey, until);
        this.save();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ConsentObj
    extends ConsentKey {
        private final Instant expire;

        @JsonCreator
        public ConsentObj(@JsonProperty(value="url") String url, @JsonProperty(value="version") String version, @JsonProperty(value="subjectType") GDPRInfo.AcceptSubject subjectType, @JsonProperty(value="subject") String subject, @JsonProperty(value="expire") Instant expire) {
            super(url, version, subjectType, subject);
            this.expire = expire;
        }

        public ConsentObj(@Nonnull ConsentKey k, Instant expire) {
            super(k.url, k.version, k.subjectType, k.subject);
            this.expire = expire;
        }

        public ConsentKey toConsentKey() {
            return new ConsentKey(this.url, this.version, this.subjectType, this.subject);
        }

        @JsonSerialize(using=JsonInstantRFC3339Serializer.class)
        @JsonDeserialize(using=JsonInstantRFC3339Deserializer.class)
        @JsonProperty
        public Instant getExpire() {
            return this.expire;
        }

        @JsonProperty
        public String getUrl() {
            return this.url;
        }

        @JsonProperty
        public String getVersion() {
            return this.version;
        }

        @JsonProperty
        public GDPRInfo.AcceptSubject getSubjectType() {
            return this.subjectType;
        }

        @JsonProperty
        public String getSubject() {
            return this.subject;
        }

        @Override
        public boolean equals(Object o) {
            throw new RuntimeException("Incorrect usage of class");
        }

        @Override
        public int hashCode() {
            throw new RuntimeException("Incorrect usage of class");
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ConsentKey {
        protected final String url;
        protected final String version;
        protected final GDPRInfo.AcceptSubject subjectType;
        protected final String subject;

        @JsonCreator
        public ConsentKey(@JsonProperty(value="expire") String url, @JsonProperty(value="expire") String version, @JsonProperty(value="expire") GDPRInfo.AcceptSubject subjectType, @JsonProperty(value="expire") String subject) {
            this.url = url;
            this.version = version;
            this.subjectType = subjectType;
            this.subject = subject;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConsentKey that = (ConsentKey)o;
            return Objects.equals(this.url, that.url) && Objects.equals(this.version, that.version) && this.subjectType == that.subjectType && Objects.equals(this.subject, that.subject);
        }

        public int hashCode() {
            return Objects.hash(this.url, this.version, this.subjectType, this.subject);
        }

        public String toString() {
            return "ConsentKey{url='" + this.url + "', version='" + this.version + "', subjectType=" + String.valueOf(this.subjectType) + ", subject='" + this.subject + "'}";
        }
    }
}

