/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.scanner;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager2;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager3;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticUserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.BasicConnectionBuilderFactory;
import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionBuilder;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.stitching.VlanRange;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ServerTrustInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.scanner.AuthorityScannerInput;
import be.iminds.ilabt.jfed.scanner.AuthorityScannerLogListener;
import be.iminds.ilabt.jfed.scanner.AuthorityType;
import be.iminds.ilabt.jfed.scanner.AuthorityTypeFinder;
import be.iminds.ilabt.jfed.scanner.ScanFeedback;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.debug_info.DebugInfoFactory;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import be.iminds.ilabt.jfed.util.library.SSLCertificateDownloader;
import be.iminds.ilabt.jfed.util.library.XmlRpcPrintUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ServerScanner.class);
    private static final Set<ServerPort> failedServerPorts = new HashSet<ServerPort>();
    private final be.iminds.ilabt.jfed.log.Logger logger;
    private final JFedPreferences jFedPreferences;
    private final AuthorityScannerInput input;
    private final ScanFeedback feedback;
    private final KeyStore trustedRootCerts;
    private final Set<X509Certificate> trustedCerts;
    private final Set<X509Certificate> trustedAuthCerts;
    private String trustedAlias;
    public final Map<ApiInfo.Api, ScannedInformation<String>> urlsByApi = new HashMap<ApiInfo.Api, ScannedInformation<String>>();
    protected final List<AuthorityScannerLogListener> resultListeners = new ArrayList<AuthorityScannerLogListener>();
    private final ScannedInformation<AuthorityType> types = new ScannedInformation();
    private final List<String> logs = new ArrayList<String>();
    private final ScannedInformation<String> hrns = new ScannedInformation();
    private final ScannedInformation<String> urns = new ScannedInformation();
    private final Set<ServerBase> serverBases = new HashSet<ServerBase>();
    private Mode mode;
    private boolean connectionSuccess = false;
    private boolean getVersionSuccess = false;
    private final boolean useProxy;
    private final GeniUserProvider geniUserProvider;
    private final JFedConnectionProvider connectionProvider;
    private final GeniUser loggedInUser;
    private final BasicConnectionBuilderFactory connectionBuilderFactory = new BasicConnectionBuilderFactory();

    public ServerScanner(be.iminds.ilabt.jfed.log.Logger logger, AuthorityScannerInput input, ScanFeedback feedback, JFedPreferences jFedPreferences, boolean useProxy, @Nullable GeniUserProvider geniUserProvider, JFedConnectionProvider connectionProvider) {
        this.logger = logger;
        this.jFedPreferences = jFedPreferences;
        this.input = input;
        this.feedback = feedback;
        this.useProxy = useProxy;
        this.connectionProvider = connectionProvider;
        this.geniUserProvider = geniUserProvider;
        this.loggedInUser = geniUserProvider == null ? null : geniUserProvider.getLoggedInGeniUser();
        this.trustedRootCerts = JFedTrustStore.getSystemTrustStore();
        this.trustedCerts = new HashSet<X509Certificate>(input.trustedCerts);
        this.trustedAuthCerts = new HashSet<X509Certificate>();
        this.trustedAlias = null;
    }

    public static Testbed createResult(ScannedInformation<AuthorityType> types, Map<ApiInfo.Api, ScannedInformation<String>> urlsByApi, ScannedInformation<String> hrns, ScannedInformation<String> urns, Set<X509Certificate> trustedAuthCerts, String trustedAlias) {
        GeniUrn urn;
        ServerBuilder resultServer = new ServerBuilder();
        TestbedBuilder resultTestbed = new TestbedBuilder();
        resultTestbed.addServerBuilder(resultServer);
        String urnString = urns.getMostTrusted();
        if (urnString == null) {
            urn = null;
        } else {
            try {
                urn = new GeniUrn(urnString);
            }
            catch (GeniUrn.GeniUrnParseException e) {
                throw new RuntimeException("invalid URN found: \"" + urnString + "\"");
            }
        }
        boolean isInstageni = urn == null ? false : urn.getEncodedTopLevelAuthority_withoutSubAuth().contains("instageni");
        boolean isExogeni = urn == null ? false : urn.getEncodedTopLevelAuthority_withoutSubAuth().contains("exogeni.net");
        Object testbedId = urn == null ? "CHANGE ME" : urn.getEncodedTopLevelAuthority_withoutSubAuth().replaceAll("[^A-Za-z0-9]", "");
        String siteName = "";
        Object siteNameCased = "";
        if (isInstageni) {
            siteName = urn.getEncodedTopLevelAuthority_withoutSubAuth().replaceFirst("instageni", "").replaceAll("\\.com$", "").replaceAll("\\.org$", "").replaceAll("\\.net$", "").replaceAll("\\.edu$", "").replaceAll(Pattern.quote("."), "");
            siteNameCased = Character.toUpperCase(siteName.charAt(0)) + siteName.toLowerCase().substring(1);
            testbedId = "instageni" + (String)siteNameCased;
        }
        resultTestbed.setId(testbedId);
        Object hrn = hrns.getMostTrusted();
        if (hrn == null) {
            hrn = testbedId;
        }
        if (hrn == null) {
            hrn = "CHANGE ME";
        }
        if (isInstageni) {
            hrn = "InstaGENI " + (String)siteNameCased;
        }
        resultTestbed.setLongName((String)hrn);
        resultServer.setName((String)hrn);
        String geniId = null;
        if (isInstageni) {
            geniId = siteName.toLowerCase() + "-ig";
            resultTestbed.setGeniId(geniId);
        }
        String usedURL = null;
        LOG.debug("urlsByApi.size = " + urlsByApi.size());
        for (Map.Entry<ApiInfo.Api, ScannedInformation<String>> e : urlsByApi.entrySet()) {
            ApiInfo.Api api = e.getKey();
            ScannedInformation<String> urlInfo = e.getValue();
            if (urlInfo.isEmpty()) continue;
            ServiceBuilder serviceBuilder = new ServiceBuilder();
            serviceBuilder.setApi(api.getId());
            serviceBuilder.setApiVersion(api.getVersion());
            serviceBuilder.setUrl(urlInfo.getMostTrusted());
            if (urn != null) {
                serviceBuilder.setUrn(ServerScanner.adaptCmUrnToRole(api.getName(), urn));
            }
            if (serviceBuilder.getUrl() != null) {
                usedURL = serviceBuilder.getUrl();
            }
            resultServer.addServiceBuilder(serviceBuilder);
        }
        if (usedURL != null) {
            try {
                URL url = new URL(usedURL);
                String baseUrl = usedURL.substring(0, usedURL.length() - url.getPath().length());
                resultServer.setBaseUrl(baseUrl);
                resultTestbed.setPingHost(url.getHost());
                if (geniId != null) {
                    try {
                        resultTestbed.setGeniHref(new URI("https://" + url.getHost() + ":5001/info/aggregate/" + geniId));
                    }
                    catch (URISyntaxException e) {
                        LOG.debug("Failed to genere geni href URI (-> ignored)");
                    }
                }
            }
            catch (MalformedURLException e) {
                LOG.error("Error in used URL", (Throwable)e);
            }
        }
        if (urnString != null) {
            try {
                GeniUrn geniUrn = new GeniUrn(urnString);
                resultServer.setUrnTld(geniUrn.getEncodedTopLevelAuthority_withoutSubAuth());
            }
            catch (GeniUrn.GeniUrnParseException e) {
                LOG.error("Error in used URN", (Throwable)e);
            }
        }
        if (types.getMostTrusted() != null) {
            resultServer.setServerType(types.getMostTrusted().toString());
        }
        if (trustedAuthCerts != null && !trustedAuthCerts.isEmpty()) {
            resultServer.setCertificateChain(KeyUtil.x509certificateChainToPem(trustedAuthCerts));
        }
        if (trustedAlias != null) {
            resultServer.setAllowedCertificateAlias(trustedAlias);
        }
        if (isInstageni) {
            resultTestbed.setAllowLinks(Boolean.valueOf(true));
        } else {
            resultTestbed.setAllowLinks(Boolean.valueOf(false));
        }
        return resultTestbed.create();
    }

    private static String adaptCmUrnToRole(ApiInfo.ApiName apiName, @Nonnull GeniUrn urn) {
        String urnResourceName;
        switch (apiName) {
            case PLANETLAB_SLICE_REGISTRY: {
                urnResourceName = "sr";
                break;
            }
            case PROTOGENI_SA: {
                urnResourceName = "sa";
                break;
            }
            case GENI_AM: {
                if (Objects.equals(urn.getResourceName(), "am")) {
                    urnResourceName = "am";
                    break;
                }
                urnResourceName = "cm";
                break;
            }
            case PROTOGENI_CH: {
                urnResourceName = "ch";
                break;
            }
            case GENI_CH: {
                urnResourceName = "ch";
                break;
            }
            case GENI_CH_SA: {
                urnResourceName = "sa";
                break;
            }
            case GENI_CH_MA: {
                urnResourceName = "ma";
                break;
            }
            case GENI_SCS: {
                urnResourceName = "scs";
                break;
            }
            case FED4FIRE_FEDMON: 
            case FED4FIRE_RESERVATION_CALENDER_PAGE: 
            case FED4FIRE_SLA_COLLECTOR: 
            case FED4FIRE_REPUTATION_SERVICE: {
                return null;
            }
            default: {
                throw new RuntimeException("Unsupported api " + String.valueOf((Object)apiName));
            }
        }
        return GeniUrn.createGeniUrnFromEncodedParts((String)urn.getEncodedTopLevelAuthority(), (String)"authority", (String)urnResourceName).toString();
    }

    public void addToUrlsByServerType(ScanCertainty certainty, ApiInfo.Api api, String url) {
        if (this.urlsByApi.containsKey(api)) {
            ScannedInformation<String> set = this.urlsByApi.get(api);
            set.add(certainty, url);
        } else {
            ScannedInformation<String> set = new ScannedInformation<String>();
            set.add(certainty, url);
            this.urlsByApi.put(api, set);
        }
    }

    public be.iminds.ilabt.jfed.log.Logger getLogger() {
        return this.logger;
    }

    private void log(@Nonnull String line) {
        this.logs.add(line);
        LOG.debug(line);
        this.fireLogLine(line);
    }

    private void log(@Nonnull String line, @Nonnull Throwable t) {
        String exceptionString = IOUtils.exceptionToStacktraceString((Throwable)t);
        this.logs.add(line);
        this.logs.add(exceptionString);
        LOG.debug(line, t);
        this.fireLogLine(line + "\n" + exceptionString + "\n");
    }

    public void findServerBases() {
        for (String urn : this.input.urns) {
            GeniUrn u = GeniUrn.parse((String)urn);
            if (u == null) continue;
            this.serverBases.add(new ServerBase(u.getEncodedTopLevelAuthority_withoutSubAuth(), 0, null));
        }
        for (String urlStr : this.input.urls) {
            try {
                String path;
                URL url = new URL(urlStr);
                int port = url.getPort();
                if (port <= 0) {
                    port = url.getDefaultPort();
                }
                if ((path = url.getPath()).endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                this.serverBases.add(new ServerBase(url.getHost(), port, path));
            }
            catch (MalformedURLException e) {
                this.log("Invalid URL: " + urlStr);
            }
        }
    }

    public void processInputUrl(String url) {
        this.addToUrlsByServerType(ScanCertainty.USER_INPUT, new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2), url);
    }

    public void addUrlsForType(AuthorityType authType) {
        this.addUrlsForType(authType, ScanCertainty.GUESS);
    }

    public void addUrlsForType(AuthorityType authType, ScanCertainty scanCertainty) {
        block5: for (ServerBase serverBase : this.serverBases) {
            switch (authType) {
                case EMULAB: {
                    ServerBase knownPort = new ServerBase(serverBase.hostname, 12369, serverBase.path);
                    ArrayList<ServerBase> bases = new ArrayList<ServerBase>();
                    bases.add(serverBase);
                    if (!Objects.equals(serverBase, knownPort)) {
                        bases.add(knownPort);
                    }
                    for (ServerBase base : bases) {
                        String serverBaseStr = base.toString().replaceAll("^www.", "").replaceAll("protogeni/xmlrpc.*", "");
                        this.addToUrlsByServerType(scanCertainty, new ApiInfo.Api(ApiInfo.ApiName.PROTOGENI_SA, 2), "https://www." + serverBaseStr + "protogeni/xmlrpc/sa");
                        this.addToUrlsByServerType(scanCertainty, new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_SA, 1), "https://www." + serverBaseStr + "protogeni/xmlrpc/geni-sa");
                        this.addToUrlsByServerType(scanCertainty, new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_MA, 1), "https://www." + serverBaseStr + "protogeni/xmlrpc/geni-ma");
                        this.addToUrlsByServerType(scanCertainty, new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2), "https://www." + serverBaseStr + "protogeni/xmlrpc/am/2.0");
                        this.addToUrlsByServerType(scanCertainty, new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 3), "https://www." + serverBaseStr + "protogeni/xmlrpc/am/3.0");
                    }
                    continue block5;
                }
                case SFAWRAP: {
                    this.addToUrlsByServerType(scanCertainty, new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 3), "https://" + String.valueOf(new ServerBase(serverBase.hostname, 12346, serverBase.path)));
                    this.addToUrlsByServerType(scanCertainty, new ApiInfo.Api(ApiInfo.ApiName.PLANETLAB_SLICE_REGISTRY, 1), "https://" + String.valueOf(new ServerBase(serverBase.hostname, 12345, serverBase.path)));
                    break;
                }
                case FOAM: {
                    String serverPath = serverBase.toString().replaceAll("foam/gapi.*", "");
                    this.addToUrlsByServerType(scanCertainty, new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 1), "https://" + String.valueOf(new ServerBase(serverBase.hostname, 3626, serverPath)) + "foam/gapi/1");
                    this.addToUrlsByServerType(scanCertainty, new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2), "https://" + String.valueOf(new ServerBase(serverBase.hostname, 3626, serverPath)) + "foam/gapi/2");
                    break;
                }
            }
        }
    }

    private JFedConnection.SshProxyInfo getProxyInfo() {
        if (!this.useProxy) {
            return null;
        }
        if (this.loggedInUser == null) {
            this.log("No user logged in, so cannot use use proxy!");
            return null;
        }
        assert (this.loggedInUser.getUserAuthorityServer() != null);
        List userProxies = this.loggedInUser.getUserAuthorityServer() == null ? Collections.emptyList() : this.loggedInUser.getUserAuthorityServer().getTestbed().getProxies();
        Optional<JFedConnection.SshProxyInfo> proxyInfo = userProxies.stream().findFirst().map(userProxy -> new JFedConnection.SshProxyInfo(userProxy.getHostname(), new VlanRange(userProxy.getPortRange()).getFirst().intValue(), userProxy.transformUsername(this.loggedInUser.getUserUrn().getEncodedResourceName()), (SshKeyInfo)SshKeyInfoFactory.createGeniUserSshKeyInfo(this.loggedInUser), userProxy.getHostKey()));
        if (proxyInfo.isPresent()) {
            this.log("Selected proxy to use: " + String.valueOf(proxyInfo.get()));
            return proxyInfo.get();
        }
        this.log("No user proxy known, so cannot use use proxy!");
        return null;
    }

    public boolean checkUrl(String urlStr) {
        try {
            URL url = new URL(urlStr);
            SSLCertificateDownloader.SSLCertificateJFedInfo info = SSLCertificateDownloader.getCertificateInfo((URL)url, (JFedConnection.SshProxyInfo)this.getProxyInfo());
            assert (info != null);
            if (info.isConnectionError()) {
                this.log("Note: Connection failure getting certificate info for \"" + urlStr + "\"", info.getConnectionException());
                return false;
            }
            this.log("Note: got certificate info for \"" + urlStr + "\". " + String.valueOf(info));
            boolean bl = this.connectionSuccess = info.getCert() != null;
            if (info.getUrn() == null) {
                String urn = "urn:publicid:IDN+" + url.getHost() + "+authority+cm";
                this.urns.add(ScanCertainty.GUESS, urn);
            } else {
                this.urns.add(ScanCertainty.INDIRECT_RECV_FROM_SERVER, info.getUrn());
            }
            if (info.getCert() == null) {
                this.log("Problem fetching certificate from server for URL: " + urlStr);
                return false;
            }
            if (info.isSelfSigned() == null) {
                this.log("Problem fetching certificate from server for URL (not known if cert is self signed): " + urlStr);
                return false;
            }
            if (info.isSelfSigned() != null) {
                if (info.isSelfSigned().booleanValue()) {
                    if (!this.trustedCerts.contains(info.getCert())) {
                        this.log("Note: server uses an unknown self signed certificate:\nIssuer=" + info.getCert().getIssuerDN().getName() + "\nSubject=" + info.getCert().getSubjectDN().getName() + "\n" + KeyUtil.x509certificateToPem((X509Certificate)info.getCert()));
                        ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
                        certChain.add(info.getCert());
                        if (!this.feedback.trustSelfSignedCert(certChain)) {
                            this.log("user does not trust certificate for: " + urlStr);
                            return false;
                        }
                        this.trustedCerts.addAll(certChain);
                        this.trustedAuthCerts.addAll(certChain);
                        this.log("User trusts self signed certificate for " + urlStr);
                    } else {
                        this.log("Note: server uses a self signed certificate that is already trusted by jFed:\n" + KeyUtil.x509certificateToPem((X509Certificate)info.getCert()));
                    }
                } else {
                    boolean globallyTrustedRootTest;
                    assert (!info.isSelfSigned().booleanValue());
                    try {
                        if (info.getChainRoot() == null) {
                            globallyTrustedRootTest = false;
                        } else {
                            String alias = this.trustedRootCerts.getCertificateAlias(info.getChainRoot());
                            globallyTrustedRootTest = alias != null;
                            LOG.debug("globallyTrustedRoot alias=" + alias);
                        }
                    }
                    catch (KeyStoreException e) {
                        LOG.error("KeyStoreException while trying to check if certificate is globally trusted root -> Will assume it is not.", (Throwable)e);
                        globallyTrustedRootTest = false;
                    }
                    assert (!globallyTrustedRootTest);
                    if (!this.trustedCerts.contains(info.getCert()) || info.getChainRoot() != null && !this.trustedCerts.contains(info.getChainRoot())) {
                        this.log("Note: server uses a non root, non self signed certificate:\nIssuer=" + info.getCert().getIssuerDN().getName() + "\nSubject=" + info.getCert().getSubjectDN().getName() + "\n" + KeyUtil.x509certificateToPem((X509Certificate)info.getCert()));
                        ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
                        certChain.add(info.getCert());
                        if (!this.feedback.trustNonSelfSignedCert(certChain)) {
                            this.log("user does not trust non self signed certificate for: " + urlStr);
                            return false;
                        }
                        this.trustedCerts.addAll(certChain);
                        this.trustedAuthCerts.addAll(certChain);
                        this.log("User trusts non-self signed certificate for " + urlStr);
                    } else {
                        boolean globallyTrustedRoot;
                        try {
                            globallyTrustedRoot = info.getChainRoot() != null && this.trustedRootCerts.getCertificateAlias(info.getChainRoot()) != null;
                        }
                        catch (KeyStoreException e) {
                            LOG.error("KeyStoreException while trying to check if certificate is globally trusted root -> Will assume it is not.", (Throwable)e);
                            globallyTrustedRoot = false;
                        }
                        if (globallyTrustedRoot) {
                            this.log("Note: server uses a non self signed certificate signed by a globally trusted root certificate:\n" + info.getChainRoot().getIssuerDN().getName());
                            ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
                            certChain.add(info.getCert());
                            this.trustedCerts.addAll(certChain);
                            this.trustedAuthCerts.addAll(certChain);
                        } else {
                            this.log("Note: server uses a non root, non self signed certificate that is already trusted by jFed:\n" + KeyUtil.x509certificateToPem((X509Certificate)info.getCert()));
                        }
                    }
                }
            }
            if (!info.getSubjectMatchesHostname().booleanValue() && url.getHost() != null && !Objects.equals(url.getHost(), info.getSubject())) {
                this.log("Note: Server certificate subject name is not for \"" + url.getHost() + "\" but for \"" + info.getSubject() + "\"");
                if (!this.feedback.trustAlias(url.getHost(), info.getSubject())) {
                    this.log("user does not trust certificate alias for: " + urlStr);
                    return false;
                }
                this.trustedAlias = info.getSubject();
                this.log("User trusts alias \"" + info.getSubject() + "\" in certificate.");
            } else {
                this.log("Note: Server certificate subject name for server \"" + url.getHost() + "\" is \"" + info.getSubject() + "\"");
            }
            return true;
        }
        catch (MalformedURLException e) {
            this.log("Invalid URL: " + urlStr);
            return false;
        }
    }

    public String fixUrl(URL serverUrl, String getVersionUrl) {
        Object serverBase = serverUrl.getHost();
        assert (!((String)serverBase).contains(":"));
        if (serverUrl.getPort() >= 0) {
            serverBase = (String)serverBase + ":" + serverUrl.getPort();
        }
        String res = getVersionUrl;
        if (serverUrl.toString().startsWith("https:") && res.startsWith("http:")) {
            res = res.replace("http:", "https:");
        }
        if (res.contains(":" + serverUrl.getPort())) {
            res = res.replace("localhost:" + serverUrl.getPort(), (CharSequence)serverBase);
            res = res.replace("127.0.0.1:" + serverUrl.getPort(), (CharSequence)serverBase);
        } else {
            res = res.replace("localhost", (CharSequence)serverBase);
            res = res.replace("127.0.0.1", (CharSequence)serverBase);
        }
        return res;
    }

    public boolean callAMGetVersion(@Nullable ApiInfo.Api api, URL url) {
        this.log("calling AM GetVersion on: " + String.valueOf(url));
        try {
            Map geniApiVersions;
            String amType;
            String newUrn;
            ServerBuilder serverBuilder = new ServerBuilder();
            serverBuilder.setDefaultComponentManagerUrn("urn:publicid:IDN+dummyforscan+authority+cm");
            serverBuilder.setName("scannedServer");
            if (this.trustedAlias != null) {
                LOG.debug("AM connection will trust SSL certificate alias " + this.trustedAlias);
                serverBuilder.setAllowedCertificateAlias(this.trustedAlias);
            } else {
                LOG.debug("AM connection will NOT trust any SSL certificate alias");
            }
            if (this.trustedAuthCerts != null && !this.trustedAuthCerts.isEmpty()) {
                serverBuilder.setCertificateChain(KeyUtil.x509certificateChainToPem(this.trustedAuthCerts));
            }
            ServiceBuilder serviceBuilder = new ServiceBuilder();
            if (api != null) {
                serviceBuilder.setApi(api.getId());
                serviceBuilder.setApiVersion(api.getVersion());
            }
            serviceBuilder.setUrl(url.toExternalForm());
            serviceBuilder.setUrn("urn:publicid:IDN+dummyforscan+authority+cm");
            serverBuilder.addServiceBuilder(serviceBuilder);
            Server wizardCreatedServer = serverBuilder.create();
            AggregateManager2 am2 = new AggregateManager2(this.getLogger(), this.jFedPreferences);
            ConnectionBuilder connectionBuilder = this.connectionBuilderFactory.createConnectionBuilder();
            connectionBuilder.setDebugInfo(DebugInfoFactory.createFromService(null, (Service)wizardCreatedServer.getServices().get(0)));
            connectionBuilder.setProxy((JFedConnection.ProxyInfo)this.getProxyInfo(), false);
            connectionBuilder.setUrl(url);
            connectionBuilder.useHttps(new JFedTrustStore(ServerTrustInfo.convert(wizardCreatedServer)), null);
            connectionBuilder.useSslClientAuthentication(this.input.userCerts, this.input.userPrivateKey);
            AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager2.VersionInfo> versionInfoReply = am2.getVersion(connectionBuilder.buildSfaConnection());
            this.log("  Processing GetVersion result. (" + XmlRpcPrintUtil.xmlRpcObjectToString((Object)versionInfoReply.getRawResult()).length() + " bytes in json)");
            if (versionInfoReply.getRawResult() == null) {
                this.log("GetVersion result is null");
                return false;
            }
            if (versionInfoReply.getRawResult().get("value") == null) {
                this.log("GetVersion result has no value");
                return false;
            }
            if (!(versionInfoReply.getRawResult().get("value") instanceof Map)) {
                this.log("GetVersion result has non Map value: " + versionInfoReply.getRawResult().get("value").getClass().getName());
                return false;
            }
            Map valueHt = (Map)versionInfoReply.getRawResult().get("value");
            this.getVersionSuccess = true;
            ScannedInformation<AuthorityType> scannedType = AuthorityTypeFinder.findTypeFromGetVersionReply(versionInfoReply.getRawResult());
            if (scannedType != null) {
                this.types.addAll(scannedType);
                this.log("Type(s) derived from GetVersion: " + String.valueOf(scannedType.getSet()));
            } else {
                this.log("No type derived from GetVersion reply");
            }
            String newHrn = (String)valueHt.get("hrn");
            if (newHrn != null) {
                serverBuilder.setName(newHrn);
            }
            if ((newUrn = (String)valueHt.get("urn")) != null) {
                serverBuilder.setDefaultComponentManagerUrn(newUrn);
                this.urns.add(ScanCertainty.RECV_FROM_SERVER, newUrn);
            }
            if ((amType = (String)valueHt.get("geni_am_type")) != null) {
                for (AuthorityType t : AuthorityType.values()) {
                    if (!t.name().equalsIgnoreCase(amType.trim())) continue;
                    serverBuilder.setServerType(amType);
                    this.types.add(ScanCertainty.RECV_FROM_SERVER, t);
                }
            }
            if (valueHt.get("orca_version") != null) {
                serverBuilder.setServerType(amType);
                this.types.add(ScanCertainty.RECV_FROM_SERVER, AuthorityType.ORCA);
            }
            ApiInfo.Api realServerType = null;
            if (valueHt.containsKey("geni_api")) {
                Object apiVersion = valueHt.get("geni_api");
                if (apiVersion instanceof Integer) {
                    realServerType = new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, (Integer)apiVersion);
                }
                if (apiVersion instanceof String) {
                    realServerType = new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, Integer.parseInt((String)apiVersion));
                }
                if (realServerType != null) {
                    this.addToUrlsByServerType(ScanCertainty.CONFIRMED, realServerType, url.toString());
                }
            }
            if ((geniApiVersions = (Map)valueHt.get("geni_api_versions")).containsKey("3")) {
                this.addToUrlsByServerType(ScanCertainty.RECV_FROM_SERVER, new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 3), this.fixUrl(url, (String)geniApiVersions.get("3")));
            }
            if (geniApiVersions.containsKey("2")) {
                this.addToUrlsByServerType(ScanCertainty.RECV_FROM_SERVER, new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2), this.fixUrl(url, (String)geniApiVersions.get("2")));
            }
            return true;
        }
        catch (Exception e) {
            this.log("exception calling GetVersion: " + e.getMessage(), e);
            return false;
        }
    }

    public boolean callAMListResources() {
        this.log("calling AM ListResources");
        try {
            if (this.loggedInUser == null) {
                this.log("There is no logged in user: cannot call ListResources");
                return false;
            }
            AutomaticUserAndSliceApiWrapper saWrapper = new AutomaticUserAndSliceApiWrapper.BasicAutomaticUserAndSliceApiWrapperFactory(this.logger, this.geniUserProvider, this.connectionProvider, this.jFedPreferences).create();
            List<AnyCredential> credentialList = ((UserAndSliceApiWrapper)saWrapper).getUserCredentials(this.logger, this.loggedInUser.getUserUrn());
            if (credentialList.isEmpty()) {
                this.log("Failed to retrieve user credentials: cannot call ListResources");
                return false;
            }
            HashMap urlMap = new HashMap();
            for (Map.Entry<ApiInfo.Api, ScannedInformation<String>> entry : this.urlsByApi.entrySet()) {
                ApiInfo.Api api = entry.getKey();
                ScannedInformation<String> si = entry.getValue();
                if (si == null || si.isEmpty()) continue;
                si.getFacts().stream().filter(fact -> fact.getCertainty().isMoreOrEqualCertainThan(ScanCertainty.RECV_FROM_SERVER)).forEach(fact -> {
                    try {
                        urlMap.put(scannedInfoServerType, new URL((String)fact.getFact()));
                        this.log("callAMListResources is using URL " + (String)fact.getFact() + " for " + String.valueOf(scannedInfoServerType));
                    }
                    catch (MalformedURLException e1) {
                        this.log("callAMListResources is Ignoring malformed URL: " + (String)fact.getFact());
                    }
                });
            }
            if (urlMap.isEmpty()) {
                this.log("callAMListResources has no URL to work on");
                return false;
            }
            ServerBuilder serverBuilder = new ServerBuilder();
            serverBuilder.setDefaultComponentManagerUrn("urn:publicid:IDN+dummyforscan+authority+cm");
            serverBuilder.setName("scannedServer");
            serverBuilder.setAllowedCertificateAlias(this.trustedAlias);
            if (this.trustedAuthCerts != null && !this.trustedAuthCerts.isEmpty()) {
                serverBuilder.setCertificateChain(KeyUtil.x509certificateChainToPem(this.trustedAuthCerts));
            }
            for (Map.Entry entry : urlMap.entrySet()) {
                ApiInfo.Api api = (ApiInfo.Api)entry.getKey();
                URL url = (URL)entry.getValue();
                ServiceBuilder serviceBuilder = new ServiceBuilder();
                serviceBuilder.setApi(api.getId());
                serviceBuilder.setApiVersion(api.getVersion());
                serviceBuilder.setUrl(url.toExternalForm());
                serviceBuilder.setUrn("urn:publicid:IDN+dummyforscan+authority+cm");
                serverBuilder.addServiceBuilder(serviceBuilder);
            }
            Server server = serverBuilder.create();
            ConnectionBuilder connectionBuilder = this.connectionBuilderFactory.createConnectionBuilder();
            connectionBuilder.setDebugInfo(DebugInfoFactory.createFromService(null, (Service)server.getServices().get(0)));
            connectionBuilder.setProxy((JFedConnection.ProxyInfo)this.getProxyInfo(), false);
            connectionBuilder.useHttps(new JFedTrustStore(ServerTrustInfo.convert(server)), null);
            connectionBuilder.useSslClientAuthentication(this.input.userCerts, this.input.userPrivateKey);
            connectionBuilder.setSocketConnectTimeoutMs(this.jFedPreferences.getInt(CorePreferenceKey.PREF_SOCKET_CONNECT_TIMEOUT_MS, 10000));
            connectionBuilder.setSocketReadTimeoutMs(this.jFedPreferences.getInt(CorePreferenceKey.PREF_SOCKET_READ_TIMEOUT_MS, 120000));
            AbstractGeniAggregateManager.AggregateManagerReply<String> listResourcesReply = null;
            if (urlMap.containsKey(new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 3))) {
                connectionBuilder.setUrl((URL)urlMap.get(new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 3)));
                AggregateManager3 am3 = new AggregateManager3(this.getLogger(), this.jFedPreferences);
                listResourcesReply = am3.listResources(connectionBuilder.buildSfaConnection(), credentialList, "geni", "3", false, true, null);
            }
            if (listResourcesReply == null && urlMap.containsKey(new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2))) {
                connectionBuilder.setUrl((URL)urlMap.get(new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2)));
                AggregateManager2 am2 = new AggregateManager2(this.getLogger(), this.jFedPreferences);
                listResourcesReply = am2.listResources(connectionBuilder.buildSfaConnection(), credentialList, "geni", "3", false, true, null, null);
            }
            if (listResourcesReply == null) {
                this.log("ListResources reply is null");
                return false;
            }
            this.log("  Processing ListResources result. (" + XmlRpcPrintUtil.xmlRpcObjectToString((Object)listResourcesReply.getRawResult()).length() + " bytes in json)");
            if (listResourcesReply.getRawResult() == null) {
                this.log("ListResources result is null");
                return false;
            }
            if (listResourcesReply.getRawResult().get("value") == null) {
                this.log("ListResources result has no value");
                return false;
            }
            if (!(listResourcesReply.getRawResult().get("value") instanceof String)) {
                this.log("ListResources result has non String value: " + listResourcesReply.getRawResult().get("value").getClass().getName());
                return false;
            }
            if (listResourcesReply.getValue() == null) {
                this.log("ListResources result has no processed value");
                return false;
            }
            String rspec = (String)listResourcesReply.getValue();
            BasicStringRspec basicStringRspec = new BasicStringRspec(rspec);
            if (!basicStringRspec.isWellFormed()) {
                this.log("ListResources returned an RSpec that is not well formed");
                return false;
            }
            if (!basicStringRspec.isValidRspec()) {
                this.log("ListResources returned an RSpec that is not a valid RSpec");
                return false;
            }
            List<String> componentManagerUrns = basicStringRspec.getAllComponentManagerUrns();
            if (componentManagerUrns != null) {
                if (componentManagerUrns.size() == 1) {
                    String urn = componentManagerUrns.get(0);
                    this.urns.add(ScanCertainty.RECV_FROM_SERVER, urn);
                    this.log("ListResources found AM urn: " + urn);
                }
                if (componentManagerUrns.size() > 1) {
                    this.log("ListResources found multiple AM urn candidates: " + String.valueOf(componentManagerUrns));
                    for (String urn : componentManagerUrns) {
                        this.urns.add(ScanCertainty.GUESS, urn);
                    }
                }
                if (componentManagerUrns.isEmpty()) {
                    this.log("ListResources found not a single component_manager_urn");
                }
            } else {
                this.log("ListResources returned an RSpec that BasicStringRspec had trouble processing");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.log("exception calling ListResources: " + e.getMessage(), e);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void scan() {
        Object urls;
        ApiInfo.Api api;
        for (X509Certificate x509Certificate : this.input.trustedCerts) {
            this.types.addAll(AuthorityTypeFinder.findTypeFromCert(x509Certificate));
        }
        for (X509Certificate x509Certificate : this.input.userCerts) {
            this.types.addAll(AuthorityTypeFinder.findTypeFromCert(x509Certificate));
        }
        for (String string : this.input.urns) {
            this.types.addAll(AuthorityTypeFinder.findTypeFromUrn(string));
        }
        for (String string : this.input.urls) {
            this.types.addAll(AuthorityTypeFinder.findTypeFromUrl(string));
        }
        if (this.input.type != null) {
            this.types.add(ScanCertainty.USER_INPUT, this.input.type);
        }
        if (this.input.urns.size() == 1) {
            this.urns.add(ScanCertainty.USER_INPUT, this.input.urns.get(0));
        }
        this.log("Derived Authority type from initial input: " + String.valueOf(this.types));
        if (this.mode == Mode.EXPERIMENTAL) {
            this.findServerBases();
            this.log("serverBases: " + String.valueOf(this.serverBases));
        }
        this.input.urls.forEach(this::processInputUrl);
        if (this.mode == Mode.EXPERIMENTAL) {
            this.types.getSet().forEach(this::addUrlsForType);
        }
        HashMap<ApiInfo.Api, ArrayList<String>> origUrlsByServerType = new HashMap<ApiInfo.Api, ArrayList<String>>();
        for (Map.Entry<ApiInfo.Api, ScannedInformation<String>> entry : this.urlsByApi.entrySet()) {
            ApiInfo.Api api2 = entry.getKey();
            ScannedInformation<String> urls2 = entry.getValue();
            origUrlsByServerType.put(api2, new ArrayList<String>(urls2.getSet()));
        }
        for (Map.Entry entry : origUrlsByServerType.entrySet()) {
            ApiInfo.Api api3 = (ApiInfo.Api)entry.getKey();
            List urls2 = (List)entry.getValue();
            this.testUrls(api3, urls2);
        }
        if (this.mode == Mode.EXPERIMENTAL && this.types.isEmpty()) {
            void var4_24;
            this.log("No types are known, so falling back to trying all types. This could take a while.");
            AuthorityType[] authorityTypeArray = AuthorityType.values();
            int n = authorityTypeArray.length;
            boolean bl = false;
            while (var4_24 < n) {
                AuthorityType authorityType = authorityTypeArray[var4_24];
                this.addUrlsForType(authorityType, ScanCertainty.FALLBACK);
                ++var4_24;
            }
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry<ApiInfo.Api, ScannedInformation<String>> entry : this.urlsByApi.entrySet()) {
            api = entry.getKey();
            urls = entry.getValue();
            List orig_urls = (List)origUrlsByServerType.get(api);
            ArrayList newUrlList = new ArrayList(((ScannedInformation)urls).getSet());
            if (orig_urls != null) {
                newUrlList.removeAll(orig_urls);
            }
            if (newUrlList.isEmpty()) continue;
            hashMap.put(api, newUrlList);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            api = (ApiInfo.Api)entry.getKey();
            urls = (List)entry.getValue();
            this.testUrls(api, (List<String>)urls);
        }
    }

    private void testUrls(ApiInfo.Api api, List<String> urls) {
        this.log("URLs to test for " + String.valueOf(api) + ": " + String.valueOf(urls));
        assert (this.mode != null);
        assert (urls != null);
        block6: for (String urlStr : urls) {
            boolean ok;
            URL url;
            try {
                url = new URL(urlStr);
            }
            catch (MalformedURLException e1) {
                this.log("Invalid URL: " + urlStr);
                continue;
            }
            ServerPort serverPort = new ServerPort(url.getHost(), url.getPort() <= 0 ? url.getDefaultPort() : url.getPort());
            if (failedServerPorts.contains(serverPort)) {
                this.log("Server port is already known not to work, will not try again: " + urlStr);
                ok = false;
            } else {
                ok = this.checkUrl(urlStr);
            }
            if (!ok) {
                this.log("Could not setup secure SSL connection to: " + urlStr);
                failedServerPorts.add(serverPort);
                continue;
            }
            switch (api.getName()) {
                case GENI_AM: {
                    boolean goodUrnKnown;
                    if (!this.callAMGetVersion(api, url)) continue block6;
                    boolean bl = goodUrnKnown = !this.urns.isEmpty() && this.urns.getMostTrustedScannedSingleFact().getCertainty().isMoreOrEqualCertainThan(ScanCertainty.RECV_FROM_SERVER);
                    if (goodUrnKnown) {
                        this.log("AM URN known already, no need for ListResources.");
                        break;
                    }
                    this.log("No AM URN known, will try to get it using ListResources.");
                    boolean listResourcesResult = this.callAMListResources();
                    if (listResourcesResult) continue block6;
                    this.log("ListResources was unsuccesful");
                    break;
                }
                case PROTOGENI_CH: 
                case GENI_CH: 
                case GENI_SCS: {
                    break;
                }
                default: {
                    this.log("unsupported servertype: " + String.valueOf(api));
                }
            }
        }
    }

    public AuthorityType getType() {
        return this.types.getMostTrusted();
    }

    public Testbed getAutoResult() {
        return ServerScanner.createResult(this.types, this.urlsByApi, this.hrns, this.urns, this.trustedAuthCerts, this.trustedAlias);
    }

    public synchronized void fireLogLine(String logLine) {
        for (AuthorityScannerLogListener l : this.resultListeners) {
            l.onLogLine(logLine);
        }
    }

    public synchronized void addResultListener(AuthorityScannerLogListener l) {
        this.resultListeners.add(l);
    }

    public synchronized void removeResultListener(AuthorityScannerLogListener l) {
        this.resultListeners.remove(l);
    }

    public String getLogText() {
        Object res = "";
        for (String logline : this.logs) {
            res = (String)res + logline + "\n";
        }
        return res;
    }

    public List<String> getLogs() {
        return this.logs;
    }

    public ScannedInformation<String> getHrns() {
        return this.hrns;
    }

    public ScannedInformation<String> getUrns() {
        return this.urns;
    }

    public Map<ApiInfo.Api, ScannedInformation<String>> getUrlsByApi() {
        return this.urlsByApi;
    }

    public String getTrustedAlias() {
        return this.trustedAlias;
    }

    public Set<X509Certificate> getTrustedAuthCerts() {
        return this.trustedAuthCerts;
    }

    public ScannedInformation<AuthorityType> getTypes() {
        return this.types;
    }

    public boolean isConnectionSuccess() {
        return this.connectionSuccess;
    }

    public boolean isGetVersionSuccess() {
        return this.getVersionSuccess;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public static class ScannedInformation<T> {
        final Set<ScannedSingleFact<T>> infoSet = new HashSet<ScannedSingleFact<T>>();

        public void add(ScanCertainty certainty, T fact) {
            this.infoSet.add(new ScannedSingleFact<T>(certainty, fact));
        }

        public void add(ScannedSingleFact<T> fact) {
            this.infoSet.add(fact);
        }

        public T getMostTrusted() {
            ScannedSingleFact<T> res = this.getMostTrustedScannedSingleFact();
            if (res == null) {
                return null;
            }
            return res.getFact();
        }

        public ScannedSingleFact<T> getMostTrustedScannedSingleFact() {
            ScannedSingleFact<T> res = null;
            for (ScannedSingleFact<T> fact : this.infoSet) {
                if (res != null && !fact.certainty.isMoreCertainThan(res.certainty)) continue;
                res = fact;
            }
            if (res == null) {
                return null;
            }
            return res;
        }

        public Set<T> getSet() {
            return this.infoSet.stream().map(ScannedSingleFact::getFact).collect(Collectors.toSet());
        }

        public Collection<ScannedSingleFact<T>> getFacts() {
            return this.infoSet;
        }

        public boolean isEmpty() {
            return this.infoSet.isEmpty();
        }

        public void addAll(ScannedInformation<T> infos) {
            if (infos == null) {
                return;
            }
            this.infoSet.addAll(infos.infoSet);
        }

        public String toString() {
            return this.infoSet.toString();
        }
    }

    public static enum ScanCertainty {
        WRONG(-1),
        FALLBACK(0),
        GUESS(1),
        GOOD_GUESS(2),
        USER_INPUT(3),
        INDIRECT_RECV_FROM_SERVER(4),
        RECV_FROM_SERVER(5),
        CONFIRMED(10);

        public final int value;

        private ScanCertainty(int value) {
            this.value = value;
        }

        public boolean isMoreCertainThan(ScanCertainty o) {
            return this.value > o.value;
        }

        public boolean isMoreOrEqualCertainThan(ScanCertainty o) {
            return this.value >= o.value;
        }
    }

    private class ServerBase {
        final String hostname;
        final int port;
        final String path;

        ServerBase(String hostname, int port, String path) {
            assert (hostname != null);
            this.hostname = hostname;
            this.port = port;
            this.path = path;
            assert (!hostname.contains(":")) : "ServerBase hostname contains port: \"" + hostname + "\"";
        }

        public String toString() {
            if (this.path == null) {
                if (this.port <= 0) {
                    return this.hostname + "/";
                }
                return this.hostname + ":" + this.port + "/";
            }
            if (this.port <= 0) {
                return this.hostname + "/" + this.path + "/";
            }
            return this.hostname + ":" + this.port + "/" + this.path + "/";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServerBase that = (ServerBase)o;
            if (this.port != that.port) {
                return false;
            }
            if (!Objects.equals(this.hostname, that.hostname)) {
                return false;
            }
            return !(this.path != null ? !Objects.equals(this.path, that.path) : that.path != null);
        }

        public int hashCode() {
            int result = this.hostname.hashCode();
            result = 31 * result + this.port;
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            return result;
        }
    }

    public static enum Mode {
        BASIC,
        EXPERIMENTAL;

    }

    private class ServerPort {
        public final String hostname;
        public final int port;

        private ServerPort(String hostname, int port) {
            this.hostname = hostname;
            this.port = port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServerPort that = (ServerPort)o;
            if (this.port != that.port) {
                return false;
            }
            return Objects.equals(this.hostname, that.hostname);
        }

        public int hashCode() {
            int result = this.hostname.hashCode();
            result = 31 * result + this.port;
            return result;
        }
    }

    public static class ScannedSingleFact<T> {
        private final T fact;
        private final ScanCertainty certainty;

        public ScannedSingleFact(ScanCertainty certainty, T fact) {
            this.fact = fact;
            this.certainty = certainty;
        }

        public T getFact() {
            return this.fact;
        }

        public ScanCertainty getCertainty() {
            return this.certainty;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScannedSingleFact that = (ScannedSingleFact)o;
            if (this.certainty != that.certainty) {
                return false;
            }
            return !(this.fact != null ? !Objects.equals(this.fact, that.fact) : that.fact != null);
        }

        public int hashCode() {
            int result = this.fact != null ? this.fact.hashCode() : 0;
            result = 31 * result + (this.certainty != null ? this.certainty.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ScannedSingleFact{fact=" + String.valueOf(this.fact) + ", certainty=" + String.valueOf((Object)this.certainty) + "}";
        }
    }
}

