/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.lib;

import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.SshVersionFinder;
import be.iminds.ilabt.jfed.util.lib.BestNodeLoginFinder;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnsibleFileWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AnsibleFileWriter.class);
    private final BasicStringRspec basicStringRspec;
    private final List<BasicStringRspec> altBasicStringRspecs;
    private final List<String> excludedClientIds;
    private final PrivateKeyHandling privateKeyHandling;
    private final File privateKeyFile;
    private final PrivateKey privateKey;
    private final PublicKey publicKey;
    private final GeniUser loggedInUser;
    private final String preferredUser;
    private final Map<String, Set<String>> extraGroups;
    private final JFedConnection.SshProxyInfo proxyInfo;
    public static final String PUBLIC_KEY_FILE_BASENAME = "id_rsa.pub";
    public static final String PRIVATE_KEY_FILE_BASENAME = "id_rsa";
    public static final String PROXY_PRIVATE_KEY_FILE_TEMPLATE = "id_rsa_proxy_";
    public static final String ANSIBLE_HOSTS_FILE_BASENAME = "ansible-hosts";
    public static final String ANSIBLE_CONFIG_FILE_BASENAME = "ansible.cfg";
    public static final String FABRIC_FILE_BASENAME = "fabfile.py";
    public static final String SSH_CONFIG_FILE_BASENAME = "ssh-config";
    public static final String SSH_PROXY_KNOWN_HOST_TEMPLATE = "known_host_proxy_";
    public static final String README_FILE_BASENAME = "README.txt";
    public static final String REQUIREMENTS_FILE_BASENAME = "requirements.txt";

    private AnsibleFileWriter(BasicStringRspec basicStringRspec, PrivateKeyHandling privateKeyHandling, File privateKeyFile, PrivateKey privateKey, PublicKey publicKey, GeniUser loggedInUser, JFedConnection.SshProxyInfo proxyInfo, String preferredUser) {
        this.basicStringRspec = basicStringRspec;
        this.altBasicStringRspecs = new ArrayList<BasicStringRspec>();
        this.excludedClientIds = new ArrayList<String>();
        this.privateKeyHandling = privateKeyHandling;
        this.privateKeyFile = privateKeyHandling == PrivateKeyHandling.DONTUSE ? null : privateKeyFile;
        this.privateKey = privateKeyHandling == PrivateKeyHandling.DONTUSE ? null : privateKey;
        this.publicKey = publicKey;
        this.loggedInUser = loggedInUser;
        this.preferredUser = preferredUser;
        this.proxyInfo = proxyInfo;
        this.extraGroups = new HashMap<String, Set<String>>();
        if (privateKeyHandling == PrivateKeyHandling.LINK) assert (privateKeyFile != null);
        if (privateKeyHandling == PrivateKeyHandling.COPY) assert (privateKey != null);
    }

    public static AnsibleFileWriter createWithoutPrivateKey(BasicStringRspec basicStringRspec, File privateKeyFile, PublicKey publicKey, GeniUser loggedInUser, JFedConnection.SshProxyInfo proxyInfo, String preferredUser) {
        return new AnsibleFileWriter(basicStringRspec, PrivateKeyHandling.DONTUSE, privateKeyFile, null, publicKey, loggedInUser, proxyInfo, preferredUser);
    }

    public static AnsibleFileWriter createWithLinkedPrivateKey(BasicStringRspec basicStringRspec, File privateKeyFile, PublicKey publicKey, GeniUser loggedInUser, JFedConnection.SshProxyInfo proxyInfo, String preferredUser) {
        return new AnsibleFileWriter(basicStringRspec, PrivateKeyHandling.LINK, privateKeyFile, null, publicKey, loggedInUser, proxyInfo, preferredUser);
    }

    public static AnsibleFileWriter createWithCopiedPrivateKey(BasicStringRspec basicStringRspec, PrivateKey privateKey, PublicKey publicKey, GeniUser loggedInUser, JFedConnection.SshProxyInfo proxyInfo, String preferredUser) {
        return new AnsibleFileWriter(basicStringRspec, PrivateKeyHandling.COPY, null, privateKey, publicKey, loggedInUser, proxyInfo, preferredUser);
    }

    public void addAltBasicStringRspec(BasicStringRspec altBasicStringRspec) {
        this.altBasicStringRspecs.add(altBasicStringRspec);
    }

    public void addAltBasicStringRspec(String altRspecString) {
        this.altBasicStringRspecs.add(new BasicStringRspec(altRspecString));
    }

    public void addExcludedClientId(String clientId) {
        this.excludedClientIds.add(clientId);
    }

    public void addExtraGroups(Map<String, List<String>> groups) {
        for (Map.Entry<String, List<String>> e : groups.entrySet()) {
            this.extraGroups.computeIfAbsent(e.getKey(), k -> new HashSet()).addAll((Collection)e.getValue());
        }
    }

    public String getPublicKeyFileContent() {
        return this.publicKey == null ? null : KeyUtil.publicKeyToOpenSshAuthorizedKeysFormat((PublicKey)this.publicKey);
    }

    public String getAnsibleConfigFileContent() {
        String privateKeyFilePath = switch (this.privateKeyHandling.ordinal()) {
            case 0 -> "./id_rsa";
            case 1 -> this.privateKeyFile.getAbsolutePath();
            case 2 -> null;
            default -> throw new RuntimeException("Unsupported privateKeyHandling -> " + String.valueOf((Object)this.privateKeyHandling));
        };
        return "[defaults]\n" + (String)(privateKeyFilePath == null ? "" : "private_key_file = " + privateKeyFilePath + "\n") + "host_key_checking = false\ninventory = ansible-hosts\n\n[ssh_connection]\nssh_args = -F ssh-config\nscp_if_ssh = True\n";
    }

    private Optional<BasicStringRspec.LoginService> getPrimaryLoginService(BasicStringRspec.BasicNodeInfo nodeInfo) {
        BestNodeLoginFinder.Feedback feedback = new BestNodeLoginFinder.Feedback(){

            @Override
            public void info(String s) {
                LOG.info(s);
            }

            @Override
            public void error(String s) {
                LOG.error(s);
            }

            @Override
            public void debug(String s) {
                LOG.debug(s);
            }
        };
        BestNodeLoginFinder finder = new BestNodeLoginFinder(this.basicStringRspec, this.preferredUser, this.loggedInUser, feedback);
        BasicStringRspec.LoginService best = finder.findBestLogin(nodeInfo.getUniqueId());
        ListIterator<BasicStringRspec> it = this.altBasicStringRspecs.listIterator();
        while (best == null && it.hasNext()) {
            finder = new BestNodeLoginFinder(it.next(), this.preferredUser, this.loggedInUser, feedback);
            best = finder.findBestLogin(nodeInfo.getUniqueId());
        }
        if (best != null && best.getSshProxy() == null && this.proxyInfo != null) {
            best = new BasicStringRspec.LoginService(best.getAuthentication(), best.getHostname(), best.getPort(), best.getUsername(), this.proxyInfo);
        }
        return Optional.ofNullable(best);
    }

    public String getAnsibleHostFileContent() {
        Object res = "# Sample commands:\n# ansible nodes -m ping\n# ansible nodes -m shell -a \"uptime\"\n\n[nodes]\n";
        List<BasicStringRspec.BasicNodeInfo> nodeInfoList = this.basicStringRspec.getBasicNodeInfo();
        if (nodeInfoList == null) {
            throw new IllegalStateException("Could not find node info");
        }
        boolean useClientIdInsteadOfHostname = this.hasSshLoginsWithDiffNodeDuplicateHostname(nodeInfoList);
        HashSet<String> rspecAnsibleGroups = new HashSet<String>();
        for (BasicStringRspec.BasicNodeInfo nodeInfo : nodeInfoList) {
            Object loginService;
            if (this.excludedClientIds.contains(nodeInfo.getClientId()) || !((Optional)(loginService = this.getPrimaryLoginService(nodeInfo))).isPresent()) continue;
            rspecAnsibleGroups.addAll(nodeInfo.getAnsibleGroups());
            BasicStringRspec.LoginService ls = ((Optional)loginService).get();
            res = (String)res + this.makeAnsibleHostLine(useClientIdInsteadOfHostname, nodeInfo.getClientId(), ls);
        }
        rspecAnsibleGroups.removeAll(this.extraGroups.keySet());
        for (String ansibleGroup : rspecAnsibleGroups) {
            res = (String)res + "\n[" + ansibleGroup + "]\n";
            for (BasicStringRspec.BasicNodeInfo nodeInfo : nodeInfoList) {
                Optional<BasicStringRspec.LoginService> loginService;
                if (this.excludedClientIds.contains(nodeInfo.getClientId()) || !nodeInfo.getAnsibleGroups().contains(ansibleGroup) || !(loginService = this.getPrimaryLoginService(nodeInfo)).isPresent()) continue;
                BasicStringRspec.LoginService ls = loginService.get();
                res = (String)res + this.makeAnsibleHostLine(useClientIdInsteadOfHostname, nodeInfo.getClientId(), ls);
            }
        }
        for (String ansibleGroup : this.extraGroups.keySet()) {
            Set<String> clientIds = this.extraGroups.get(ansibleGroup);
            if (clientIds.isEmpty()) continue;
            res = (String)res + "\n[" + ansibleGroup + "]\n";
            for (BasicStringRspec.BasicNodeInfo nodeInfo : nodeInfoList) {
                Optional<BasicStringRspec.LoginService> loginService;
                if (this.excludedClientIds.contains(nodeInfo.getClientId()) || !clientIds.contains(nodeInfo.getClientId()) || !(loginService = this.getPrimaryLoginService(nodeInfo)).isPresent()) continue;
                BasicStringRspec.LoginService ls = loginService.get();
                res = (String)res + this.makeAnsibleHostLine(useClientIdInsteadOfHostname, nodeInfo.getClientId(), ls);
            }
        }
        return res;
    }

    @Nonnull
    private String makeAnsibleHostLine(boolean useClientIdInsteadOfHostname, String clientId, BasicStringRspec.LoginService ls) {
        return String.format("%s \tansible_ssh_host=%s\tansible_ssh_port=%s\tansible_ssh_user=%s" + (useClientIdInsteadOfHostname ? "\tansible_ssh_common_args='-F \"ssh-config\"'" : "") + " \n", clientId, useClientIdInsteadOfHostname ? clientId : ls.getHostname(), ls.getPort(), ls.getUsername());
    }

    public String getFabricFileContent() {
        Object res = "from fabric.api import env, run\n\n";
        ArrayList<String> allHosts = new ArrayList<String>();
        res = (String)res + "#For your convenience, each server has been linked to it's client-Id by means of a role:";
        List<BasicStringRspec.BasicNodeInfo> nodeInfoList = this.basicStringRspec.getBasicNodeInfo();
        if (nodeInfoList == null) {
            throw new IllegalStateException("Could not find node info");
        }
        for (BasicStringRspec.BasicNodeInfo nodeInfo : nodeInfoList) {
            Optional<BasicStringRspec.LoginService> loginService;
            if (this.excludedClientIds.contains(nodeInfo.getClientId()) || !(loginService = this.getPrimaryLoginService(nodeInfo)).isPresent()) continue;
            res = (String)res + "env.roledefs['" + nodeInfo.getClientId() + "'] = ['" + loginService.get().getHostname() + "']\n";
            allHosts.add(loginService.get().getHostname());
        }
        res = (String)res + "\nenv.roledefs['all'] = [";
        boolean first = true;
        for (String hostname : allHosts) {
            if (!first) {
                res = (String)res + ", ";
            }
            res = (String)res + "'" + hostname + "'";
            first = false;
        }
        res = (String)res + "]\n";
        res = (String)res + "\n#Use env.hosts instead of roles if you want to execute actions on all hosts instead of being selective:\n#env.hosts = [\n";
        for (String host : allHosts) {
            res = (String)res + "#\t\"" + host + "\",\n";
        }
        res = (String)res + "#  ]\n\n";
        res = (String)res + "\n\n";
        switch (this.privateKeyHandling.ordinal()) {
            case 0: {
                res = (String)res + "env.key_filename=\"./id_rsa\"\n";
                break;
            }
            case 1: {
                res = (String)res + "env.key_filename=\"" + this.privateKeyFile.getAbsolutePath() + "\"\n";
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new RuntimeException("Unsupported privateKeyHandling -> " + String.valueOf((Object)this.privateKeyHandling));
            }
        }
        res = (String)res + "env.use_ssh_config = True\nenv.ssh_config_path = './ssh-config'\n\ndef pingtest():\n    run('ping -c 3 8.8.8.8')\n\ndef uptime():\n    run('uptime')\n";
        return res;
    }

    public String getReadmeFileContent() throws IOException {
        return IOUtils.resourceToString((String)"EXPORT_TOOLS_README.txt", this.getClass());
    }

    public String getRequirementsFileContent() {
        return "ansible==1.9.4\n";
    }

    public String getProxySshConfigContent(JFedConnection.SshProxyInfo proxy, int proxyIndex) {
        assert (proxy.getSshKeyInfo() != null);
        assert (proxy.getSshKeyInfo().getPrivateKey() != null);
        Object privateProxyKeyFilePath = switch (this.privateKeyHandling.ordinal()) {
            case 0 -> {
                if (proxy.getSshKeyInfo() != null && proxy.getSshKeyInfo().getPrivateKey() != null && Objects.equals(proxy.getSshKeyInfo().getPrivateKey(), this.privateKey)) {
                    yield "./id_rsa";
                }
                yield "./id_rsa_proxy_" + proxyIndex;
            }
            case 1 -> this.privateKeyFile.getAbsolutePath();
            case 2 -> null;
            default -> throw new RuntimeException("Unsupported privateKeyHandling -> " + String.valueOf((Object)this.privateKeyHandling));
        };
        Object res = String.format("Host %s %s\n    User %s\n    HostName %s\n    Port %s\n" + (String)(privateProxyKeyFilePath == null ? "" : "    IdentityFile " + (String)privateProxyKeyFilePath + "\n") + "    ProxyCommand none\n    BatchMode yes\n    PasswordAuthentication no\n    EscapeChar none\n", proxy.getHostname(), "proxy" + proxyIndex, proxy.getUsername(), proxy.getHostname(), proxy.getPort());
        if (proxy.getHostKey() != null && !proxy.getHostKey().isEmpty()) {
            res = (String)res + "    UserKnownHostsFile known_host_proxy_" + proxyIndex + "\n";
            res = (String)res + "    CheckHostIP no\n";
            res = (String)res + "    StrictHostKeyChecking yes\n";
        } else {
            res = (String)res + "    CheckHostIP no\n";
            res = (String)res + "    StrictHostKeyChecking no\n";
        }
        res = (String)res + "\n";
        return res;
    }

    public String getSshConfigFileContent() {
        String privateKeyFilePath = switch (this.privateKeyHandling.ordinal()) {
            case 0 -> "./id_rsa";
            case 1 -> this.privateKeyFile.getAbsolutePath();
            case 2 -> null;
            default -> throw new RuntimeException("Unsupported privateKeyHandling -> " + String.valueOf((Object)this.privateKeyHandling));
        };
        HashSet<JFedConnection.SshProxyInfo> handledProxies = new HashSet<JFedConnection.SshProxyInfo>();
        HashMap<JFedConnection.SshProxyInfo, Integer> proxyIdMap = new HashMap<JFedConnection.SshProxyInfo, Integer>();
        Object res = "";
        List<BasicStringRspec.BasicNodeInfo> nodeInfoList = this.basicStringRspec.getBasicNodeInfo();
        if (nodeInfoList == null) {
            throw new IllegalStateException("Could not find node info");
        }
        boolean includeHostnameInHost = this.hasSshLoginsWithDiffNodeDuplicateHostname(nodeInfoList);
        for (BasicStringRspec.BasicNodeInfo nodeInfo : nodeInfoList) {
            Optional<BasicStringRspec.LoginService> loginService;
            if (this.excludedClientIds.contains(nodeInfo.getClientId()) || !(loginService = this.getPrimaryLoginService(nodeInfo)).isPresent()) continue;
            BasicStringRspec.LoginService ls = loginService.get();
            if (ls.getSshProxy() != null && handledProxies.add(ls.getSshProxy())) {
                res = (String)res + this.getProxySshConfigContent(ls.getSshProxy(), handledProxies.size() - 1);
                proxyIdMap.put(ls.getSshProxy(), handledProxies.size() - 1);
            }
            res = includeHostnameInHost ? (String)res + String.format("Host %s %s\n", nodeInfo.getClientId(), ls.getHostname()) : (String)res + String.format("Host %s\n", nodeInfo.getClientId());
            res = (String)res + String.format("    HostName %s\n    Port %s\n    User %s\n", ls.getHostname(), ls.getPort(), ls.getUsername());
            res = (String)res + (String)(privateKeyFilePath == null ? "" : "    IdentityFile " + privateKeyFilePath + "\n");
            res = (String)res + "    ForwardAgent yes\n";
            if (ls.getSshProxy() != null) {
                JFedConnection.SshProxyInfo proxy = ls.getSshProxy();
                int proxyId = (Integer)proxyIdMap.get(proxy);
                res = Objects.equals(SshVersionFinder.checkIfVersionSupportsNc(), Boolean.TRUE) ? (String)res + "    ProxyCommand            ssh -F ssh-config proxy" + proxyId + " -W %h:%p\n" : (String)res + "    ProxyCommand            ssh -F ssh-config proxy" + proxyId + " nc -w 5 %h %p\n";
                res = (String)res + "    TCPKeepAlive            yes\n";
                res = (String)res + "    Compression             no\n";
            }
            res = (String)res + "    CheckHostIP no\n";
            res = (String)res + "    StrictHostKeyChecking no\n";
            res = (String)res + "\n";
        }
        return res;
    }

    private boolean hasSshLoginsWithDiffNodeDuplicateHostname(@Nonnull List<BasicStringRspec.BasicNodeInfo> nodeInfoList) {
        HashMap<String, Set> portByHostname = new HashMap<String, Set>();
        for (BasicStringRspec.BasicNodeInfo nodeInfo : nodeInfoList) {
            Optional<BasicStringRspec.LoginService> loginService = this.getPrimaryLoginService(nodeInfo);
            if (!loginService.isPresent()) continue;
            BasicStringRspec.LoginService ls = loginService.get();
            if (portByHostname.containsKey(ls.getHostname())) {
                return true;
            }
            portByHostname.computeIfAbsent(ls.getHostname(), hn -> new HashSet()).add(ls.getPort());
        }
        return false;
    }

    public String getKnownHostLine(JFedConnection.SshProxyInfo proxyInfo) {
        String[] parts;
        assert (proxyInfo.getHostKey() != null);
        Object hostkey = proxyInfo.getHostKey().trim();
        if (((String)hostkey).split(" ").length >= 3 && ((parts = ((String)hostkey).split(" "))[1].startsWith("ecdsa") || parts[1].startsWith("ssh-"))) {
            Object newHostkey = "";
            for (int i = 1; i < parts.length; ++i) {
                newHostkey = (String)newHostkey + parts[i] + " ";
            }
            hostkey = newHostkey;
        }
        if (!((String)hostkey).startsWith("ssh-") && !((String)hostkey).startsWith("ecdsa")) {
            hostkey = "ssh-rsa " + (String)hostkey;
        }
        if (proxyInfo.getPort() == 22) {
            return proxyInfo.getHostname() + " " + (String)hostkey + "\n";
        }
        return "[" + proxyInfo.getHostname() + "]:" + proxyInfo.getPort() + " " + (String)hostkey + "\n";
    }

    private List<JFedConnection.SshProxyInfo> proxiesByIndex() {
        ArrayList<JFedConnection.SshProxyInfo> res = new ArrayList<JFedConnection.SshProxyInfo>();
        HashSet<JFedConnection.SshProxyInfo> handledProxies = new HashSet<JFedConnection.SshProxyInfo>();
        List<BasicStringRspec.BasicNodeInfo> nodeInfoList = this.basicStringRspec.getBasicNodeInfo();
        if (nodeInfoList == null) {
            throw new IllegalStateException("Could not find node info");
        }
        for (BasicStringRspec.BasicNodeInfo nodeInfo : nodeInfoList) {
            BasicStringRspec.LoginService ls;
            Optional<BasicStringRspec.LoginService> loginService = this.getPrimaryLoginService(nodeInfo);
            if (!loginService.isPresent() || (ls = loginService.get()).getSshProxy() == null || !handledProxies.add(ls.getSshProxy())) continue;
            res.add(ls.getSshProxy());
        }
        return res;
    }

    public String writeFilesToZip(File zipFile) {
        String string;
        assert (this.privateKeyHandling == PrivateKeyHandling.COPY || this.privateKeyHandling == PrivateKeyHandling.DONTUSE);
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
        try {
            OutputStreamWriter writer = new OutputStreamWriter(zos);
            List<AnsibleFileInfo> filesToZip = this.getFilesToWrite(true);
            for (AnsibleFileInfo fileInfo : filesToZip) {
                zos.putNextEntry(new ZipEntry(fileInfo.getFilename()));
                writer.write(fileInfo.getContent());
                writer.flush();
                zos.closeEntry();
            }
            string = String.format("Wrote tool configuration files to '%s'", zipFile.getAbsolutePath());
        }
        catch (Throwable throwable) {
            try {
                try {
                    zos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                LOG.error("Error while writing tool configuration files", (Throwable)ex);
                return "Error while writing tool configuration files";
            }
        }
        zos.close();
        return string;
    }

    public void writeFilesToDir(File ansibleDir) throws IOException {
        assert (ansibleDir != null);
        assert (ansibleDir.exists());
        IOUtils.stringToFile((File)new File(ansibleDir, ANSIBLE_CONFIG_FILE_BASENAME), (String)this.getAnsibleConfigFileContent());
        if (this.publicKey != null) {
            IOUtils.stringToFile((File)new File(ansibleDir, PUBLIC_KEY_FILE_BASENAME), (String)this.getPublicKeyFileContent());
        }
        IOUtils.stringToFile((File)new File(ansibleDir, ANSIBLE_HOSTS_FILE_BASENAME), (String)this.getAnsibleHostFileContent());
        IOUtils.stringToFile((File)new File(ansibleDir, FABRIC_FILE_BASENAME), (String)this.getFabricFileContent());
        IOUtils.stringToFile((File)new File(ansibleDir, SSH_CONFIG_FILE_BASENAME), (String)this.getSshConfigFileContent());
        IOUtils.stringToFile((File)new File(ansibleDir, REQUIREMENTS_FILE_BASENAME), (String)this.getRequirementsFileContent());
        int proxyIndex = 0;
        for (JFedConnection.SshProxyInfo proxyInfo : this.proxiesByIndex()) {
            if (proxyInfo.getHostKey() != null && !proxyInfo.getHostKey().isEmpty()) {
                String filename = SSH_PROXY_KNOWN_HOST_TEMPLATE + proxyIndex;
                IOUtils.stringToFile((File)new File(ansibleDir, filename), (String)this.getKnownHostLine(proxyInfo));
            }
            if (this.privateKeyHandling == PrivateKeyHandling.COPY && proxyInfo.getSshKeyInfo() != null && proxyInfo.getSshKeyInfo().getPrivateKey() != null && !Objects.equals(proxyInfo.getSshKeyInfo().getPrivateKey(), this.privateKey)) {
                File privKeyFile = new File(ansibleDir, PROXY_PRIVATE_KEY_FILE_TEMPLATE + proxyIndex);
                IOUtils.stringToFile((File)privKeyFile, (String)new String(KeyUtil.privateKeyToAnyPem((PrivateKey)proxyInfo.getSshKeyInfo().getPrivateKey())));
                IOUtils.assureUserOnlyPerms((File)privKeyFile, (boolean)true, (boolean)true, (boolean)false);
            }
            ++proxyIndex;
        }
        if (this.privateKeyHandling == PrivateKeyHandling.COPY && this.privateKey != null) {
            File privKeyFile = new File(ansibleDir, PRIVATE_KEY_FILE_BASENAME);
            IOUtils.stringToFile((File)privKeyFile, (String)new String(KeyUtil.privateKeyToAnyPem((PrivateKey)this.privateKey)));
            IOUtils.assureUserOnlyPerms((File)privKeyFile, (boolean)true, (boolean)true, (boolean)false);
        }
    }

    public List<AnsibleFileInfo> getFilesToWrite(boolean includeReadme) {
        ArrayList<AnsibleFileInfo> res = new ArrayList<AnsibleFileInfo>();
        assert (this.privateKeyHandling == PrivateKeyHandling.COPY || this.privateKeyHandling == PrivateKeyHandling.DONTUSE);
        if (this.privateKeyHandling == PrivateKeyHandling.COPY && this.privateKey != null) {
            res.add(new AnsibleFileInfo(PRIVATE_KEY_FILE_BASENAME, KeyUtil.privateKeyToAnyPem((PrivateKey)this.privateKey), true));
        }
        if (this.publicKey != null) {
            String publicKeyStr = KeyUtil.publicKeyToOpenSshAuthorizedKeysFormat((PublicKey)this.publicKey);
            if (publicKeyStr != null) {
                res.add(new AnsibleFileInfo(PUBLIC_KEY_FILE_BASENAME, publicKeyStr, false));
            } else {
                LOG.warn("Could not convert publicKey to OpenSSH format. Skipping");
            }
        }
        res.add(new AnsibleFileInfo(ANSIBLE_CONFIG_FILE_BASENAME, this.getAnsibleConfigFileContent(), false));
        res.add(new AnsibleFileInfo(ANSIBLE_HOSTS_FILE_BASENAME, this.getAnsibleHostFileContent(), false));
        res.add(new AnsibleFileInfo(FABRIC_FILE_BASENAME, this.getFabricFileContent(), false));
        res.add(new AnsibleFileInfo(SSH_CONFIG_FILE_BASENAME, this.getSshConfigFileContent(), false));
        if (includeReadme) {
            try {
                res.add(new AnsibleFileInfo(README_FILE_BASENAME, this.getReadmeFileContent(), false));
            }
            catch (IOException e) {
                LOG.error("Error creating README file. Will ignore.", (Throwable)e);
            }
        }
        res.add(new AnsibleFileInfo(REQUIREMENTS_FILE_BASENAME, this.getRequirementsFileContent(), false));
        int proxyIndex = 0;
        for (JFedConnection.SshProxyInfo proxyInfo : this.proxiesByIndex()) {
            if (proxyInfo.getHostKey() != null && !proxyInfo.getHostKey().isEmpty()) {
                res.add(new AnsibleFileInfo(SSH_PROXY_KNOWN_HOST_TEMPLATE + proxyIndex, this.getKnownHostLine(proxyInfo), false));
            }
            if (this.privateKeyHandling == PrivateKeyHandling.COPY && proxyInfo.getSshKeyInfo() != null && proxyInfo.getSshKeyInfo().getPrivateKey() != null && !Objects.equals(proxyInfo.getSshKeyInfo().getPrivateKey(), this.privateKey)) {
                res.add(new AnsibleFileInfo(PROXY_PRIVATE_KEY_FILE_TEMPLATE + proxyIndex, KeyUtil.privateKeyToAnyPem((PrivateKey)proxyInfo.getSshKeyInfo().getPrivateKey()), false));
            }
            ++proxyIndex;
        }
        return res;
    }

    public static enum PrivateKeyHandling {
        COPY,
        LINK,
        DONTUSE;

    }

    public static class AnsibleFileInfo {
        @Nonnull
        private final String filename;
        @Nonnull
        private final String content;
        private final boolean privateFile;

        public AnsibleFileInfo(@Nonnull String filename, @Nonnull String content, boolean privateFile) {
            this.filename = filename;
            this.content = content;
            this.privateFile = privateFile;
        }

        public AnsibleFileInfo(@Nonnull String filename, @Nonnull char[] content, boolean privateFile) {
            this(filename, new String(content), privateFile);
        }

        @Nonnull
        public String getFilename() {
            return this.filename;
        }

        @Nonnull
        public String getContent() {
            return this.content;
        }

        @Nonnull
        public char[] getContentChars() {
            return this.content.toCharArray();
        }

        @Nonnull
        public byte[] getContentBytes() {
            return this.content.getBytes(StandardCharsets.UTF_8);
        }

        public boolean isPrivateFile() {
            return this.privateFile;
        }
    }
}

