/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.lib;

import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserWithSpeaksFor;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestNodeLoginFinder {
    private static final Logger LOG = LoggerFactory.getLogger(BestNodeLoginFinder.class);
    @Nonnull
    private final BasicStringRspec basicStringRspec;
    @Nullable
    private final String preferredUserName;
    @Nonnull
    private final Feedback feedback;
    @Nullable
    private final GeniUser loggedInUser;

    public BestNodeLoginFinder(@Nonnull BasicStringRspec basicStringRspec, @Nullable String preferredUserName, @Nullable GeniUser loggedInUser, @Nonnull Feedback feedback) {
        this.basicStringRspec = basicStringRspec;
        this.preferredUserName = preferredUserName;
        this.loggedInUser = loggedInUser;
        this.feedback = feedback;
    }

    @Nullable
    public BasicStringRspec.LoginService findBestLogin(String nodeUniqueId) {
        int loginCount;
        String authUrnString;
        List<BasicStringRspec.BasicNodeInfo> basicNodeInfos = this.basicStringRspec.getBasicNodeInfo();
        if (basicNodeInfos == null) {
            LOG.debug("findBestLogin = null because basicNodeInfos == null");
            return null;
        }
        int nodeCount = basicNodeInfos.size();
        BasicStringRspec.BasicNodeInfo basicNodeInfo = null;
        for (BasicStringRspec.BasicNodeInfo cur : basicNodeInfos) {
            if (!Objects.equals(cur.getUniqueId(), nodeUniqueId)) continue;
            basicNodeInfo = cur;
        }
        String string = authUrnString = basicNodeInfo == null ? null : basicNodeInfo.getComponentManagerId();
        if (basicNodeInfo == null) {
            LOG.debug("findBestLogin did not find node " + nodeUniqueId);
        }
        List<BasicStringRspec.LoginService> loginServiceList = this.basicStringRspec.findNodeLoginInfoByUniqueId(nodeUniqueId);
        LOG.debug("findBestLogin found " + loginServiceList.size() + " logins for node " + nodeUniqueId);
        if (this.preferredUserName != null) {
            this.feedback.info("Configuration: nodelogin_preferred_user=" + this.preferredUserName);
        }
        if ((loginCount = loginServiceList.size()) > 0) {
            if (loginCount > 1) {
                ArrayList<JFedConnection.SshProxyInfo> proxies = new ArrayList<JFedConnection.SshProxyInfo>();
                for (BasicStringRspec.LoginService loginService : loginServiceList) {
                    JFedConnection.SshProxyInfo sshProxy = loginService.getSshProxy();
                    if (sshProxy == null) continue;
                    proxies.add(sshProxy);
                    this.feedback.info("Found proxy " + sshProxy.getUsername() + "@" + sshProxy.getHostname() + ":" + sshProxy.getPort() + "  for login " + loginService.getUsername() + "@" + loginService.getHostname() + ":" + loginService.getPort());
                }
                ArrayList<BasicStringRspec.LoginService> loginServicesMatchingLoginUsername = new ArrayList<BasicStringRspec.LoginService>();
                ArrayList<BasicStringRspec.LoginService> loginServicesMatchingProxy = new ArrayList<BasicStringRspec.LoginService>();
                ArrayList<BasicStringRspec.LoginService> loginServicesMatchingSpecialName = new ArrayList<BasicStringRspec.LoginService>();
                ArrayList<BasicStringRspec.LoginService> loginServicesMatchingPreferredUser = new ArrayList<BasicStringRspec.LoginService>();
                ArrayList<BasicStringRspec.LoginService> loginServicesMatchingNothing = new ArrayList<BasicStringRspec.LoginService>();
                String loggedInUserName = null;
                if (this.loggedInUser != null) {
                    if (this.loggedInUser instanceof GeniUserWithSpeaksFor) {
                        GeniUserWithSpeaksFor geniUserWithSpeaksFor = (GeniUserWithSpeaksFor)this.loggedInUser;
                        loggedInUserName = geniUserWithSpeaksFor.getSpeaksForUrn().getResourceName();
                    } else {
                        loggedInUserName = this.loggedInUser.getUserUrn().getResourceName();
                    }
                }
                for (BasicStringRspec.LoginService loginService : loginServiceList) {
                    String hostname = loginService.getHostname();
                    String username = loginService.getUsername();
                    int port = loginService.getPort();
                    JFedConnection.SshProxyInfo sshProxy = loginService.getSshProxy();
                    assert (port > 0);
                    if (hostname == null) {
                        this.feedback.error("hostname is null for login service");
                        continue;
                    }
                    if (username == null) {
                        this.feedback.error("username is null for login service");
                        continue;
                    }
                    boolean isPreferredUser = this.preferredUserName != null && Objects.equals(this.preferredUserName, username);
                    boolean isLoggedInUserName = loggedInUserName != null && Objects.equals(username, loggedInUserName);
                    boolean isProxy = false;
                    for (JFedConnection.SshProxyInfo proxy : proxies) {
                        if (!Objects.equals(proxy.getUsername(), username) || !Objects.equals(proxy.getHostname(), hostname) || proxy.getPort() != port) continue;
                        isProxy = true;
                    }
                    boolean isSpecialName = false;
                    if (username.equalsIgnoreCase("root")) {
                        isSpecialName = true;
                    }
                    if (username.equalsIgnoreCase("admin")) {
                        isSpecialName = true;
                    }
                    if (isProxy) {
                        loginServicesMatchingProxy.add(loginService);
                        this.feedback.info("The login " + username + "@" + hostname + ":" + port + " is a proxy login");
                        continue;
                    }
                    if (isPreferredUser) {
                        loginServicesMatchingPreferredUser.add(loginService);
                        this.feedback.info("The login " + username + "@" + hostname + ":" + port + " is a user preferred login");
                        continue;
                    }
                    if (isLoggedInUserName) {
                        loginServicesMatchingLoginUsername.add(loginService);
                        this.feedback.info("The login " + username + "@" + hostname + ":" + port + " matches the user account name");
                        continue;
                    }
                    if (isSpecialName) {
                        loginServicesMatchingSpecialName.add(loginService);
                        this.feedback.info("The login " + username + "@" + hostname + ":" + port + " is a super user login");
                        continue;
                    }
                    loginServicesMatchingNothing.add(loginService);
                    this.feedback.info("The login " + username + "@" + hostname + ":" + port + " is an normal login");
                }
                BasicStringRspec.LoginService chosenLoginService = null;
                if (!loginServicesMatchingPreferredUser.isEmpty()) {
                    chosenLoginService = (BasicStringRspec.LoginService)loginServicesMatchingPreferredUser.get(0);
                    this.feedback.info("Found multiple node logins in manifest rspec (" + loginCount + " service logins for " + nodeCount + " nodes), using login info for preferred user \"" + chosenLoginService.getUsername() + "\"." + (String)(authUrnString == null ? "" : " (for nodes of auth " + authUrnString + ")"));
                } else {
                    if (!loginServicesMatchingLoginUsername.isEmpty()) {
                        chosenLoginService = (BasicStringRspec.LoginService)loginServicesMatchingLoginUsername.get(0);
                    }
                    if (chosenLoginService == null && !loginServicesMatchingNothing.isEmpty()) {
                        chosenLoginService = (BasicStringRspec.LoginService)loginServicesMatchingNothing.get(0);
                    }
                    if (chosenLoginService == null && !loginServicesMatchingSpecialName.isEmpty()) {
                        chosenLoginService = (BasicStringRspec.LoginService)loginServicesMatchingSpecialName.get(0);
                    }
                    if (chosenLoginService == null && !loginServicesMatchingProxy.isEmpty()) {
                        chosenLoginService = (BasicStringRspec.LoginService)loginServicesMatchingProxy.get(0);
                    }
                    if (chosenLoginService != null) {
                        this.feedback.info("Found multiple node logins in manifest rspec (" + loginCount + " service logins for " + nodeCount + " nodes), Chose login info for user \"" + chosenLoginService.getUsername() + "\"." + (String)(authUrnString == null ? "" : " (for nodes of auth " + authUrnString + ")"));
                    } else {
                        this.feedback.error("Found multiple node logins in manifest rspec (" + loginCount + " service logins for " + nodeCount + " nodes),  but the code failed to choose one. This is a bug!");
                        return null;
                    }
                }
                this.feedback.info("Returning: chosenLoginService=" + String.valueOf(chosenLoginService));
                return chosenLoginService;
            }
            BasicStringRspec.LoginService onlyLoginService = loginServiceList.get(0);
            if (onlyLoginService.getHostname() == null) {
                this.feedback.error("hostname is null for login service");
                return null;
            }
            if (onlyLoginService.getUsername() == null) {
                this.feedback.error("username is null for login service");
                return null;
            }
            this.feedback.info("Returning: onlyLoginService=" + String.valueOf(onlyLoginService));
            return onlyLoginService;
        }
        this.feedback.info("Found no node service login in manifest RSpec" + (String)(authUrnString == null ? "" : " (for nodes of auth " + authUrnString + ")"));
        return null;
    }

    @Nullable
    public BasicStringRspec.RdpService findBestRdp(String nodeUniqueId) {
        int loginCount;
        String authUrnString;
        List<BasicStringRspec.BasicNodeInfo> basicNodeInfos = this.basicStringRspec.getBasicNodeInfo();
        if (basicNodeInfos == null) {
            LOG.debug("findBestLogin = null because basicNodeInfos == null");
            return null;
        }
        int nodeCount = basicNodeInfos.size();
        BasicStringRspec.BasicNodeInfo basicNodeInfo = null;
        for (BasicStringRspec.BasicNodeInfo cur : basicNodeInfos) {
            if (!Objects.equals(cur.getUniqueId(), nodeUniqueId)) continue;
            basicNodeInfo = cur;
        }
        String string = authUrnString = basicNodeInfo == null ? null : basicNodeInfo.getComponentManagerId();
        if (basicNodeInfo == null) {
            LOG.debug("findBestLogin did not find node " + nodeUniqueId);
        }
        List<BasicStringRspec.RdpService> rdpServiceList = this.basicStringRspec.findNodeRdpInfoByUniqueId(nodeUniqueId);
        LOG.debug("findBestLogin found " + rdpServiceList.size() + " rdp services for node " + nodeUniqueId);
        if (this.preferredUserName != null) {
            this.feedback.info("Configuration: nodelogin_preferred_user=" + this.preferredUserName);
        }
        if ((loginCount = rdpServiceList.size()) > 0) {
            if (loginCount > 1) {
                ArrayList<JFedConnection.SshProxyInfo> proxies = new ArrayList<JFedConnection.SshProxyInfo>();
                for (BasicStringRspec.RdpService loginService : rdpServiceList) {
                    JFedConnection.SshProxyInfo sshProxy = loginService.getSshProxy();
                    if (sshProxy == null) continue;
                    proxies.add(sshProxy);
                    this.feedback.info("Found proxy " + sshProxy.getUsername() + "@" + sshProxy.getHostname() + ":" + sshProxy.getPort() + "  for login " + loginService.getUsername() + "@" + loginService.getHostname() + ":" + loginService.getPort());
                }
                ArrayList<BasicStringRspec.RdpService> loginServicesMatchingLoginUsername = new ArrayList<BasicStringRspec.RdpService>();
                ArrayList<BasicStringRspec.RdpService> loginServicesMatchingProxy = new ArrayList<BasicStringRspec.RdpService>();
                ArrayList<BasicStringRspec.RdpService> loginServicesMatchingSpecialName = new ArrayList<BasicStringRspec.RdpService>();
                ArrayList<BasicStringRspec.RdpService> loginServicesMatchingPreferredUser = new ArrayList<BasicStringRspec.RdpService>();
                ArrayList<BasicStringRspec.RdpService> loginServicesMatchingNothing = new ArrayList<BasicStringRspec.RdpService>();
                String loggedInUserName = null;
                if (this.loggedInUser != null) {
                    if (this.loggedInUser instanceof GeniUserWithSpeaksFor) {
                        GeniUserWithSpeaksFor geniUserWithSpeaksFor = (GeniUserWithSpeaksFor)this.loggedInUser;
                        loggedInUserName = geniUserWithSpeaksFor.getSpeaksForUrn().getResourceName();
                    } else {
                        loggedInUserName = this.loggedInUser.getUserUrn().getResourceName();
                    }
                }
                for (BasicStringRspec.RdpService rdpService : rdpServiceList) {
                    String hostname = rdpService.getHostname();
                    String username = rdpService.getUsername();
                    int port = rdpService.getPort();
                    JFedConnection.SshProxyInfo sshProxy = rdpService.getSshProxy();
                    assert (port > 0);
                    if (hostname == null) {
                        this.feedback.error("hostname is null for login service");
                        continue;
                    }
                    if (username == null) {
                        this.feedback.error("username is null for login service");
                        continue;
                    }
                    boolean isPreferredUser = this.preferredUserName != null && Objects.equals(this.preferredUserName, username);
                    boolean isLoggedInUserName = loggedInUserName != null && Objects.equals(username, loggedInUserName);
                    boolean isProxy = false;
                    for (JFedConnection.SshProxyInfo proxy : proxies) {
                        if (!Objects.equals(proxy.getUsername(), username) || !Objects.equals(proxy.getHostname(), hostname) || proxy.getPort() != port) continue;
                        isProxy = true;
                    }
                    boolean isSpecialName = false;
                    if (username.equalsIgnoreCase("root")) {
                        isSpecialName = true;
                    }
                    if (username.equalsIgnoreCase("admin")) {
                        isSpecialName = true;
                    }
                    if (isProxy) {
                        loginServicesMatchingProxy.add(rdpService);
                        this.feedback.info("The login " + username + "@" + hostname + ":" + port + " is a proxy login");
                        continue;
                    }
                    if (isPreferredUser) {
                        loginServicesMatchingPreferredUser.add(rdpService);
                        this.feedback.info("The login " + username + "@" + hostname + ":" + port + " is a user preferred login");
                        continue;
                    }
                    if (isLoggedInUserName) {
                        loginServicesMatchingLoginUsername.add(rdpService);
                        this.feedback.info("The login " + username + "@" + hostname + ":" + port + " matches the user account name");
                        continue;
                    }
                    if (isSpecialName) {
                        loginServicesMatchingSpecialName.add(rdpService);
                        this.feedback.info("The login " + username + "@" + hostname + ":" + port + " is a super user login");
                        continue;
                    }
                    loginServicesMatchingNothing.add(rdpService);
                    this.feedback.info("The login " + username + "@" + hostname + ":" + port + " is an normal login");
                }
                BasicStringRspec.RdpService chosenLoginService = null;
                if (!loginServicesMatchingPreferredUser.isEmpty()) {
                    chosenLoginService = (BasicStringRspec.RdpService)loginServicesMatchingPreferredUser.get(0);
                    this.feedback.info("Found multiple node logins in manifest rspec (" + loginCount + " service logins for " + nodeCount + " nodes), using login info for preferred user \"" + chosenLoginService.getUsername() + "\"." + (String)(authUrnString == null ? "" : " (for nodes of auth " + authUrnString + ")"));
                } else {
                    if (!loginServicesMatchingLoginUsername.isEmpty()) {
                        chosenLoginService = (BasicStringRspec.RdpService)loginServicesMatchingLoginUsername.get(0);
                    }
                    if (chosenLoginService == null && !loginServicesMatchingNothing.isEmpty()) {
                        chosenLoginService = (BasicStringRspec.RdpService)loginServicesMatchingNothing.get(0);
                    }
                    if (chosenLoginService == null && !loginServicesMatchingSpecialName.isEmpty()) {
                        chosenLoginService = (BasicStringRspec.RdpService)loginServicesMatchingSpecialName.get(0);
                    }
                    if (chosenLoginService == null && !loginServicesMatchingProxy.isEmpty()) {
                        chosenLoginService = (BasicStringRspec.RdpService)loginServicesMatchingProxy.get(0);
                    }
                    if (chosenLoginService != null) {
                        this.feedback.info("Found multiple node logins in manifest rspec (" + loginCount + " service logins for " + nodeCount + " nodes), Chose login info for user \"" + chosenLoginService.getUsername() + "\"." + (String)(authUrnString == null ? "" : " (for nodes of auth " + authUrnString + ")"));
                    } else {
                        this.feedback.error("Found multiple node logins in manifest rspec (" + loginCount + " service logins for " + nodeCount + " nodes),  but the code failed to choose one. This is a bug!");
                        return null;
                    }
                }
                return chosenLoginService;
            }
            BasicStringRspec.RdpService onlyLoginService = rdpServiceList.get(0);
            if (onlyLoginService.getHostname() == null) {
                this.feedback.error("hostname is null for login service");
                return null;
            }
            if (onlyLoginService.getUsername() == null) {
                this.feedback.error("username is null for login service");
                return null;
            }
            return onlyLoginService;
        }
        this.feedback.info("Found no node service login in manifest RSpec" + (String)(authUrnString == null ? "" : " (for nodes of auth " + authUrnString + ")"));
        return null;
    }

    public static interface Feedback {
        public void info(String var1);

        public void error(String var1);

        public void debug(String var1);
    }
}

