/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.connectivity_tester;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import be.iminds.ilabt.jfed.connectivity_tester.PingUtils;

public class Ping4Test
implements ConnectivityTest {
    private static final String DEFAULT_IPV4_ADDRESS = "flsmonitor.fed4fire.eu";
    private final String address;

    public Ping4Test() {
        this(DEFAULT_IPV4_ADDRESS);
    }

    public Ping4Test(String address) {
        this.address = address;
    }

    @Override
    public String getName() {
        return "Ping to IPv4-host '" + this.address + "'";
    }

    @Override
    public boolean isLoginRequired() {
        return false;
    }

    @Override
    public ConnectivityTest.ConnectivityTestResult call() {
        if (PingUtils.isReachableByPing(this.address)) {
            return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.SUCCEEDED, "Successfully connected to " + this.address);
        }
        return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "Unable to reach " + this.address);
    }
}

