/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.connectivity_tester;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.library.SshProxySocketFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyPairWrapper;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHLoginTest
implements ConnectivityTest {
    private static final Logger LOG = LoggerFactory.getLogger(SSHLoginTest.class);
    private final String hostname;
    private final int port;
    private final String username;
    private final SshKeyInfo forceUserSshKeyInfo;
    private final JFedConnection.SshProxyInfo proxyInfo;
    @Nullable
    private final String category;
    private final GeniUserProvider geniUserProvider;
    private final JFedPreferences jFedPreferences;

    public SSHLoginTest(String hostname, int port, String username, @Nullable SshKeyInfo forceUserSshKeyInfo, JFedConnection.SshProxyInfo proxyInfo, GeniUserProvider geniUserProvider, JFedPreferences jFedPreferences, String category) {
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.forceUserSshKeyInfo = forceUserSshKeyInfo;
        this.proxyInfo = proxyInfo;
        this.geniUserProvider = geniUserProvider;
        this.jFedPreferences = jFedPreferences;
        this.category = category;
    }

    @Override
    public String getName() {
        return (String)(this.category == null ? "" : "[" + this.category + "] ") + "SSH Login " + this.username + "@" + this.hostname + ":" + this.port + (String)(this.proxyInfo == null ? "" : " with proxy " + String.valueOf(this.proxyInfo));
    }

    @Override
    public boolean isLoginRequired() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ConnectivityTest.ConnectivityTestResult call() {
        ConnectivityTest.ConnectivityTestResult connectivityTestResult;
        Session session;
        SSHClient ssh;
        block33: {
            SshKeyInfo sshKeyInfo;
            if (this.forceUserSshKeyInfo != null) {
                sshKeyInfo = this.forceUserSshKeyInfo;
                if (!this.forceUserSshKeyInfo.hasUnencryptedPrivateKey()) {
                    LOG.info("Private key in forceUserSshKeyInfo is encrypted. Login cannot be tested. forceUserSshKeyInfo.getPrivateKey()=" + (sshKeyInfo.getPrivateKey() == null ? "null" : "nonnull") + " forceUserSshKeyInfo.hasUnencryptedPrivateKey()=" + sshKeyInfo.hasUnencryptedPrivateKey());
                    return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.SKIPPED, "Private key in forceUserSshKeyInfo is encrypted. Login cannot be tested.");
                }
            } else {
                sshKeyInfo = this.jFedPreferences.getCustomSshKeyInfo();
            }
            if (sshKeyInfo != null && !sshKeyInfo.hasUnencryptedPrivateKey()) {
                LOG.info("Private key in preferences is encrypted. Login cannot be tested. sshKeyInfo.getPrivateKey()=" + (sshKeyInfo.getPrivateKey() == null ? "null" : "nonnull") + " sshKeyInfo.hasUnencryptedPrivateKey()=" + sshKeyInfo.hasUnencryptedPrivateKey());
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.SKIPPED, "Private key in preferences is encrypted. Login cannot be tested.");
            }
            if (sshKeyInfo == null) {
                LOG.info("The user's SSH key will be used.");
                GeniUser geniUser = this.geniUserProvider.getLoggedInGeniUser();
                sshKeyInfo = SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)geniUser);
            }
            if (!sshKeyInfo.hasUnencryptedPrivateKey() || sshKeyInfo.getPrivateKey() == null) {
                LOG.info("Private key in preferences is encrypted. Login cannot be tested. sshKeyInfo.hasUnencryptedPrivateKey()={} sshKeyInfo.getPrivateKey()= {}", (Object)sshKeyInfo.hasUnencryptedPrivateKey(), (Object)(sshKeyInfo.getPrivateKey() == null ? "null" : "notnull"));
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.SKIPPED, "Private key in preferences is encrypted (" + (String)(sshKeyInfo.hasUnencryptedPrivateKey() ? "false, but privKey=" + (sshKeyInfo.getPrivateKey() == null ? "null" : "notnull") : "true") + "). Login cannot be tested.");
            }
            ssh = new SSHClient();
            ssh.setTimeout(8000);
            ssh.setConnectTimeout(10000);
            ssh.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            Object socketImplFactory = null;
            boolean forceSshProxyDns = false;
            try {
                if (this.proxyInfo != null) {
                    ssh.setSocketFactory((SocketFactory)SshProxySocketFactory.createWithForcedTarget((JFedConnection.SshProxyInfo)this.proxyInfo, (String)this.hostname, (int)this.port));
                    forceSshProxyDns = true;
                    LOG.info("Using SSH proxy for SSH connection: " + String.valueOf(this.proxyInfo));
                }
            }
            catch (IOException ex) {
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "Could not connect to SSH proxy: " + ex.getMessage(), ex);
            }
            try {
                if (forceSshProxyDns) {
                    ssh.connect("localhost", this.port);
                } else {
                    ssh.connect(this.hostname, this.port);
                }
            }
            catch (IOException ex) {
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "Could not connect to " + this.hostname + ": " + ex.getMessage(), ex);
            }
            try {
                ssh.authPublickey(this.username, new KeyProvider[]{new KeyPairWrapper(sshKeyInfo.getPublicKey(), sshKeyInfo.getPrivateKey())});
            }
            catch (IOException e) {
                LOG.error("Error while registring private key", (Throwable)e);
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "Couldn't authenticate with provided private key", e);
            }
            LOG.debug("Successfully authenticated {}@{}:{}", new Object[]{this.username, this.hostname, this.port});
            session = ssh.startSession();
            Session.Command comm = session.exec("uname -a");
            comm.join();
            LOG.debug("Test-channel exited with status {}", (Object)comm.getExitStatus());
            BufferedReader sout = new BufferedReader(new InputStreamReader(comm.getInputStream()));
            BufferedReader serr = new BufferedReader(new InputStreamReader(comm.getErrorStream()));
            LOG.info("Output of test-commands: {}", (Object)sout.lines().collect(Collectors.joining("\n")));
            String errorOutput = serr.lines().collect(Collectors.joining("\n"));
            if (!errorOutput.isEmpty()) {
                LOG.warn("Error-output of test-commands: " + errorOutput);
            }
            connectivityTestResult = new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.SUCCEEDED, "Successfully authenticated " + this.username + "@" + this.hostname + ":" + this.port);
            if (session == null) break block33;
            session.close();
        }
        try {
            ssh.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return connectivityTestResult;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (session != null) {
                            try {
                                session.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        ConnectivityTest.ConnectivityTestResult connectivityTestResult2 = new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "Successfully authenticated " + this.username + "@" + this.hostname + ":" + this.port + ". But command failed", e);
                        return connectivityTestResult2;
                    }
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    try {
                        ssh.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

