/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.connectivity_tester;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import be.iminds.ilabt.jfed.util.common.ThreadFactoryUtil;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeConnectivityTest<CT extends ConnectivityTest>
implements Callable<Optional<ConnectivityTest.ConnectivityTestResult>> {
    private static final Logger LOG = LoggerFactory.getLogger(SafeConnectivityTest.class);
    private final CT connectivityTest;
    private final long maxRunTime;

    public SafeConnectivityTest(CT connectivityTest, long maxRunTime) {
        this.connectivityTest = connectivityTest;
        this.maxRunTime = maxRunTime;
    }

    @Override
    public Optional<ConnectivityTest.ConnectivityTestResult> call() {
        ExecutorService es = Executors.newSingleThreadExecutor(ThreadFactoryUtil.getFactory((String)("ConnectivityTestThread#" + String.valueOf(this.connectivityTest)), (Boolean)true));
        Date startTime = new Date();
        Future testResult = es.submit(this.connectivityTest);
        es.shutdown();
        try {
            if (!es.awaitTermination(this.maxRunTime, TimeUnit.MILLISECONDS)) {
                es.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Date stopTime = new Date();
        try {
            Optional<ConnectivityTest.ConnectivityTestResult> result = Optional.of((ConnectivityTest.ConnectivityTestResult)testResult.get());
            long durationMs = stopTime.getTime() - startTime.getTime();
            LOG.debug("{} took {}ms. result={}", new Object[]{this.connectivityTest.getName(), durationMs, result});
            return result;
        }
        catch (InterruptedException e) {
            LOG.info("ConnectivityTestThread of {} was interrupted", (Object)this.connectivityTest.getName(), (Object)e);
            return Optional.empty();
        }
        catch (ExecutionException e) {
            LOG.info("Error while executing {}", (Object)this.connectivityTest.getName(), (Object)e);
            return Optional.empty();
        }
    }
}

