/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experiment;

import be.iminds.ilabt.jfed.call_log_output.LogOutput;
import be.iminds.ilabt.jfed.espec.bundle.ESpecBundle;
import be.iminds.ilabt.jfed.espec.filefetcher.ExperimentSpecificationFileManager;
import be.iminds.ilabt.jfed.espec.filefetcher.FileFetcher;
import be.iminds.ilabt.jfed.espec.model.AnsibleHostSpec;
import be.iminds.ilabt.jfed.espec.model.AnsibleSpec;
import be.iminds.ilabt.jfed.espec.model.BasicExperimentSpecificationBuilder;
import be.iminds.ilabt.jfed.espec.model.ExecuteSpec;
import be.iminds.ilabt.jfed.espec.model.ExperimentSpecification;
import be.iminds.ilabt.jfed.espec.model.FileSource;
import be.iminds.ilabt.jfed.espec.model.RspecSpec;
import be.iminds.ilabt.jfed.espec.model.UploadLikeSpec;
import be.iminds.ilabt.jfed.espec.util.ESpecLogListener;
import be.iminds.ilabt.jfed.espec.util.ESpecLogger;
import be.iminds.ilabt.jfed.experiment.ExperimentChangeListener;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.util.ExperimentRestoreInformation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.git.GitAuthPreferences;
import be.iminds.ilabt.jfed.highlevel.jobs.link_test.LinkTestListener;
import be.iminds.ilabt.jfed.highlevel.jobs.link_test.LinkTestLogger;
import be.iminds.ilabt.jfed.highlevel.jobs.report.JobReport;
import be.iminds.ilabt.jfed.highlevel.model.InternalState;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.util.LogEntryGeneratorWrappingLogger;
import be.iminds.ilabt.jfed.highlevel.util.LogEntryListener;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.rspec.generator.RSpecGeneratorFactory;
import be.iminds.ilabt.jfed.rspec.model.DistributeSshKeypair;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecFactoryFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.parser.StaxRspecParser;
import be.iminds.ilabt.jfed.rspec.rspec_source.ImmutableRequestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Experiment
implements LogEntryListener {
    private static final Logger ORIG_LOG = LoggerFactory.getLogger(Experiment.class);
    private final LogEntryGeneratorWrappingLogger LOG = new LogEntryGeneratorWrappingLogger(ORIG_LOG, this);
    public static Duration DEFAULT_MAX_WAIT_UNTIL_READY = Duration.ofMinutes(45L);
    public static Duration DEFAULT_LONG_MAX_WAIT_UNTIL_READY = Duration.ofHours(2L);
    @Nonnull
    private final String name;
    @Nullable
    private final String subAuthName;
    @Nonnull
    private final List<GeniUrn> initialShareWithUsers;
    @Nullable
    private final RequestRspecSource newRequestRspecSource;
    @Nullable
    private final RequestRspecSource existingRequestRspecSource;
    @Nonnull
    private final BooleanProperty containsExperimentSpecification;
    @Nullable
    private ExperimentSpecification experimentSpecification;
    @Nullable
    private ESpecBundle experimentSpecificationBundle;
    @Nullable
    private ExperimentSpecificationFileManager experimentSpecificationFileManager;
    @Nonnull
    private final ESpecLogger eSpecLogger;
    @Nonnull
    private final LinkTestLogger linkTestLogger;
    @Nonnull
    private ObservableList<JobReport> jobReports = new SimpleListProperty(FXCollections.observableArrayList());
    @Nonnull
    private ObservableList<LogOutput.LogEntry> logEntries = new SimpleListProperty(FXCollections.observableArrayList());
    @Nullable
    private final Instant requestedStartTime;
    @Nonnull
    private final Instant requestedEndTime;
    @Nullable
    private Duration checkReadyInterval = null;
    @Nullable
    private Duration maxWaitUntilReady = DEFAULT_MAX_WAIT_UNTIL_READY;
    @Nullable
    private List<UserSpec> userSpecs;
    private final boolean requestSla;
    private final boolean linkTestRequested;
    @Nullable
    private final Service scs;
    private ExperimentRestoreInformation experimentRestoreInformation;
    private final ReadOnlyObjectWrapper<Slice> slice = new ReadOnlyObjectWrapper();
    private final ReadOnlyObjectWrapper<ExperimentState> experimentState;
    private final List<ExperimentPart> experimentPartsReadOnlyList;
    private final ObservableList<ExperimentPart> experimentPartsObservableList;
    private final List<ExperimentChangeListener> experimentChangeListeners = new ArrayList<ExperimentChangeListener>();
    private final ObservableMap<String, Object> extras = FXCollections.observableHashMap();
    private final ObservableMap<DistributeSshKeypair, KeyPair> keypairs = FXCollections.observableHashMap();

    public Experiment(@Nonnull String name, @Nullable String subAuthName, @Nonnull List<GeniUrn> initialShareWithUsers, @Nonnull RequestRspecSource newRequestRspecSource, @Nullable Instant requestedStartTime, @Nonnull Instant requestedEndTime, @Nullable List<UserSpec> userSpecs, boolean requestSla, boolean linkTestRequested, @Nullable Service scs) {
        assert (name != null);
        assert (newRequestRspecSource != null);
        assert (requestedEndTime != null);
        this.name = name;
        this.subAuthName = subAuthName;
        this.initialShareWithUsers = Collections.unmodifiableList(new ArrayList<GeniUrn>(initialShareWithUsers));
        this.userSpecs = userSpecs;
        this.requestSla = requestSla;
        this.linkTestRequested = linkTestRequested;
        this.scs = scs;
        this.containsExperimentSpecification = new SimpleBooleanProperty(false);
        this.experimentSpecification = null;
        this.experimentSpecificationBundle = null;
        this.experimentSpecificationFileManager = null;
        this.eSpecLogger = new ESpecLogger();
        this.linkTestLogger = new LinkTestLogger();
        this.requestedStartTime = requestedStartTime != null ? requestedStartTime.truncatedTo(ChronoUnit.SECONDS) : null;
        this.requestedEndTime = requestedEndTime.truncatedTo(ChronoUnit.SECONDS);
        this.newRequestRspecSource = new ImmutableRequestRspecSource(newRequestRspecSource);
        this.existingRequestRspecSource = null;
        this.experimentState = new ReadOnlyObjectWrapper((Object)ExperimentState.PENDING);
        this.experimentPartsReadOnlyList = new CopyOnWriteArrayList<ExperimentPart>();
        this.experimentPartsObservableList = FXCollections.observableList(this.experimentPartsReadOnlyList);
        this.finishConstruction();
    }

    public Experiment(@Nullable Slice slice, @Nullable String name, @Nullable String subAuthName, @Nonnull List<GeniUrn> initialShareWithUsers, @Nonnull ESpecBundle experimentSpecificationBundle, @Nullable Instant requestedStartTime, @Nonnull Instant requestedEndTime, @Nullable List<UserSpec> userSpecs, boolean requestSla, @Nullable RSpecGeneratorFactory rSpecGeneratorFactory, @Nullable GitAuthPreferences gitAuthPreferences, boolean linkTestRequested, @Nullable Service scs) {
        String requestRspec;
        assert (slice != null || name != null);
        assert (requestedEndTime != null);
        if (slice == null) {
            this.name = name;
            this.subAuthName = subAuthName;
        } else {
            this.name = slice.getName();
            this.subAuthName = slice.getSubAuthorityName();
        }
        this.initialShareWithUsers = Collections.unmodifiableList(new ArrayList<GeniUrn>(initialShareWithUsers));
        this.userSpecs = userSpecs;
        this.requestSla = requestSla;
        this.linkTestRequested = linkTestRequested;
        this.scs = scs;
        this.requestedStartTime = requestedStartTime != null ? requestedStartTime.truncatedTo(ChronoUnit.SECONDS) : null;
        this.requestedEndTime = requestedEndTime.truncatedTo(ChronoUnit.SECONDS);
        this.experimentSpecificationBundle = experimentSpecificationBundle;
        ExperimentSpecification experimentSpecification = experimentSpecificationBundle.getExperimentSpecification();
        this.containsExperimentSpecification = new SimpleBooleanProperty(experimentSpecification != null);
        try {
            requestRspec = new String(new FileFetcher(((RspecSpec)experimentSpecification.getRspecs().get(0)).getSource(), experimentSpecificationBundle, rSpecGeneratorFactory, gitAuthPreferences).fetchBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get Request RSpec from Experiment Specification");
        }
        this.newRequestRspecSource = experimentSpecification.getAnsible() != null && experimentSpecification.getAnsible().getAnsibleHostSpec().getHostType() == AnsibleHostSpec.HostType.ADD ? this.createRspecWithAnsibleNode(requestRspec, experimentSpecification.getAnsible()) : new ImmutableRequestRspecSource(requestRspec, ModelRspecType.BASIC);
        this.existingRequestRspecSource = null;
        this.experimentSpecification = experimentSpecification;
        this.eSpecLogger = new ESpecLogger();
        this.linkTestLogger = new LinkTestLogger();
        this.experimentSpecificationFileManager = new ExperimentSpecificationFileManager(experimentSpecification, experimentSpecificationBundle, this.eSpecLogger, rSpecGeneratorFactory, gitAuthPreferences);
        this.experimentState = new ReadOnlyObjectWrapper((Object)(slice == null ? ExperimentState.PENDING : ExperimentState.RESTORING));
        this.experimentPartsReadOnlyList = new CopyOnWriteArrayList<ExperimentPart>();
        this.experimentPartsObservableList = FXCollections.observableList(this.experimentPartsReadOnlyList);
        if (slice != null) {
            this.registerSlice(slice);
        }
        this.finishConstruction();
    }

    private ExperimentSpecification addEnableIlabtInternetToESpecAnsible(ExperimentSpecification experimentSpecification) {
        AnsibleSpec origAnsibleSpec = experimentSpecification.getAnsible();
        if (origAnsibleSpec == null) {
            return experimentSpecification;
        }
        BasicExperimentSpecificationBuilder builder = new BasicExperimentSpecificationBuilder(experimentSpecification);
        AnsibleHostSpec origAnsibleHostSpec = origAnsibleSpec.getAnsibleHostSpec();
        if (origAnsibleHostSpec.getExecuteLists().stream().map(UploadLikeSpec::getDesc).anyMatch(d -> d.contains("enable-internet"))) {
            return experimentSpecification;
        }
        ArrayList<ExecuteSpec> newExecuteList = new ArrayList<ExecuteSpec>(origAnsibleHostSpec.getExecuteLists());
        newExecuteList.add(new ExecuteSpec(new FileSource(FileSource.SourceType.DOWNLOAD, "https://raw.githubusercontent.com/imec-ilabt/ilabt-scripts/master/enable-internet.sh", "enable-internet.sh"), null, null, "u=rx", Boolean.valueOf(true), null, null));
        AnsibleHostSpec newAnsibleHostSpec = new AnsibleHostSpec(origAnsibleHostSpec.getHostType(), origAnsibleHostSpec.getNodeName(), origAnsibleHostSpec.getUploadLists(), newExecuteList, origAnsibleHostSpec.getGalaxyCommand(), origAnsibleHostSpec.getGalaxyInstallTemplate(), origAnsibleHostSpec.getPlaybookCommand(), origAnsibleHostSpec.getPlaybookRunTemplate());
        AnsibleSpec newAnsibleSpec = new AnsibleSpec(newAnsibleHostSpec, origAnsibleSpec.getAnsibleGalaxySpecs(), origAnsibleSpec.getAnsiblePlaybookSpecs(), origAnsibleSpec.getGroups());
        builder.setAnsible(newAnsibleSpec);
        return builder.create();
    }

    private RequestRspecSource createRspecWithAnsibleNode(@Nonnull String requestRspec, @Nonnull AnsibleSpec ansibleSpec) {
        ModelRspec extendedRspecModel = StaxRspecParser.parseOrNullNoError((String)requestRspec, (ModelRspecType)ModelRspecType.BASIC);
        if (extendedRspecModel == null) {
            throw new RuntimeException("Failed to get Request RSpec Model from Experiment Specification");
        }
        if (extendedRspecModel.getNodes().isEmpty()) {
            throw new RuntimeException("Cannot add ansible node to RSpec without any nodes");
        }
        RspecNode firstNode = (RspecNode)extendedRspecModel.getNodes().get(0);
        RspecFactory factory = RspecFactoryFactory.getRspecFactoryInstance((ModelRspecType)extendedRspecModel.getModelRspecType());
        RspecNode ansibleNode = factory.createNode(extendedRspecModel);
        if (ansibleSpec.getAnsibleHostSpec().getNodeName() == null) {
            ansibleNode.setClientId("ansible");
        } else {
            ansibleNode.setClientId(ansibleSpec.getAnsibleHostSpec().getNodeName());
        }
        ansibleNode.setComponentManagerId(firstNode.getComponentManagerId());
        ansibleNode.setExclusive(firstNode.getExclusive());
        ansibleNode.setSliverTypeName(firstNode.getSliverTypeName());
        extendedRspecModel.addNode(ansibleNode);
        return new ImmutableRequestRspecSource(extendedRspecModel);
    }

    public Experiment(@Nonnull Slice slice, @Nonnull RequestRspecSource newRequestRspecSource, @Nullable Instant requestedStartTime, @Nonnull Instant requestedEndTime, @Nullable List<UserSpec> userSpecs, @Nullable RequestRspecSource existingRequestRspecSource, boolean requestSla, boolean linkTestRequested, @Nullable Service scs) {
        this.requestSla = requestSla;
        this.linkTestRequested = linkTestRequested;
        this.name = slice.getName();
        this.subAuthName = slice.getSubAuthorityName();
        this.initialShareWithUsers = Collections.emptyList();
        this.scs = scs;
        this.requestedStartTime = requestedStartTime != null ? requestedStartTime.truncatedTo(ChronoUnit.SECONDS) : null;
        this.requestedEndTime = requestedEndTime.truncatedTo(ChronoUnit.SECONDS);
        this.newRequestRspecSource = newRequestRspecSource;
        this.existingRequestRspecSource = existingRequestRspecSource;
        this.containsExperimentSpecification = new SimpleBooleanProperty(false);
        this.experimentSpecification = null;
        this.experimentSpecificationBundle = null;
        this.experimentSpecificationFileManager = null;
        this.eSpecLogger = new ESpecLogger();
        this.linkTestLogger = new LinkTestLogger();
        this.userSpecs = userSpecs;
        this.experimentPartsReadOnlyList = new CopyOnWriteArrayList<ExperimentPart>();
        this.experimentPartsObservableList = FXCollections.observableList(this.experimentPartsReadOnlyList);
        this.experimentState = new ReadOnlyObjectWrapper((Object)ExperimentState.RESTORING);
        this.registerSlice(slice);
        this.finishConstruction();
    }

    public Experiment(@Nonnull Slice slice, @Nullable Instant requestedStartTime, @Nonnull Instant requestedEndTime) {
        this.name = slice.getName();
        this.subAuthName = slice.getSubAuthorityName();
        this.initialShareWithUsers = Collections.emptyList();
        this.containsExperimentSpecification = new SimpleBooleanProperty(false);
        this.experimentSpecification = null;
        this.experimentSpecificationBundle = null;
        this.experimentSpecificationFileManager = null;
        this.eSpecLogger = new ESpecLogger();
        this.linkTestLogger = new LinkTestLogger();
        this.newRequestRspecSource = null;
        this.scs = null;
        RequestRspecSource existingRequestRspecSource = slice.getRequestRspec();
        if (existingRequestRspecSource == null && slice.getManifestRspec() != null && slice.getManifestRspec().getStringRspec() != null) {
            existingRequestRspecSource = new ImmutableRequestRspecSource(slice.getManifestRspec().getStringRspec(), ModelRspecType.FX);
        }
        this.existingRequestRspecSource = existingRequestRspecSource;
        this.requestedStartTime = requestedStartTime;
        this.requestedEndTime = requestedEndTime.truncatedTo(ChronoUnit.SECONDS);
        this.experimentPartsReadOnlyList = new CopyOnWriteArrayList<ExperimentPart>();
        this.experimentPartsObservableList = FXCollections.observableList(this.experimentPartsReadOnlyList);
        this.userSpecs = null;
        this.requestSla = false;
        this.linkTestRequested = false;
        this.registerSlice(slice);
        this.experimentState = new ReadOnlyObjectWrapper((Object)ExperimentState.RESTORING);
        this.finishConstruction();
    }

    private void finishConstruction() {
        this.experimentState.addListener((observable, oldValue, newValue) -> {
            for (int i = 0; i < this.experimentChangeListeners.size(); ++i) {
                this.experimentChangeListeners.get(i).onExperimentStateChange((ExperimentState)((Object)newValue));
            }
        });
        this.experimentPartsObservableList.addListener(c -> {
            while (c.next()) {
                assert (c.wasAdded()) : "ExperimentParts should only be added!";
                for (ExperimentPart part : c.getAddedSubList()) {
                    for (int i = 0; i < this.experimentChangeListeners.size(); ++i) {
                        this.experimentChangeListeners.get(i).onExperimentPartAdded(part);
                    }
                }
            }
        });
    }

    public void registerSlice(Slice slice) {
        if (this.slice.get() != null) {
            throw new IllegalStateException("Slice is already set in Experiment");
        }
        if (slice == null) {
            throw new IllegalArgumentException("Slice is null");
        }
        if (slice.getUrn() == null) {
            throw new IllegalArgumentException("Slice has no URN");
        }
        this.slice.setValue((Object)slice);
        this.experimentRestoreInformation = new ExperimentRestoreInformation(slice.getUrn());
        this.experimentRestoreInformation.bindToExperiment(this);
    }

    public void updateUserSpecs(@Nonnull List<UserSpec> userSpecs) {
        this.userSpecs = userSpecs;
    }

    public void setMaxWaitUntilReady(@Nullable Duration maxWaitUntilReady) {
        this.maxWaitUntilReady = maxWaitUntilReady;
    }

    public void setCheckReadyInterval(@Nullable Duration checkReadyInterval) {
        this.checkReadyInterval = checkReadyInterval;
    }

    public void addExperimentChangeListener(ExperimentChangeListener experimentChangeListener) {
        assert (!this.experimentChangeListeners.contains(experimentChangeListener));
        this.experimentChangeListeners.add(experimentChangeListener);
    }

    public void removeExperimentChangeListener(ExperimentChangeListener experimentChangeListener) {
        throw new UnsupportedOperationException("removing ExperimentChangeListener is not supported.");
    }

    @Nonnull
    public ObservableList<JobReport> getJobReports() {
        return this.jobReports;
    }

    public void addJobReport(@Nonnull JobReport jobReport) {
        this.jobReports.add((Object)jobReport);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public List<UserSpec> getUserSpecs() {
        return this.userSpecs;
    }

    @Nullable
    public Duration getMaxWaitUntilReady() {
        return this.maxWaitUntilReady;
    }

    @Nullable
    public Duration getCheckReadyInterval() {
        return this.checkReadyInterval;
    }

    public boolean isRequestSla() {
        return this.requestSla;
    }

    public boolean isLinkTestRequested() {
        return this.linkTestRequested;
    }

    @Nonnull
    public Instant getRequestedEndTime() {
        return this.requestedEndTime;
    }

    @Nullable
    public Instant getRequestedStartTime() {
        return this.requestedStartTime;
    }

    @Nullable
    public Service getScs() {
        return this.scs;
    }

    @Nullable
    public RequestRspecSource getNewRequestRspecSource() {
        return this.newRequestRspecSource;
    }

    @Nonnull
    public boolean getContainsExperimentSpecification() {
        return this.containsExperimentSpecification.get();
    }

    @Nonnull
    public BooleanProperty containsExperimentSpecificationProperty() {
        return this.containsExperimentSpecification;
    }

    @Nullable
    public ExperimentSpecification getExperimentSpecification() {
        return this.experimentSpecification;
    }

    @Nullable
    public ExperimentSpecificationFileManager getExperimentSpecificationFileManager() {
        return this.experimentSpecificationFileManager;
    }

    @Nonnull
    public ESpecLogger getExperimentSpecificationLogger() {
        return this.eSpecLogger;
    }

    public void addESpecLogListener(@Nonnull ESpecLogListener listener) {
        this.eSpecLogger.addESpecLogListener(listener);
    }

    public void removeESpecLogListener(@Nonnull ESpecLogListener listener) {
        this.eSpecLogger.removeESpecLogListener(listener);
    }

    @Nonnull
    public LinkTestLogger getLinkTestLogger() {
        return this.linkTestLogger;
    }

    public void addLinkTestListener(@Nonnull LinkTestListener listener) {
        this.linkTestLogger.addLinkTestListener(listener);
    }

    public void removeLinkTestListener(@Nonnull LinkTestListener listener) {
        this.linkTestLogger.removeLinkTestListener(listener);
    }

    @Nullable
    public ESpecBundle getExperimentSpecificationBundle() {
        return this.experimentSpecificationBundle;
    }

    public void resetExperimentSpecification(@Nullable ExperimentSpecification experimentSpecification, @Nullable ESpecBundle experimentSpecificationBundle, @Nullable RSpecGeneratorFactory rSpecGeneratorFactory, @Nullable GitAuthPreferences gitAuthPreferences) {
        this.containsExperimentSpecification.setValue(Boolean.valueOf(experimentSpecification != null));
        this.experimentSpecification = experimentSpecification;
        this.experimentSpecificationBundle = experimentSpecificationBundle;
        this.experimentSpecificationFileManager = experimentSpecification != null && experimentSpecificationBundle != null ? new ExperimentSpecificationFileManager(experimentSpecification, experimentSpecificationBundle, this.eSpecLogger, rSpecGeneratorFactory, gitAuthPreferences) : null;
    }

    @Nullable
    public Slice getSliceOrNull() {
        return (Slice)this.slice.get();
    }

    public void requireSlice() {
        if (this.slice.get() == null) {
            throw new IllegalStateException("Experiment should have a slice");
        }
    }

    @Nonnull
    public Optional<Slice> getSliceOpt() {
        return Optional.ofNullable((Slice)this.slice.get());
    }

    @Nonnull
    public Slice getSlice() {
        Slice res = (Slice)this.slice.get();
        if (res == null) {
            throw new IllegalStateException("The Experiment does not have a slice");
        }
        return res;
    }

    @Nullable
    public GeniUrn getSliceUrn() {
        return this.slice.get() == null ? null : ((Slice)this.slice.get()).getUrn();
    }

    @Nullable
    public String getSliceUrnString() {
        return this.slice.get() == null ? null : ((Slice)this.slice.get()).getUrnString();
    }

    public ReadOnlyObjectProperty<Slice> sliceProperty() {
        return this.slice.getReadOnlyProperty();
    }

    @Nonnull
    public ExperimentState getExperimentState() {
        return (ExperimentState)((Object)this.experimentState.get());
    }

    @Nonnull
    public ReadOnlyObjectProperty<ExperimentState> experimentStateProperty() {
        return this.experimentState.getReadOnlyProperty();
    }

    @Nullable
    public String getSubAuthName() {
        return this.subAuthName;
    }

    @Nonnull
    public List<GeniUrn> getInitialShareWithUsers() {
        return this.initialShareWithUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReservationMade() {
        ObservableList<ExperimentPart> observableList = this.experimentPartsObservableList;
        synchronized (observableList) {
            return this.experimentPartsReadOnlyList.stream().anyMatch(experimentPart -> experimentPart.getState() == InternalState.RESERVED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAnyPartSawNotEnoughFreeResourcesError() {
        ObservableList<ExperimentPart> observableList = this.experimentPartsObservableList;
        synchronized (observableList) {
            return this.experimentPartsReadOnlyList.stream().anyMatch(ExperimentPart::getSawNotEnoughFreeResourcesError);
        }
    }

    public ExperimentRestoreInformation getExperimentRestoreInformation() {
        return this.experimentRestoreInformation;
    }

    public void setExperimentState(@Nonnull ExperimentState experimentState) {
        if (experimentState == ExperimentState.FAILING || experimentState == ExperimentState.FAILED) {
            try {
                throw new RuntimeException("tracing setExperimentState(" + String.valueOf((Object)experimentState) + ") origin");
            }
            catch (Exception e) {
                Exception traceE = e;
                this.LOG.info(String.format("Setting state for experiment %s to %s (stacktrace included)", this.name, experimentState.toString()), traceE);
            }
        } else {
            this.LOG.debug("Setting state for experiment {} to {}", (Object)this.name, (Object)experimentState);
        }
        this.experimentState.set((Object)experimentState);
    }

    @Nullable
    public RequestRspecSource getExistingRequestRspecSource() {
        return this.existingRequestRspecSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ObservableList<ExperimentPart> getPartsObservableList() {
        ObservableList<ExperimentPart> observableList = this.experimentPartsObservableList;
        synchronized (observableList) {
            return this.experimentPartsObservableList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public List<ExperimentPart> getPartsListCopy() {
        ObservableList<ExperimentPart> observableList = this.experimentPartsObservableList;
        synchronized (observableList) {
            return new ArrayList<ExperimentPart>(this.experimentPartsReadOnlyList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Stream<ExperimentPart> getPartsStream() {
        ObservableList<ExperimentPart> observableList = this.experimentPartsObservableList;
        synchronized (observableList) {
            return new ArrayList<ExperimentPart>(this.experimentPartsReadOnlyList).stream();
        }
    }

    public int getPartsSize() {
        return this.experimentPartsReadOnlyList.size();
    }

    public boolean isPartsEmpty() {
        return this.experimentPartsReadOnlyList.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExperimentPart(@Nonnull ExperimentPart experimentPart) {
        assert (experimentPart.getExperiment() == this);
        ObservableList<ExperimentPart> observableList = this.experimentPartsObservableList;
        synchronized (observableList) {
            this.experimentPartsObservableList.add((Object)experimentPart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SfaExperimentPart getPart(Server auth) {
        ObservableList<ExperimentPart> observableList = this.experimentPartsObservableList;
        synchronized (observableList) {
            return this.experimentPartsReadOnlyList.stream().filter(part -> part instanceof SfaExperimentPart && Objects.equals(((SfaExperimentPart)part).getConnectSfaAuthority(), auth)).map(SfaExperimentPart.class::cast).findFirst().orElse(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ExperimentPart getPart(Sliver sliver) {
        ObservableList<ExperimentPart> observableList = this.experimentPartsObservableList;
        synchronized (observableList) {
            return this.experimentPartsReadOnlyList.stream().filter(part -> part instanceof SfaExperimentPart && ((SfaExperimentPart)part).getSlivers().contains(sliver)).findFirst().orElse(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ExperimentPart getPart(GeniUrn sliverUrn) {
        ObservableList<ExperimentPart> observableList = this.experimentPartsObservableList;
        synchronized (observableList) {
            for (ExperimentPart experimentPart : this.experimentPartsReadOnlyList) {
                if (!(experimentPart instanceof SfaExperimentPart)) continue;
                SfaExperimentPart sfaExperimentPart = (SfaExperimentPart)experimentPart;
                for (Sliver sliver : sfaExperimentPart.getSlivers()) {
                    if (!Objects.equals(sliver.getUrn(), sliverUrn)) continue;
                    return experimentPart;
                }
            }
        }
        return null;
    }

    public ObservableMap<String, Object> getExtras() {
        return this.extras;
    }

    public ObservableMap<DistributeSshKeypair, KeyPair> getKeypairs() {
        return this.keypairs;
    }

    @Override
    public void log(@Nonnull LogOutput.LogEntry logEntry) {
        this.logEntries.add((Object)logEntry);
    }

    @Nonnull
    public ObservableList<LogOutput.LogEntry> getLogEntries() {
        return this.logEntries;
    }
}

